% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06_vcov.R
\name{vcov.modeler}
\alias{vcov.modeler}
\title{Variance-Covariance matrix for an object of class \code{modeler}}
\usage{
\method{vcov}{modeler}(object, id = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{modeler}, typically the result of calling
the \code{modeler()} function.}

\item{id}{An optional unique identifier to filter by a specific group.
Default is \code{NULL}.}

\item{...}{Additional parameters for future functionality.}
}
\value{
A list of matrices, where each matrix represents the variance-covariance
matrix of the estimated parameters for each group or fit.
}
\description{
Extract the variance-covariance matrix for the parameter estimates
from an object of class \code{modeler}.
}
\examples{
library(flexFitR)
data(dt_potato)
mod_1 <- dt_potato |>
  modeler(
    x = DAP,
    y = Canopy,
    grp = Plot,
    fn = "fn_lin_plat",
    parameters = c(t1 = 45, t2 = 80, k = 0.9),
    subset = c(15, 2, 45)
  )
print(mod_1)
vcov(mod_1)
}
\author{
Johan Aparicio [aut]
}
