% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Llogis.R
\name{Llogis}
\alias{Hllogis}
\alias{Llogis}
\alias{dllogis}
\alias{hllogis}
\alias{pllogis}
\alias{qllogis}
\alias{rllogis}
\title{The log-logistic distribution}
\arguments{
\item{x, q}{vector of quantiles.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the
length is taken to be the number required.}

\item{shape, scale}{vector of shape and scale parameters.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as
log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P(X \le x)}{P(X <= x)}, otherwise, \eqn{P(X > x)}{P(X > x)}.}
}
\value{
\code{dllogis} gives the density, \code{pllogis} gives the
distribution function, \code{qllogis} gives the quantile function,
\code{hllogis} gives the hazard function, \code{Hllogis} gives the
cumulative hazard function, and \code{rllogis} generates random
deviates.
}
\description{
Density, distribution function, hazards, quantile function and
random generation for the log-logistic distribution.
}
\details{
The log-logistic distribution with \code{shape} parameter
\eqn{a>0} and \code{scale} parameter \eqn{b>0} has probability
density function

\deqn{f(x | a, b) = (a/b) (x/b)^{a-1} / (1 + (x/b)^a)^2}

and hazard

\deqn{h(x | a, b) = (a/b) (x/b)^{a-1} / (1 + (x/b)^a)}

for \eqn{x>0}. The hazard is decreasing for shape \eqn{a\leq 1}{a
>= 1}, and unimodal for \eqn{a > 1}.

The probability distribution function is \deqn{F(x | a, b) = 1 - 1
/ (1 + (x/b)^a)}

If \eqn{a > 1}, the mean is \eqn{b c / sin(c)}, and if \eqn{a > 2}
the variance is \eqn{b^2 * (2*c/sin(2*c) - c^2/sin(c)^2)}, where
\eqn{c = \pi/a}, otherwise these are undefined.
}
\note{
Various different parameterisations of this distribution are
used.  In the one used here, the interpretation of the parameters
is the same as in the standard Weibull distribution
(\code{\link{dweibull}}).  Like the Weibull, the survivor function
is a transformation of \eqn{(x/b)^a} from the real line to [0,1],
but with a different link function.  Covariates on \eqn{b}
represent time acceleration factors, or ratios of expected
survival.

The same parameterisation is also uqsed in
\code{\link[eha]{dllogis}} in the \pkg{eha} package.
}
\author{
Christopher Jackson <chris.jackson@mrc-bsu.cam.ac.uk>
}
\references{
Stata Press (2007) Stata release 10 manual: Survival analysis
and epidemiological tables.
}
\seealso{
\code{\link{dweibull}}
}
\keyword{distribution}

