% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.flexsurvmix.R
\name{probs_flexsurvmix}
\alias{probs_flexsurvmix}
\title{Probabilities of competing events from a flexsurvmix model}
\usage{
probs_flexsurvmix(x, newdata = NULL, B = NULL)
}
\arguments{
\item{x}{Fitted model object returned from \code{\link{flexsurvmix}}.}

\item{newdata}{Data frame or list of covariate values.   If omitted for a
model with covariates, a default is used, defined by all combinations of
factors if the only covariates in the model are factors, or all covariate
values of zero if there are any non-factor covariates in the model.}

\item{B}{Number of simulations to use to compute 95\% confidence intervals,
based on the asymptotic multivariate normal distribution of the basic
parameter estimates.  If \code{B=NULL} then intervals are not computed.}
}
\value{
A data frame containing the probability that each of the competing
  events will occur next, by event and by any covariate values specified in
  \code{newdata}.
}
\description{
Probabilities of competing events from a flexsurvmix model
}
