% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.flexsurvmix.R
\name{rmst_flexsurvmix}
\alias{rmst_flexsurvmix}
\title{Restricted mean times to events from a flexsurvmix model}
\usage{
rmst_flexsurvmix(x, newdata = NULL, tot = Inf, B = NULL)
}
\arguments{
\item{x}{Fitted model object returned from \code{\link{flexsurvmix}}.}

\item{newdata}{Data frame or list of covariate values.   If omitted for a
model with covariates, a default is used, defined by all combinations of
factors if the only covariates in the model are factors, or all covariate
values of zero if there are any non-factor covariates in the model.}

\item{tot}{Time horizon to compute the restricted mean until.}

\item{B}{Number of simulations to use to compute 95\% confidence intervals,
based on the asymptotic multivariate normal distribution of the basic
parameter estimates.  If \code{B=NULL} then intervals are not computed.}
}
\value{
Restricted mean times to next event conditionally on each alternative event,
  given the specified covariate values.
}
\description{
This returns the restricted mean of each event-specific parametric time-to-event
distribution in the mixture model, which is the mean time to event
conditionally on that event being the one that happens, and conditionally
on the event time being less than some time horizon \code{tot}.
}
