% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\name{empty_blanks}
\alias{empty_blanks}
\title{make blank columns as transparent}
\usage{
empty_blanks(x)
}
\arguments{
\item{x}{a flextable object}
}
\description{
blank columns are set as transparent. This is a shortcut function
that will delete top and bottom borders, change background color to
transparent and display empty content.
}
\examples{
library(magrittr)

typology <- data.frame(
  col_keys = c( "Sepal.Length", "Sepal.Width", "Petal.Length",
                "Petal.Width", "Species" ),
  what = c("Sepal", "Sepal", "Petal", "Petal", " "),
  measure = c("Length", "Width", "Length", "Width", "Species"),
  stringsAsFactors = FALSE )
typology

head(iris) \%>\%
  flextable(
    col_keys = c("Species",
                 "break1", "Sepal.Length", "Sepal.Width",
                 "break2", "Petal.Length", "Petal.Width") ) \%>\%
  set_header_df(mapping = typology, key = "col_keys" ) \%>\%
  theme_vanilla() \%>\%
  empty_blanks() \%>\%
  autofit() \%>\%
  tabwid()
}
