% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ph_with_flextable.R
\name{ph_with_flextable}
\alias{ph_with_flextable}
\title{wml table code}
\usage{
ph_with_flextable(x, value, type, index = 1)
}
\arguments{
\item{x}{a pptx device}

\item{value}{\code{flextable} object}

\item{type}{placeholder type}

\item{index}{placeholder index (integer). This is to be used when a placeholder type
is not unique in the current slide, e.g. two placeholders with type 'body'.}
}
\description{
produces the wml of a flextable
}
\examples{
library(officer)
ft <- flextable(head(mtcars))
ft <- theme_zebra(ft)
ft <- autofit(ft)
doc <- read_pptx()
doc <- add_slide(doc, layout = "Title and Content", master = "Office Theme")
doc <- ph_with_flextable(doc, value = ft, type = "body")
print(doc, target = "test.pptx" )
}
