% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{getRealVStat}
\alias{getRealVStat}
\title{V Statistic for Real Matrices}
\usage{
getRealVStat(X, p)
}
\arguments{
\item{X}{The \eqn{N \times P} real matrix}

\item{p}{The power \eqn{p} of \eqn{l_p^p}, i.e., \eqn{||x||_p^p = (x_1^p+...x_n^p)}s}
}
\value{
\eqn{V(\mathbf{X})}, the variance of the pairwise \eqn{l_p^p} distance between samples
}
\description{
Computes \eqn{V} statistic for a real matrix \eqn{\mathbf{X}},
where \eqn{V(\mathbf{X})} = scaled variance of \eqn{l_p^p} distances between the
row samples of \eqn{\mathbf{X}}.
}
\details{
Dependencies: getLpDistance
}
\examples{
X <- matrix(nrow = 5, ncol = 10, rnorm(50))
getRealVStat(X, p = 2)

}
