% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rand.r
\name{rand}
\alias{flrand}
\alias{flrnorm}
\alias{flrunif}
\alias{rand}
\title{Generators}
\usage{
flrunif(m, n, min = 0, max = 1)

flrnorm(m, n, mean = 0, sd = 1)

flrand(generator, m, n, ...)
}
\arguments{
\item{m, n}{The dimensions of the matrix/vector. \code{m} must be specified.  If \code{n}
is not, then the return is a vector.}

\item{min, max}{Minimum and maximum values for the uniform generator.}

\item{mean, sd}{Mean and standard deviation values for the normal generator.}

\item{generator}{A generating function, such as \code{rnorm}, or even something custom
defined.}

\item{...}{Additional arguments passed to the generator. For example, if \code{runif} is
passed as \code{generator}, then you might additionally pass \code{max=10}.}
}
\description{
Random float vector/matrix generators. \code{flrunif()} produces uniform
random values. \code{flrnorm()} produces random normal values.
\code{flrand()} will accept an arbitrary generator. See the details section
for more information.
}
\details{
For \code{flrunif()} and \code{flrnorm()}, the data is produced without a
double precision copy.  That is, it is not (computationally) equivalent to
\code{fl(matrix(runif(...)))}, though the operations are conceptually the
same.  For these, To produce a vector instead of a matrix, leave argument
\code{n} blank. Setting \code{n=1} will produce an mx1 matrix.

For \code{flrand()}, the data is generated in double precision in 4KiB
batches and copied over to a pre-allocated vector.  This will be slower than
generating all of the data up front and copying it, although it uses far less
memory most of the time.  So you can think of \code{flrunif()} and
\code{flrnorm()} as highly optimized versions of \code{flrand()} for uniform
and normal generators specifically.
}
\examples{
library(float)

flrunif(10) # length 10 vector
flrunif(10, 1) # 10x1 matrix
flrunif(10, min=10, max=20)

flrand(runif, 10) # conceptually the same as flrunif(10)

mygen = function(n) sample(1:5, n, replace=TRUE)
flrand(mygen, 30)

}

