% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_modified_peptides.R
\name{convert_modified_peptides}
\alias{convert_modified_peptides}
\title{Conversion of software specific modified peptide entries}
\usage{
convert_modified_peptides(
  input_df,
  software = c("MaxQuant", "PD", "DIA-NN", "Spectronaut")
)
}
\arguments{
\item{input_df}{A tibble with modified peptide level information. For MaxQuant: evidence.txt, for PD: PSMs.txt with R-friendly headers enabled, for DIA-NN and Spectronaut default output reports.}

\item{software}{The used analysis software for the input_df - MaxQuant, PD, DIA-NN or Spectronaut. Default is MaxQuant.}
}
\value{
This function returns the original submitted \code{tibble} - input_df - including two new columns:
\itemize{
\item traceR_mod.peptides - software-independent standardized text for modified peptide entries.
\item traceR_mod.peptides_unknownMods - logical value, if TRUE: a modification is detected, which is not converted to a standardized text.
}
}
\description{
Modified peptide entries are converted to a common text representation
}
\details{
The input entries are converted to a software independent format. The generated entries are appended to the submitted dataframe. Conversion of modifications is currently only available for UniMod:35 and UniMod:4. Other modifications will not be converted to standardized format.
}
\examples{
# Load libraries
library(dplyr)
library(stringr)
library(tidyr)
library(tibble)

# MaxQuant example data
data <- tibble::tibble(
 "Modified sequence" = c("_AACLLPK_",
  "_ALTDM(Oxidation (M))PQM(Oxidation (M))R_",
  "ALTDM(Dummy_Modification)PQMK"),
  Charge = c(2,2,3)
)

# Conversion
convert_modified_peptides(
 input_df = data,
 software = "MaxQuant"
)
}
\author{
Oliver Kardell
}
