% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trace_level.R
\name{trace_level}
\alias{trace_level}
\title{Trace common and unique identifications between different software outputs}
\usage{
trace_level(
  input_df1,
  input_df2,
  analysis_name1 = "input_df1",
  analysis_name2 = "input_df2",
  level = c("precursor", "modified_peptides", "proteinGroups"),
  filter_unknown_mods = TRUE
)
}
\arguments{
\item{input_df1}{A tibble with flowTraceR's standardized precursor, modified peptide, or proteinGroup level information - required column depends on chosen \code{level}.}

\item{input_df2}{A tibble with flowTraceR's standardized precursor, modified peptide,  or proteinGroup level information - required column depends on chosen \code{level}.}

\item{analysis_name1}{output tibble name for input_df1 - default is \code{"input_df1"}.}

\item{analysis_name2}{output tibble name for input_df2 - default is \code{"input_df2"}.}

\item{level}{\code{"precursor", "modified_peptides", "proteinGroups"} - respective level for tracing common vs. unique entries. Default is precursor.}

\item{filter_unknown_mods}{Logical value, default is TRUE. If TRUE, unknown modifications are filtered out - requires "traceR_precursor_unknownMods" or "traceR_mod.peptides_unknownMods" column; depends on chosen \code{level}.}
}
\value{
This function returns a list with both original submitted \code{tibbles} - input_df1 and input_df2 - including one of the following new columns depending on chosen \code{level} :
\itemize{
\item traceR_traced_precursor - categorization on precursor level in common and unique entries.
\item traceR_traced_mod.peptides - categorization on modified peptide level in common and unique entries.
\item traceR_traced_proteinGroups - categorization on proteinGroups level in common and unique entries.
}
}
\description{
Identifications of two input data frames are compared and categorized in unique and common entries.
}
\details{
Based on flowTraceR's standardized output format two software outputs can be compared and categorized into common and unique identifications for a chosen level: precursor, modified peptide or proteinGroup level.
}
\examples{
# Load libraries
library(dplyr)
library(stringr)
library(tibble)

# DIA-NN example data
diann <- tibble::tibble(
  "traceR_proteinGroups" = c("P02768", "P02671", "Q92496", "DummyProt"),
  "traceR_mod.peptides" = c("AAC(UniMod:4)LLPK", "RLEVDIDIK",
   "EGIVEYPR", "ALTDM(DummyModification)PQMK"),
  "traceR_mod.peptides_unknownMods" = c(FALSE, FALSE, FALSE, TRUE),
  "traceR_precursor" = c("AAC(UniMod:4)LLPK1", "RLEVDIDIK2",
   "EGIVEYPR2", "ALTDM(DummyModification)PQMK3" ),
  "traceR_precursor_unknownMods" = c(FALSE, FALSE, FALSE, TRUE)
)

# Spectronaut example data
spectronaut <- tibble::tibble(
  "traceR_proteinGroups" = c("P02768", "Q02985", "P02671"),
  "traceR_mod.peptides" = c("AAC(UniMod:4)LLPK", "EGIVEYPR", "M(UniMod:35)KPVPDLVPGNFK"),
  "traceR_mod.peptides_unknownMods" = c(FALSE, FALSE, FALSE),
  "traceR_precursor" = c("AAC(UniMod:4)LLPK1", "EGIVEYPR2", "M(UniMod:35)KPVPDLVPGNFK2"),
  "traceR_precursor_unknownMods" = c(FALSE, FALSE, FALSE)
)

# trace proteinGroup level
traced_proteinGroups <- trace_level(
  input_df1 = diann,
  input_df2 = spectronaut,
  analysis_name1 = "DIA-NN",
  analysis_name2 = "Spectronaut",
  level = "proteinGroups",
  filter_unknown_mods = TRUE
)

# trace precursor level
traced_pecursor <- trace_level(
  input_df1 = diann,
  input_df2 = spectronaut,
  analysis_name1 = "DIA-NN",
  analysis_name2 = "Spectronaut",
  level = "precursor",
  filter_unknown_mods = TRUE
)
}
\author{
Oliver Kardell
}
