% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/to-flowmat.R
\name{to_flowmat}
\alias{as.flowmat}
\alias{is.flowmat}
\alias{to_flowmat}
\alias{to_flowmat.data.frame}
\alias{to_flowmat.flow}
\alias{to_flowmat.list}
\title{Create a flowmat using a list a commands.}
\usage{
to_flowmat(x, ...)

\method{to_flowmat}{list}(x, samplename, ...)

\method{to_flowmat}{data.frame}(x, ...)

\method{to_flowmat}{flow}(x, ...)

as.flowmat(x, grp_col, jobname_col, cmd_col, ...)

is.flowmat(x)
}
\arguments{
\item{x}{a named list, where name corresponds to the jobname and value is a vector of commands to run.}

\item{...}{not used}

\item{samplename}{character of length 1 or that of nrow(x) ['samplename']}

\item{grp_col}{column used for grouping, default samplename.}

\item{jobname_col}{column specifying jobname, default jobname}

\item{cmd_col}{column specifying commands to run, default cmd}
}
\description{
Create a flowmat (data.frame) using a \strong{named} list a commands.

as.flowmat(): reads a file and checks for required columns. If x is data.frame checks for required columns.
}
\examples{
## Use this link for a few examples:
## http://docs.flowr.space/flowr/tutorial.html#define_modules

## create a vector of shell commands
cmds = c("sleep 1", "sleep 2")
## create a named list
lst = list("sleep" = cmds)
## create a flowmat
flowmat = to_flowmat(lst, samplename = "samp")

## Use flowmat to create a skeleton flowdef
flowdef = to_flowdef(flowmat)

## use both (flowmat and flowdef) to create a flow
fobj = to_flow(flowmat, flowdef)

## submit the flow to the cluster (execute=TRUE) or do a dry-run (execute=FALSE)
\dontrun{
fobj2 = submit_flow(fobj, execute=FALSE)
fobj3 = submit_flow(fobj, execute=TRUE)

## Get the status or kill all the jobs
status(fobj3)
kill(fobj3)
}
}

