% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flux_plot.R
\name{flux_plot}
\alias{flux_plot}
\title{plotting fluxes for visual evaluation}
\usage{
flux_plot(
  slopes_df,
  color_discard = "#D55E00",
  color_cut = "#D55E00",
  color_ok = "#009E73",
  color_zero = "#CC79A7",
  f_date_breaks = "1 min",
  f_minor_breaks = "10 sec",
  f_date_labels = "\%e/\%m \\n \%H:\%M",
  f_ylim_upper = 800,
  f_ylim_lower = 400,
  f_plotname = "plot_quality",
  facet_wrap_args = list(ncol = 4, nrow = 3, scales = "free"),
  y_text_position = 500,
  print_plot = "FALSE",
  output = "print_only",
  ggsave_args = list(),
  cut_arg = "cut",
  no_data_flag = "no_data"
)
}
\arguments{
\item{slopes_df}{dataset containing slopes,
with flags produced by flux_quality}

\item{color_discard}{color for fits with a discard quality flag}

\item{color_cut}{color for the part of the flux that is cut}

\item{color_ok}{color for fits with an ok quality flag}

\item{color_zero}{color for fits with a zero quality flag}

\item{f_date_breaks}{date_breaks argument for scale_x_datetime}

\item{f_minor_breaks}{minor breaks argument for scale_x_datetime}

\item{f_date_labels}{date_labels argument for scale_x_datetime}

\item{f_ylim_upper}{y axis upper limit}

\item{f_ylim_lower}{y axis lower limit}

\item{f_plotname}{filename for the extracted pdf file}

\item{facet_wrap_args}{list of arguments for
\link[ggforce:facet_wrap_paginate]{facet_wrap_paginate}}

\item{y_text_position}{position of the text box}

\item{print_plot}{FALSE or TRUE, if TRUE it prints the plot in R
but will take time depending on the size of the dataset}

\item{output}{"pdfpages", the plots are saved as A4 landscape pdf pages;
"ggsave", the plots can be saved with the ggsave function;
"print_only" (default) prints the plot without creating a file
(independently from 'print_plot' being TRUE or FALSE)}

\item{ggsave_args}{list of arguments for \link[ggplot2:ggsave]{ggsave}
(in case \code{output = "ggsave"})}

\item{cut_arg}{argument pointing rows to be cut from the measurements}

\item{no_data_flag}{flag marking fluxID without data in f_quality_flag}
}
\value{
a ggplot object if \code{print_plot = TRUE},
if \code{print_plot = FALSE} it will not return anything but will produce a file
depending on \code{output}
}
\description{
plots the fluxes, fit and slope in facets
with color code indicating quality flags
This function takes time to run and is optional in the workflow,
but it is still highly recommended to use it to visually check
the measurements.
}
\examples{
data(slopes0_flag)
flux_plot(slopes0_flag, output = "print_only")
data(slopes30lin_flag)
flux_plot(slopes30lin_flag, output = "print_only")
flux_plot(slopes30qua_flag, output = "print_only")
}
