% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flux.function.R
\name{fluxing}
\alias{fluxing}
\title{generate fluxes}
\usage{
fluxing(
  mat,
  biomasses = NULL,
  losses,
  efficiencies,
  bioms.prefs = TRUE,
  bioms.losses = TRUE,
  ef.level = "prey"
)
}
\arguments{
\item{mat}{Network adjacency matrix describing interactions among species. Interactions can be either binary or weighted.}

\item{biomasses}{Vector of species biomasses.}

\item{losses}{A vector or an array of species energy losses (excluding consumption).}

\item{efficiencies}{A vector or an array of conversion efficiencies of species in the adjacency matrix. These values describe the proportion of consumed energy that is converted to biomass of the consumer.}

\item{bioms.prefs}{Logical - if \code{TRUE}, consumer preferences are scaled according to species biomasses.}

\item{bioms.losses}{Logical - if \code{TRUE}, losses are scaled with species biomasses.}

\item{ef.level}{Set to \code{"prey"} if efficiencies are defined by prey, \code{"pred"} if they are a property of the predator.}
}
\value{
Returns an adjacency matrix where entries are the computed energy fluxes between consumer species and their respective resources.
}
\description{
Creates a valuated graph adjacency matrix from its binary version.
}
\details{
This function computes fluxes in food webs based on an equilibrium hypothesis: for each species, sum of ingoing fluxes (gains from predation) balances the sum of outgoing fluxes.
Outgoing fluxes are defined by consumption and the \code{losses} argument. Usually \code{losses} relate to species metabolic rates and/or natural death rates. For each species \code{i}, sum of ingoing fluxes \code{F_i} is computed as:
\deqn{
F_{i} = \frac{1}{e_i} (L_i + \sum_j W_{ij}F_j) \quad if \quad \code{ef.level == "pred"}
}
\deqn{
F_{i} = \frac{L_i + \sum_j W_{ij}F_j}{\sum_j W_{ji}e_j} \quad if \quad \code{ef.level == "pred"}
}
\code{W} set the matrix of preferences estimated from \code{mat}, according to \code{bioms.prefs}. \code{L} is the vector depicting sum of losses
(scaled or not by biomasses, accordingly to \code{bioms.losses}) and \code{e} is the vector of species efficiencies.


\itemize{
\item{\code{mat}:} Either a binary or a valuated matrix can be used. A non zero value for mat[i,j] means that species i is consumed by species j.
Matrix entries would assess predator preferences on its prey, thus providing a binary matrix assumes no preferences.

\item{\code{losses}:} Express species energetic losses not related to consumption. Usually metabolic or death rates.
When an array is provided, losses associated to each species correspond to line sums.

\item{\code{efficiencies}:} Determines how efficient species are to convert energy (see \code{ef.level} for more details).
Providing an array will assume values depending on both prey and predator identity.

\item{\code{bioms.pref}:} If \code{TRUE}, preferences \eqn{W_{ij}} of predator j on prey i are scaled accordingly to species biomass using the following formula:
\deqn{
W_{i,j} = \frac{mat[i,j] * biomasses[i]}{\sum_k mat[i,k]* biomasses[k]}
}
If \code{FALSE}, a normalisation on column values is performed.

\item{\code{bioms.losses}:} Set to true, function will assume that losses are defined per biomass unit.
Thus, total losses will be thereafter multiplied by biomass values for each species.

\item{\code{ef.level}:} If \code{"prey"} (resp \code{"pred"}), the total amount of energy that can be metabolized from a trophic link
will be determined by prey (resp predator) identity. \code{"link.specific"} assumes that efficiencies are defined for each trophic interaction
and implies \code{efficiencies} parameter to be a matrix.

}
}
\examples{
# first compute species per unit biomass metabolic rates using the metabolic theory:
losses = 0.1 * species.level$bodymasses^(-0.25)

# call of the function:
fluxing(species.level$mat, 
       species.level$biomasses, 
       losses, 
       species.level$efficiencies, 
       bioms.pref = TRUE, 
       ef.level = "prey")

}
\author{
Benoit gauzens, \email{benoit.gauzens@gmail.com}
}
