% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictorLM.R
\name{PredictorLM}
\alias{PredictorLM}
\title{PredictorLM}
\description{
This task specializes \link{Predictor} for \code{lm} and \code{lm}-type models.
The \code{model} is assumed to be a \code{lm}.

It is recommended to use \code{\link[=makePredictor]{makePredictor()}} for construction of Predictor objects.
}
\section{Super class}{
\code{\link[fmeffects:Predictor]{fmeffects::Predictor}} -> \code{PredictorLM}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PredictorLM-new}{\code{PredictorLM$new()}}
\item \href{#method-PredictorLM-predict}{\code{PredictorLM$predict()}}
\item \href{#method-PredictorLM-clone}{\code{PredictorLM$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictorLM-new"></a>}}
\if{latex}{\out{\hypertarget{method-PredictorLM-new}{}}}
\subsection{Method \code{new()}}{
Create a new PredictorCaret object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictorLM$new(model, data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{\verb{train, train.formula} object.}

\item{\code{data}}{The data used for computing FMEs, must be data.frame or data.table.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictorLM-predict"></a>}}
\if{latex}{\out{\hypertarget{method-PredictorLM-predict}{}}}
\subsection{Method \code{predict()}}{
Predicts on an observation \code{"newdata"}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictorLM$predict(newdata)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{newdata}}{The feature vector for which the target should be predicted.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictorLM-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PredictorLM-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictorLM$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
