% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lattice_2d.R
\name{fm_mesh_2d_map}
\alias{fm_mesh_2d_map}
\alias{fm_mesh_2d_map_lim}
\title{Special coordinate mappings for \code{fm_mesh_2d} projections.}
\usage{
fm_mesh_2d_map(
  loc,
  projection = c("default", "longlat", "longsinlat", "mollweide"),
  inverse = TRUE
)

fm_mesh_2d_map_lim(
  loc = NULL,
  projection = c("default", "longlat", "longsinlat", "mollweide")
)
}
\arguments{
\item{loc}{Coordinates to be mapped.}

\item{projection}{The projection type.}

\item{inverse}{If \code{TRUE}, \code{loc} are map coordinates and
coordinates in the spherical domain are calculated.  If \code{FALSE}, \code{loc}
are coordinates in the spherical domain and the forward map projection is
calculated. Default: \code{TRUE}}
}
\value{
For \code{fm_mesh_2d_map_lim}, a list:
\item{xlim }{X axis limits in the map domain}
\item{ylim }{Y axis limits in the map domain}
No attempt is
made to find minimal limits for partial spherical domains.
}
\description{
Calculates coordinate mappings for spherical \code{fm_mesh_2d} projections.
This is an internal function not intended for general use.
}
\section{Functions}{
\itemize{
\item \code{fm_mesh_2d_map_lim()}: Projection extent limit calculations

}}
\examples{
(loc <- fm_mesh_2d_map(cbind(20, 10), "longlat"))
fm_mesh_2d_map(loc, "longlat", inverse = FALSE)

}
\seealso{
\code{\link[=fm_evaluator]{fm_evaluator()}}
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
\keyword{internal}
