% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh_2d.R
\name{fm_rcdt_2d}
\alias{fm_rcdt_2d}
\alias{fm_rcdt_2d_inla}
\alias{fm_delaunay_2d}
\title{Refined Constrained Delaunay Triangulation}
\usage{
fm_rcdt_2d(...)

fm_rcdt_2d_inla(
  loc = NULL,
  tv = NULL,
  boundary = NULL,
  interior = NULL,
  extend = (missing(tv) || is.null(tv)),
  refine = FALSE,
  lattice = NULL,
  globe = NULL,
  cutoff = 1e-12,
  quality.spec = NULL,
  crs = NULL,
  ...
)

fm_delaunay_2d(loc, crs = NULL, ...)
}
\arguments{
\item{...}{Currently passed on to \code{fm_mesh_2d_inla} or converted to
\code{\link[=fmesher_rcdt]{fmesher_rcdt()}} options.}

\item{loc}{Input coordinates that should be part of the mesh. Can be a matrix, \code{sf}, \code{sfc}, \code{SpatialPoints},
or other object supported by \code{\link[=fm_unify_coords]{fm_unify_coords()}}.}

\item{tv}{Initial triangulation, as a N-by-3 indec vector into \code{loc}}

\item{boundary, interior}{Objects supported by \code{\link[=fm_as_segm]{fm_as_segm()}}.
If \code{boundary} is \code{numeric}, \code{fm_nonconvex_hull(loc, convex = boundary)} is
used.}

\item{extend}{\code{logical} or \code{list} specifying whether to extend the
data region, with parameters \describe{ \item{list("n")}{the number of edges
in the extended boundary (default=8)} \item{list("offset")}{the extension
distance.  If negative, interpreted as a factor relative to the approximate
data diameter (default=-0.10)} } Setting to \code{FALSE} is only useful in
combination \code{lattice} or \code{boundary}.}

\item{refine}{\code{logical} or \code{list} specifying whether to refine the
triangulation, with parameters \describe{ \item{list("min.angle")}{the
minimum allowed interior angle in any triangle.  The algorithm is guaranteed
to converge for \code{min.angle} at most 21 (default=\code{21})}
\item{list("max.edge")}{the maximum allowed edge length in any triangle.  If
negative, interpreted as a relative factor in an ad hoc formula depending on
the data density (default=\code{Inf})} \item{list("max.n.strict")}{the
maximum number of vertices allowed, overriding \code{min.angle} and
\code{max.edge} (default=-1, meaning no limit)} \item{list("max.n")}{the
maximum number of vertices allowed, overriding \code{max.edge} only
(default=-1, meaning no limit)} }}

\item{lattice}{An \code{fm_lattice_2d} object, generated by
\code{\link[=fm_lattice_2d]{fm_lattice_2d()}}, specifying points on a regular lattice.}

\item{globe}{If non-NULL, an integer specifying the level of subdivision
for global mesh points, used with \code{\link[=fmesher_globe_points]{fmesher_globe_points()}}}

\item{cutoff}{The minimum allowed distance between points.  Point at most as
far apart as this are replaced by a single vertex prior to the mesh
refinement step.}

\item{quality.spec}{List of vectors of per vertex \code{max.edge} target
specification for each location in \code{loc}, \code{boundary/interior}
(\code{segm}), and \code{lattice}.  Only used if refining the mesh.}

\item{crs}{Optional crs object}
}
\value{
An \code{fm_mesh_2d} object
}
\description{
Computes a refined constrained Delaunay triangulation on R2 or S2.
}
\section{Functions}{
\itemize{
\item \code{fm_rcdt_2d_inla()}: Legacy method for the \code{INLA::inla.mesh.create()}
interface

\item \code{fm_delaunay_2d()}: Construct a plain Delaunay triangulation.

}}
\section{INLA compatibility}{

For mesh and curve creation, the \code{\link[=fm_rcdt_2d_inla]{fm_rcdt_2d_inla()}}, \code{\link[=fm_mesh_2d_inla]{fm_mesh_2d_inla()}},
and \code{\link[=fm_nonconvex_hull_inla]{fm_nonconvex_hull_inla()}} methods will keep the interface syntax used by
\code{INLA::inla.mesh.create()}, \code{INLA::inla.mesh.2d()}, and
\code{INLA::inla.nonconvex.hull()} functions, respectively, whereas the
\code{\link[=fm_rcdt_2d]{fm_rcdt_2d()}}, \code{\link[=fm_mesh_2d]{fm_mesh_2d()}}, and \code{\link[=fm_nonconvex_hull]{fm_nonconvex_hull()}} interfaces may be
different, and potentially change in the future.
}

\examples{
(m <- fm_rcdt_2d_inla(
  boundary = fm_nonconvex_hull(cbind(0, 0), convex = 5)
))

fm_delaunay_2d(matrix(rnorm(30), 15, 2))

}
