% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marketInfo.R
\name{fmpc_symbols_index}
\alias{fmpc_symbols_index}
\title{Current or historical constituents for a specific index}
\usage{
fmpc_symbols_index(
  period = c("current", "historical"),
  index = c("sp500", "nasdaq", "dowjones")
)
}
\arguments{
\item{period}{'current' for current list, 'historical' for a list of
companies that have been added and the ones that were replaced}

\item{index}{indicate the index to pull for: sp500, dowjones, nasdaq}
}
\value{
data frame of constituents
}
\description{
Shows current or historical companies in the S&P 500, Nasdaq, or Dow Jones
}
\examples{

\dontrun{

# Must set a valid API token
fmpc_set_token('FMPAPIKEY')
fmpc_symbols_index()
fmpc_symbols_index('historical','nasdaq')
}

}
