# Functions and data for Japanese population statistics
# written by Minato Nakazawa, 2010-2022.
# rev. 0.2, 24 August 2010
# rev. 0.2.1, 7 May 2011, Vital statistics data for 2010 were added in part.
# rev. 0.2.2, 11 December 2011, resting vital statistics data for 2010 were added.
# rev. 0.2.3, 14 December 2011, Japanese census population of 2010 was added.
# rev. 0.2.4, 14 December 2011, bug in NAMESPACE was fixed.
# rev. 0.3.0, 23 December 2011, Jpopl (longer version of Jpop), Jfert 
#  (age specific fertility and marital fertility data in Japan), Jlife 
#  (completed life tables in Japan), Gompertz, Siler, Denny, CT, Hadwiger
#  and related functions were added.
# rev. 0.3.5, 11 December 2012, Jlife was updated (added qx2010M and qx2010F)
# rev. 0.5.0, 4 August 2014, lifetable3() was added, Jvital was updated,
#           fitGM() and fitSiler() for the data with missing value were improved.
# rev. 0.5.1. 15 September 2014, Japanese vital statistics (Jvital) was updated
#           to include 2013 data and a new data.frame Jvital2013byPref was added.
# rev. 0.5.2. 10 September 2015, Japanese vital statistics (Jvital) was updated
#           to include 2014 data.
# rev. 0.5.3. September 2016, hlifetable() for healthy life expectancy was added.
# rev. 0.6.0, 20 March 2017, New data were added to JASM, Jfert, Jlife, Jpop, 
#           Jpopl, Jvital.  p-values of oddsratio() and riskratio() were improved. 
#           In addition, spearman.ci.sas() was added.
# rev. 0.6.1, 16 May 2017, Bug fix in the variable name ASMFR2015 of the Jfert 
#           dataframe.  Three demographic functions WhipplesIndex(), 
#           CaretakerRatio(), and IndexOfDissimilarity() were added.
# rev. 0.6.3, 2 April 2018, New data were added to Jvital.  PrefYLL2015 was
#           included as a new data.
# rev. 0.7.0, 14 December 2019, New data (2017 and 2018) were added to Jvital.
#           Function PEI() was added.
# rev. 0.7.1, 9 May 2021, New data (2019 confirmed) were added to Jvital.
#           Tentative new model population of Japan in Heisei 27 (2015) H27MPJ was added.
# rev. 0.7.2, 11 December 2021, New data (2020 census) were added to Jpop and Jpopl.
# rev. 0.7.3, 1 March 2022, New data (2020 vital statistics) were addded to Jvital.
# rev. 0.7.4, 25 November 2022, New data (23rd complete life table) and AS(M)FR2020 
#                               were addded to Jlife.
# rev. 0.7.5, 24 December 2022, New data (e0 by prefecture and YLL2010 and 2020 by 
#                               prefecture were added as Prefe0, PrefYLL2010, and
#                               PrefYLL2020.

# Model population of Japan in Showa 60 (1985)
S60MPJ <- c(8180, 8338, 8497, 8655, 8814, 8972, 9130, 9289, 
 9400, 8651, 7616, 6581, 5546, 4511, 3476, 2441, 1406, 784)*1000

# Tentative model population of Japan in Heisei 27 (2015)
# https://www.mhlw.go.jp/content/12601000/000638712.pdf
H27MPJ <- c(978, 4048, 5369, 5711, 6053, 6396, 6738, 7081, 7423, 7766,
 8108, 8451, 8793, 9135, 9246, 7892, 6306, 4720, 3134, 1548, 423)*1000
names(H27MPJ) <- c("0", "1-4", sprintf("%d-%d", 1:18*5, 1:18*5+4), "95-")

# MortalityJapan Data
# * Japanese age-specific mortality data with age-specific population
# References:
# http://www.stat.go.jp/english/data/nenkan/66nenkan/index.htm
# http://www.e-stat.go.jp/SG1/estat/List.do?bid=000001025191&amp;cycode=0
# http://www.e-stat.go.jp/SG1/estat/List.do?lid=000001071995 (index for H22 vital statistics)
# http://www.e-stat.go.jp/SG1/estat/Xlsdl.do?sinfid=000008874020 (for H22M and H22F)
# http://www.e-stat.go.jp/SG1/estat/GL08020103.do?_csvDownload_&fileId=000007722015&releaseCount=2 (for H27M and H27F)
# http://www.e-stat.go.jp/SG1/estat/GL08020103.do?_csvDownload_&fileId=000007809777&releaseCount=2 (for H27MP and H27FP)
# Mortality data of <<Japanese>> in Japan.
# 
JASM <- data.frame(
 AGECLASS = c(paste("[",0:16*5,"-",0:16*5+4,"]",sep=""),"[85-]"), 
 S60MODEL = c(8180, 8338, 8497, 8655, 8814, 8972, 9130, 9289, 9400, 8651, 7616, 6581, 5546, 4511, 3476, 2441, 1406, 784)*1000, 
 S60M = c(6042, 1155, 1011, 3179, 3397, 3167, 4237, 7110, 10234, 15063, 24347, 30747, 30884, 38240, 55100, 65593, 59125, 48786), 
 H02M = c(4532, 844, 760, 3204, 3466, 2916, 3264, 5449, 9769, 14218, 20161, 32925, 42742, 42664, 51737, 69320, 67916, 67451), 
 H07M = c(3929, 752, 716, 2413, 3640, 3203, 3297, 4413, 8236, 15616, 21905, 30491, 47188, 59828, 60927, 68504, 77924, 87750), 
 H12M = c(2933, 438, 493, 1721, 2875, 3271, 3749, 4621, 6840, 13141, 24103, 31848, 42214, 60962, 76413, 73947, 73533, 102177), 
 H17M = c(2291, 409, 361, 1220, 2303, 2887, 3915, 4915, 6806, 10577, 19546, 34233, 43403, 55261, 80198, 99338, 89502, 127261), 
 H22M = c(1703, 240, 321, 867, 1820, 2234, 2920, 4441, 6063, 8663, 13388, 24653, 41726, 52396, 66594, 93095, 108331, 144495), 
 H27M = c(1473, 253, 267, 836, 1515, 1786, 2325, 3455, 6214, 8656, 12838, 19460, 36141, 61424, 76916, 96964, 126762, 209063),
 S60F = c(4792, 636, 638, 1033, 1272, 1558, 2496, 4017, 5650, 7644, 11504, 14828, 19961, 26490, 40891, 55657, 64448, 80930), 
 H02F = c(3451, 533, 482, 1149, 1329, 1361, 1774, 3102, 5542, 7510, 10097, 14616, 19986, 27267, 38076, 58203, 71633, 110407), 
 H07F = c(3111, 483, 468, 949, 1447, 1393, 1832, 2426, 4578, 8520, 11041, 14241, 21122, 29261, 41516, 56924, 79939, 141519), 
 H12F = c(2336, 300, 251, 676, 1160, 1546, 1847, 2425, 3639, 6595, 11740, 14144, 18466, 28096, 40115, 57053, 73527, 171735), 
 H17F = c(1811, 246, 229, 582, 1067, 1283, 2037, 2554, 3432, 5177, 9418, 15346, 18855, 25568, 40627, 60024, 84683, 225778), 
 H22F = c(1381, 190, 191, 442, 713, 953, 1514, 2460, 3209, 4511, 6720, 11162, 18111, 23276, 33466, 54783, 82815, 264402), 
 H27F = c(1219, 199, 203, 384, 586, 830, 1224, 1947, 3556, 4884, 6879, 9275, 16076, 26863, 37407, 56501, 95693, 359915),
 S60MP = c(3818777, 4373058, 5146970, 4600427, 4165995, 3948330, 4558265, 5398230, 4551877, 4092121, 3926414, 3409374, 2379902, 1781008, 1503595, 1017428, 542243, 255975),
 H02MP= c(3326039, 3821833, 4369880, 5122215, 4468199, 4078469, 3925353, 4524829, 5349985, 4482298, 3997248, 3783367, 3236549, 2194783, 1559972, 1197457, 678385, 357040),
 H07MP = c(3070015, 3349827, 3826968, 4385775, 5041228, 4452125, 4113849, 3945809, 4527352, 5328335, 4421787, 3906621, 3611948, 2998706, 1941558, 1260411, 824492, 479086),
 H12MP = c(3022521, 3083431, 3353150, 3833984, 4307242, 4965277, 4436818, 4096286, 3924171, 4467772, 5210038, 4290239, 3749528, 3357281, 2670270, 1625822, 915268, 653475),
 H17MP = c(2854502, 3036503, 3080678, 3373430, 3754822, 4198551, 4933265, 4402787, 4065470, 3867500, 4383240, 5077369, 4154529, 3545006, 3039743, 2256317, 1222635, 810898),
 H22MP = c(2710581, 2859805, 3031943, 3109229, 3266240, 3691723, 4221011, 4950122, 4400375, 4027969, 3809576, 4287489, 4920468, 3921774, 3225503, 2582940, 1692584, 1047611),
 H27MP = c(2512550, 2682940, 2839052, 3027777, 2909245, 3107413, 3560557, 4102712, 4823953, 4277897, 3904342, 3680870, 4106675, 4618555, 3551927, 2767144, 1983316, 1456554),
 S60FP = c(3640486, 4158776, 4895151, 4379520, 4034559, 3875072, 4495959, 5339814, 4583077, 4144493, 4006580, 3590371, 3025636, 2412411, 2059802, 1475915, 890694, 529272),
 H02FP = c(3166858, 3644724, 4156905, 4884872, 4331922, 3992244, 3862332, 4478951, 5308305, 4535714, 4091138, 3941521, 3508465, 2908793, 2257562, 1820756, 1154473, 765374),
 H07FP = c(2925239, 3190844, 3650837, 4172183, 4853773, 4336016, 4012606, 3876412, 4478720, 5290031, 4500131, 4046859, 3863161, 3397372, 2753609, 2028656, 1476273, 1100659),
 H12FP = c(2881577, 2938358, 3193462, 3654181, 4114218, 4825032, 4339792, 4018579, 3876048, 4448236, 5231952, 4443933, 3986305, 3748658, 3230306, 2524778, 1699421, 1579873),
 H17FP = c(2723585, 2891992, 2933974, 3194950, 3595776, 4081498, 4821592, 4332994, 4015126, 3858361, 4413259, 5177795, 4390100, 3887604, 3597754, 3006484, 2189758, 2115806),
 H22FP = c(2586167, 2725856, 2889092, 2954128, 3160193, 3601978, 4120486, 4836227, 4341490, 4005147, 3834923, 4376245, 5116781, 4288399, 3737799, 3358073, 2643680, 2747322),
 H27FP = c(2399703, 2554869, 2703893, 2869558, 2799599, 3012181, 3467119, 3986452, 4699880, 4199388, 3878950, 3725890, 4254300, 4941694, 4079873, 3464644, 2950153, 3415848)
)

# Age-specific fertility and marital fertility in Japan, from 1950 to 2020, every five years.
# The calculations were the numbers of live births divided by the numbers of women for ASFR (15-54),
# and the numbers of legitimate live births divided by the numbers of married women for ASMFR (15-54).
# Source: vital statistics and poulation census in Japan.
# https://www.e-stat.go.jp/stat-search/file-download?statInfId=000032118572&fileKind=1 (2020)
# https://www.e-stat.go.jp/stat-search/file-download?statInfId=000032142474&fileKind=0 (2020)
Jfert <- data.frame(
 Age = 15:54,
 ASFR1950 = c(0.000260711, 0.001705030, 0.006591795, 0.017620283, 0.040790446, 0.078629763, 0.125202828, 0.166849597, 0.207317758, 0.230443897, 0.239184624, 0.246438987, 0.237856153, 0.230670246, 0.225215755, 0.193561718, 0.192555580, 0.177637429, 0.160928599, 0.145888523, 0.133295047, 0.116344142, 0.104138972, 0.089249266, 0.076652895, 0.061970125, 0.046197905, 0.032859096, 0.019662408, 0.011974434, 0.005368680, 0.002700873, 0.001184486, 0.000744872, 0.000530990, 0.000266312, 0.000171810, 0.000145562, 0.000138299, 0.000067362),
 ASFR1955 = c(0.000070983, 0.000559515, 0.002512467, 0.007212682, 0.018227718, 0.040126691, 0.073339359, 0.113589559, 0.152935845, 0.180821615, 0.191488552, 0.196638849, 0.184207493, 0.173252138, 0.155864350, 0.138810525, 0.125306100, 0.110305534, 0.096498824, 0.084689962, 0.065311995, 0.059965870, 0.049075725, 0.039520237, 0.030759043, 0.023963927, 0.016713385, 0.011391080, 0.006699386, 0.003658195, 0.001731880, 0.000859430, 0.000372341, 0.000232640, 0.000133523, 0.000111132, 0.000077403, 0.000053553, 0.000028477, 0.000029630),
 ASFR1960 = c(0.000053094, 0.000385133, 0.001630130, 0.005121859, 0.013445511, 0.029479723, 0.061841040, 0.121878127, 0.146522646, 0.183220770, 0.196800417, 0.200980681, 0.191961155, 0.169286423, 0.145490604, 0.119733913, 0.096378212, 0.075041593, 0.059777440, 0.046032112, 0.035641138, 0.028803185, 0.022086914, 0.017200571, 0.013387683, 0.008999843, 0.007106351, 0.004734921, 0.002832813, 0.001561041, 0.000837431, 0.000374447, 0.000273385, 0.000101189, 0.000079644, 0.000042244, 0.000034479, 0.000027630, 0.000014089, 0.000022087),
 ASFR1965 = c(0.000044694, 0.000305474, 0.001663200, 0.004976753, 0.013431697, 0.032193796, 0.059460142, 0.102515173, 0.157392265, 0.196083767, 0.217469932, 0.229129707, 0.221193716, 0.191294734, 0.165074382, 0.133640171, 0.105995611, 0.082762030, 0.061863810, 0.045929908, 0.033590236, 0.024556180, 0.017114744, 0.011947056, 0.008381734, 0.005730720, 0.004050107, 0.002579103, 0.001490817, 0.000881452, 0.000390388, 0.000201474, 0.000112520, 0.000063497, 0.000045442, 0.000009808, 0.000009689, 0.000006027, 0.000002003, 0.000004215),
 ASFR1970 = c(0.000101986, 0.000316745, 0.001511908, 0.005289492, 0.013560580, 0.029550080, 0.054395467, 0.097373731, 0.138715378, 0.196078676, 0.237151560, 0.231503653, 0.217599735, 0.195945272, 0.162651837, 0.130300110, 0.104525507, 0.082645611, 0.063177330, 0.047590066, 0.034172872, 0.025036156, 0.018013577, 0.012508130, 0.008416872, 0.005526181, 0.003581835, 0.002262773, 0.001216680, 0.000705286, 0.000429818, 0.000182290, 0.000090547, 0.000048395, 0.000032394, 0.000008164, 0.000026243, 0.000009844, 0.000001969, 0.000000000),
 ASFR1975 = c(0.000038521, 0.000390991, 0.001808677, 0.005353476, 0.012829082, 0.027838342, 0.055789810, 0.094779776, 0.142403212, 0.188957783, 0.214894151, 0.210256093, 0.197870257, 0.158667683, 0.142838831, 0.117766465, 0.086028643, 0.065837764, 0.049076320, 0.035412268, 0.025409664, 0.019120780, 0.013640387, 0.009694862, 0.006626651, 0.004408733, 0.002769248, 0.001856668, 0.001007156, 0.000479436, 0.000236021, 0.000096597, 0.000044715, 0.000022276, 0.000012558, 0.000004344, 0.000003109, 0.000001587, 0.000000000, 0.000000000),
 ASFR1980 = c(0.000047004, 0.000510820, 0.002037849, 0.005025035, 0.011274545, 0.021780467, 0.038662594, 0.064155775, 0.107039938, 0.153595802, 0.185813488, 0.204778178, 0.196688529, 0.176708721, 0.149484860, 0.120946198, 0.087655629, 0.066056160, 0.044368279, 0.034005781, 0.024682091, 0.016870941, 0.011605586, 0.007992752, 0.005486923, 0.003471239, 0.002275825, 0.001452036, 0.000764381, 0.000386250, 0.000195205, 0.000065832, 0.000035683, 0.000006241, 0.000008888, 0.000000000, 0.000001348, 0.000000000, 0.000000000, 0.000000000),
 ASFR1985 = c(0.000105524, 0.000749910, 0.002492273, 0.005348907, 0.014222000, 0.021623323, 0.035304048, 0.055206325, 0.084251147, 0.121392025, 0.158529657, 0.185214814, 0.191854121, 0.188065959, 0.166656912, 0.138612238, 0.109196349, 0.083022874, 0.062400290, 0.045694036, 0.032047982, 0.021856284, 0.014900668, 0.009130913, 0.006749212, 0.004245422, 0.002472931, 0.001576511, 0.000763892, 0.000395075, 0.000166578, 0.000074107, 0.000040513, 0.000008307, 0.000004708, 0.000000000, 0.000001263, 0.000000000, 0.000000000, 0.000000000),
 ASFR1990 = c(0.000100246, 0.000593825, 0.001939386, 0.004641243, 0.010634627, 0.018556033, 0.028619560, 0.041738200, 0.053894828, 0.090066115, 0.107246300, 0.132764463, 0.149122973, 0.154970482, 0.149950692, 0.134078482, 0.111593908, 0.090613185, 0.071777705, 0.053159648, 0.038877110, 0.028098748, 0.018969053, 0.012657299, 0.008403840, 0.005248922, 0.003017329, 0.001729599, 0.000859374, 0.000395120, 0.000159605, 0.000067431, 0.000024888, 0.000008390, 0.000005364, 0.000000000, 0.000000000, 0.000000000, 0.000000000, 0.000000000),
 ASFR1995 = c(0.000139844, 0.000821193, 0.002205650, 0.004771452, 0.010382292, 0.018157305, 0.027600871, 0.036811743, 0.050118426, 0.066454767, 0.085649146, 0.105659523, 0.122525624, 0.119505349, 0.142152548, 0.121574239, 0.108585030, 0.091893237, 0.076431224, 0.059915052, 0.045269969, 0.033716193, 0.023370778, 0.016156330, 0.010571075, 0.006603901, 0.004003958, 0.002254599, 0.001233951, 0.000557760, 0.000225834, 0.000090732, 0.000033846, 0.000010648, 0.000014076, 0.000000000, 0.000000000, 0.000000000, 0.000000000, 0.000000000),
 ASFR2000 = c(0.000326523, 0.001312392, 0.003809118, 0.007258369, 0.013960783, 0.021319571, 0.029766957, 0.036661848, 0.046098427, 0.059239583, 0.074309419, 0.088834137, 0.100687857, 0.109512446, 0.113622172, 0.110591679, 0.104234727, 0.093800356, 0.072992318, 0.070056959, 0.051635939, 0.040188530, 0.028535257, 0.020080841, 0.013713545, 0.008777109, 0.005205700, 0.002893721, 0.001511141, 0.000751093, 0.000303392, 0.000104448, 0.000041988, 0.000015012, 0.000016156, 0.000000000, 0.000000000, 0.000000000, 0.000000000, 0.000000000),
 ASFR2005 = c(0.000356895, 0.001321707, 0.003445039, 0.006679420, 0.013583641, 0.020790521, 0.028741653, 0.036167981, 0.043748595, 0.053466942, 0.064359061, 0.076213510, 0.086301413, 0.095462295, 0.101839374, 0.102042852, 0.096274417, 0.087443432, 0.077724881, 0.066407235, 0.055796412, 0.045255195, 0.033900009, 0.022827080, 0.018904444, 0.010808441, 0.006803036, 0.003738373, 0.001930482, 0.000966168, 0.000437347, 0.000162657, 0.000070111, 0.000044783, 0.000070738, 0.000000000, 0.000000000, 0.000000000, 0.000000000, 0.000000000),
 ASFR2010 = c(0.000380558, 0.001230021, 0.003153180, 0.006176307, 0.012558422, 0.019731645, 0.027595312, 0.034222582, 0.043587140, 0.056079935, 0.066494510, 0.078677105, 0.090132039, 0.100037786, 0.107008876, 0.107172384, 0.105965360, 0.099397855, 0.091271896, 0.081027563, 0.070645151, 0.058617560, 0.045109766, 0.034543522, 0.025469225, 0.017338228, 0.010941179, 0.006300612, 0.003025582, 0.001550367, 0.000549636, 0.000237037, 0.000070889, 0.000055741, 0.000055195, 0.000000000, 0.000000000, 0.000000000, 0.000000000, 0.000000000),
 ASFR2015 = c(0.000268852, 0.001034745, 0.003016254, 0.005513041, 0.010487962, 0.016321517, 0.022067943, 0.027440417, 0.034788265, 0.044089810, 0.055644873, 0.068677944, 0.083363810, 0.096377105, 0.108055697, 0.109601456, 0.108232560, 0.103075316, 0.096212307, 0.089472857, 0.080159189, 0.068767078, 0.055365855, 0.044224725, 0.033133296, 0.024036828, 0.015170290, 0.008962763, 0.004720461, 0.002159509, 0.000886836, 0.000272630, 0.000138157, 0.000045016, 0.000038736, 0.000017450, 0.000023589, 0.000002544, 0.000007885, 0.000004001),
 ASFR2020 = c(0.000151579, 0.000542779, 0.001707857, 0.003251824, 0.006659107, 0.010902761, 0.016309738, 0.021512472, 0.028710428, 0.036917100, 0.048126821, 0.060045214, 0.074483887, 0.087481828, 0.098176578, 0.101730923, 0.102133856, 0.097294553, 0.090411651, 0.085518812, 0.076083360, 0.065330843, 0.053918682, 0.043070128, 0.034585028, 0.024906175, 0.016917903, 0.010047010, 0.005679595, 0.002648600, 0.001077966, 0.000399525, 0.000144552, 0.000069101, 0.000040326, 0.000020778, 0.000007765, 0.000015905, 0.000007967, 0.000001453),
 ASMFR1950 = c(0.111650485, 0.264957265, 0.340912321, 0.364502211, 0.386313519, 0.398085884, 0.392243924, 0.372486904, 0.363518955, 0.342825610, 0.321345902, 0.311314754, 0.289978056, 0.274731978, 0.265543330, 0.226904100, 0.225251121, 0.207961962, 0.188795847, 0.171567381, 0.157246495, 0.137007157, 0.122814772, 0.105430175, 0.090307754, 0.073174574, 0.054403597, 0.038830213, 0.023387789, 0.014439706, 0.006518721, 0.003277118, 0.001440814, 0.000918740, 0.000641021, 0.000329466, 0.000217353, 0.000186215, 0.000169980, 0.000098843),
 ASMFR1955 = c(0.097674419, 0.263650546, 0.304214436, 0.316316046, 0.330543574, 0.353772839, 0.357159882, 0.352682622, 0.340584891, 0.314052041, 0.285920661, 0.264647339, 0.233358078, 0.211251607, 0.185271218, 0.161948809, 0.144646152, 0.126642892, 0.110494482, 0.097057783, 0.075179804, 0.069561009, 0.057305873, 0.046473369, 0.036367769, 0.028571097, 0.020029843, 0.013774895, 0.008107457, 0.004384924, 0.002110984, 0.001050919, 0.000451390, 0.000285606, 0.000161249, 0.000147392, 0.000092900, 0.000066250, 0.000036080, 0.000042326),
 ASMFR1960 = c(0.082352941, 0.272727273, 0.291313559, 0.297179487, 0.315156974, 0.320722892, 0.351839541, 0.356282425, 0.336318501, 0.326736645, 0.297205316, 0.272024755, 0.243683553, 0.206311447, 0.172024206, 0.139524064, 0.110653709, 0.085657217, 0.067866227, 0.052219526, 0.040067280, 0.032339195, 0.024921563, 0.019346544, 0.015198562, 0.010276369, 0.008273083, 0.005575359, 0.003382240, 0.001877358, 0.001016086, 0.000456300, 0.000338905, 0.000128113, 0.000102761, 0.000056500, 0.000043464, 0.000034568, 0.000019599, 0.000027620),
 ASMFR1965 = c(0.009326425, 0.155610973, 0.289855072, 0.289076087, 0.318478075, 0.350908575, 0.353974816, 0.364453314, 0.364168630, 0.339421504, 0.313861651, 0.295791423, 0.266995645, 0.222661355, 0.188043982, 0.150675020, 0.118358795, 0.092176300, 0.068847479, 0.050912188, 0.037137155, 0.027071196, 0.018812249, 0.013290341, 0.009237345, 0.006300891, 0.004510136, 0.002881373, 0.001680672, 0.000995244, 0.000449056, 0.000236189, 0.000127374, 0.000079076, 0.000044573, 0.000013021, 0.000010437, 0.000008230, 0.000002794, 0.000002979),
 ASMFR1970 = c(0.011671612, 0.033333333, 0.125141388, 0.236120907, 0.303323615, 0.324985759, 0.330751579, 0.349900356, 0.333900515, 0.353983926, 0.348181102, 0.298206025, 0.263793531, 0.228832563, 0.184347491, 0.145343727, 0.115159837, 0.090507668, 0.068883350, 0.051735004, 0.037038697, 0.027087537, 0.019574997, 0.013558500, 0.009176395, 0.006015216, 0.003913949, 0.002454769, 0.001334428, 0.000782260, 0.000479764, 0.000201364, 0.000105613, 0.000053358, 0.000040591, 0.000008351, 0.000034311, 0.000013164, 0.000002680, 0.000000000),
 ASMFR1975 = c(0.001092896, 0.126630435, 0.270044053, 0.327397260, 0.344766225, 0.342056497, 0.356818182, 0.348482828, 0.347899094, 0.343230046, 0.321849368, 0.279130726, 0.244489918, 0.187777011, 0.164241984, 0.132579749, 0.095143856, 0.072212492, 0.053429235, 0.038300922, 0.027407176, 0.020450621, 0.014557650, 0.010316631, 0.007033095, 0.004681326, 0.002950495, 0.001964085, 0.001081956, 0.000519989, 0.000255215, 0.000106004, 0.000049268, 0.000024830, 0.000013477, 0.000005293, 0.000003850, 0.000001994, 0.000000000, 0.000000000),
 ASMFR1980 = c(0.011396011, 0.175187032, 0.342270108, 0.359799499, 0.367088044, 0.356684294, 0.351806013, 0.341617968, 0.349177613, 0.339571113, 0.315084436, 0.289245502, 0.251287739, 0.211777110, 0.172304904, 0.135593486, 0.096463911, 0.071740380, 0.047556148, 0.035996939, 0.025869221, 0.017460981, 0.011847088, 0.008084642, 0.005484681, 0.003452324, 0.002257986, 0.001431157, 0.000735769, 0.000384927, 0.000185565, 0.000062384, 0.000037375, 0.000006546, 0.000007997, 0.000000000, 0.000001414, 0.000000000, 0.000000000, 0.000000000),
 ASMFR1985 = c(0.011904762, 0.315270936, 0.433925997, 0.407255492, 0.465967309, 0.389048379, 0.357563477, 0.334709202, 0.326119266, 0.321844576, 0.309791873, 0.292658005, 0.266744373, 0.238598749, 0.199678689, 0.160374162, 0.122841276, 0.091715092, 0.067735622, 0.048996093, 0.033988973, 0.022852376, 0.015412714, 0.009349121, 0.006763367, 0.004211128, 0.002405716, 0.001504478, 0.000723916, 0.000359583, 0.000166087, 0.000077593, 0.000037185, 0.000006198, 0.000003685, 0.000000000, 0.000001321, 0.000000000, 0.000000000, 0.000000000),
 ASMFR1990 = c(0.031746032, 0.481182796, 0.440445587, 0.431764097, 0.454739777, 0.406756299, 0.367453616, 0.336975802, 0.289003845, 0.313753423, 0.274378383, 0.263864803, 0.247375273, 0.227071707, 0.202357950, 0.170714367, 0.136615152, 0.107947583, 0.083701327, 0.061148127, 0.044217282, 0.031572993, 0.021128948, 0.013991474, 0.009243155, 0.005736702, 0.003261151, 0.001852036, 0.000905083, 0.000424343, 0.000161672, 0.000072829, 0.000027531, 0.000007300, 0.000006254, 0.000000000, 0.000000000, 0.000000000, 0.000000000, 0.000000000),
 ASMFR1995 = c(0.078431373, 0.572337043, 0.600852878, 0.536020077, 0.513868023, 0.444279787, 0.388509294, 0.330147213, 0.295827903, 0.270099714, 0.255705908, 0.244282238, 0.235049336, 0.200536954, 0.216310748, 0.171339050, 0.145309888, 0.118106594, 0.095092918, 0.072737298, 0.053861957, 0.026554242, 0.018124970, 0.012588007, 0.007624483, 0.004447187, 0.002653575, 0.001426369, 0.000638979, 0.000255445, 0.000107192, 0.000039424, 0.000009962, 0.000008365, 0.000000000, 0.000000000, 0.000000000, 0.000000000, 0.000000000, 0.000000000),
 ASMFR2000 = c(0.052132701, 0.486430063, 0.568161568, 0.546152937, 0.533508974, 0.472864968, 0.421738325, 0.360007850, 0.319685781, 0.288979784, 0.263998101, 0.242661959, 0.225951002, 0.211097489, 0.195798324, 0.175374979, 0.154787395, 0.132653549, 0.099533703, 0.093013056, 0.066421146, 0.050518010, 0.035088964, 0.024196175, 0.016247003, 0.010236378, 0.005967089, 0.003279362, 0.001683927, 0.000802590, 0.000337899, 0.000112724, 0.000048742, 0.000014106, 0.000016988, 0.000000000, 0.000000000, 0.000000000, 0.000000000, 0.000000000),
 ASMFR2005 = c(0.113636364, 0.620805369, 0.558731402, 0.554736512, 0.577059407, 0.496662814, 0.437196852, 0.377534957, 0.327779190, 0.295107972, 0.265029949, 0.245802509, 0.227811618, 0.213768257, 0.199502425, 0.180423531, 0.158578348, 0.136775013, 0.116865264, 0.096577182, 0.078909118, 0.062225893, 0.045590402, 0.030007699, 0.024515444, 0.013682288, 0.008455040, 0.004559795, 0.002282878, 0.001137280, 0.000510440, 0.000188251, 0.000085181, 0.000046826, 0.000082248, 0.000000000, 0.000000000, 0.000000000, 0.000000000, 0.000000000),
 ASMFR2010 = c(0.011363636, 0.653645833, 0.579075426, 0.584449813, 0.628913444, 0.539346405, 0.480086182, 0.401357909, 0.359204158, 0.327815039, 0.286643849, 0.263711969, 0.247185038, 0.233364916, 0.220968388, 0.199900973, 0.184370093, 0.164122433, 0.144388051, 0.123695535, 0.104735523, 0.085001306, 0.064122051, 0.048430300, 0.035293452, 0.023710410, 0.014669911, 0.008333465, 0.003948020, 0.001979181, 0.000684789, 0.000303361, 0.000081863, 0.000067915, 0.000068376, 0.000000000, 0.000000000, 0.000000000, 0.000000000, 0.000000000),
 ASMFR2015 = c(0.020833333, 0.370288248, 0.683576956, 0.525983146, 0.566655340, 0.504986563, 0.450066477, 0.380064475, 0.333074574, 0.294221705, 0.262226948, 0.243462590, 0.236288460, 0.229085124, 0.224262865, 0.205688282, 0.189131459, 0.170583903, 0.152718617, 0.137456704, 0.119570505, 0.100546202, 0.079651826, 0.062845143, 0.046472247, 0.033448290, 0.020957913, 0.012239433, 0.006430971, 0.002908319, 0.001172588, 0.000357149, 0.000183783, 0.000057770, 0.000051878, 0.000022312, 0.000028737, 0.000003432, 0.000007034, 0.000005323),
 ASMFR2020 = c(0.024390244, 0.266666667, 0.622923588, 0.493907392, 0.523959426, 0.473943662, 0.418034807, 0.344974016, 0.304968633, 0.263107454, 0.239375340, 0.222388726, 0.217712572, 0.214580121, 0.210842066, 0.196913019, 0.183578530, 0.165250947, 0.146635331, 0.133227103, 0.115040734, 0.096254470, 0.077895000, 0.061219272, 0.048613074, 0.034698585, 0.023481082, 0.013835274, 0.007756589, 0.003598687, 0.001444940, 0.000537141, 0.000197673, 0.000092142, 0.000053667, 0.000028403, 0.000011171, 0.000017867, 0.000011336, 0.000002073)
)

# Completed life tables of Japan
# Source: http://www.stat.go.jp/data/chouki/02.htm and http://www.stat.go.jp/data/chouki/zuhyou/02-35.xls
# http://www.mhlw.go.jp/toukei/saikin/hw/life/20th/index.html
# http://www.mhlw.go.jp/toukei/saikin/hw/life/21th/index.html (for qx2010M and qx2010F)
# http://www.mhlw.go.jp/toukei/saikin/hw/life/22th/index.html (for qx2015M and qx2015F)
# http://www.mhlw.go.jp/toukei/saikin/hw/life/23th/index.html (for qx2020M and qx2020F)
Jlife <- data.frame(
 Age = 0:116,
 qx1895M = c(0.14895, 0.04472, 0.02956, 0.02011, 0.01384, 0.00999, 0.00779, 0.00635, 0.00540, 0.00481, 0.00451, 0.00422, 0.00412, 0.00427, 0.00465, 0.00521, 0.00595, 0.00667, 0.00738, 0.00784, 0.00821, 0.00844, 0.00866, 0.00877, 0.00881, 0.00880, 0.00876, 0.00871, 0.00867, 0.00863, 0.00863, 0.00866, 0.00873, 0.00886, 0.00903, 0.00927, 0.00955, 0.00990, 0.01029, 0.01072, 0.01119, 0.01168, 0.01221, 0.01277, 0.01338, 0.01406, 0.01481, 0.01564, 0.01656, 0.01756, 0.01864, 0.01979, 0.02104, 0.02241, 0.02390, 0.02556, 0.02740, 0.02943, 0.03164, 0.03399, 0.03649, 0.03909, 0.04185, 0.04478, 0.04796, 0.05141, 0.05525, 0.05946, 0.06406, 0.06907, 0.07445, 0.08022, 0.08638, 0.09294, 0.09992, 0.10740, 0.11540, 0.12390, 0.13280, 0.14220, 0.15190, 0.16150, 0.17100, 0.18010, 0.18840, 0.19570, 0.21000, 0.22530, 0.24170, 0.25930, 0.27800, 0.29850, 0.32030, 0.34360, 0.36870, 0.39560, 0.42440, 0.45540, 0.48860, 0.52180, 0.56240, 0.60340, 0.64740, 0.69460, 0.74520, 0.79960, 0.85780, 0.92040, 0.98750, 1.00000, NA, NA, NA, NA, NA, NA, NA),
 qx1895F = c(0.13380, 0.04162, 0.02824, 0.01946, 0.01356, 0.00978, 0.00743, 0.00603, 0.00517, 0.00466, 0.00441, 0.00432, 0.00446, 0.00483, 0.00528, 0.00595, 0.00665, 0.00738, 0.00808, 0.00863, 0.00899, 0.00925, 0.00950, 0.00966, 0.00977, 0.00984, 0.00989, 0.00993, 0.00998, 0.01006, 0.01015, 0.01027, 0.01042, 0.01060, 0.01081, 0.01102, 0.01123, 0.01143, 0.01159, 0.01172, 0.01179, 0.01183, 0.01185, 0.01188, 0.01196, 0.01212, 0.01239, 0.01278, 0.01329, 0.01391, 0.01464, 0.01543, 0.01637, 0.01737, 0.01848, 0.01972, 0.02111, 0.02267, 0.02438, 0.02625, 0.02826, 0.03042, 0.03274, 0.03525, 0.03799, 0.04101, 0.04437, 0.04809, 0.05218, 0.05668, 0.06154, 0.06687, 0.07260, 0.07880, 0.08550, 0.09280, 0.10060, 0.10900, 0.11790, 0.12710, 0.13650, 0.14590, 0.15510, 0.16390, 0.17220, 0.18000, 0.19450, 0.21020, 0.22720, 0.24560, 0.26540, 0.28680, 0.31000, 0.33510, 0.36210, 0.39140, 0.42300, 0.45710, 0.49410, 0.53400, 0.57710, 0.62370, 0.67410, 0.72850, 0.78730, 0.85090, 0.91960, 0.99390, 1.00000, NA, NA, NA, NA, NA, NA, NA, NA),
 qx1901M = c(0.15686, 0.03686, 0.02591, 0.01700, 0.01119, 0.00787, 0.00585, 0.00475, 0.00412, 0.00364, 0.00331, 0.00316, 0.00317, 0.00354, 0.00414, 0.00475, 0.00551, 0.00633, 0.00713, 0.00781, 0.00830, 0.00860, 0.00872, 0.00870, 0.00856, 0.00838, 0.00818, 0.00800, 0.00789, 0.00785, 0.00787, 0.00795, 0.00808, 0.00825, 0.00845, 0.00869, 0.00896, 0.00927, 0.00961, 0.00999, 0.01040, 0.01087, 0.01138, 0.01194, 0.01258, 0.01328, 0.01404, 0.01487, 0.01577, 0.01673, 0.01775, 0.01887, 0.02009, 0.02141, 0.02288, 0.02448, 0.02624, 0.02816, 0.03027, 0.03256, 0.03506, 0.03778, 0.04074, 0.04397, 0.04746, 0.05121, 0.05522, 0.05952, 0.06414, 0.06910, 0.07445, 0.08022, 0.08640, 0.09296, 0.09984, 0.10750, 0.11580, 0.12470, 0.13430, 0.14470, 0.15580, 0.16780, 0.18070, 0.19460, 0.20960, 0.22580, 0.24320, 0.26190, 0.28210, 0.30380, 0.32720, 0.35240, 0.37950, 0.40870, 0.44020, 0.47400, 0.51060, 0.54980, 0.59220, 0.63780, 0.68690, 0.73980, 0.79670, 0.85810, 0.92420, 0.99530, 1.00000, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 qx1901F = c(0.14092, 0.03598, 0.02602, 0.01732, 0.01168, 0.00810, 0.00596, 0.00481, 0.00422, 0.00391, 0.00377, 0.00385, 0.00421, 0.00481, 0.00556, 0.00638, 0.00724, 0.00806, 0.00876, 0.00929, 0.00964, 0.00985, 0.00994, 0.00996, 0.00995, 0.00992, 0.00990, 0.00990, 0.00990, 0.00993, 0.00998, 0.01006, 0.01017, 0.01031, 0.01048, 0.01067, 0.01087, 0.01105, 0.01121, 0.01132, 0.01138, 0.01139, 0.01138, 0.01135, 0.01138, 0.01149, 0.01171, 0.01204, 0.01251, 0.01310, 0.01380, 0.01458, 0.01544, 0.01637, 0.01739, 0.01852, 0.01977, 0.02118, 0.02277, 0.02453, 0.02650, 0.02869, 0.03110, 0.03376, 0.03668, 0.03987, 0.04337, 0.04717, 0.05130, 0.05581, 0.06072, 0.06605, 0.07183, 0.07811, 0.08494, 0.09200, 0.09965, 0.10790, 0.11690, 0.12660, 0.13720, 0.14860, 0.16090, 0.17430, 0.18880, 0.20450, 0.22150, 0.23990, 0.25980, 0.28140, 0.30480, 0.33010, 0.35760, 0.38730, 0.41950, 0.45440, 0.49210, 0.53300, 0.57730, 0.62530, 0.67730, 0.73360, 0.79460, 0.86070, 0.93220, 1.00000, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 qx1911M = c(0.16050, 0.04410, 0.02357, 0.01473, 0.01027, 0.00710, 0.00539, 0.00449, 0.00391, 0.00349, 0.00320, 0.00306, 0.00312, 0.00358, 0.00427, 0.00499, 0.00588, 0.00682, 0.00769, 0.00840, 0.00887, 0.00909, 0.00911, 0.00899, 0.00878, 0.00854, 0.00829, 0.00807, 0.00792, 0.00780, 0.00773, 0.00771, 0.00774, 0.00781, 0.00794, 0.00810, 0.00829, 0.00854, 0.00884, 0.00919, 0.00959, 0.01002, 0.01051, 0.01104, 0.01161, 0.01224, 0.01292, 0.01367, 0.01449, 0.01540, 0.01640, 0.01750, 0.01861, 0.01998, 0.02138, 0.02291, 0.02457, 0.02638, 0.02836, 0.03051, 0.03284, 0.03535, 0.03805, 0.04099, 0.04416, 0.04760, 0.05135, 0.05544, 0.05988, 0.06466, 0.06978, 0.07530, 0.08098, 0.08700, 0.09323, 0.10132, 0.10883, 0.11667, 0.12564, 0.13531, 0.14572, 0.15692, 0.16900, 0.18200, 0.19600, 0.21108, 0.22732, 0.24481, 0.26364, 0.28393, 0.30577, 0.32930, 0.35463, 0.38191, 0.41129, 0.44293, 0.47701, 0.51370, 0.55322, 0.59578, 0.64162, 0.69098, 0.74414, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 qx1911F = c(0.14504, 0.04370, 0.02386, 0.01473, 0.01037, 0.00757, 0.00581, 0.00486, 0.00432, 0.00403, 0.00396, 0.00418, 0.00475, 0.00558, 0.00653, 0.00755, 0.00856, 0.00945, 0.01012, 0.01056, 0.01079, 0.01084, 0.01078, 0.01065, 0.01048, 0.01031, 0.01014, 0.01001, 0.00991, 0.00984, 0.00983, 0.00984, 0.00989, 0.00998, 0.01009, 0.01021, 0.01034, 0.01046, 0.01055, 0.01062, 0.01065, 0.01065, 0.01063, 0.01062, 0.01066, 0.01076, 0.01097, 0.01129, 0.01172, 0.01230, 0.01296, 0.01372, 0.01456, 0.01546, 0.01644, 0.01750, 0.01865, 0.01990, 0.02129, 0.02283, 0.02456, 0.02647, 0.02860, 0.03098, 0.03361, 0.03654, 0.03978, 0.04334, 0.04728, 0.05161, 0.05657, 0.06158, 0.06688, 0.07243, 0.07827, 0.08446, 0.09108, 0.09826, 0.10609, 0.11469, 0.12410, 0.13465, 0.14579, 0.15785, 0.17091, 0.18504, 0.20034, 0.21691, 0.23485, 0.25427, 0.27530, 0.29807, 0.32273, 0.34941, 0.37831, 0.40960, 0.44347, 0.48015, 0.51986, 0.56285, 0.60940, 0.65979, 0.71437, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 qx1923M = c(0.16204, 0.04845, 0.02611, 0.01655, 0.01050, 0.00704, 0.00534, 0.00458, 0.00392, 0.00341, 0.00317, 0.00307, 0.00314, 0.00357, 0.00452, 0.00597, 0.00766, 0.00920, 0.01032, 0.01083, 0.01080, 0.01060, 0.01039, 0.01020, 0.00991, 0.00951, 0.00911, 0.00879, 0.00851, 0.00832, 0.00823, 0.00823, 0.00822, 0.00832, 0.00842, 0.00871, 0.00897, 0.00931, 0.00963, 0.01007, 0.01053, 0.01098, 0.01153, 0.01224, 0.01297, 0.01371, 0.01442, 0.01528, 0.01632, 0.01755, 0.01862, 0.01976, 0.02101, 0.02269, 0.02436, 0.02627, 0.02853, 0.03103, 0.03372, 0.03657, 0.03915, 0.04196, 0.04493, 0.04864, 0.05277, 0.05705, 0.06130, 0.06594, 0.07166, 0.07817, 0.08480, 0.09119, 0.09851, 0.10649, 0.11517, 0.12446, 0.13448, 0.14527, 0.15694, 0.16927, 0.18274, 0.19705, 0.21234, 0.22859, 0.24579, 0.26460, 0.28427, 0.30468, 0.32707, 0.35116, 0.37276, 0.40000, 0.42667, 0.45349, 0.48328, 0.51059, 0.54087, 0.57330, 0.60245, 0.63426, 0.66624, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 qx1923F = c(0.14400, 0.04757, 0.02627, 0.01741, 0.01146, 0.00776, 0.00575, 0.00490, 0.00415, 0.00375, 0.00373, 0.00386, 0.00435, 0.00562, 0.00726, 0.00901, 0.01026, 0.01115, 0.01167, 0.01199, 0.01208, 0.01214, 0.01205, 0.01181, 0.01147, 0.01117, 0.01091, 0.01081, 0.01068, 0.01054, 0.01045, 0.01043, 0.01043, 0.01049, 0.01058, 0.01073, 0.01092, 0.01107, 0.01123, 0.01132, 0.01134, 0.01129, 0.01120, 0.01112, 0.01119, 0.01130, 0.01158, 0.01183, 0.01227, 0.01304, 0.01382, 0.01455, 0.01526, 0.01601, 0.01709, 0.01839, 0.01974, 0.02129, 0.02287, 0.02447, 0.02640, 0.02842, 0.03098, 0.03380, 0.03677, 0.03977, 0.04303, 0.04676, 0.05134, 0.05628, 0.06157, 0.06704, 0.07319, 0.08005, 0.08760, 0.09585, 0.10483, 0.11480, 0.12558, 0.13738, 0.15026, 0.16426, 0.17941, 0.19606, 0.21389, 0.23315, 0.25394, 0.27653, 0.29981, 0.32623, 0.35351, 0.38085, 0.41237, 0.44386, 0.47739, 0.51107, 0.54733, 0.58364, 0.62009, 0.65632, 0.69398, 0.72842, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 qx1928M = c(0.14010, 0.04312, 0.02237, 0.01500, 0.00981, 0.00644, 0.00485, 0.00398, 0.00335, 0.00286, 0.00263, 0.00244, 0.00251, 0.00290, 0.00370, 0.00502, 0.00649, 0.00800, 0.00911, 0.00971, 0.00982, 0.00972, 0.00952, 0.00926, 0.00896, 0.00861, 0.00825, 0.00802, 0.00775, 0.00753, 0.00739, 0.00729, 0.00733, 0.00746, 0.00760, 0.00770, 0.00778, 0.00803, 0.00846, 0.00901, 0.00958, 0.01003, 0.01061, 0.01131, 0.01200, 0.01269, 0.01350, 0.01438, 0.01540, 0.01641, 0.01750, 0.01876, 0.02015, 0.02168, 0.02341, 0.02495, 0.02689, 0.02907, 0.03145, 0.03391, 0.03671, 0.03977, 0.04354, 0.04729, 0.05121, 0.05486, 0.05898, 0.06328, 0.06826, 0.07399, 0.08035, 0.08728, 0.09362, 0.10102, 0.10894, 0.11753, 0.12661, 0.13646, 0.14697, 0.15815, 0.17020, 0.18298, 0.19667, 0.21136, 0.22657, 0.24320, 0.26067, 0.27888, 0.29821, 0.31832, 0.34141, 0.36120, 0.38743, 0.41026, 0.43623, 0.46272, 0.48804, 0.51963, 0.54669, 0.57425, 0.60484, 0.63265, 0.66389, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 qx1928F = c(0.12414, 0.04210, 0.02265, 0.01557, 0.01060, 0.00709, 0.00521, 0.00412, 0.00345, 0.00304, 0.00300, 0.00310, 0.00345, 0.00432, 0.00588, 0.00732, 0.00862, 0.00949, 0.01009, 0.01044, 0.01059, 0.01060, 0.01043, 0.01019, 0.00993, 0.00964, 0.00942, 0.00923, 0.00905, 0.00894, 0.00894, 0.00891, 0.00898, 0.00905, 0.00914, 0.00926, 0.00943, 0.00955, 0.00974, 0.00995, 0.01005, 0.01007, 0.01005, 0.01000, 0.01003, 0.01017, 0.01032, 0.01077, 0.01134, 0.01194, 0.01262, 0.01332, 0.01412, 0.01504, 0.01599, 0.01686, 0.01789, 0.01918, 0.02071, 0.02234, 0.02416, 0.02608, 0.02854, 0.03106, 0.03406, 0.03708, 0.04031, 0.04387, 0.04817, 0.05268, 0.05767, 0.06241, 0.06803, 0.07384, 0.08135, 0.08892, 0.09720, 0.10623, 0.11615, 0.12682, 0.13854, 0.15128, 0.16516, 0.18006, 0.19618, 0.21372, 0.23248, 0.25296, 0.27441, 0.29758, 0.32269, 0.34904, 0.37573, 0.40752, 0.43386, 0.47009, 0.50088, 0.53710, 0.56947, 0.60638, 0.64234, 0.67758, 0.71328, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 qx1935M = c(0.11303, 0.03699, 0.02045, 0.01349, 0.00911, 0.00648, 0.00460, 0.00361, 0.00300, 0.00261, 0.00240, 0.00226, 0.00234, 0.00263, 0.00343, 0.00479, 0.00635, 0.00782, 0.00888, 0.00950, 0.00996, 0.01016, 0.01009, 0.00988, 0.00950, 0.00922, 0.00884, 0.00854, 0.00822, 0.00791, 0.00769, 0.00759, 0.00753, 0.00757, 0.00751, 0.00760, 0.00763, 0.00782, 0.00811, 0.00846, 0.00891, 0.00933, 0.00981, 0.01050, 0.01113, 0.01185, 0.01247, 0.01348, 0.01474, 0.01606, 0.01725, 0.01829, 0.01945, 0.02104, 0.02251, 0.02398, 0.02590, 0.02817, 0.03060, 0.03315, 0.03554, 0.03805, 0.04026, 0.04441, 0.04800, 0.05191, 0.05609, 0.06063, 0.06556, 0.07089, 0.07668, 0.08289, 0.08966, 0.09692, 0.10472, 0.11326, 0.12232, 0.13212, 0.14270, 0.15398, 0.16615, 0.17920, 0.19316, 0.20821, 0.22386, 0.24096, 0.25878, 0.27839, 0.29766, 0.32010, 0.34275, 0.36390, 0.39189, 0.41630, 0.44416, 0.47032, 0.50000, 0.52931, 0.56044, 0.58958, 0.62132, 0.65147, 0.68308, 0.71359, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 qx1935F = c(0.09917, 0.03527, 0.01996, 0.01361, 0.00932, 0.00657, 0.00455, 0.00351, 0.00293, 0.00260, 0.00254, 0.00268, 0.00316, 0.00406, 0.00544, 0.00695, 0.00807, 0.00874, 0.00910, 0.00934, 0.00960, 0.00970, 0.00967, 0.00960, 0.00939, 0.00906, 0.00867, 0.00837, 0.00818, 0.00809, 0.00806, 0.00802, 0.00809, 0.00808, 0.00810, 0.00824, 0.00843, 0.00859, 0.00871, 0.00879, 0.00901, 0.00902, 0.00900, 0.00906, 0.00921, 0.00949, 0.00971, 0.01015, 0.01070, 0.01140, 0.01211, 0.01281, 0.01356, 0.01440, 0.01512, 0.01590, 0.01695, 0.01810, 0.01928, 0.02085, 0.02274, 0.02446, 0.02627, 0.02876, 0.03128, 0.03408, 0.03716, 0.04059, 0.04442, 0.04861, 0.05333, 0.05846, 0.06421, 0.07055, 0.07759, 0.08530, 0.09382, 0.10325, 0.11364, 0.12497, 0.13753, 0.15118, 0.16629, 0.18259, 0.20052, 0.22000, 0.24101, 0.26374, 0.28831, 0.31465, 0.34332, 0.37361, 0.40354, 0.43894, 0.47412, 0.51007, 0.54795, 0.58586, 0.62561, 0.66450, 0.70291, 0.74183, 0.77722, 0.81307, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 qx1947M = c(0.08598, 0.03316, 0.01917, 0.01103, 0.00701, 0.00513, 0.00383, 0.00308, 0.00259, 0.00223, 0.00196, 0.00178, 0.00170, 0.00183, 0.00213, 0.00261, 0.00329, 0.00428, 0.00551, 0.00674, 0.00769, 0.00833, 0.00882, 0.00924, 0.00955, 0.00960, 0.00930, 0.00896, 0.00872, 0.00854, 0.00844, 0.00845, 0.00853, 0.00862, 0.00855, 0.00853, 0.00863, 0.00874, 0.00884, 0.00895, 0.00910, 0.00937, 0.00978, 0.01028, 0.01071, 0.01108, 0.01153, 0.01227, 0.01310, 0.01394, 0.01482, 0.01589, 0.01729, 0.01868, 0.01981, 0.02122, 0.02339, 0.02580, 0.02808, 0.03035, 0.03325, 0.03665, 0.04007, 0.04348, 0.04716, 0.05110, 0.05528, 0.05977, 0.06452, 0.06964, 0.07506, 0.08089, 0.08705, 0.09367, 0.10063, 0.10815, 0.11606, 0.12450, 0.13343, 0.14304, 0.15309, 0.16382, 0.17506, 0.18710, 0.19973, 0.21321, 0.22548, 0.24374, 0.25783, 0.27354, 0.29163, 0.30915, 0.32877, 0.34694, 0.36979, 0.38694, 0.41089, 0.43364, 0.45697, 0.48066, 0.50573, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 qx1947F = c(0.07664, 0.03245, 0.01895, 0.01091, 0.00679, 0.00479, 0.00348, 0.00275, 0.00227, 0.00199, 0.00183, 0.00174, 0.00176, 0.00200, 0.00245, 0.00305, 0.00372, 0.00446, 0.00534, 0.00627, 0.00694, 0.00731, 0.00751, 0.00768, 0.00778, 0.00765, 0.00736, 0.00720, 0.00721, 0.00728, 0.00726, 0.00715, 0.00708, 0.00704, 0.00700, 0.00700, 0.00702, 0.00710, 0.00718, 0.00729, 0.00751, 0.00782, 0.00802, 0.00807, 0.00805, 0.00820, 0.00852, 0.00897, 0.00962, 0.01039, 0.01111, 0.01171, 0.01231, 0.01290, 0.01355, 0.01439, 0.01564, 0.01697, 0.01834, 0.01993, 0.02207, 0.02447, 0.02674, 0.02827, 0.03079, 0.03353, 0.03663, 0.03993, 0.04359, 0.04763, 0.05203, 0.05684, 0.06214, 0.06789, 0.07424, 0.08117, 0.08871, 0.09698, 0.10597, 0.11578, 0.12643, 0.13805, 0.15064, 0.16435, 0.17905, 0.19505, 0.21237, 0.23079, 0.25088, 0.27217, 0.29470, 0.31952, 0.34469, 0.37165, 0.40100, 0.43096, 0.46324, 0.49521, 0.52846, 0.56264, 0.59790, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 qx1951M = c(0.05669, 0.01153, 0.00890, 0.00658, 0.00461, 0.00310, 0.00224, 0.00179, 0.00151, 0.00126, 0.00109, 0.00101, 0.00096, 0.00098, 0.00104, 0.00123, 0.00155, 0.00194, 0.00239, 0.00282, 0.00314, 0.00339, 0.00367, 0.00396, 0.00411, 0.00419, 0.00426, 0.00426, 0.00433, 0.00443, 0.00437, 0.00424, 0.00425, 0.00433, 0.00439, 0.00449, 0.00470, 0.00486, 0.00501, 0.00525, 0.00561, 0.00591, 0.00621, 0.00660, 0.00710, 0.00749, 0.00798, 0.00873, 0.00945, 0.01005, 0.01073, 0.01154, 0.01256, 0.01365, 0.01481, 0.01610, 0.01762, 0.01958, 0.02153, 0.02299, 0.02477, 0.02729, 0.03116, 0.03407, 0.03721, 0.04059, 0.04422, 0.04812, 0.05232, 0.05686, 0.06170, 0.06695, 0.07252, 0.07857, 0.08502, 0.09197, 0.09937, 0.10734, 0.11583, 0.12495, 0.13468, 0.14507, 0.15619, 0.16795, 0.18054, 0.19389, 0.20810, 0.22338, 0.23881, 0.25618, 0.27392, 0.29265, 0.31176, 0.33333, 0.35470, 0.37748, 0.39894, 0.42478, 0.44615, 0.47222, 0.50312, 0.53047, 0.55835, 0.58657, 1.00000, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 qx1951F = c(0.04973, 0.01163, 0.00879, 0.00647, 0.00449, 0.00294, 0.00202, 0.00153, 0.00122, 0.00105, 0.00095, 0.00092, 0.00095, 0.00104, 0.00112, 0.00129, 0.00151, 0.00181, 0.00217, 0.00253, 0.00277, 0.00296, 0.00325, 0.00355, 0.00371, 0.00377, 0.00384, 0.00395, 0.00395, 0.00397, 0.00399, 0.00400, 0.00403, 0.00408, 0.00414, 0.00422, 0.00431, 0.00441, 0.00460, 0.00477, 0.00495, 0.00509, 0.00523, 0.00536, 0.00558, 0.00590, 0.00629, 0.00673, 0.00724, 0.00768, 0.00804, 0.00867, 0.00946, 0.01012, 0.01069, 0.01146, 0.01246, 0.01389, 0.01510, 0.01588, 0.01690, 0.01857, 0.02028, 0.02179, 0.02505, 0.02746, 0.03009, 0.03298, 0.03616, 0.03965, 0.04351, 0.04770, 0.05237, 0.05742, 0.06300, 0.06912, 0.07579, 0.08313, 0.09113, 0.09989, 0.10945, 0.11984, 0.13123, 0.14356, 0.15699, 0.17158, 0.18726, 0.20437, 0.22269, 0.24251, 0.26359, 0.28648, 0.31077, 0.33629, 0.36382, 0.39257, 0.42287, 0.45622, 0.48305, 0.52459, 0.55172, 0.59194, 0.62783, 0.66376, 1.00000, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 qx1955M = c(0.04183, 0.00576, 0.00463, 0.00364, 0.00280, 0.00213, 0.00167, 0.00137, 0.00112, 0.00092, 0.00079, 0.00073, 0.00073, 0.00073, 0.00077, 0.00090, 0.00112, 0.00145, 0.00181, 0.00213, 0.00240, 0.00262, 0.00279, 0.00287, 0.00291, 0.00294, 0.00292, 0.00287, 0.00285, 0.00286, 0.00289, 0.00291, 0.00297, 0.00309, 0.00320, 0.00327, 0.00333, 0.00346, 0.00365, 0.00386, 0.00406, 0.00429, 0.00462, 0.00506, 0.00553, 0.00602, 0.00663, 0.00730, 0.00794, 0.00856, 0.00923, 0.01000, 0.01095, 0.01205, 0.01315, 0.01415, 0.01519, 0.01663, 0.01867, 0.02090, 0.02297, 0.02502, 0.02729, 0.02988, 0.03264, 0.03563, 0.03957, 0.04378, 0.04781, 0.05206, 0.05704, 0.06254, 0.06876, 0.07493, 0.08160, 0.08786, 0.09510, 0.10281, 0.11101, 0.11972, 0.12896, 0.13877, 0.14917, 0.16018, 0.17184, 0.18416, 0.19717, 0.21090, 0.22537, 0.24059, 0.25659, 0.27336, 0.29095, 0.30933, 0.32852, 0.34852, 0.36930, 0.39086, 0.41316, 0.43618, 0.45987, 0.48417, 0.50902, 0.53435, 0.56007, 0.58608, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 qx1955F = c(0.03689, 0.00532, 0.00434, 0.00345, 0.00267, 0.00195, 0.00134, 0.00093, 0.00073, 0.00064, 0.00062, 0.00062, 0.00062, 0.00062, 0.00065, 0.00072, 0.00084, 0.00103, 0.00127, 0.00149, 0.00168, 0.00183, 0.00196, 0.00206, 0.00211, 0.00216, 0.00221, 0.00228, 0.00235, 0.00240, 0.00246, 0.00253, 0.00257, 0.00263, 0.00272, 0.00285, 0.00298, 0.00308, 0.00317, 0.00330, 0.00341, 0.00355, 0.00376, 0.00401, 0.00427, 0.00450, 0.00483, 0.00534, 0.00589, 0.00635, 0.00671, 0.00709, 0.00765, 0.00831, 0.00892, 0.00947, 0.01014, 0.01111, 0.01234, 0.01350, 0.01454, 0.01586, 0.01761, 0.01947, 0.02115, 0.02299, 0.02569, 0.02880, 0.03194, 0.03528, 0.03879, 0.04348, 0.04792, 0.05275, 0.05799, 0.06367, 0.06983, 0.07649, 0.08370, 0.09151, 0.09994, 0.10905, 0.11887, 0.12946, 0.14087, 0.15314, 0.16631, 0.18045, 0.19559, 0.21178, 0.22906, 0.24748, 0.26707, 0.28784, 0.30983, 0.33303, 0.35745, 0.38305, 0.40981, 0.43767, 0.46656, 0.49637, 0.52698, 0.55824, 0.58999, 0.62201, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 qx1960M = c(0.03333, 0.00372, 0.00289, 0.00225, 0.00177, 0.00142, 0.00117, 0.00098, 0.00083, 0.00072, 0.00064, 0.00058, 0.00055, 0.00057, 0.00066, 0.00083, 0.00106, 0.00133, 0.00157, 0.00177, 0.00192, 0.00206, 0.00218, 0.00227, 0.00232, 0.00233, 0.00232, 0.00231, 0.00228, 0.00226, 0.00226, 0.00228, 0.00236, 0.00248, 0.00261, 0.00272, 0.00283, 0.00296, 0.00316, 0.00339, 0.00362, 0.00385, 0.00408, 0.00438, 0.00477, 0.00521, 0.00570, 0.00628, 0.00695, 0.00767, 0.00847, 0.00934, 0.01028, 0.01131, 0.01245, 0.01374, 0.01514, 0.01673, 0.01842, 0.02019, 0.02204, 0.02407, 0.02649, 0.02918, 0.03219, 0.03557, 0.03910, 0.04276, 0.04694, 0.05162, 0.05696, 0.06290, 0.06951, 0.07656, 0.08409, 0.09216, 0.10080, 0.10970, 0.11979, 0.13026, 0.14084, 0.15244, 0.16340, 0.17433, 0.18548, 0.19712, 0.20958, 0.22298, 0.23744, 0.25315, 0.27023, 0.28887, 0.30909, 0.33119, 0.35519, 0.38131, 0.40965, 0.44040, 0.47360, 0.50915, 0.54687, 0.58645, 0.62749, 0.66945, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 qx1960F = c(0.02739, 0.00323, 0.00244, 0.00185, 0.00142, 0.00112, 0.00090, 0.00071, 0.00057, 0.00049, 0.00046, 0.00044, 0.00042, 0.00041, 0.00043, 0.00049, 0.00061, 0.00078, 0.00095, 0.00109, 0.00121, 0.00131, 0.00139, 0.00145, 0.00148, 0.00151, 0.00154, 0.00157, 0.00159, 0.00161, 0.00165, 0.00172, 0.00180, 0.00189, 0.00196, 0.00204, 0.00213, 0.00226, 0.00242, 0.00258, 0.00271, 0.00281, 0.00294, 0.00315, 0.00345, 0.00379, 0.00415, 0.00451, 0.00489, 0.00526, 0.00567, 0.00617, 0.00673, 0.00734, 0.00788, 0.00842, 0.00909, 0.00997, 0.01099, 0.01210, 0.01317, 0.01435, 0.01574, 0.01742, 0.01935, 0.02156, 0.02400, 0.02658, 0.02949, 0.03285, 0.03691, 0.04172, 0.04703, 0.05269, 0.05862, 0.06501, 0.07233, 0.08027, 0.08882, 0.09732, 0.10614, 0.11639, 0.12654, 0.13726, 0.14872, 0.16085, 0.17395, 0.18809, 0.20337, 0.21992, 0.23783, 0.25722, 0.27810, 0.30071, 0.32503, 0.35123, 0.37939, 0.40963, 0.44196, 0.47629, 0.51247, 0.55027, 0.58939, 0.62942, 0.66990, 0.71026, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 qx1965M = c(0.02071, 0.00217, 0.00164, 0.00128, 0.00105, 0.00091, 0.00081, 0.00071, 0.00061, 0.00053, 0.00047, 0.00044, 0.00044, 0.00047, 0.00055, 0.00068, 0.00084, 0.00098, 0.00111, 0.00122, 0.00133, 0.00143, 0.00152, 0.00157, 0.00160, 0.00160, 0.00160, 0.00161, 0.00166, 0.00174, 0.00182, 0.00190, 0.00200, 0.00212, 0.00224, 0.00235, 0.00247, 0.00262, 0.00282, 0.00302, 0.00321, 0.00341, 0.00366, 0.00398, 0.00434, 0.00472, 0.00518, 0.00570, 0.00627, 0.00683, 0.00739, 0.00803, 0.00882, 0.00980, 0.01085, 0.01199, 0.01327, 0.01468, 0.01627, 0.01808, 0.01997, 0.02204, 0.02451, 0.02730, 0.03020, 0.03305, 0.03610, 0.03956, 0.04383, 0.04885, 0.05436, 0.06007, 0.06603, 0.07245, 0.07955, 0.08782, 0.09685, 0.10633, 0.11661, 0.12783, 0.13979, 0.15255, 0.16544, 0.17853, 0.19230, 0.20747, 0.22214, 0.23559, 0.25234, 0.26967, 0.28775, 0.30658, 0.32617, 0.34650, 0.36756, 0.38933, 0.41177, 0.43485, 0.45853, 0.48275, 0.50744, 0.53254, 0.55797, 0.58362, 0.60940, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 qx1965F = c(0.01632, 0.00180, 0.00129, 0.00095, 0.00073, 0.00061, 0.00052, 0.00043, 0.00036, 0.00031, 0.00028, 0.00027, 0.00028, 0.00030, 0.00033, 0.00036, 0.00040, 0.00046, 0.00052, 0.00059, 0.00067, 0.00075, 0.00082, 0.00088, 0.00093, 0.00097, 0.00103, 0.00106, 0.00108, 0.00111, 0.00115, 0.00120, 0.00127, 0.00136, 0.00144, 0.00151, 0.00160, 0.00169, 0.00179, 0.00191, 0.00203, 0.00218, 0.00236, 0.00258, 0.00284, 0.00311, 0.00342, 0.00374, 0.00409, 0.00442, 0.00473, 0.00508, 0.00552, 0.00604, 0.00659, 0.00717, 0.00783, 0.00856, 0.00937, 0.01022, 0.01118, 0.01234, 0.01372, 0.01524, 0.01699, 0.01896, 0.02120, 0.02370, 0.02643, 0.02935, 0.03270, 0.03684, 0.04159, 0.04670, 0.05239, 0.05918, 0.06693, 0.07556, 0.08491, 0.09473, 0.10541, 0.11755, 0.12993, 0.14171, 0.15260, 0.16395, 0.17703, 0.19278, 0.21032, 0.22699, 0.24453, 0.26296, 0.28228, 0.30250, 0.32363, 0.34563, 0.36851, 0.39223, 0.41676, 0.44204, 0.46802, 0.49461, 0.52175, 0.54931, 0.57720, 0.60527, 0.63340, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 qx1970M = c(0.01481, 0.00167, 0.00125, 0.00099, 0.00082, 0.00073, 0.00066, 0.00056, 0.00047, 0.00041, 0.00038, 0.00039, 0.00040, 0.00042, 0.00051, 0.00069, 0.00093, 0.00114, 0.00127, 0.00131, 0.00132, 0.00133, 0.00132, 0.00130, 0.00130, 0.00134, 0.00139, 0.00145, 0.00149, 0.00151, 0.00154, 0.00159, 0.00167, 0.00180, 0.00197, 0.00214, 0.00232, 0.00251, 0.00271, 0.00292, 0.00312, 0.00332, 0.00354, 0.00379, 0.00407, 0.00438, 0.00470, 0.00506, 0.00552, 0.00607, 0.00666, 0.00728, 0.00794, 0.00870, 0.00960, 0.01067, 0.01186, 0.01311, 0.01445, 0.01593, 0.01767, 0.01970, 0.02195, 0.02443, 0.02771, 0.03003, 0.03325, 0.03683, 0.04070, 0.04494, 0.04957, 0.05462, 0.06038, 0.06673, 0.07358, 0.08106, 0.08899, 0.09695, 0.10497, 0.11354, 0.12385, 0.13533, 0.14725, 0.15970, 0.17243, 0.18542, 0.19980, 0.21560, 0.23241, 0.24583, 0.26644, 0.28503, 0.30446, 0.32473, 0.34583, 0.36775, 0.39046, 0.41393, 0.43812, 0.46298, 0.48844, 0.51443, 0.54086, 0.56764, 0.59465, 0.62176, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 qx1970F = c(0.01149, 0.00137, 0.00097, 0.00071, 0.00055, 0.00046, 0.00040, 0.00034, 0.00030, 0.00027, 0.00025, 0.00024, 0.00024, 0.00025, 0.00028, 0.00032, 0.00037, 0.00043, 0.00050, 0.00056, 0.00061, 0.00066, 0.00069, 0.00072, 0.00075, 0.00078, 0.00081, 0.00084, 0.00087, 0.00088, 0.00091, 0.00096, 0.00102, 0.00110, 0.00118, 0.00125, 0.00133, 0.00142, 0.00152, 0.00164, 0.00177, 0.00193, 0.00210, 0.00226, 0.00242, 0.00260, 0.00281, 0.00310, 0.00345, 0.00380, 0.00412, 0.00443, 0.00479, 0.00525, 0.00578, 0.00634, 0.00690, 0.00743, 0.00805, 0.00888, 0.00998, 0.01122, 0.01250, 0.01375, 0.01499, 0.01652, 0.01844, 0.02063, 0.02306, 0.02591, 0.02922, 0.03314, 0.03765, 0.04262, 0.04780, 0.05360, 0.06034, 0.06763, 0.07502, 0.08283, 0.09200, 0.10242, 0.11377, 0.12626, 0.13973, 0.15343, 0.16731, 0.18136, 0.19544, 0.21020, 0.22550, 0.24122, 0.25735, 0.27389, 0.29083, 0.30815, 0.32586, 0.34393, 0.36235, 0.38111, 0.40017, 0.41952, 0.43913, 0.45897, 0.47901, 0.49922, 0.51956, 0.53999, 0.56047, 0.58096, NA, NA, NA, NA, NA, NA, NA),
 qx1975M = c(0.01110, 0.00140, 0.00101, 0.00076, 0.00062, 0.00055, 0.00050, 0.00044, 0.00037, 0.00032, 0.00028, 0.00028, 0.00027, 0.00029, 0.00039, 0.00056, 0.00075, 0.00092, 0.00102, 0.00105, 0.00105, 0.00106, 0.00107, 0.00107, 0.00106, 0.00105, 0.00104, 0.00104, 0.00106, 0.00110, 0.00116, 0.00122, 0.00131, 0.00139, 0.00147, 0.00159, 0.00174, 0.00192, 0.00212, 0.00234, 0.00259, 0.00287, 0.00318, 0.00349, 0.00378, 0.00404, 0.00431, 0.00460, 0.00491, 0.00529, 0.00573, 0.00618, 0.00667, 0.00723, 0.00790, 0.00872, 0.00971, 0.01074, 0.01174, 0.01275, 0.01393, 0.01534, 0.01701, 0.01889, 0.02098, 0.02351, 0.02649, 0.02975, 0.03310, 0.03655, 0.04024, 0.04453, 0.04958, 0.05507, 0.06094, 0.06700, 0.07365, 0.08137, 0.09010, 0.09980, 0.11039, 0.12161, 0.13272, 0.14407, 0.15618, 0.16957, 0.18384, 0.19851, 0.21345, 0.22841, 0.24225, 0.25905, 0.27513, 0.29154, 0.30829, 0.32537, 0.34275, 0.36042, 0.37838, 0.39660, 0.41505, 0.43373, 0.45259, 0.47163, 0.49081, 0.51009, 0.52946, 0.54887, 0.56829, NA, NA, NA, NA, NA, NA, NA, NA),
 qx1975F = c(0.00871, 0.00111, 0.00078, 0.00056, 0.00042, 0.00035, 0.00030, 0.00025, 0.00022, 0.00020, 0.00018, 0.00018, 0.00019, 0.00020, 0.00022, 0.00025, 0.00028, 0.00033, 0.00038, 0.00044, 0.00049, 0.00052, 0.00055, 0.00057, 0.00059, 0.00060, 0.00060, 0.00061, 0.00064, 0.00068, 0.00072, 0.00075, 0.00079, 0.00084, 0.00089, 0.00095, 0.00102, 0.00110, 0.00120, 0.00130, 0.00141, 0.00154, 0.00168, 0.00181, 0.00194, 0.00210, 0.00230, 0.00253, 0.00277, 0.00302, 0.00330, 0.00362, 0.00396, 0.00430, 0.00464, 0.00500, 0.00544, 0.00594, 0.00648, 0.00708, 0.00772, 0.00847, 0.00936, 0.01041, 0.01162, 0.01310, 0.01477, 0.01657, 0.01850, 0.02069, 0.02326, 0.02633, 0.03000, 0.03397, 0.03839, 0.04331, 0.04889, 0.05537, 0.06298, 0.07147, 0.08073, 0.09099, 0.10157, 0.11188, 0.12289, 0.13550, 0.14934, 0.16416, 0.17996, 0.19709, 0.21397, 0.23049, 0.24718, 0.26612, 0.28207, 0.29947, 0.31699, 0.33462, 0.35234, 0.37014, 0.38800, 0.40591, 0.42385, 0.44180, 0.45974, 0.47767, 0.49554, 0.51336, 0.53109, 0.54872, 0.56622, NA, NA, NA, NA, NA, NA),
 qx1980M = c(0.00826, 0.00105, 0.00080, 0.00062, 0.00050, 0.00043, 0.00039, 0.00034, 0.00029, 0.00024, 0.00021, 0.00020, 0.00020, 0.00023, 0.00032, 0.00046, 0.00063, 0.00077, 0.00085, 0.00088, 0.00089, 0.00088, 0.00087, 0.00085, 0.00085, 0.00085, 0.00086, 0.00089, 0.00091, 0.00093, 0.00096, 0.00100, 0.00105, 0.00112, 0.00121, 0.00132, 0.00145, 0.00159, 0.00172, 0.00187, 0.00205, 0.00225, 0.00249, 0.00277, 0.00311, 0.00353, 0.00399, 0.00444, 0.00484, 0.00518, 0.00551, 0.00589, 0.00635, 0.00686, 0.00739, 0.00796, 0.00858, 0.00934, 0.01029, 0.01135, 0.01245, 0.01362, 0.01498, 0.01654, 0.01825, 0.02015, 0.02231, 0.02486, 0.02785, 0.03120, 0.03501, 0.03916, 0.04377, 0.04869, 0.05392, 0.05981, 0.06648, 0.07402, 0.08209, 0.09085, 0.10036, 0.11001, 0.12013, 0.13104, 0.14273, 0.15464, 0.16959, 0.18481, 0.20031, 0.21607, 0.23210, 0.24837, 0.26489, 0.28164, 0.29862, 0.31580, 0.33318, 0.35074, 0.36847, 0.38634, 0.40435, 0.42247, 0.44069, 0.45898, 0.47732, 0.49568, 0.51405, 0.53240, 0.55070, NA, NA, NA, NA, NA, NA, NA, NA),
 qx1980F = c(0.00658, 0.00089, 0.00062, 0.00043, 0.00032, 0.00027, 0.00024, 0.00020, 0.00018, 0.00015, 0.00014, 0.00013, 0.00013, 0.00013, 0.00016, 0.00020, 0.00024, 0.00028, 0.00031, 0.00034, 0.00035, 0.00036, 0.00037, 0.00037, 0.00039, 0.00043, 0.00046, 0.00049, 0.00050, 0.00052, 0.00054, 0.00057, 0.00062, 0.00067, 0.00072, 0.00077, 0.00082, 0.00089, 0.00097, 0.00104, 0.00112, 0.00122, 0.00133, 0.00146, 0.00160, 0.00175, 0.00192, 0.00211, 0.00232, 0.00255, 0.00279, 0.00304, 0.00326, 0.00348, 0.00376, 0.00410, 0.00448, 0.00487, 0.00529, 0.00582, 0.00644, 0.00716, 0.00789, 0.00870, 0.00962, 0.01063, 0.01180, 0.01320, 0.01490, 0.01692, 0.01934, 0.02213, 0.02519, 0.02850, 0.03213, 0.03627, 0.04105, 0.04673, 0.05310, 0.06040, 0.06841, 0.07727, 0.08698, 0.09761, 0.10902, 0.12155, 0.13501, 0.14888, 0.16314, 0.17900, 0.19728, 0.21455, 0.23282, 0.25211, 0.27243, 0.29378, 0.31619, 0.33962, 0.36407, 0.38950, 0.41586, 0.44311, 0.47115, 0.49990, 0.52924, 0.55905, 0.58918, 0.61946, 0.64970, 0.67973, NA, NA, NA, NA, NA, NA, NA),
 qx1985M = c(0.00585, 0.00086, 0.00062, 0.00044, 0.00034, 0.00030, 0.00028, 0.00026, 0.00024, 0.00020, 0.00018, 0.00018, 0.00017, 0.00020, 0.00028, 0.00042, 0.00060, 0.00077, 0.00088, 0.00091, 0.00090, 0.00086, 0.00082, 0.00079, 0.00078, 0.00079, 0.00080, 0.00081, 0.00081, 0.00080, 0.00080, 0.00083, 0.00090, 0.00099, 0.00108, 0.00117, 0.00126, 0.00137, 0.00151, 0.00166, 0.00183, 0.00202, 0.00222, 0.00242, 0.00266, 0.00295, 0.00329, 0.00366, 0.00408, 0.00456, 0.00510, 0.00570, 0.00629, 0.00686, 0.00743, 0.00798, 0.00854, 0.00910, 0.00976, 0.01054, 0.01144, 0.01237, 0.01337, 0.01455, 0.01592, 0.01742, 0.01923, 0.02139, 0.02379, 0.02630, 0.02908, 0.03232, 0.03623, 0.04084, 0.04605, 0.05204, 0.05866, 0.06571, 0.07284, 0.08020, 0.08812, 0.09717, 0.10772, 0.11898, 0.13062, 0.14331, 0.15630, 0.17016, 0.18493, 0.20064, 0.21734, 0.23506, 0.25381, 0.27362, 0.29451, 0.31647, 0.33952, 0.36363, 0.38878, 0.41493, 0.44201, 0.46996, 0.49869, 0.52808, 0.55800, 0.58831, 0.61882, 0.64935, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 qx1985F = c(0.00508, 0.00070, 0.00047, 0.00031, 0.00022, 0.00019, 0.00017, 0.00015, 0.00013, 0.00012, 0.00012, 0.00012, 0.00012, 0.00014, 0.00016, 0.00018, 0.00021, 0.00025, 0.00028, 0.00030, 0.00031, 0.00031, 0.00032, 0.00033, 0.00035, 0.00037, 0.00038, 0.00040, 0.00043, 0.00046, 0.00048, 0.00051, 0.00054, 0.00058, 0.00062, 0.00067, 0.00072, 0.00079, 0.00086, 0.00094, 0.00102, 0.00112, 0.00123, 0.00134, 0.00144, 0.00156, 0.00168, 0.00183, 0.00201, 0.00223, 0.00246, 0.00269, 0.00290, 0.00310, 0.00330, 0.00352, 0.00379, 0.00413, 0.00451, 0.00494, 0.00542, 0.00597, 0.00663, 0.00738, 0.00821, 0.00910, 0.01005, 0.01111, 0.01237, 0.01383, 0.01547, 0.01734, 0.01956, 0.02225, 0.02536, 0.02921, 0.03382, 0.03888, 0.04430, 0.05009, 0.05643, 0.06373, 0.07210, 0.08144, 0.09186, 0.10321, 0.11602, 0.13083, 0.14649, 0.16203, 0.17770, 0.19347, 0.21095, 0.23026, 0.25153, 0.27488, 0.30042, 0.32823, 0.35835, 0.39079, 0.42552, 0.46241, 0.50130, 0.54191, 0.58386, 0.62671, 0.66988, 0.71272, 0.75452, NA, NA, NA, NA, NA, NA, NA, NA),
 qx1990M = c(0.00495, 0.00078, 0.00057, 0.00042, 0.00033, 0.00029, 0.00025, 0.00022, 0.00018, 0.00015, 0.00014, 0.00015, 0.00016, 0.00018, 0.00023, 0.00034, 0.00050, 0.00066, 0.00078, 0.00084, 0.00083, 0.00081, 0.00078, 0.00076, 0.00075, 0.00073, 0.00071, 0.00071, 0.00073, 0.00075, 0.00078, 0.00080, 0.00083, 0.00087, 0.00092, 0.00099, 0.00107, 0.00117, 0.00129, 0.00140, 0.00155, 0.00172, 0.00188, 0.00206, 0.00228, 0.00254, 0.00284, 0.00315, 0.00344, 0.00372, 0.00405, 0.00446, 0.00495, 0.00557, 0.00630, 0.00710, 0.00791, 0.00873, 0.00954, 0.01040, 0.01132, 0.01228, 0.01323, 0.01424, 0.01536, 0.01664, 0.01805, 0.01968, 0.02160, 0.02382, 0.02641, 0.02946, 0.03292, 0.03679, 0.04095, 0.04542, 0.05055, 0.05661, 0.06367, 0.07148, 0.08039, 0.08997, 0.09997, 0.11032, 0.12106, 0.13240, 0.14472, 0.15847, 0.17309, 0.18816, 0.20323, 0.21957, 0.23665, 0.25449, 0.27310, 0.29247, 0.31259, 0.33347, 0.35507, 0.37738, 0.40037, 0.42399, 0.44821, 0.47296, 0.49819, 0.52381, 0.54974, 0.57589, 0.60215, 0.62842, NA, NA, NA, NA, NA, NA, NA),
 qx1990F = c(0.00417, 0.00064, 0.00042, 0.00027, 0.00019, 0.00016, 0.00016, 0.00014, 0.00013, 0.00012, 0.00011, 0.00010, 0.00010, 0.00011, 0.00014, 0.00017, 0.00020, 0.00024, 0.00027, 0.00029, 0.00030, 0.00031, 0.00032, 0.00033, 0.00033, 0.00033, 0.00032, 0.00034, 0.00036, 0.00039, 0.00042, 0.00044, 0.00045, 0.00049, 0.00053, 0.00058, 0.00063, 0.00068, 0.00073, 0.00079, 0.00089, 0.00099, 0.00109, 0.00117, 0.00125, 0.00134, 0.00147, 0.00163, 0.00180, 0.00198, 0.00217, 0.00234, 0.00248, 0.00264, 0.00285, 0.00309, 0.00338, 0.00369, 0.00403, 0.00441, 0.00481, 0.00522, 0.00567, 0.00619, 0.00681, 0.00752, 0.00834, 0.00930, 0.01044, 0.01176, 0.01324, 0.01495, 0.01694, 0.01917, 0.02161, 0.02435, 0.02757, 0.03145, 0.03616, 0.04156, 0.04785, 0.05502, 0.06302, 0.07176, 0.08119, 0.09125, 0.10249, 0.11498, 0.12856, 0.14327, 0.15876, 0.17517, 0.19222, 0.21044, 0.22972, 0.24947, 0.27002, 0.29135, 0.31346, 0.33631, 0.35990, 0.38417, 0.40909, 0.43461, 0.46065, 0.48716, 0.51405, 0.54122, 0.56857, 0.59600, 0.62339, 0.65060, NA, NA, NA, NA, NA),
 qx1995M = c(0.00456, 0.00069, 0.00051, 0.00037, 0.00029, 0.00025, 0.00024, 0.00022, 0.00020, 0.00019, 0.00018, 0.00017, 0.00017, 0.00019, 0.00025, 0.00033, 0.00044, 0.00055, 0.00065, 0.00072, 0.00075, 0.00075, 0.00074, 0.00073, 0.00072, 0.00071, 0.00071, 0.00072, 0.00075, 0.00077, 0.00079, 0.00079, 0.00081, 0.00085, 0.00091, 0.00098, 0.00106, 0.00113, 0.00121, 0.00131, 0.00144, 0.00159, 0.00176, 0.00196, 0.00218, 0.00247, 0.00278, 0.00305, 0.00334, 0.00366, 0.00406, 0.00450, 0.00495, 0.00538, 0.00582, 0.00634, 0.00696, 0.00768, 0.00854, 0.00954, 0.01066, 0.01188, 0.01311, 0.01437, 0.01570, 0.01704, 0.01843, 0.01996, 0.02175, 0.02387, 0.02624, 0.02883, 0.03179, 0.03522, 0.03911, 0.04343, 0.04831, 0.05384, 0.06003, 0.06690, 0.07453, 0.08313, 0.09265, 0.10295, 0.11379, 0.12615, 0.13985, 0.15401, 0.16795, 0.18221, 0.19961, 0.21574, 0.23232, 0.24934, 0.26680, 0.28468, 0.30298, 0.32168, 0.34076, 0.36021, 0.38000, 0.40011, 0.42051, 0.44117, 0.46206, 0.48315, 0.50438, 0.52573, 0.54715, 0.56858, 0.58998, NA, NA, NA, NA, NA, NA),
 qx1995F = c(0.00383, 0.00059, 0.00041, 0.00028, 0.00021, 0.00018, 0.00017, 0.00015, 0.00013, 0.00012, 0.00012, 0.00012, 0.00012, 0.00013, 0.00015, 0.00018, 0.00020, 0.00023, 0.00024, 0.00027, 0.00029, 0.00031, 0.00031, 0.00030, 0.00029, 0.00030, 0.00031, 0.00034, 0.00036, 0.00038, 0.00040, 0.00043, 0.00047, 0.00050, 0.00052, 0.00054, 0.00057, 0.00062, 0.00069, 0.00076, 0.00083, 0.00090, 0.00099, 0.00110, 0.00123, 0.00137, 0.00152, 0.00167, 0.00181, 0.00195, 0.00211, 0.00227, 0.00245, 0.00263, 0.00282, 0.00302, 0.00324, 0.00347, 0.00375, 0.00413, 0.00457, 0.00504, 0.00549, 0.00598, 0.00653, 0.00715, 0.00783, 0.00857, 0.00946, 0.01054, 0.01182, 0.01328, 0.01499, 0.01698, 0.01928, 0.02185, 0.02476, 0.02810, 0.03195, 0.03632, 0.04130, 0.04701, 0.05356, 0.06100, 0.06937, 0.07914, 0.09029, 0.10206, 0.11413, 0.12690, 0.14091, 0.15638, 0.17294, 0.18963, 0.20518, 0.22054, 0.23646, 0.25238, 0.26830, 0.28420, 0.30009, 0.31594, 0.33177, 0.34755, 0.36328, 0.37895, 0.39456, 0.41009, 0.42554, 0.44091, 0.45617, 0.47133, 0.48637, 0.50129, 0.51608, 0.53073, NA),
 qx2000M = c(0.00345, 0.00051, 0.00038, 0.00027, 0.00021, 0.00018, 0.00016, 0.00014, 0.00012, 0.00011, 0.00010, 0.00011, 0.00013, 0.00016, 0.00021, 0.00027, 0.00036, 0.00046, 0.00054, 0.00060, 0.00063, 0.00065, 0.00067, 0.00069, 0.00069, 0.00068, 0.00066, 0.00065, 0.00067, 0.00071, 0.00077, 0.00082, 0.00088, 0.00092, 0.00095, 0.00099, 0.00105, 0.00114, 0.00125, 0.00136, 0.00147, 0.00159, 0.00173, 0.00190, 0.00210, 0.00232, 0.00258, 0.00287, 0.00318, 0.00352, 0.00392, 0.00435, 0.00480, 0.00527, 0.00575, 0.00625, 0.00678, 0.00737, 0.00795, 0.00854, 0.00923, 0.01007, 0.01106, 0.01226, 0.01359, 0.01498, 0.01646, 0.01808, 0.01988, 0.02181, 0.02384, 0.02605, 0.02850, 0.03126, 0.03437, 0.03784, 0.04162, 0.04606, 0.05127, 0.05731, 0.06401, 0.07156, 0.07962, 0.08813, 0.09699, 0.10640, 0.11678, 0.12806, 0.14042, 0.15378, 0.17013, 0.18465, 0.19968, 0.21523, 0.23129, 0.24787, 0.26496, 0.28255, 0.30065, 0.31923, 0.33828, 0.35778, 0.37772, 0.39808, 0.41881, 0.43989, 0.46129, 0.48297, 0.50487, 0.52696, 0.54918, 0.57147, 0.59378, NA, NA, NA, NA),
 qx2000F = c(0.00298, 0.00044, 0.00030, 0.00020, 0.00014, 0.00012, 0.00011, 0.00010, 0.00009, 0.00008, 0.00008, 0.00008, 0.00008, 0.00008, 0.00010, 0.00012, 0.00016, 0.00019, 0.00022, 0.00023, 0.00025, 0.00027, 0.00028, 0.00030, 0.00030, 0.00031, 0.00031, 0.00032, 0.00034, 0.00036, 0.00038, 0.00041, 0.00044, 0.00047, 0.00050, 0.00054, 0.00058, 0.00062, 0.00067, 0.00072, 0.00078, 0.00085, 0.00094, 0.00104, 0.00113, 0.00122, 0.00131, 0.00143, 0.00158, 0.00175, 0.00196, 0.00215, 0.00233, 0.00251, 0.00266, 0.00279, 0.00294, 0.00313, 0.00334, 0.00356, 0.00383, 0.00416, 0.00458, 0.00507, 0.00562, 0.00618, 0.00680, 0.00748, 0.00825, 0.00907, 0.00999, 0.01106, 0.01228, 0.01371, 0.01539, 0.01740, 0.01974, 0.02249, 0.02573, 0.02944, 0.03365, 0.03837, 0.04356, 0.04934, 0.05581, 0.06316, 0.07155, 0.08085, 0.09117, 0.10252, 0.11550, 0.12979, 0.14472, 0.15966, 0.17498, 0.19062, 0.20655, 0.22278, 0.23929, 0.25609, 0.27316, 0.29048, 0.30805, 0.32585, 0.34387, 0.36210, 0.38050, 0.39907, 0.41778, 0.43661, 0.45554, 0.47454, 0.49359, 0.51266, 0.53172, 0.55075, 0.56970),
 qx2005M = c(0.00298, 0.00045, 0.00032, 0.00022, 0.00016, 0.00014, 0.00014, 0.00014, 0.00013, 0.00011, 0.00009, 0.00009, 0.00010, 0.00014, 0.00018, 0.00023, 0.00028, 0.00035, 0.00043, 0.00050, 0.00056, 0.00060, 0.00063, 0.00066, 0.00067, 0.00067, 0.00067, 0.00068, 0.00070, 0.00072, 0.00074, 0.00076, 0.00079, 0.00085, 0.00092, 0.00098, 0.00105, 0.00113, 0.00122, 0.00132, 0.00143, 0.00154, 0.00168, 0.00185, 0.00205, 0.00227, 0.00251, 0.00274, 0.00297, 0.00325, 0.00357, 0.00393, 0.00435, 0.00478, 0.00524, 0.00579, 0.00639, 0.00697, 0.00756, 0.00818, 0.00883, 0.00956, 0.01034, 0.01109, 0.01187, 0.01277, 0.01386, 0.01525, 0.01699, 0.01903, 0.02123, 0.02361, 0.02615, 0.02895, 0.03208, 0.03555, 0.03939, 0.04368, 0.04856, 0.05402, 0.05998, 0.06639, 0.07361, 0.08176, 0.09081, 0.10068, 0.11164, 0.12361, 0.13642, 0.14936, 0.16453, 0.17971, 0.19560, 0.21220, 0.22953, 0.24758, 0.26637, 0.28588, 0.30611, 0.32706, 0.34869, 0.37099, 0.39393, 0.41747, 0.44156, 0.46615, 0.49118, 0.51657, 0.54226, 0.56814, 0.59413, 0.62011, NA, NA, NA, NA, NA),
 qx2005F = c(0.00252, 0.00034, 0.00025, 0.00018, 0.00013, 0.00011, 0.00009, 0.00009, 0.00008, 0.00007, 0.00007, 0.00006, 0.00007, 0.00008, 0.00010, 0.00012, 0.00014, 0.00017, 0.00021, 0.00024, 0.00026, 0.00029, 0.00031, 0.00033, 0.00033, 0.00032, 0.00031, 0.00031, 0.00032, 0.00035, 0.00037, 0.00040, 0.00042, 0.00046, 0.00049, 0.00053, 0.00057, 0.00060, 0.00065, 0.00070, 0.00075, 0.00081, 0.00087, 0.00094, 0.00103, 0.00113, 0.00124, 0.00135, 0.00147, 0.00161, 0.00176, 0.00192, 0.00209, 0.00226, 0.00243, 0.00265, 0.00287, 0.00306, 0.00324, 0.00343, 0.00364, 0.00391, 0.00425, 0.00458, 0.00492, 0.00536, 0.00589, 0.00648, 0.00716, 0.00797, 0.00890, 0.00999, 0.01124, 0.01260, 0.01409, 0.01574, 0.01759, 0.01970, 0.02221, 0.02528, 0.02898, 0.03332, 0.03844, 0.04410, 0.05023, 0.05696, 0.06468, 0.07353, 0.08359, 0.09431, 0.10563, 0.11800, 0.13200, 0.14747, 0.16403, 0.17947, 0.19736, 0.21641, 0.23667, 0.25815, 0.28088, 0.30487, 0.33010, 0.35656, 0.38422, 0.41302, 0.44287, 0.47369, 0.50534, 0.53768, 0.57053, 0.60369, 0.63692, 0.66997, 0.70259, NA, NA),
 qx2010M = c(0.00246, 0.00037, 0.00026, 0.00018, 0.00013, 0.00011, 0.0001, 0.00009, 0.00008, 0.00008, 0.00008, 0.0001, 0.00011, 0.00013, 0.00015, 0.00019, 0.00024, 0.0003, 0.00038, 0.00045, 0.00051, 0.00057, 0.00061, 0.00064, 0.00064, 0.00064, 0.00065, 0.00066, 0.00067, 0.00068, 0.00069, 0.00071, 0.00074, 0.00077, 0.00081, 0.00085, 0.0009, 0.00098, 0.00108, 0.00118, 0.00128, 0.0014, 0.00152, 0.00166, 0.00181, 0.00198, 0.00216, 0.00238, 0.00263, 0.00289, 0.00317, 0.00347, 0.00381, 0.00419, 0.00461, 0.00507, 0.00558, 0.00612, 0.00669, 0.00732, 0.0081, 0.00888, 0.00961, 0.01037, 0.01121, 0.01214, 0.01319, 0.01434, 0.01553, 0.01685, 0.01842, 0.02023, 0.02227, 0.02466, 0.02753, 0.03087, 0.03478, 0.03919, 0.0442, 0.04974, 0.05568, 0.06208, 0.06937, 0.07793, 0.08752, 0.09785, 0.10827, 0.11926, 0.13135, 0.14503, 0.16041, 0.17569, 0.19195, 0.20922, 0.22755, 0.24695, 0.26744, 0.28905, 0.31177, 0.3356, 0.36051, 0.38649, 0.41348, 0.44142, 0.47023, 0.4998, 0.53002, 0.56075, 0.59182, 0.62304, 0.65422, NA, NA, NA, NA, NA, NA),
 qx2010F = c(0.00210, 0.00033, 0.00023, 0.00015, 0.00011, 0.00009, 0.00008, 0.00008, 0.00007, 0.00006, 0.00006, 0.00006, 0.00007, 0.00008, 0.0001, 0.00012, 0.00014, 0.00016, 0.00019, 0.00021, 0.00024, 0.00025, 0.00026, 0.00026, 0.00026, 0.00026, 0.00027, 0.00028, 0.00031, 0.00034, 0.00036, 0.00038, 0.0004, 0.00042, 0.00045, 0.00048, 0.00052, 0.00056, 0.00061, 0.00066, 0.00071, 0.00076, 0.00082, 0.00091, 0.001, 0.00108, 0.00115, 0.00124, 0.00138, 0.00153, 0.00167, 0.00179, 0.00191, 0.00204, 0.00219, 0.00236, 0.00254, 0.00273, 0.00292, 0.00313, 0.0034, 0.0037, 0.00401, 0.00434, 0.00465, 0.00498, 0.00537, 0.00584, 0.00634, 0.00692, 0.00767, 0.00856, 0.00961, 0.01083, 0.01224, 0.01381, 0.01558, 0.01763, 0.02006, 0.02284, 0.026, 0.02956, 0.03371, 0.03867, 0.04458, 0.05155, 0.05937, 0.06837, 0.07843, 0.08949, 0.1016, 0.1149, 0.12964, 0.14628, 0.16458, 0.18367, 0.2033, 0.22398, 0.24573, 0.26854, 0.29242, 0.31734, 0.34328, 0.37021, 0.39806, 0.42678, 0.45627, 0.48643, 0.51715, 0.54827, 0.57965, 0.61112, 0.64247, 0.67352, 0.70404, NA, NA),
 qx2015M = c(0.00202, 0.00034, 0.00024, 0.00016, 0.00012, 0.00010, 0.00010, 0.00010, 0.00009, 0.00008, 0.00007, 0.00007, 0.00008, 0.00011, 0.00013, 0.00017, 0.00021, 0.00026, 0.00032, 0.00039, 0.00045, 0.00049, 0.00051, 0.00054, 0.00055, 0.00055, 0.00055, 0.00054, 0.00055, 0.00056, 0.00058, 0.00060, 0.00062, 0.00066, 0.00070, 0.00074, 0.00076, 0.00080, 0.00085, 0.00095, 0.00105, 0.00115, 0.00124, 0.00134, 0.00147, 0.00163, 0.00181, 0.00200, 0.00222, 0.00243, 0.00266, 0.00293, 0.00323, 0.00355, 0.00391, 0.00432, 0.00475, 0.00518, 0.00560, 0.00609, 0.00669, 0.00748, 0.00837, 0.00926, 0.01014, 0.01119, 0.01231, 0.01345, 0.01468, 0.01599, 0.01747, 0.01915, 0.02095, 0.02268, 0.02463, 0.02707, 0.03009, 0.03376, 0.03812, 0.04307, 0.04862, 0.05502, 0.06222, 0.07032, 0.07945, 0.08947, 0.10002, 0.11144, 0.12399, 0.13783, 0.15329, 0.17010, 0.18905, 0.20953, 0.22932, 0.24601, 0.26408, 0.28243, 0.30104, 0.31989, 0.33896, 0.35824, 0.37771, 0.39733, 0.41709, 0.43697, 0.45693, 0.47695, 0.49699, 0.51704, 0.53705, 0.55698, 0.57682, NA, NA, NA, NA),
 qx2015F = c(0.00178, 0.00032, 0.00020, 0.00012, 0.00008, 0.00008, 0.00008, 0.00008, 0.00007, 0.00007, 0.00007, 0.00007, 0.00007, 0.00007, 0.00008, 0.00010, 0.00012, 0.00013, 0.00015, 0.00016, 0.00017, 0.00019, 0.00020, 0.00022, 0.00023, 0.00024, 0.00025, 0.00027, 0.00029, 0.00030, 0.00031, 0.00032, 0.00034, 0.00037, 0.00039, 0.00041, 0.00043, 0.00046, 0.00050, 0.00057, 0.00063, 0.00069, 0.00074, 0.00080, 0.00087, 0.00095, 0.00105, 0.00116, 0.00126, 0.00136, 0.00148, 0.00162, 0.00178, 0.00193, 0.00208, 0.00221, 0.00233, 0.00245, 0.00259, 0.00279, 0.00304, 0.00333, 0.00362, 0.00391, 0.00422, 0.00460, 0.00502, 0.00547, 0.00597, 0.00654, 0.00722, 0.00800, 0.00888, 0.00977, 0.01077, 0.01202, 0.01363, 0.01559, 0.01789, 0.02057, 0.02361, 0.02714, 0.03136, 0.03630, 0.04188, 0.04816, 0.05538, 0.06373, 0.07352, 0.08454, 0.09695, 0.11100, 0.12757, 0.14619, 0.16620, 0.18796, 0.20798, 0.22839, 0.24917, 0.27030, 0.29175, 0.31351, 0.33554, 0.35783, 0.38033, 0.40301, 0.42585, 0.44879, 0.47179, 0.49482, 0.51783, 0.54076, 0.56358, 0.58622, 0.60864, 0.63079, NA),
 qx2020M = c(0.00184, 0.00024, 0.00017, 0.00011, 0.00008, 0.00006, 0.00006, 0.00005, 0.00005, 0.00005, 0.00006, 0.00007, 0.00009, 0.00011, 0.00014, 0.00018, 0.00022, 0.00028, 0.00033, 0.00038, 0.00044, 0.00049, 0.00052, 0.00052, 0.00051, 0.00049, 0.00049, 0.00049, 0.00049, 0.00050, 0.00052, 0.00055, 0.00060, 0.00064, 0.00068, 0.00070, 0.00071, 0.00073, 0.00077, 0.00084, 0.00093, 0.00102, 0.00112, 0.00123, 0.00135, 0.00149, 0.00164, 0.00179, 0.00198, 0.00219, 0.00243, 0.00269, 0.00295, 0.00324, 0.00356, 0.00392, 0.00432, 0.00473, 0.00517, 0.00566, 0.00624, 0.00691, 0.00765, 0.00841, 0.00922, 0.01010, 0.01115, 0.01241, 0.01378, 0.01518, 0.01678, 0.01843, 0.02012, 0.02205, 0.02423, 0.02672, 0.02946, 0.03251, 0.03572, 0.03939, 0.04384, 0.04908, 0.05520, 0.06226, 0.07032, 0.07937, 0.08965, 0.10118, 0.11381, 0.12734, 0.14192, 0.15799, 0.17586, 0.19566, 0.21626, 0.23661, 0.25528, 0.27429, 0.29363, 0.31329, 0.33324, 0.35346, 0.37394, 0.39463, 0.41552, 0.43658, 0.45777, 0.47905, 0.50039, 0.52176, 0.54310, 0.56438, 0.58556, 0.60658, NA, NA, NA),
 qx2020F = c(0.00172, 0.00017, 0.00012, 0.00009, 0.00007, 0.00007, 0.00007, 0.00006, 0.00006, 0.00005, 0.00005, 0.00006, 0.00007, 0.00008, 0.00009, 0.00011, 0.00014, 0.00017, 0.00019, 0.00020, 0.00022, 0.00023, 0.00024, 0.00025, 0.00025, 0.00025, 0.00025, 0.00026, 0.00026, 0.00027, 0.00027, 0.00027, 0.00028, 0.00031, 0.00035, 0.00039, 0.00043, 0.00046, 0.00050, 0.00054, 0.00058, 0.00063, 0.00068, 0.00074, 0.00082, 0.00091, 0.00099, 0.00108, 0.00119, 0.00131, 0.00145, 0.00158, 0.00171, 0.00181, 0.00192, 0.00204, 0.00218, 0.00233, 0.00247, 0.00263, 0.00281, 0.00305, 0.00333, 0.00361, 0.00390, 0.00422, 0.00461, 0.00507, 0.00558, 0.00613, 0.00681, 0.00754, 0.00830, 0.00917, 0.01014, 0.01127, 0.01264, 0.01433, 0.01626, 0.01853, 0.02117, 0.02423, 0.02783, 0.03211, 0.03713, 0.04289, 0.04954, 0.05726, 0.06625, 0.07636, 0.08770, 0.10104, 0.11679, 0.13477, 0.15424, 0.17535, 0.19558, 0.21655, 0.23827, 0.26070, 0.28385, 0.30767, 0.33214, 0.35722, 0.38287, 0.40903, 0.43564, 0.46263, 0.48993, 0.51745, 0.54509, 0.57276, 0.60035, 0.62774, 0.65482, NA, NA)
)

# https://www.e-stat.go.jp/SG1/estat/GL08020103.do?_csvDownload_&fileId=000007809775&releaseCount=3 (M2015, F2015)
# https://www.e-stat.go.jp/stat-search/file-download?statInfId=000032142404&fileKind=0 (M2020, F2020)
# Age structures of Japan from 1888 to 2020, for "0"-"85+"
# People with unknown age are excluded.
Jpop <- data.frame(
 Age = c(sprintf("%d",0:84),"85+"),
 M1888 = c(539962, 469536, 470197, 449086, 443053, 458304, 450499, 454853, 440727, 444884, 441802, 429857, 445958, 412208, 402551, 400626, 354671, 328631, 318501, 320255, 367315, 332457, 326722, 353824, 337183, 286454, 267747, 248681, 284076, 282911, 307536, 304933, 295960, 292081, 300346, 293079, 298184, 254272, 269215, 288596, 274011, 260447, 242722, 251201, 236685, 241090, 209308, 215382, 202426, 186624, 171901, 142281, 169829, 169811, 157469, 156079, 169846, 152641, 166130, 140839, 141986, 136525, 122316, 124440, 115478, 104853, 106483, 86080, 84246, 82064, 69670, 59619, 57921, 49142, 44238, 41984, 34636, 32570, 25655, 20675, 19302, 15535, 12449, 10829, 8341, 15116),
 F1888 = c(520477, 456728, 464484, 437816, 436275, 452806, 440192, 449820, 431196, 436490, 430249, 416833, 436860, 402193, 393830, 390332, 343913, 318685, 309364, 312341, 353366, 324587, 314969, 341210, 325249, 279142, 260291, 243576, 272548, 277030, 291097, 293245, 283190, 278231, 282355, 276216, 277217, 241261, 250557, 271006, 252869, 248619, 202031, 242039, 220613, 223010, 195498, 199379, 190087, 174937, 162685, 139618, 163277, 165918, 153014, 157093, 168845, 152207, 161576, 143623, 147307, 140389, 127731, 131105, 123072, 113425, 113211, 97254, 95246, 92907, 79595, 72185, 70452, 61542, 55903, 54271, 46616, 44037, 35214, 30470, 28239, 23855, 19564, 17354, 13497, 28919),
 M1893 = c(531884, 513295, 450066, 469437, 493529, 479868, 439925, 450351, 435507, 435302, 452498, 445389, 450400, 437540, 441487, 436830, 422396, 439676, 405094, 393641, 389073, 343620, 317886, 304964, 306768, 352743, 318411, 313469, 340083, 323864, 274532, 256060, 237639, 271387, 269131, 293987, 292457, 281992, 278821, 285916, 276905, 281637, 239655, 252098, 271199, 256147, 242090, 224229, 232286, 217095, 220575, 189748, 194073, 182214, 166659, 152201, 123033, 147627, 146318, 132928, 131473, 141716, 125394, 134802, 111637, 110911, 105788, 92241, 92559, 83626, 73350, 72816, 57037, 53939, 50629, 41589, 33400, 31345, 25499, 21596, 19251, 14999, 13250, 9810, 7262, 23411),
 F1893 = c(514991, 496325, 439461, 456309, 481878, 465354, 429037, 444884, 426928, 427514, 448257, 435490, 446481, 428566, 431449, 425001, 409843, 430262, 395188, 384955, 380341, 332723, 308511, 295267, 298801, 340030, 308992, 300281, 325505, 310628, 264545, 246640, 228807, 257809, 261284, 275144, 276314, 266833, 262420, 266216, 259082, 259851, 225665, 235273, 254253, 236742, 233660, 187499, 226921, 205771, 208324, 180272, 184421, 174648, 159099, 147771, 124527, 146364, 148255, 134189, 138032, 147163, 131302, 137866, 120419, 121922, 114831, 102381, 104250, 95173, 85353, 83798, 69642, 65784, 62702, 51926, 44155, 42105, 35233, 30165, 27863, 22531, 20097, 15134, 12254, 40897),
 M1898 = c(610181, 566578, 528074, 517467, 501655, 477716, 479135, 429067, 455998, 484852, 474595, 434128, 444642, 430407, 430185, 447303, 439833, 443536, 428980, 431504, 426227, 411754, 426814, 389848, 376914, 374171, 327661, 304114, 291981, 293383, 339995, 306348, 299073, 327382, 310989, 261791, 242355, 224144, 258210, 256376, 280548, 278364, 267512, 263866, 269469, 261455, 265605, 222129, 234035, 251991, 236531, 222624, 203763, 210858, 194960, 197579, 167547, 170646, 158749, 143012, 129182, 102204, 122084, 119564, 106861, 103793, 110537, 95486, 100971, 81161, 79268, 73315, 61718, 60466, 52855, 44452, 42542, 31575, 29128, 26056, 20238, 14656, 12992, 10074, 8060, 26662),
 F1898 = c(599251, 549702, 521339, 503210, 485609, 466586, 466875, 422199, 444950, 475109, 461107, 423598, 438998, 421034, 422676, 441201, 429114, 439147, 419572, 421525, 415300, 398323, 418838, 381668, 371662, 367081, 319343, 294618, 282975, 285071, 325182, 296682, 285809, 312337, 297486, 250877, 232302, 214233, 243422, 247516, 260100, 261115, 252430, 246514, 250306, 245481, 245790, 211723, 219948, 240104, 221636, 219637, 171766, 211085, 189132, 191570, 163566, 166784, 157738, 142062, 130436, 108304, 127503, 127296, 114062, 115837, 121890, 106750, 110123, 93834, 94037, 86287, 74977, 74754, 65780, 57034, 53703, 42789, 38872, 36021, 28063, 22138, 19810, 15788, 12763, 47445),
 M1903 = c(664315, 638514, 616396, 572519, 549855, 550031, 531195, 506818, 504418, 492810, 471597, 474410, 425324, 450108, 480285, 468622, 426026, 434786, 419418, 417953, 435392, 429125, 431056, 415809, 417046, 412211, 397700, 413026, 377825, 364985, 362590, 317693, 294485, 282647, 283627, 327134, 294012, 287552, 314248, 297143, 250808, 232242, 213672, 245604, 244039, 265958, 262832, 251498, 247694, 251072, 242082, 245527, 204086, 213565, 228408, 212567, 199353, 180915, 185673, 169604, 170541, 142833, 143345, 132467, 117433, 104241, 81006, 94826, 91043, 79619, 75823, 78399, 65846, 67362, 51928, 49349, 43808, 35387, 33276, 28109, 22242, 20457, 14442, 13011, 11093, 33850),
 F1903 = c(641621, 620169, 598610, 554751, 530308, 542691, 517561, 500445, 490512, 477739, 460600, 461780, 417257, 437744, 467626, 452501, 413826, 428143, 410684, 410904, 430581, 416397, 424390, 404430, 406125, 400326, 382963, 401335, 365926, 355907, 351889, 305561, 282075, 271009, 273007, 310584, 281498, 272063, 296924, 281927, 237663, 220461, 202600, 230543, 234701, 246534, 247121, 238250, 233530, 236057, 230296, 229738, 197427, 204384, 222366, 204478, 201206, 157111, 192085, 170697, 170789, 144266, 146194, 136647, 122794, 110978, 90288, 105002, 102912, 90361, 90416, 93022, 79508, 79283, 64892, 63226, 56301, 46625, 45089, 37629, 30911, 27788, 21179, 18233, 16173, 52144),
 M1908 = c(742391, 673382, 587905, 583248, 578223, 591956, 598996, 592778, 558654, 539602, 544954, 525538, 500815, 498141, 487321, 465002, 466238, 416217, 438568, 465970, 454330, 412210, 419455, 402978, 400512, 404516, 401608, 408120, 394006, 395430, 391800, 378613, 393634, 361857, 349383, 346608, 303931, 281517, 270734, 271096, 312018, 280457, 274232, 296665, 281710, 237380, 218815, 201269, 229670, 227367, 247482, 242859, 231203, 226987, 228191, 218960, 219618, 181647, 188315, 199504, 184244, 169803, 152651, 155034, 139931, 137510, 112975, 111611, 100957, 87608, 75963, 57779, 65018, 60626, 51855, 47814, 47358, 38543, 37601, 27602, 25123, 21030, 16771, 14956, 12190, 49540),
 F1908 = c(720300, 666180, 550532, 578260, 561647, 574544, 581553, 575561, 540613, 519425, 539245, 511929, 493264, 482125, 469579, 450164, 449176, 405882, 423953, 451233, 437288, 400732, 413653, 395379, 395092, 411871, 397509, 403584, 384963, 386657, 380999, 364322, 381713, 347760, 338046, 333097, 290358, 267536, 257473, 258400, 292993, 266995, 257832, 279256, 265880, 224722, 208515, 191570, 216851, 219811, 231834, 231682, 222359, 217086, 218561, 212255, 210658, 180395, 185126, 199520, 182565, 178010, 138642, 166852, 146539, 144206, 120192, 120371, 110608, 97681, 86090, 68386, 77152, 74053, 63029, 61101, 60464, 49657, 47457, 36703, 33930, 28769, 22581, 20837, 16384, 63740),
 M1913 = c(793494, 735634, 717503, 682483, 670039, 658098, 633390, 566780, 570109, 569974, 586399, 594110, 586211, 550558, 532460, 537297, 516743, 491169, 486451, 473514, 449780, 449660, 401304, 422445, 449450, 439346, 397652, 405621, 389542, 385501, 390809, 387813, 393500, 379434, 380017, 376196, 363728, 378330, 348153, 335007, 332367, 290604, 268962, 257606, 258019, 295755, 264607, 258705, 278554, 264017, 221157, 203110, 185763, 211839, 207744, 224348, 218949, 206807, 201615, 200652, 189930, 189593, 153739, 158212, 164662, 150144, 136303, 120994, 120262, 106055, 101374, 81318, 78626, 69276, 57948, 48547, 35846, 39061, 35168, 28744, 26229, 24888, 19606, 18237, 12667, 68466),
 F1913 = c(769695, 716247, 702610, 672180, 656631, 640464, 627574, 532811, 566653, 553011, 569559, 577440, 569362, 531701, 510086, 527254, 498916, 478680, 467651, 454169, 434937, 433156, 390794, 407231, 433611, 419604, 383777, 394543, 377543, 375935, 392171, 379072, 386417, 368519, 368012, 363093, 346644, 363272, 330342, 321162, 317477, 275386, 254239, 243306, 245232, 277755, 253052, 243930, 264524, 251790, 211595, 195895, 179648, 203019, 205168, 214483, 213604, 204024, 198240, 197889, 190627, 187849, 159409, 162961, 172888, 156425, 150287, 115548, 136986, 118900, 114015, 92887, 90776, 81444, 69633, 59921, 45724, 49950, 46199, 37667, 35105, 33440, 26279, 23548, 17122, 78853),
 M1918 = c(780605, 745709, 727338, 720168, 723232, 701273, 691781, 692262, 666249, 658101, 649356, 626106, 558722, 561275, 560219, 575350, 581830, 571252, 532139, 513168, 514331, 493208, 468751, 463445, 451509, 429658, 429793, 384342, 403590, 429508, 418359, 379102, 385438, 370727, 366842, 371949, 368999, 373983, 360047, 360700, 357379, 343813, 357291, 328833, 317019, 313216, 272834, 251592, 240740, 239545, 274216, 243179, 236695, 253168, 238687, 198759, 182346, 164187, 185875, 181414, 193347, 186564, 174432, 167099, 164671, 152544, 149365, 118767, 120137, 122353, 108420, 96370, 83020, 80173, 67966, 63408, 48686, 45405, 38374, 30904, 24814, 17540, 18189, 15698, 12571, 82029),
 F1918 = c(764984, 732717, 709952, 705082, 699962, 681580, 675349, 678332, 655533, 646179, 633498, 621382, 524570, 556724, 541154, 556054, 559869, 549900, 511205, 489393, 505218, 477538, 457409, 446290, 432055, 412207, 411432, 368963, 384448, 410631, 395151, 360830, 372804, 356239, 356005, 370056, 357991, 364558, 347260, 346600, 342340, 325619, 342441, 311377, 303320, 300262, 259910, 239383, 229344, 230495, 260349, 235633, 227288, 245020, 232404, 194576, 179948, 163658, 184442, 185171, 191290, 189534, 179162, 172709, 170688, 162077, 157706, 131400, 132159, 138455, 121595, 115202, 85947, 99086, 83496, 77283, 60486, 57069, 49692, 40761, 32904, 23788, 24498, 21490, 16551, 86166),
 M1920 = c(945066, 699760, 696705, 700319, 710777, 693097, 710875, 699984, 696316, 666884, 647926, 652832, 633372, 611589, 543506, 548173, 542611, 562069, 553269, 542900, 507656, 454593, 464661, 448240, 441329, 437897, 417268, 397286, 397149, 358405, 378262, 393733, 377506, 359513, 324429, 340166, 343045, 339568, 338880, 346112, 324853, 338875, 330215, 317831, 328480, 294835, 284428, 275922, 255836, 229383, 212305, 224716, 255192, 216904, 213123, 228975, 212156, 166609, 157988, 146357, 165791, 160960, 163556, 163247, 149479, 142279, 137592, 122325, 116785, 95498, 94922, 94613, 82342, 66461, 61202, 55700, 45758, 39810, 29684, 27301, 21243, 16310, 11705, 8384, 7831, 24696),
 F1920 = c(932477, 693228, 690980, 691180, 697223, 679831, 693058, 682137, 681472, 653266, 634949, 636603, 617284, 597638, 525868, 533853, 526648, 545539, 539377, 524618, 495101, 461315, 473562, 434769, 428084, 416528, 397665, 378191, 378746, 344814, 361079, 379946, 363827, 352664, 318491, 334543, 342127, 342228, 337205, 346864, 319173, 332044, 319390, 311378, 321525, 289040, 280639, 273052, 250014, 225418, 209189, 223561, 254180, 212973, 212619, 230339, 211913, 168543, 163254, 153959, 171594, 169595, 172080, 175390, 164113, 156562, 154181, 139986, 133431, 113898, 114704, 117484, 103348, 86085, 75457, 76830, 64926, 57007, 43478, 41518, 33100, 26129, 19991, 15087, 14403, 51310),
 M1925 = c(965811, 831914, 803695, 794814, 764245, 806161, 655769, 665422, 675149, 688670, 676678, 699259, 694727, 687458, 652869, 633577, 636543, 609350, 589150, 519750, 522162, 502399, 518298, 519397, 512543, 482679, 452759, 462125, 434361, 424578, 417464, 397434, 378762, 382464, 344053, 365381, 379399, 364073, 346726, 312959, 324028, 326691, 322112, 321718, 329675, 309872, 317391, 310093, 297059, 305073, 272310, 261141, 251696, 232766, 205918, 190699, 199658, 224394, 184650, 181834, 194160, 177170, 137565, 128490, 116615, 128737, 123199, 121786, 119078, 108675, 100029, 93510, 79281, 73141, 57594, 55868, 52431, 43854, 32846, 28633, 24618, 19172, 15517, 10838, 8951, 21546),
 F1925 = c(954913, 819843, 793732, 785363, 750253, 793330, 647753, 658139, 661830, 672209, 660136, 677890, 674824, 672300, 638889, 619866, 624931, 591961, 568664, 491485, 506919, 486014, 506967, 500042, 485786, 462179, 427746, 438005, 405613, 403426, 388669, 368073, 354379, 360271, 324518, 343788, 360040, 341824, 331931, 303256, 313581, 319763, 319798, 317931, 326468, 304428, 312920, 302295, 293418, 302600, 271015, 260618, 253943, 233785, 207711, 194281, 206614, 233502, 186369, 188816, 204394, 188031, 149411, 142108, 130397, 142527, 139828, 139712, 139369, 131429, 122693, 117495, 101916, 94972, 78549, 77296, 75283, 64239, 50279, 42285, 40313, 32898, 26929, 19619, 16979, 47149),
 M1930 = c(985978, 906284, 882064, 892926, 876190, 818268, 787488, 791425, 770332, 747273, 787708, 638012, 657616, 668724, 684500, 670377, 687032, 670302, 659262, 631690, 607136, 593436, 568102, 557128, 489604, 497517, 487241, 503125, 501079, 491795, 461605, 437622, 446004, 420519, 409290, 404573, 384820, 366631, 368993, 331888, 349878, 364120, 346957, 331246, 295733, 307629, 307067, 303068, 301051, 306342, 285734, 293312, 284354, 271418, 275758, 245697, 233846, 222549, 204467, 179307, 163068, 169057, 185901, 154599, 147690, 154147, 138420, 104624, 95339, 84663, 92270, 84643, 82477, 77549, 67045, 59727, 53644, 43390, 37777, 27913, 25506, 23199, 17912, 12443, 10123, 25937),
 F1930 = c(966328, 892847, 867421, 880805, 860292, 807296, 775957, 779521, 758222, 731303, 770273, 628181, 645661, 653383, 666987, 652238, 663652, 650111, 642497, 612443, 585975, 588191, 554187, 532306, 455441, 481256, 461284, 477735, 474166, 460436, 433927, 407310, 422269, 390638, 384481, 374775, 356739, 340407, 344027, 311980, 327957, 343896, 324108, 317016, 285567, 298941, 304450, 305593, 302769, 309353, 284874, 295217, 283176, 276145, 280706, 252169, 242153, 233671, 213050, 189194, 174953, 185281, 206472, 169157, 165907, 175759, 158848, 123350, 115800, 104880, 112530, 107418, 106474, 102993, 93202, 85101, 77557, 64907, 56836, 44866, 42701, 40156, 31952, 23403, 18066, 58328),
 M1935 = c(1031081, 933210, 931018, 918975, 899717, 870382, 858901, 852881, 867527, 853572, 814735, 776991, 780365, 763582, 741101, 776367, 631960, 643259, 645384, 653743, 630192, 608136, 598567, 610643, 589245, 567214, 564031, 542553, 528353, 468097, 474670, 464869, 482303, 483147, 474503, 446621, 419209, 430075, 404539, 393002, 385265, 367706, 349124, 350381, 315151, 333627, 343211, 326956, 311132, 276253, 286472, 284261, 279110, 276434, 278099, 258825, 261471, 252886, 240876, 241034, 212209, 199776, 188486, 170284, 146065, 131019, 132742, 142070, 115109, 109068, 110507, 96532, 71173, 62607, 53404, 55992, 48828, 45601, 40761, 33647, 28435, 24048, 17970, 14700, 9890, 30216),
 F1935 = c(1004828, 913346, 914236, 899666, 882424, 853965, 846563, 837284, 854297, 836047, 802531, 763111, 766684, 752045, 724102, 758172, 620520, 632900, 635965, 642647, 622918, 627180, 607156, 601809, 575225, 554063, 553608, 523005, 503334, 435825, 458296, 437229, 458719, 457304, 441597, 420085, 387726, 402106, 372748, 369735, 355587, 337520, 322809, 327249, 295219, 314479, 325566, 308594, 300453, 272563, 282637, 287075, 287670, 283654, 287463, 266675, 272572, 262554, 255385, 258859, 229314, 218558, 210730, 190033, 165156, 151793, 158558, 172354, 137896, 136483, 139792, 123864, 94104, 86295, 75145, 78599, 72003, 68437, 62967, 54969, 48041, 41735, 32357, 27393, 19410, 68445),
 M1940 = c(1014500, 848400, 894300, 926900, 939400, 909100, 887400, 897200, 890700, 881700, 855600, 844300, 848700, 850500, 844700, 800600, 752700, 739600, 705900, 671900, 651100, 347800, 366400, 435100, 499200, 497600, 517600, 515700, 527100, 521300, 512800, 514000, 495600, 487500, 435300, 445800, 437200, 454500, 457200, 446200, 420200, 396400, 405100, 380100, 366800, 361000, 341500, 324800, 326100, 291600, 308200, 317500, 298000, 281700, 248800, 257800, 252100, 246000, 243000, 241400, 222100, 223300, 211700, 197500, 194600, 168100, 155100, 144300, 127800, 107200, 92800, 91800, 95700, 74000, 67000, 65300, 54600, 38300, 31800, 26000, 25300, 20700, 18300, 15000, 11300, 31000),
 F1940 = c(985900, 827400, 876600, 905900, 915800, 887500, 870800, 879800, 870200, 863900, 836200, 830300, 832800, 836200, 830200, 792100, 749700, 745900, 720400, 684800, 712700, 575400, 582300, 584500, 591600, 570600, 578700, 563300, 562700, 541500, 522300, 524400, 497500, 480500, 416100, 439600, 421500, 438700, 439100, 423800, 399400, 372000, 383300, 354100, 348900, 338800, 320900, 306700, 311200, 280300, 298400, 309300, 289500, 280800, 252800, 264200, 265200, 264300, 261700, 263400, 243200, 248500, 236200, 226200, 224300, 198200, 185600, 177200, 157400, 134300, 119900, 124200, 132300, 100900, 96500, 95400, 81300, 59500, 51300, 42900, 42100, 36500, 32800, 28800, 23400, 72100),
 M1947 = c(1274050, 790690, 832073, 1014303, 986990, 1018877, 1002728, 909484, 806104, 860213, 906820, 917676, 887522, 859262, 878009, 871785, 861470, 826178, 806677, 778462, 779465, 743288, 688986, 610123, 540594, 508479, 484361, 512924, 445542, 459607, 470024, 482991, 470148, 486143, 471381, 466790, 472637, 469089, 466941, 454102, 456157, 409642, 415118, 405748, 423943, 422027, 415649, 392223, 365972, 368340, 344634, 333510, 329871, 305111, 286598, 286283, 251255, 263202, 268968, 247231, 231169, 195657, 197791, 191450, 180468, 170739, 169437, 147842, 143427, 133004, 118617, 114975, 94711, 83231, 73692, 61440, 47569, 38139, 33520, 32385, 23383, 19968, 17556, 13490, 8045, 23224),
 F1947 = c(1223585, 764614, 815766, 994016, 965559, 992351, 982155, 893018, 790419, 843666, 883612, 902634, 872165, 843647, 861346, 856647, 844888, 815334, 808991, 793425, 777400, 771206, 754115, 705445, 691282, 671789, 641299, 664592, 545282, 557759, 557950, 562947, 551175, 560080, 534760, 533357, 529332, 509506, 500683, 479346, 460245, 396238, 413444, 396635, 414828, 409998, 399021, 380110, 350746, 354759, 325100, 319116, 313280, 295745, 279014, 279999, 249248, 267723, 272907, 257643, 243002, 213161, 219496, 222125, 215026, 206801, 206889, 184884, 182370, 174115, 157148, 155074, 133393, 119543, 109762, 92055, 73129, 61554, 55262, 55192, 40688, 37576, 34162, 26324, 17285, 53116),
 M1950 = c(1182171, 1286543, 1264541, 1198969, 786266, 831695, 1008498, 978246, 1007452, 999535, 910239, 799903, 863405, 906746, 920094, 884422, 860642, 869344, 861541, 841618, 802744, 783719, 764479, 752413, 732460, 674941, 609884, 543701, 507376, 485996, 517749, 437635, 456249, 465986, 482621, 473869, 488768, 474335, 476776, 462357, 458889, 458870, 446234, 444655, 390307, 404955, 393991, 412372, 409830, 397700, 372487, 346338, 353080, 330302, 317068, 307578, 288699, 271109, 272106, 239169, 248485, 246402, 228624, 209036, 177020, 177794, 168497, 158173, 149451, 142004, 125348, 120299, 109434, 96685, 88525, 72140, 62677, 54100, 44756, 34017, 26469, 23524, 20963, 13666, 10967, 28757),
 F1950 = c(1133819, 1236138, 1215447, 1148008, 753555, 808775, 982049, 955372, 979916, 971127, 887460, 781549, 848275, 885510, 896736, 866860, 844560, 855154, 848454, 835073, 800066, 790078, 774428, 765699, 759456, 727321, 686462, 673201, 651224, 625014, 653342, 532345, 546574, 550679, 559057, 541528, 552877, 531098, 535982, 510483, 491979, 490953, 465168, 453861, 382064, 407549, 385431, 405239, 401411, 386071, 364235, 331761, 343496, 318152, 311749, 301155, 283405, 267119, 273923, 244766, 260938, 260369, 240866, 230650, 201505, 206601, 202278, 197282, 188857, 179778, 163941, 161441, 150459, 138053, 127423, 107661, 96444, 85746, 72289, 55823, 46806, 43641, 40695, 26592, 22460, 66651),
 M1955 = c(875952, 874643, 927800, 989687, 1058248, 1144964, 1264782, 1257152, 1192780, 776813, 827056, 1003333, 977202, 1011047, 997162, 906578, 796136, 852872, 888736, 897047, 864749, 833829, 843018, 835105, 819714, 784388, 771468, 757398, 739378, 722750, 672348, 605186, 536980, 503550, 479175, 510722, 431127, 447980, 457391, 472278, 464994, 477632, 464012, 464696, 453416, 450264, 445379, 431780, 430697, 377395, 389533, 379789, 394440, 388306, 377181, 353605, 325323, 327958, 308274, 292543, 281414, 261359, 242841, 235674, 205505, 211002, 207775, 188576, 170247, 141456, 139047, 129376, 118199, 107724, 99430, 84967, 78857, 68991, 58111, 51133, 39521, 32319, 26317, 20588, 14447, 39681),
 F1955 = c(833387, 835448, 889975, 949493, 1013108, 1097602, 1214277, 1206274, 1142290, 745658, 805159, 978037, 954724, 985160, 968937, 887541, 782821, 843394, 878730, 891664, 863515, 835295, 848784, 836318, 822916, 788115, 780090, 763514, 749301, 747926, 719225, 677884, 662741, 643241, 616602, 644338, 524465, 537394, 541267, 548164, 530923, 541183, 520495, 525272, 502707, 485022, 478224, 451199, 442745, 374468, 395924, 374663, 392135, 386276, 371243, 350441, 317696, 326864, 306571, 296239, 284924, 266127, 250625, 248812, 219312, 232794, 231430, 210004, 200872, 172863, 175188, 169307, 162405, 150863, 141123, 125293, 120059, 107518, 95603, 85169, 68426, 58167, 49463, 39696, 28843, 94441),
 M1960 = c(819570, 828314, 804114, 785371, 836380, 887769, 884000, 937370, 995634, 1065805, 1154276, 1273695, 1266718, 1207759, 775461, 816862, 991000, 958960, 986034, 960998, 871111, 761657, 815279, 848971, 863078, 840007, 812566, 831572, 828594, 816427, 784994, 772624, 759057, 736485, 720880, 671027, 601413, 533583, 500665, 476182, 507042, 425861, 441900, 451411, 464906, 456709, 467180, 454380, 453287, 440403, 435822, 431446, 415031, 412210, 359228, 368792, 358168, 369692, 365575, 351144, 325500, 296527, 295668, 272307, 256755, 244168, 224260, 204214, 195377, 167023, 167498, 162400, 143430, 124855, 100489, 95354, 85584, 75661, 65391, 57777, 46721, 41287, 33765, 26973, 21853, 57103),
 F1960 = c(780378, 790690, 769550, 751134, 799327, 847453, 843533, 901999, 955303, 1020275, 1108179, 1224304, 1217132, 1158394, 744272, 800488, 977690, 947775, 978402, 961464, 879897, 773781, 834811, 865851, 876546, 849916, 821439, 838591, 825909, 814503, 781237, 773388, 759337, 744784, 742907, 716565, 673435, 657853, 639031, 613381, 639372, 518977, 530895, 535514, 542069, 524112, 533009, 513896, 516045, 491792, 474437, 469649, 440134, 429741, 363506, 382320, 361759, 377507, 374443, 357976, 336354, 302862, 307906, 284361, 274768, 261327, 242277, 225825, 220994, 193825, 202058, 198605, 176523, 163809, 137360, 135970, 127558, 118474, 105931, 95697, 81309, 74375, 63405, 53046, 44929, 133500),
 M1965 = c(900258, 857136, 833855, 810592, 802931, 810541, 826881, 805554, 782201, 831017, 877404, 875746, 933850, 992880, 1058445, 1140306, 1250399, 1234606, 1166953, 735091, 776412, 941244, 917413, 949076, 939824, 864534, 761580, 824717, 861327, 879403, 851704, 826279, 843032, 837513, 822441, 790396, 776690, 758470, 734333, 713583, 665282, 595806, 528489, 495006, 464059, 496875, 417432, 432834, 440414, 453185, 443878, 452593, 436822, 434134, 420060, 414837, 405715, 393084, 393540, 335367, 340750, 327245, 334858, 324182, 308011, 283822, 255103, 251075, 227080, 209661, 196605, 175924, 156823, 145256, 120764, 117842, 109462, 92775, 76561, 58771, 52601, 44405, 37191, 29775, 24778, 74765),
 F1965 = c(863267, 822556, 801608, 778511, 770893, 780671, 796870, 779095, 756188, 801102, 844291, 843687, 906481, 961297, 1023422, 1109921, 1224596, 1210642, 1145897, 729585, 785845, 959637, 935590, 967320, 955158, 879402, 775033, 840204, 869815, 879212, 846514, 822887, 838551, 824090, 811906, 780125, 771469, 754836, 739687, 734408, 707710, 667483, 651481, 631643, 598062, 628341, 510736, 522288, 525205, 532022, 513849, 520729, 499734, 497462, 472210, 457390, 445862, 420642, 416419, 347278, 363217, 340689, 355358, 345318, 329000, 308739, 274822, 276223, 253338, 241603, 227916, 208560, 190717, 182015, 156038, 159576, 151609, 129793, 116481, 93267, 87916, 78762, 69665, 58881, 49940, 178714),
 M1970 = c(974495, 965677, 942789, 943929, 738025, 915097, 859064, 836183, 811055, 804504, 814215, 827301, 808216, 786420, 830419, 870185, 866940, 914803, 959808, 1011137, 1092090, 1195607, 1195607, 1138769, 722812, 772338, 942980, 923898, 958982, 947582, 875276, 768109, 830456, 863738, 878197, 851127, 822758, 837880, 829397, 813516, 779593, 755188, 736707, 716007, 703380, 652648, 584981, 519082, 483890, 456218, 485704, 408019, 418802, 425281, 434577, 416025, 422685, 408532, 412144, 395749, 386773, 374984, 356343, 348591, 299702, 301233, 285955, 287917, 274893, 257872, 236470, 204823, 196629, 174108, 156046, 141592, 122399, 104678, 93412, 74288, 69542, 61070, 48496, 37435, 26989, 90344),
 F1970 = c(923747, 918033, 896539, 899735, 704595, 874181, 820453, 801151, 776092, 769556, 781493, 795746, 778547, 757184, 798338, 840987, 844452, 900183, 950239, 1008310, 1094581, 1205474, 1207813, 1147173, 727710, 782420, 960988, 939019, 967302, 952689, 880168, 771301, 836897, 864902, 872289, 845783, 817939, 833285, 817202, 803955, 770750, 750447, 731931, 722047, 727578, 699203, 659158, 646302, 623848, 594367, 619798, 504037, 512457, 514040, 518675, 486787, 493048, 476247, 484972, 459024, 442052, 428497, 398681, 388632, 327864, 339594, 316027, 327682, 315303, 299110, 281587, 243195, 240919, 216326, 200303, 185371, 165200, 146432, 135265, 111794, 110235, 100509, 81235, 68932, 52135, 209947),
 M1975 = c(980837, 1041105, 1056806, 1036530, 1012081, 983965, 966737, 946098, 948711, 738142, 918944, 859484, 839381, 814153, 805079, 812466, 829720, 804551, 778583, 814960, 851366, 843081, 898952, 951532, 1018595, 1103362, 1214051, 1213915, 1163269, 731692, 789707, 963771, 940695, 973225, 957193, 878565, 769926, 828800, 860589, 874686, 850764, 817817, 830778, 821141, 804563, 770596, 754499, 733964, 707929, 689513, 639983, 567794, 500850, 466798, 441346, 466183, 388137, 400652, 404747, 412957, 401738, 404392, 387778, 379769, 362146, 353144, 337272, 316586, 306461, 257765, 255307, 239083, 235218, 218501, 199813, 176213, 150713, 139452, 119441, 102487, 88949, 72662, 59397, 49517, 37238, 122647),
 F1975 = c(932920, 987681, 1007021, 983974, 961652, 931696, 917087, 898551, 902936, 704098, 876701, 820210, 801892, 777544, 768676, 778283, 797282, 777456, 757530, 797715, 831389, 829394, 890756, 945309, 1011135, 1094941, 1204615, 1200794, 1145510, 722434, 789418, 965423, 941185, 970172, 955002, 879482, 769409, 832457, 859833, 868573, 846881, 813730, 827352, 811558, 799486, 767543, 757206, 738139, 722615, 719406, 691231, 646365, 631278, 610805, 585255, 606829, 489455, 500247, 499565, 504877, 485151, 488809, 469139, 464361, 440451, 425512, 406371, 375420, 365171, 305335, 311343, 289041, 291948, 277260, 258368, 232586, 201738, 194408, 171111, 152858, 135504, 114723, 98159, 85172, 67382, 268153),
 M1980 = c(813741, 839734, 873852, 896520, 942253, 987894, 1043386, 1057899, 1038900, 1014408, 986691, 969928, 947950, 950553, 739691, 918958, 861039, 836807, 810042, 796839, 799070, 811388, 786000, 761782, 801876, 838484, 838094, 897409, 952586, 1018895, 1102659, 1215045, 1213414, 1162414, 728013, 783458, 959654, 934884, 967450, 949270, 868342, 760935, 818091, 849067, 862555, 834964, 801400, 812186, 801196, 783400, 750312, 732273, 712218, 688381, 663779, 616407, 546530, 480873, 447403, 420166, 442667, 366679, 376164, 378022, 382398, 369077, 367968, 348859, 338768, 318987, 306388, 287749, 265690, 251187, 206647, 200063, 181482, 173886, 155861, 137422, 116308, 94853, 83637, 68046, 54871, 171959),
 F1980 = c(772763, 796501, 832203, 852643, 895206, 939188, 990115, 1009314, 986149, 964781, 934427, 920572, 900343, 903934, 705539, 876000, 821082, 801324, 779779, 770375, 775654, 790713, 771947, 750422, 792174, 824578, 828292, 890109, 945249, 1007659, 1089823, 1200333, 1197681, 1142385, 719964, 785662, 963932, 939435, 967720, 950116, 872245, 763962, 825645, 853343, 863315, 838855, 806362, 819005, 803147, 789872, 758338, 745598, 728976, 719279, 700868, 678795, 633804, 618631, 599031, 571865, 592481, 474986, 484638, 482395, 484817, 463807, 465072, 445148, 434964, 412031, 394769, 373698, 341269, 326536, 269044, 270181, 246071, 243374, 224616, 203729, 177577, 148686, 137122, 114754, 97789, 357411),
 M1985 = c(731571, 761945, 770041, 772180, 783040, 818476, 839670, 873463, 897453, 943996, 987723, 1043746, 1058743, 1040855, 1015903, 989065, 973067, 948823, 950503, 738969, 913438, 848953, 824689, 795001, 783914, 788956, 803555, 784395, 764859, 806565, 844981, 842843, 899787, 952550, 1018104, 1099089, 1210092, 1207873, 1157498, 723678, 779447, 951201, 925656, 957375, 938198, 857144, 750030, 805068, 834371, 845508, 818507, 781316, 789879, 777909, 758803, 723393, 706655, 685056, 659422, 634848, 588200, 519717, 455343, 421907, 394735, 412027, 338300, 344947, 343324, 342410, 327545, 323387, 301237, 286874, 264552, 249358, 227758, 204353, 187366, 148593, 138303, 120889, 110605, 93824, 78622, 255975),
 F1985 = c(698087, 726418, 734869, 736535, 744577, 778147, 796802, 832698, 854417, 896712, 939806, 990877, 1010238, 988291, 965939, 935985, 922468, 902105, 908447, 710515, 879888, 819451, 797751, 773704, 763765, 771409, 788121, 771007, 751141, 793394, 826608, 828858, 889841, 943406, 1007246, 1088435, 1198240, 1195628, 1139419, 718092, 784180, 958867, 933504, 962058, 944468, 866148, 758637, 818539, 846194, 854975, 831392, 796367, 807635, 792944, 778242, 745855, 734709, 716348, 704493, 688966, 665583, 618809, 603566, 582863, 554815, 572575, 456446, 464967, 459762, 458661, 437434, 434946, 412616, 401006, 373800, 354081, 328472, 295232, 276112, 222018, 216393, 190592, 182019, 161227, 140463, 529272),
 M1990 = c(621085, 645402, 667257, 687831, 704464, 736058, 761634, 769649, 771683, 782809, 817406, 839095, 873298, 896453, 943628, 985737, 1042024, 1054881, 1034094, 1005479, 973949, 944150, 919825, 916854, 713421, 883781, 826886, 808914, 784220, 774668, 781953, 799044, 779718, 761121, 803517, 838061, 837748, 892900, 946671, 1009449, 1089260, 1201223, 1197000, 1145495, 717007, 769005, 937807, 911479, 944264, 919743, 839221, 733134, 787247, 814957, 822689, 789554, 755444, 761760, 749978, 726631, 691021, 673338, 650990, 624476, 596724, 549075, 481806, 420591, 386452, 356859, 370104, 299809, 303523, 295724, 290812, 273596, 263794, 240910, 222217, 196940, 179520, 157591, 135288, 117665, 88321, 357040),
 F1990 = c(592600, 615076, 634260, 655607, 669315, 702303, 726407, 734636, 736490, 744888, 777859, 797019, 832487, 853227, 896313, 937693, 988506, 1006504, 987020, 965149, 932473, 912977, 893522, 894019, 698931, 864869, 809441, 791595, 767843, 758496, 767364, 785240, 768365, 749202, 792161, 823055, 826834, 886971, 940406, 1001685, 1082127, 1192114, 1188137, 1132220, 713707, 776919, 949119, 924139, 953472, 932065, 854326, 747303, 809303, 835977, 844229, 815172, 785470, 795281, 781824, 763774, 730878, 718656, 700076, 686543, 672312, 643216, 597623, 581526, 558750, 527678, 543261, 429636, 436600, 425157, 422908, 397757, 391046, 366912, 348782, 316259, 293058, 264553, 230221, 207509, 159132, 765374),
 M1995 = c(609216, 614989, 606889, 619493, 619428, 629916, 649749, 672371, 690873, 706918, 736103, 762492, 770688, 773727, 783958, 820866, 843556, 875464, 898934, 946955, 981345, 1027784, 1036176, 1011951, 983972, 955370, 937672, 920132, 920151, 718800, 891348, 834566, 816403, 790825, 780707, 788702, 803470, 782578, 764634, 806425, 838188, 839141, 894531, 946993, 1008499, 1088256, 1200806, 1189535, 1138015, 711723, 759251, 927393, 900511, 928788, 905844, 825214, 719936, 769577, 793802, 798092, 762856, 725277, 726730, 710919, 686166, 648860, 628847, 603318, 573453, 544228, 496562, 430627, 371237, 336686, 306446, 312171, 247321, 245812, 233068, 222039, 202470, 188880, 164889, 145548, 122705, 479086),
 F1995 = c(582362, 586019, 578374, 588572, 589912, 601336, 619888, 638816, 658956, 671848, 703147, 727793, 736180, 737988, 745729, 779439, 798838, 832861, 857391, 903654, 937529, 981998, 999681, 977824, 956741, 927680, 914494, 895731, 895985, 702126, 868712, 813381, 795891, 772276, 762346, 771792, 787930, 770107, 752151, 794432, 823907, 827681, 886632, 940070, 1000430, 1080439, 1190322, 1181836, 1127009, 710425, 770095, 942760, 916903, 945590, 924783, 847365, 740576, 799998, 825167, 833753, 803717, 770370, 778710, 764339, 746025, 712209, 698390, 677929, 660247, 648597, 617346, 568608, 551080, 525290, 491285, 499901, 390885, 394301, 376651, 366918, 339728, 326261, 296485, 273661, 240138, 1100659),
 M2000 = c(600466, 596910, 610326, 607950, 606869, 615685, 618234, 608946, 620484, 620082, 634159, 646345, 673706, 692224, 706716, 738536, 765613, 772956, 772660, 784219, 823540, 834550, 858862, 874109, 916181, 955777, 1005385, 1020949, 1004494, 978672, 955040, 934421, 916453, 916005, 714899, 887876, 830981, 813476, 786872, 777081, 784295, 799822, 778822, 760715, 800517, 830052, 830544, 882903, 932313, 991960, 1068508, 1172217, 1165232, 1109956, 694125, 740133, 901083, 873685, 900734, 874604, 796438, 693530, 738582, 762043, 758935, 722261, 678589, 674979, 654568, 626884, 590373, 563026, 535445, 504578, 476848, 428635, 366138, 310938, 274724, 245387, 243345, 185705, 176442, 162064, 147712, 653475),
 F2000 = c(571186, 569250, 581831, 581353, 577957, 588448, 589508, 580020, 589798, 590584, 605357, 616000, 640697, 660282, 671126, 704392, 728441, 736916, 737769, 746663, 776798, 790541, 821808, 841135, 883936, 925199, 973691, 995701, 975953, 954488, 929220, 915242, 896745, 895971, 702614, 869898, 814511, 797785, 773125, 763260, 772350, 789135, 770634, 751750, 792179, 820721, 823375, 881209, 932586, 990345, 1070463, 1175634, 1170344, 1113337, 702174, 761830, 931715, 905769, 933340, 911279, 835779, 730911, 787932, 815024, 816659, 787956, 749661, 755222, 738010, 717809, 683298, 666734, 645390, 623437, 611447, 578338, 527533, 506633, 473975, 438299, 438440, 334513, 327377, 307963, 291128, 1579873),
 M2005 = c(539668, 557804, 571375, 588649, 597006, 607278, 604292, 610904, 608086, 605943, 616199, 617258, 608449, 620052, 618720, 632362, 653268, 675064, 696653, 716083, 741422, 753852, 757026, 746565, 755957, 786273, 806426, 838134, 861964, 905754, 949205, 999283, 1014512, 997497, 972768, 945606, 927533, 910300, 908866, 710482, 882923, 827731, 805966, 779029, 769821, 774589, 790161, 766938, 748341, 787471, 816353, 816299, 865997, 913501, 971090, 1043747, 1145025, 1135716, 1079446, 673435, 718324, 874355, 849367, 869302, 843181, 763350, 660974, 698526, 714359, 707797, 667385, 621368, 611177, 586033, 553780, 511696, 484419, 453050, 418680, 388472, 339083, 281960, 231663, 198904, 171025, 810898),
 F2005 = c(517132, 533512, 544274, 560801, 567866, 575699, 575444, 582445, 580785, 577619, 588325, 588164, 579067, 589196, 589222, 601812, 619808, 638398, 660443, 674489, 701168, 717475, 724303, 722848, 729982, 760627, 782125, 816883, 839660, 882203, 924371, 973483, 995080, 974451, 954207, 926907, 913562, 896126, 893579, 702820, 870861, 815550, 795941, 771168, 761606, 769944, 786091, 767125, 747451, 787750, 815028, 817565, 873788, 924649, 982229, 1060582, 1164429, 1157535, 1101184, 694065, 752586, 921463, 895682, 922336, 898033, 820761, 715569, 768743, 789694, 792837, 762627, 723176, 724894, 705863, 681194, 645035, 626316, 601320, 574415, 559398, 519961, 465704, 436403, 403387, 364303, 2115806),
 M2010 = c(535357, 534800, 549618, 547391, 543415, 541784, 561736, 572664, 587557, 596064, 603214, 602200, 611951, 608621, 605957, 625135, 630044, 617821, 623883, 612346, 620070, 633987, 655100, 671178, 685905, 711906, 734612, 744281, 745319, 755605, 789707, 810617, 844822, 866048, 909817, 952113, 1003334, 1019444, 1001440, 973791, 946353, 929854, 909126, 907805, 707237, 875220, 820099, 799335, 772698, 760617, 765827, 778349, 756737, 735910, 772753, 799902, 800001, 847340, 893276, 946970, 1017505, 1111132, 1099971, 1044270, 647590, 686748, 830331, 800182, 816330, 788183, 707137, 607840, 637594, 642992, 629940, 586255, 537517, 519347, 489295, 450526, 406441, 372484, 339041, 304029, 270589, 1047611),
 F2010 = c(510618, 510617, 524576, 522149, 518207, 516705, 537120, 544652, 560176, 567203, 572061, 574398, 583821, 581783, 577029, 593631, 595993, 584693, 592009, 587802, 599080, 615342, 633182, 650335, 662254, 692406, 714943, 725675, 730412, 738542, 771598, 790366, 825114, 846215, 887193, 928180, 978648, 997629, 977208, 954562, 927939, 916907, 898523, 895344, 702777, 868952, 812419, 795184, 770223, 758369, 766232, 781299, 763147, 742787, 781458, 808459, 811286, 866398, 916613, 973489, 1048918, 1150785, 1144348, 1088314, 684416, 740117, 902585, 874253, 898487, 872957, 793847, 690903, 739366, 757137, 756546, 722590, 679840, 677778, 654252, 623613, 583834, 559643, 529513, 497917, 472773, 2747322),
 M2015 = c(488646, 496812, 514340, 517889, 533234, 535281, 540338, 550486, 546601, 541885, 543132, 561901, 573235, 590503, 599253, 615314, 615201, 624601, 618127, 612173, 618294, 613685, 600363, 608260, 605790, 616202, 631361, 653268, 670795, 684091, 709122, 732061, 744101, 744738, 754725, 787195, 808838, 840265, 863248, 904656, 944154, 997639, 1011220, 994781, 966224, 936899, 920877, 899784, 898229, 699088, 863615, 808872, 787394, 760465, 747965, 750627, 764221, 740862, 719326, 754487, 779239, 776097, 820184, 864252, 911347, 972084, 1058636, 1041367, 982794, 604781, 637232, 765578, 732095, 740270, 707265, 628530, 533884, 551102, 547285, 526616, 477824, 427524, 400898, 364913, 323167, 1461624),
 F2015 = c(468544, 473524, 492351, 494877, 507489, 508688, 514398, 524514, 520353, 517243, 517942, 536997, 545320, 561721, 569313, 580245, 581786, 590136, 588423, 582382, 590999, 586960, 575793, 584220, 583763, 596497, 611419, 631629, 651192, 663158, 692947, 716873, 727730, 730603, 737978, 770654, 790480, 822348, 843804, 884669, 924082, 974075, 994671, 974693, 950679, 922380, 909657, 890291, 888578, 697021, 859623, 805459, 786137, 760939, 749827, 757242, 771731, 753175, 732630, 770945, 796734, 798314, 851456, 902301, 955086, 1026866, 1124914, 1114989, 1055137, 662299, 714557, 869144, 838593, 859848, 831229, 751834, 650373, 690948, 701764, 694520, 655790, 611232, 600593, 567833, 531646, 3425863),
 M2015J = c(480925, 488854, 506509, 510136, 526126, 528569, 533839, 544244, 540436, 535852, 537452, 556179, 567602, 584656, 593163, 607238, 607002, 615670, 605293, 592574, 593541, 587587, 572852, 579453, 575812, 584739, 600113, 623977, 641836, 656748, 683082, 706903, 718911, 719739, 731922, 765137, 787671, 819971, 843777, 886156, 925569, 979040, 993141, 977032, 949171, 919995, 904583, 883933, 883626, 685760, 849454, 795059, 774056, 748722, 737051, 739877, 754176, 731332, 710042, 745443, 770335, 767225, 811290, 855322, 902503, 963060, 1049771, 1032732, 974638, 598354, 630715, 758874, 725839, 734527, 701972, 623623, 529555, 546857, 543687, 523422, 474895, 425248, 398642, 362913, 321618, 1456554),
 F2015J = c(460898, 465670, 484764, 487542, 500829, 502380, 508146, 518304, 514472, 511567, 512539, 531623, 539923, 556169, 563639, 572575, 574169, 581725, 576615, 564474, 568405, 563401, 551264, 559090, 557439, 567692, 583036, 603549, 622514, 635390, 665374, 689314, 699689, 701164, 711578, 744181, 763752, 797487, 820026, 861006, 900986, 950653, 970731, 950785, 926725, 898401, 886317, 867434, 868678, 678558, 840789, 787639, 768601, 745807, 736114, 743775, 759574, 741261, 721176, 760104, 786154, 788158, 841695, 892505, 945788, 1017646, 1115673, 1105838, 1046806, 655731, 707837, 862259, 831783, 853259, 824735, 746324, 645491, 685937, 696955, 689937, 651695, 607739, 597148, 564448, 529123, 3415848),
 M2020 = c(425174, 443318, 465785, 477647, 499265, 511421, 511271, 522070, 524058, 537831, 542356, 545009, 554827, 552460, 547479, 549189, 571502, 577524, 590473, 591341, 599122, 595722, 607438, 607959, 607628, 616283, 617665, 608393, 617037, 614709, 627959, 639989, 661486, 678489, 689108, 712613, 737068, 746200, 746742, 754232, 787456, 807174, 836725, 858743, 899348, 934925, 987951, 1001876, 984614, 953624, 923018, 906390, 884012, 880302, 683281, 842548, 788824, 767258, 741565, 725108, 726778, 738473, 713490, 691447, 722715, 741752, 736356, 773688, 809590, 848674, 898630, 974111, 949118, 888828, 538599, 561533, 670027, 632854, 632702, 595744, 519332, 431327, 434337, 420044, 391053, 1896652),
 F2020 = c(406650, 423207, 444220, 456416, 474400, 487243, 485305, 498587, 500267, 511040, 515380, 518176, 528286, 524919, 521625, 521181, 541657, 545713, 560916, 567944, 577927, 578734, 586497, 586024, 584255, 594097, 594502, 584368, 592946, 591964, 606266, 618786, 638083, 657183, 667245, 695106, 719706, 730322, 732178, 737400, 770853, 789164, 820244, 840905, 880465, 917469, 968651, 989261, 969591, 942331, 914413, 901504, 880203, 878653, 688075, 846742, 794086, 774759, 750382, 736210, 742894, 756022, 736792, 716293, 752286, 774689, 775762, 825151, 870265, 919341, 987530, 1078410, 1065025, 1004558, 626986, 673299, 818265, 783717, 797760, 765027, 686726, 586308, 614410, 615013, 598178, 4124434),
 M2020J = c(416205, 433846, 456414, 468049, 489631, 502330, 502013, 513149, 515259, 529830, 534703, 537738, 547504, 545257, 540663, 542488, 564625, 570613, 582147, 575382, 571312, 564746, 571200, 566966, 564608, 573123, 576561, 567683, 579399, 578685, 590411, 605476, 630411, 649321, 662611, 688249, 713544, 723237, 723939, 734260, 768475, 789116, 820049, 843069, 884062, 920288, 973588, 987839, 970786, 940004, 909718, 893886, 871719, 869283, 672794, 831887, 778458, 757176, 732762, 717175, 719141, 731371, 706834, 684936, 716452, 735734, 730784, 768394, 804441, 843806, 893927, 969386, 944711, 884767, 535397, 558373, 667148, 630180, 630242, 593445, 517309, 429584, 432676, 418613, 389708, 1890693),
 F2020J = c(397871, 414017, 435436, 447403, 465233, 478571, 476561, 490253, 492130, 503635, 508384, 511193, 521194, 518177, 515263, 514877, 535419, 539373, 553170, 551251, 549240, 548915, 554778, 552351, 548599, 558404, 560425, 550503, 561271, 561255, 573461, 587548, 609448, 629231, 641405, 669655, 694071, 704138, 704655, 713333, 746741, 765165, 797921, 819657, 859579, 897265, 948471, 968395, 948552, 921292, 893145, 880712, 860423, 861585, 671926, 830748, 778657, 759654, 737517, 724574, 731783, 746355, 727290, 707336, 743655, 766558, 768418, 818504, 863784, 913580, 981865, 1072979, 1059763, 999723, 623162, 669281, 814274, 779955, 794284, 761514, 683530, 583466, 611824, 612679, 595900, 4111927)
)

# Age structures from age 0 up to 110+ of Japan from 1888 to 2020, basically every 5 years.
# M****J: males, Japanese only, year ****.  F****: females, All, year ****
# People with unknown age are not included.
# Source: http://www.stat.go.jp/english/data/kokusei/index.htm
# http://www.stat.go.jp/data/chouki/02.htm and http://www.stat.go.jp/data/chouki/zuhyou/02-02.xls
# https://www.e-stat.go.jp/SG1/estat/GL08020103.do?_csvDownload_&fileId=000007809775&releaseCount=3 (M2015, F2015)
# https://www.e-stat.go.jp/stat-search/file-download?statInfId=000032142404&fileKind=0 (M2020, F2020)
Jpopl <- data.frame(
 Age = c(sprintf("%d",0:109),"110+"),
 M1888 = c(539962, 469536, 470197, 449086, 443053, 458304, 450499, 454853, 440727, 444884, 441802, 429857, 445958, 412208, 402551, 400626, 354671, 328631, 318501, 320255, 367315, 332457, 326722, 353824, 337183, 286454, 267747, 248681, 284076, 282911, 307536, 304933, 295960, 292081, 300346, 293079, 298184, 254272, 269215, 288596, 274011, 260447, 242722, 251201, 236685, 241090, 209308, 215382, 202426, 186624, 171901, 142281, 169829, 169811, 157469, 156079, 169846, 152641, 166130, 140839, 141986, 136525, 122316, 124440, 115478, 104853, 106483, 86080, 84246, 82064, 69670, 59619, 57921, 49142, 44238, 41984, 34636, 32570, 25655, 20675, 19302, 15535, 12449, 10829, 8341, 4481, 3109, 2430, 1795, 1113, 736, 510, 323, 207, 147, 114, 55, 29, 28, 21, 18, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 F1888 = c(520477, 456728, 464484, 437816, 436275, 452806, 440192, 449820, 431196, 436490, 430249, 416833, 436860, 402193, 393830, 390332, 343913, 318685, 309364, 312341, 353366, 324587, 314969, 341210, 325249, 279142, 260291, 243576, 272548, 277030, 291097, 293245, 283190, 278231, 282355, 276216, 277217, 241261, 250557, 271006, 252869, 248619, 202031, 242039, 220613, 223010, 195498, 199379, 190087, 174937, 162685, 139618, 163277, 165918, 153014, 157093, 168845, 152207, 161576, 143623, 147307, 140389, 127731, 131105, 123072, 113425, 113211, 97254, 95246, 92907, 79595, 72185, 70452, 61542, 55903, 54271, 46616, 44037, 35214, 30470, 28239, 23855, 19564, 17354, 13497, 7967, 5603, 4439, 3452, 2320, 1607, 1227, 788, 516, 354, 204, 150, 114, 80, 48, 50, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 M1893 = c(531884, 513295, 450066, 469437, 493529, 479868, 439925, 450351, 435507, 435302, 452498, 445389, 450400, 437540, 441487, 436830, 422396, 439676, 405094, 393641, 389073, 343620, 317886, 304964, 306768, 352743, 318411, 313469, 340083, 323864, 274532, 256060, 237639, 271387, 269131, 293987, 292457, 281992, 278821, 285916, 276905, 281637, 239655, 252098, 271199, 256147, 242090, 224229, 232286, 217095, 220575, 189748, 194073, 182214, 166659, 152201, 123033, 147627, 146318, 132928, 131473, 141716, 125394, 134802, 111637, 110911, 105788, 92241, 92559, 83626, 73350, 72816, 57037, 53939, 50629, 41589, 33400, 31345, 25499, 21596, 19251, 14999, 13250, 9810, 7262, 6396, 5026, 3867, 3112, 2384, 945, 591, 416, 282, 144, 96, 37, 43, 26, 22, 24, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 F1893 = c(514991, 496325, 439461, 456309, 481878, 465354, 429037, 444884, 426928, 427514, 448257, 435490, 446481, 428566, 431449, 425001, 409843, 430262, 395188, 384955, 380341, 332723, 308511, 295267, 298801, 340030, 308992, 300281, 325505, 310628, 264545, 246640, 228807, 257809, 261284, 275144, 276314, 266833, 262420, 266216, 259082, 259851, 225665, 235273, 254253, 236742, 233660, 187499, 226921, 205771, 208324, 180272, 184421, 174648, 159099, 147771, 124527, 146364, 148255, 134189, 138032, 147163, 131302, 137866, 120419, 121922, 114831, 102381, 104250, 95173, 85353, 83798, 69642, 65784, 62702, 51926, 44155, 42105, 35233, 30165, 27863, 22531, 20097, 15134, 12254, 10442, 8641, 6807, 5536, 4123, 1752, 1120, 887, 555, 332, 255, 155, 98, 70, 50, 74, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 M1898 = c(610181, 566578, 528074, 517467, 501655, 477716, 479135, 429067, 455998, 484852, 474595, 434128, 444642, 430407, 430185, 447303, 439833, 443536, 428980, 431504, 426227, 411754, 426814, 389848, 376914, 374171, 327661, 304114, 291981, 293383, 339995, 306348, 299073, 327382, 310989, 261791, 242355, 224144, 258210, 256376, 280548, 278364, 267512, 263866, 269469, 261455, 265605, 222129, 234035, 251991, 236531, 222624, 203763, 210858, 194960, 197579, 167547, 170646, 158749, 143012, 129182, 102204, 122084, 119564, 106861, 103793, 110537, 95486, 100971, 81161, 79268, 73315, 61718, 60466, 52855, 44452, 42542, 31575, 29128, 26056, 20238, 14656, 12992, 10074, 8060, 6596, 5111, 4142, 2965, 1997, 1600, 1299, 991, 851, 642, 166, 85, 81, 52, 26, 58, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 F1898 = c(599251, 549702, 521339, 503210, 485609, 466586, 466875, 422199, 444950, 475109, 461107, 423598, 438998, 421034, 422676, 441201, 429114, 439147, 419572, 421525, 415300, 398323, 418838, 381668, 371662, 367081, 319343, 294618, 282975, 285071, 325182, 296682, 285809, 312337, 297486, 250877, 232302, 214233, 243422, 247516, 260100, 261115, 252430, 246514, 250306, 245481, 245790, 211723, 219948, 240104, 221636, 219637, 171766, 211085, 189132, 191570, 163566, 166784, 157738, 142062, 130436, 108304, 127503, 127296, 114062, 115837, 121890, 106750, 110123, 93834, 94037, 86287, 74977, 74754, 65780, 57034, 53703, 42789, 38872, 36021, 28063, 22138, 19810, 15788, 12763, 11117, 8835, 7153, 5144, 3810, 3112, 2577, 1911, 1626, 1151, 307, 208, 160, 84, 82, 168, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 M1903 = c(664315, 638514, 616396, 572519, 549855, 550031, 531195, 506818, 504418, 492810, 471597, 474410, 425324, 450108, 480285, 468622, 426026, 434786, 419418, 417953, 435392, 429125, 431056, 415809, 417046, 412211, 397700, 413026, 377825, 364985, 362590, 317693, 294485, 282647, 283627, 327134, 294012, 287552, 314248, 297143, 250808, 232242, 213672, 245604, 244039, 265958, 262832, 251498, 247694, 251072, 242082, 245527, 204086, 213565, 228408, 212567, 199353, 180915, 185673, 169604, 170541, 142833, 143345, 132467, 117433, 104241, 81006, 94826, 91043, 79619, 75823, 78399, 65846, 67362, 51928, 49349, 43808, 35387, 33276, 28109, 22242, 20457, 14442, 13011, 11093, 8166, 5383, 4353, 3529, 2749, 2189, 1771, 1433, 1020, 724, 608, 497, 416, 417, 277, 318, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 F1903 = c(641621, 620169, 598610, 554751, 530308, 542691, 517561, 500445, 490512, 477739, 460600, 461780, 417257, 437744, 467626, 452501, 413826, 428143, 410684, 410904, 430581, 416397, 424390, 404430, 406125, 400326, 382963, 401335, 365926, 355907, 351889, 305561, 282075, 271009, 273007, 310584, 281498, 272063, 296924, 281927, 237663, 220461, 202600, 230543, 234701, 246534, 247121, 238250, 233530, 236057, 230296, 229738, 197427, 204384, 222366, 204478, 201206, 157111, 192085, 170697, 170789, 144266, 146194, 136647, 122794, 110978, 90288, 105002, 102912, 90361, 90416, 93022, 79508, 79283, 64892, 63226, 56301, 46625, 45089, 37629, 30911, 27788, 21179, 18233, 16173, 11603, 8397, 6950, 5464, 4528, 3454, 2864, 2303, 1581, 1157, 1016, 883, 671, 588, 443, 512, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 M1908 = c(742391, 673382, 587905, 583248, 578223, 591956, 598996, 592778, 558654, 539602, 544954, 525538, 500815, 498141, 487321, 465002, 466238, 416217, 438568, 465970, 454330, 412210, 419455, 402978, 400512, 404516, 401608, 408120, 394006, 395430, 391800, 378613, 393634, 361857, 349383, 346608, 303931, 281517, 270734, 271096, 312018, 280457, 274232, 296665, 281710, 237380, 218815, 201269, 229670, 227367, 247482, 242859, 231203, 226987, 228191, 218960, 219618, 181647, 188315, 199504, 184244, 169803, 152651, 155034, 139931, 137510, 112975, 111611, 100957, 87608, 75963, 57779, 65018, 60626, 51855, 47814, 47358, 38543, 37601, 27602, 25123, 21030, 16771, 14956, 12190, 9479, 8322, 5941, 5469, 4595, 3452, 2191, 1706, 1558, 1341, 1054, 923, 778, 597, 467, 1667, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 F1908 = c(720300, 666180, 550532, 578260, 561647, 574544, 581553, 575561, 540613, 519425, 539245, 511929, 493264, 482125, 469579, 450164, 449176, 405882, 423953, 451233, 437288, 400732, 413653, 395379, 395092, 411871, 397509, 403584, 384963, 386657, 380999, 364322, 381713, 347760, 338046, 333097, 290358, 267536, 257473, 258400, 292993, 266995, 257832, 279256, 265880, 224722, 208515, 191570, 216851, 219811, 231834, 231682, 222359, 217086, 218561, 212255, 210658, 180395, 185126, 199520, 182565, 178010, 138642, 166852, 146539, 144206, 120192, 120371, 110608, 97681, 86090, 68386, 77152, 74053, 63029, 61101, 60464, 49657, 47457, 36703, 33930, 28769, 22581, 20837, 16384, 12760, 10941, 7966, 6780, 5942, 4091, 2655, 2197, 1926, 1587, 1236, 1204, 1018, 692, 572, 2173, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 M1913 = c(793494, 735634, 717503, 682483, 670039, 658098, 633390, 566780, 570109, 569974, 586399, 594110, 586211, 550558, 532460, 537297, 516743, 491169, 486451, 473514, 449780, 449660, 401304, 422445, 449450, 439346, 397652, 405621, 389542, 385501, 390809, 387813, 393500, 379434, 380017, 376196, 363728, 378330, 348153, 335007, 332367, 290604, 268962, 257606, 258019, 295755, 264607, 258705, 278554, 264017, 221157, 203110, 185763, 211839, 207744, 224348, 218949, 206807, 201615, 200652, 189930, 189593, 153739, 158212, 164662, 150144, 136303, 120994, 120262, 106055, 101374, 81318, 78626, 69276, 57948, 48547, 35846, 39061, 35168, 28744, 26229, 24888, 19606, 18237, 12667, 11315, 9223, 7376, 6565, 5534, 4468, 4036, 3069, 3017, 2716, 2123, 1479, 1229, 1105, 959, 4252, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 F1913 = c(769695, 716247, 702610, 672180, 656631, 640464, 627574, 532811, 566653, 553011, 569559, 577440, 569362, 531701, 510086, 527254, 498916, 478680, 467651, 454169, 434937, 433156, 390794, 407231, 433611, 419604, 383777, 394543, 377543, 375935, 392171, 379072, 386417, 368519, 368012, 363093, 346644, 363272, 330342, 321162, 317477, 275386, 254239, 243306, 245232, 277755, 253052, 243930, 264524, 251790, 211595, 195895, 179648, 203019, 205168, 214483, 213604, 204024, 198240, 197889, 190627, 187849, 159409, 162961, 172888, 156425, 150287, 115548, 136986, 118900, 114015, 92887, 90776, 81444, 69633, 59921, 45724, 49950, 46199, 37667, 35105, 33440, 26279, 23548, 17122, 15060, 12000, 9133, 8065, 6267, 4866, 4047, 3117, 2771, 2603, 1934, 1307, 1149, 1001, 875, 4658, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 M1918 = c(780605, 745709, 727338, 720168, 723232, 701273, 691781, 692262, 666249, 658101, 649356, 626106, 558722, 561275, 560219, 575350, 581830, 571252, 532139, 513168, 514331, 493208, 468751, 463445, 451509, 429658, 429793, 384342, 403590, 429508, 418359, 379102, 385438, 370727, 366842, 371949, 368999, 373983, 360047, 360700, 357379, 343813, 357291, 328833, 317019, 313216, 272834, 251592, 240740, 239545, 274216, 243179, 236695, 253168, 238687, 198759, 182346, 164187, 185875, 181414, 193347, 186564, 174432, 167099, 164671, 152544, 149365, 118767, 120137, 122353, 108420, 96370, 83020, 80173, 67966, 63408, 48686, 45405, 38374, 30904, 24814, 17540, 18189, 15698, 12571, 11453, 10576, 8402, 7900, 5534, 4960, 4368, 3688, 3366, 3049, 2591, 2558, 2070, 2084, 1892, 7538, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 F1918 = c(764984, 732717, 709952, 705082, 699962, 681580, 675349, 678332, 655533, 646179, 633498, 621382, 524570, 556724, 541154, 556054, 559869, 549900, 511205, 489393, 505218, 477538, 457409, 446290, 432055, 412207, 411432, 368963, 384448, 410631, 395151, 360830, 372804, 356239, 356005, 370056, 357991, 364558, 347260, 346600, 342340, 325619, 342441, 311377, 303320, 300262, 259910, 239383, 229344, 230495, 260349, 235633, 227288, 245020, 232404, 194576, 179948, 163658, 184442, 185171, 191290, 189534, 179162, 172709, 170688, 162077, 157706, 131400, 132159, 138455, 121595, 115202, 85947, 99086, 83496, 77283, 60486, 57069, 49692, 40761, 32904, 23788, 24498, 21490, 16551, 15085, 13427, 10146, 8662, 6010, 5139, 4019, 3325, 2998, 2499, 2118, 1909, 1580, 1615, 1437, 6197, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 M1920 = c(945066, 699760, 696705, 700319, 710777, 693097, 710875, 699984, 696316, 666884, 647926, 652832, 633372, 611589, 543506, 548173, 542611, 562069, 553269, 542900, 507656, 454593, 464661, 448240, 441329, 437897, 417268, 397286, 397149, 358405, 378262, 393733, 377506, 359513, 324429, 340166, 343045, 339568, 338880, 346112, 324853, 338875, 330215, 317831, 328480, 294835, 284428, 275922, 255836, 229383, 212305, 224716, 255192, 216904, 213123, 228975, 212156, 166609, 157988, 146357, 165791, 160960, 163556, 163247, 149479, 142279, 137592, 122325, 116785, 95498, 94922, 94613, 82342, 66461, 61202, 55700, 45758, 39810, 29684, 27301, 21243, 16310, 11705, 8384, 7831, 6200, 4791, 4100, 3277, 2319, 1644, 696, 544, 322, 220, 166, 140, 145, 95, 10, 27, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 F1920 = c(932477, 693228, 690980, 691180, 697223, 679831, 693058, 682137, 681472, 653266, 634949, 636603, 617284, 597638, 525868, 533853, 526648, 545539, 539377, 524618, 495101, 461315, 473562, 434769, 428084, 416528, 397665, 378191, 378746, 344814, 361079, 379946, 363827, 352664, 318491, 334543, 342127, 342228, 337205, 346864, 319173, 332044, 319390, 311378, 321525, 289040, 280639, 273052, 250014, 225418, 209189, 223561, 254180, 212973, 212619, 230339, 211913, 168543, 163254, 153959, 171594, 169595, 172080, 175390, 164113, 156562, 154181, 139986, 133431, 113898, 114704, 117484, 103348, 86085, 75457, 76830, 64926, 57007, 43478, 41518, 33100, 26129, 19991, 15087, 14403, 12137, 9338, 8199, 6900, 4975, 3645, 1771, 1358, 908, 634, 514, 319, 285, 207, 34, 86, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 M1925 = c(965811, 831914, 803695, 794814, 764245, 806161, 655769, 665422, 675149, 688670, 676678, 699259, 694727, 687458, 652869, 633577, 636543, 609350, 589150, 519750, 522162, 502399, 518298, 519397, 512543, 482679, 452759, 462125, 434361, 424578, 417464, 397434, 378762, 382464, 344053, 365381, 379399, 364073, 346726, 312959, 324028, 326691, 322112, 321718, 329675, 309872, 317391, 310093, 297059, 305073, 272310, 261141, 251696, 232766, 205918, 190699, 199658, 224394, 184650, 181834, 194160, 177170, 137565, 128490, 116615, 128737, 123199, 121786, 119078, 108675, 100029, 93510, 79281, 73141, 57594, 55868, 52431, 43854, 32846, 28633, 24618, 19172, 15517, 10838, 8951, 6476, 4544, 3080, 1951, 1534, 1122, 848, 619, 549, 377, 242, 71, 44, 23, 18, 48, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 F1925 = c(954913, 819843, 793732, 785363, 750253, 793330, 647753, 658139, 661830, 672209, 660136, 677890, 674824, 672300, 638889, 619866, 624931, 591961, 568664, 491485, 506919, 486014, 506967, 500042, 485786, 462179, 427746, 438005, 405613, 403426, 388669, 368073, 354379, 360271, 324518, 343788, 360040, 341824, 331931, 303256, 313581, 319763, 319798, 317931, 326468, 304428, 312920, 302295, 293418, 302600, 271015, 260618, 253943, 233785, 207711, 194281, 206614, 233502, 186369, 188816, 204394, 188031, 149411, 142108, 130397, 142527, 139828, 139712, 139369, 131429, 122693, 117495, 101916, 94972, 78549, 77296, 75283, 64239, 50279, 42285, 40313, 32898, 26929, 19619, 16979, 12787, 9299, 6530, 4390, 3647, 2896, 2078, 1699, 1473, 1063, 686, 209, 140, 73, 40, 139, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 M1930 = c(985978, 906284, 882064, 892926, 876190, 818268, 787488, 791425, 770332, 747273, 787708, 638012, 657616, 668724, 684500, 670377, 687032, 670302, 659262, 631690, 607136, 593436, 568102, 557128, 489604, 497517, 487241, 503125, 501079, 491795, 461605, 437622, 446004, 420519, 409290, 404573, 384820, 366631, 368993, 331888, 349878, 364120, 346957, 331246, 295733, 307629, 307067, 303068, 301051, 306342, 285734, 293312, 284354, 271418, 275758, 245697, 233846, 222549, 204467, 179307, 163068, 169057, 185901, 154599, 147690, 154147, 138420, 104624, 95339, 84663, 92270, 84643, 82477, 77549, 67045, 59727, 53644, 43390, 37777, 27913, 25506, 23199, 17912, 12443, 10123, 8017, 5607, 4059, 2518, 2058, 1253, 840, 478, 284, 206, 145, 115, 134, 90, 102, 31, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 F1930 = c(966328, 892847, 867421, 880805, 860292, 807296, 775957, 779521, 758222, 731303, 770273, 628181, 645661, 653383, 666987, 652238, 663652, 650111, 642497, 612443, 585975, 588191, 554187, 532306, 455441, 481256, 461284, 477735, 474166, 460436, 433927, 407310, 422269, 390638, 384481, 374775, 356739, 340407, 344027, 311980, 327957, 343896, 324108, 317016, 285567, 298941, 304450, 305593, 302769, 309353, 284874, 295217, 283176, 276145, 280706, 252169, 242153, 233671, 213050, 189194, 174953, 185281, 206472, 169157, 165907, 175759, 158848, 123350, 115800, 104880, 112530, 107418, 106474, 102993, 93202, 85101, 77557, 64907, 56836, 44866, 42701, 40156, 31952, 23403, 18066, 16464, 11898, 8893, 5967, 4682, 3218, 2089, 1446, 797, 635, 542, 388, 431, 456, 348, 74, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 M1935 = c(1031081, 933210, 931018, 918975, 899717, 870382, 858901, 852881, 867527, 853572, 814735, 776991, 780365, 763582, 741101, 776367, 631960, 643259, 645384, 653743, 630192, 608136, 598567, 610643, 589245, 567214, 564031, 542553, 528353, 468097, 474670, 464869, 482303, 483147, 474503, 446621, 419209, 430075, 404539, 393002, 385265, 367706, 349124, 350381, 315151, 333627, 343211, 326956, 311132, 276253, 286472, 284261, 279110, 276434, 278099, 258825, 261471, 252886, 240876, 241034, 212209, 199776, 188486, 170284, 146065, 131019, 132742, 142070, 115109, 109068, 110507, 96532, 71173, 62607, 53404, 55992, 48828, 45601, 40761, 33647, 28435, 24048, 17970, 14700, 9890, 8506, 6925, 5011, 3154, 2334, 1591, 1049, 616, 347, 281, 157, 104, 45, 41, 15, 40, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 F1935 = c(1004828, 913346, 914236, 899666, 882424, 853965, 846563, 837284, 854297, 836047, 802531, 763111, 766684, 752045, 724102, 758172, 620520, 632900, 635965, 642647, 622918, 627180, 607156, 601809, 575225, 554063, 553608, 523005, 503334, 435825, 458296, 437229, 458719, 457304, 441597, 420085, 387726, 402106, 372748, 369735, 355587, 337520, 322809, 327249, 295219, 314479, 325566, 308594, 300453, 272563, 282637, 287075, 287670, 283654, 287463, 266675, 272572, 262554, 255385, 258859, 229314, 218558, 210730, 190033, 165156, 151793, 158558, 172354, 137896, 136483, 139792, 123864, 94104, 86295, 75145, 78599, 72003, 68437, 62967, 54969, 48041, 41735, 32357, 27393, 19410, 17484, 15254, 11175, 7383, 5029, 4222, 2814, 1833, 1157, 711, 505, 308, 189, 108, 85, 188, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 M1940 = c(1005488, 839248, 884861, 918069, 930372, 900048, 878667, 888682, 882473, 874102, 847195, 836270, 840419, 842626, 837921, 795839, 751668, 742892, 715449, 688944, 721755, 574274, 578076, 580695, 585159, 566907, 580306, 566664, 562888, 546298, 527477, 526959, 505847, 495310, 438530, 448315, 439008, 455978, 457910, 446255, 419969, 395963, 403869, 379007, 365562, 359058, 340042, 323312, 324314, 290066, 306466, 315533, 296539, 280217, 247006, 256037, 250033, 243966, 241047, 239050, 220200, 221381, 209938, 195703, 192758, 166533, 153697, 142741, 126494, 105951, 91816, 90669, 94632, 73194, 66247, 64724, 54085, 37918, 31471, 25754, 25047, 20519, 18165, 14856, 11269, 8912, 6935, 4608, 3460, 2035, 1540, 1304, 858, 401, 257, 181, 136, 79, 51, 44, 26, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 F1940 = c(977251, 818778, 867689, 897455, 907090, 878743, 862519, 871413, 862461, 856232, 828254, 822587, 825057, 828918, 823977, 786830, 745206, 741385, 715614, 680684, 708746, 572024, 578373, 580353, 587701, 566776, 574618, 559444, 559137, 538080, 518657, 520605, 493771, 476955, 412351, 435991, 417864, 435046, 435541, 420060, 396025, 369091, 379702, 350800, 345750, 335194, 317745, 303685, 307939, 277364, 295437, 305811, 286819, 278231, 250315, 261823, 262726, 261685, 259310, 260537, 240749, 246142, 233978, 223759, 221894, 196128, 183705, 175120, 155306, 132468, 118320, 122420, 130410, 99528, 95359, 94223, 80360, 58717, 50561, 42249, 41497, 35933, 32402, 28346, 23116, 18970, 15188, 10361, 7945, 5072, 4207, 3512, 2301, 1219, 756, 629, 400, 234, 152, 114, 159, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 M1947 = c(1274050, 790690, 832073, 1014303, 986990, 1018877, 1002728, 909484, 806104, 860213, 906820, 917676, 887522, 859262, 878009, 871785, 861470, 826178, 806677, 778462, 779465, 743288, 688986, 610123, 540594, 508479, 484361, 512924, 445542, 459607, 470024, 482991, 470148, 486143, 471381, 466790, 472637, 469089, 466941, 454102, 456157, 409642, 415118, 405748, 423943, 422027, 415649, 392223, 365972, 368340, 344634, 333510, 329871, 305111, 286598, 286283, 251255, 263202, 268968, 247231, 231169, 195657, 197791, 191450, 180468, 170739, 169437, 147842, 143427, 133004, 118617, 114975, 94711, 83231, 73692, 61440, 47569, 38139, 33520, 32385, 23383, 19968, 17556, 13490, 8045, 6191, 4427, 3906, 2717, 1974, 1456, 925, 607, 424, 216, 150, 102, 66, 38, 9, 16, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 F1947 = c(1223585, 764614, 815766, 994016, 965559, 992351, 982155, 893018, 790419, 843666, 883612, 902634, 872165, 843647, 861346, 856647, 844888, 815334, 808991, 793425, 777400, 771206, 754115, 705445, 691282, 671789, 641299, 664592, 545282, 557759, 557950, 562947, 551175, 560080, 534760, 533357, 529332, 509506, 500683, 479346, 460245, 396238, 413444, 396635, 414828, 409998, 399021, 380110, 350746, 354759, 325100, 319116, 313280, 295745, 279014, 279999, 249248, 267723, 272907, 257643, 243002, 213161, 219496, 222125, 215026, 206801, 206889, 184884, 182370, 174115, 157148, 155074, 133393, 119543, 109762, 92055, 73129, 61554, 55262, 55192, 40688, 37576, 34162, 26324, 17285, 13460, 9646, 8585, 6389, 4758, 3354, 2412, 1681, 1175, 647, 410, 242, 189, 102, 27, 39, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 M1950 = c(1182171, 1286543, 1264541, 1198969, 786266, 831695, 1008498, 978246, 1007452, 999535, 910239, 799903, 863405, 906746, 920094, 884422, 860642, 869344, 861541, 841618, 802744, 783719, 764479, 752413, 732460, 674941, 609884, 543701, 507376, 485996, 517749, 437635, 456249, 465986, 482621, 473869, 488768, 474335, 476776, 462357, 458889, 458870, 446234, 444655, 390307, 404955, 393991, 412372, 409830, 397700, 372487, 346338, 353080, 330302, 317068, 307578, 288699, 271109, 272106, 239169, 248485, 246402, 228624, 209036, 177020, 177794, 168497, 158173, 149451, 142004, 125348, 120299, 109434, 96685, 88525, 72140, 62677, 54100, 44756, 34017, 26469, 23524, 20963, 13666, 10967, 9330, 6463, 4000, 2668, 2046, 1406, 907, 705, 427, 296, 216, 158, 52, 35, 23, 25, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 F1950 = c(1133819, 1236138, 1215447, 1148008, 753555, 808775, 982049, 955372, 979916, 971127, 887460, 781549, 848275, 885510, 896736, 866860, 844560, 855154, 848454, 835073, 800066, 790078, 774428, 765699, 759456, 727321, 686462, 673201, 651224, 625014, 653342, 532345, 546574, 550679, 559057, 541528, 552877, 531098, 535982, 510483, 491979, 490953, 465168, 453861, 382064, 407549, 385431, 405239, 401411, 386071, 364235, 331761, 343496, 318152, 311749, 301155, 283405, 267119, 273923, 244766, 260938, 260369, 240866, 230650, 201505, 206601, 202278, 197282, 188857, 179778, 163941, 161441, 150459, 138053, 127423, 107661, 96444, 85746, 72289, 55823, 46806, 43641, 40695, 26592, 22460, 19878, 13895, 9296, 6782, 4695, 3741, 2548, 1805, 1351, 961, 713, 528, 203, 116, 67, 72, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 M1955 = c(875952, 874643, 927800, 989687, 1058248, 1144964, 1264782, 1257152, 1192780, 776813, 827056, 1003333, 977202, 1011047, 997162, 906578, 796136, 852872, 888736, 897047, 864749, 833829, 843018, 835105, 819714, 784388, 771468, 757398, 739378, 722750, 672348, 605186, 536980, 503550, 479175, 510722, 431127, 447980, 457391, 472278, 464994, 477632, 464012, 464696, 453416, 450264, 445379, 431780, 430697, 377395, 389533, 379789, 394440, 388306, 377181, 353605, 325323, 327958, 308274, 292543, 281414, 261359, 242841, 235674, 205505, 211002, 207775, 188576, 170247, 141456, 139047, 129376, 118199, 107724, 99430, 84967, 78857, 68991, 58111, 51133, 39521, 32319, 26317, 20588, 14447, 10607, 8697, 7131, 4309, 3108, 2372, 1451, 749, 473, 324, 172, 101, 90, 39, 21, 37, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 F1955 = c(833387, 835448, 889975, 949493, 1013108, 1097602, 1214277, 1206274, 1142290, 745658, 805159, 978037, 954724, 985160, 968937, 887541, 782821, 843394, 878730, 891664, 863515, 835295, 848784, 836318, 822916, 788115, 780090, 763514, 749301, 747926, 719225, 677884, 662741, 643241, 616602, 644338, 524465, 537394, 541267, 548164, 530923, 541183, 520495, 525272, 502707, 485022, 478224, 451199, 442745, 374468, 395924, 374663, 392135, 386276, 371243, 350441, 317696, 326864, 306571, 296239, 284924, 266127, 250625, 248812, 219312, 232794, 231430, 210004, 200872, 172863, 175188, 169307, 162405, 150863, 141123, 125293, 120059, 107518, 95603, 85169, 68426, 58167, 49463, 39696, 28843, 22750, 19817, 16690, 10201, 8045, 6428, 3947, 2366, 1547, 963, 660, 427, 230, 173, 76, 121, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 M1960 = c(819570, 828314, 804114, 785371, 836380, 887769, 884000, 937370, 995634, 1065805, 1154276, 1273695, 1266718, 1207759, 775461, 816862, 991000, 958960, 986034, 960998, 871111, 761657, 815279, 848971, 863078, 840007, 812566, 831572, 828594, 816427, 784994, 772624, 759057, 736485, 720880, 671027, 601413, 533583, 500665, 476182, 507042, 425861, 441900, 451411, 464906, 456709, 467180, 454380, 453287, 440403, 435822, 431446, 415031, 412210, 359228, 368792, 358168, 369692, 365575, 351144, 325500, 296527, 295668, 272307, 256755, 244168, 224260, 204214, 195377, 167023, 167498, 162400, 143430, 124855, 100489, 95354, 85584, 75661, 65391, 57777, 46721, 41287, 33765, 26973, 21853, 15823, 12044, 9178, 6591, 4557, 2840, 2081, 1471, 751, 535, 304, 119, 65, 41, 26, 27, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 F1960 = c(780378, 790690, 769550, 751134, 799327, 847453, 843533, 901999, 955303, 1020275, 1108179, 1224304, 1217132, 1158394, 744272, 800488, 977690, 947775, 978402, 961464, 879897, 773781, 834811, 865851, 876546, 849916, 821439, 838591, 825909, 814503, 781237, 773388, 759337, 744784, 742907, 716565, 673435, 657853, 639031, 613381, 639372, 518977, 530895, 535514, 542069, 524112, 533009, 513896, 516045, 491792, 474437, 469649, 440134, 429741, 363506, 382320, 361759, 377507, 374443, 357976, 336354, 302862, 307906, 284361, 274768, 261327, 242277, 225825, 220994, 193825, 202058, 198605, 176523, 163809, 137360, 135970, 127558, 118474, 105931, 95697, 81309, 74375, 63405, 53046, 44929, 33469, 26905, 21122, 15525, 10599, 7613, 5825, 4293, 2266, 1601, 1090, 596, 274, 157, 95, 117, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 M1965 = c(900258, 857136, 833855, 810592, 802931, 810541, 826881, 805554, 782201, 831017, 877404, 875746, 933850, 992880, 1058445, 1140306, 1250399, 1234606, 1166953, 735091, 776412, 941244, 917413, 949076, 939824, 864534, 761580, 824717, 861327, 879403, 851704, 826279, 843032, 837513, 822441, 790396, 776690, 758470, 734333, 713583, 665282, 595806, 528489, 495006, 464059, 496875, 417432, 432834, 440414, 453185, 443878, 452593, 436822, 434134, 420060, 414837, 405715, 393084, 393540, 335367, 340750, 327245, 334858, 324182, 308011, 283822, 255103, 251075, 227080, 209661, 196605, 175924, 156823, 145256, 120764, 117842, 109462, 92775, 76561, 58771, 52601, 44405, 37191, 29775, 24778, 18382, 15217, 11420, 8642, 6466, 4440, 3108, 2210, 1719, 1378, 384, 211, 153, 53, 33, 39, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 F1965 = c(863267, 822556, 801608, 778511, 770893, 780671, 796870, 779095, 756188, 801102, 844291, 843687, 906481, 961297, 1023422, 1109921, 1224596, 1210642, 1145897, 729585, 785845, 959637, 935590, 967320, 955158, 879402, 775033, 840204, 869815, 879212, 846514, 822887, 838551, 824090, 811906, 780125, 771469, 754836, 739687, 734408, 707710, 667483, 651481, 631643, 598062, 628341, 510736, 522288, 525205, 532022, 513849, 520729, 499734, 497462, 472210, 457390, 445862, 420642, 416419, 347278, 363217, 340689, 355358, 345318, 329000, 308739, 274822, 276223, 253338, 241603, 227916, 208560, 190717, 182015, 156038, 159576, 151609, 129793, 116481, 93267, 87916, 78762, 69665, 58881, 49940, 40292, 34367, 27139, 20959, 16274, 11362, 8491, 6225, 4498, 3282, 1196, 853, 558, 231, 166, 175, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 M1970 = c(974495, 965677, 942789, 943929, 738025, 915097, 859064, 836183, 811055, 804504, 814215, 827301, 808216, 786420, 830419, 870185, 866940, 914803, 959808, 1011137, 1092090, 1195607, 1195607, 1138769, 722812, 772338, 942980, 923898, 958982, 947582, 875276, 768109, 830456, 863738, 878197, 851127, 822758, 837880, 829397, 813516, 779593, 755188, 736707, 716007, 703380, 652648, 584981, 519082, 483890, 456218, 485704, 408019, 418802, 425281, 434577, 416025, 422685, 408532, 412144, 395749, 386773, 374984, 356343, 348591, 299702, 301233, 285955, 287917, 274893, 257872, 236470, 204823, 196629, 174108, 156046, 141592, 122399, 104678, 93412, 74288, 69542, 61070, 48496, 37435, 26989, 22404, 17549, 13861, 10095, 7659, 5408, 4211, 2891, 2024, 1569, 617, 364, 219, 104, 60, 65, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 F1970 = c(923747, 918033, 896539, 899735, 704595, 874181, 820453, 801151, 776092, 769556, 781493, 795746, 778547, 757184, 798338, 840987, 844452, 900183, 950239, 1008310, 1094581, 1205474, 1207813, 1147173, 727710, 782420, 960988, 939019, 967302, 952689, 880168, 771301, 836897, 864902, 872289, 845783, 817939, 833285, 817202, 803955, 770750, 750447, 731931, 722047, 727578, 699203, 659158, 646302, 623848, 594367, 619798, 504037, 512457, 514040, 518675, 486787, 493048, 476247, 484972, 459024, 442052, 428497, 398681, 388632, 327864, 339594, 316027, 327682, 315303, 299110, 281587, 243195, 240919, 216326, 200303, 185371, 165200, 146432, 135265, 111794, 110235, 100509, 81235, 68932, 52135, 45571, 38100, 31119, 24188, 19128, 14293, 11207, 8021, 5725, 4266, 1951, 1248, 763, 451, 237, 243, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 M1975 = c(980837, 1041105, 1056806, 1036530, 1012081, 983965, 966737, 946098, 948711, 738142, 918944, 859484, 839381, 814153, 805079, 812466, 829720, 804551, 778583, 814960, 851366, 843081, 898952, 951532, 1018595, 1103362, 1214051, 1213915, 1163269, 731692, 789707, 963771, 940695, 973225, 957193, 878565, 769926, 828800, 860589, 874686, 850764, 817817, 830778, 821141, 804563, 770596, 754499, 733964, 707929, 689513, 639983, 567794, 500850, 466798, 441346, 466183, 388137, 400652, 404747, 412957, 401738, 404392, 387778, 379769, 362146, 353144, 337272, 316586, 306461, 257765, 255307, 239083, 235218, 218501, 199813, 176213, 150713, 139452, 119441, 102487, 88949, 72662, 59397, 49517, 37238, 32620, 26397, 19250, 13634, 9025, 6917, 5071, 3487, 2438, 1756, 796, 561, 320, 173, 96, 106, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 F1975 = c(932920, 987681, 1007021, 983974, 961652, 931696, 917087, 898551, 902936, 704098, 876701, 820210, 801892, 777544, 768676, 778283, 797282, 777456, 757530, 797715, 831389, 829394, 890756, 945309, 1011135, 1094941, 1204615, 1200794, 1145510, 722434, 789418, 965423, 941185, 970172, 955002, 879482, 769409, 832457, 859833, 868573, 846881, 813730, 827352, 811558, 799486, 767543, 757206, 738139, 722615, 719406, 691231, 646365, 631278, 610805, 585255, 606829, 489455, 500247, 499565, 504877, 485151, 488809, 469139, 464361, 440451, 425512, 406371, 375420, 365171, 305335, 311343, 289041, 291948, 277260, 258368, 232586, 201738, 194408, 171111, 152858, 135504, 114723, 98159, 85172, 67382, 62006, 53078, 40192, 31238, 21625, 17471, 13165, 9828, 6927, 5144, 2777, 1860, 1181, 739, 454, 468, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 M1980 = c(813741, 839734, 873852, 896520, 942253, 987894, 1043386, 1057899, 1038900, 1014408, 986691, 969928, 947950, 950553, 739691, 918958, 861039, 836807, 810042, 796839, 799070, 811388, 786000, 761782, 801876, 838484, 838094, 897409, 952586, 1018895, 1102659, 1215045, 1213414, 1162414, 728013, 783458, 959654, 934884, 967450, 949270, 868342, 760935, 818091, 849067, 862555, 834964, 801400, 812186, 801196, 783400, 750312, 732273, 712218, 688381, 663779, 616407, 546530, 480873, 447403, 420166, 442667, 366679, 376164, 378022, 382398, 369077, 367968, 348859, 338768, 318987, 306388, 287749, 265690, 251187, 206647, 200063, 181482, 173886, 155861, 137422, 116308, 94853, 83637, 68046, 54871, 44786, 34334, 25865, 19926, 13821, 11097, 7986, 5391, 3399, 2051, 1267, 896, 506, 294, 164, 176, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 F1980 = c(772763, 796501, 832203, 852643, 895206, 939188, 990115, 1009314, 986149, 964781, 934427, 920572, 900343, 903934, 705539, 876000, 821082, 801324, 779779, 770375, 775654, 790713, 771947, 750422, 792174, 824578, 828292, 890109, 945249, 1007659, 1089823, 1200333, 1197681, 1142385, 719964, 785662, 963932, 939435, 967720, 950116, 872245, 763962, 825645, 853343, 863315, 838855, 806362, 819005, 803147, 789872, 758338, 745598, 728976, 719279, 700868, 678795, 633804, 618631, 599031, 571865, 592481, 474986, 484638, 482395, 484817, 463807, 465072, 445148, 434964, 412031, 394769, 373698, 341269, 326536, 269044, 270181, 246071, 243374, 224616, 203729, 177577, 148686, 137122, 114754, 97789, 81385, 65138, 52036, 42162, 30537, 25720, 20221, 13718, 9528, 5936, 4015, 2699, 1799, 1040, 664, 813, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 M1985 = c(731571, 761945, 770041, 772180, 783040, 818476, 839670, 873463, 897453, 943996, 987723, 1043746, 1058743, 1040855, 1015903, 989065, 973067, 948823, 950503, 738969, 913438, 848953, 824689, 795001, 783914, 788956, 803555, 784395, 764859, 806565, 844981, 842843, 899787, 952550, 1018104, 1099089, 1210092, 1207873, 1157498, 723678, 779447, 951201, 925656, 957375, 938198, 857144, 750030, 805068, 834371, 845508, 818507, 781316, 789879, 777909, 758803, 723393, 706655, 685056, 659422, 634848, 588200, 519717, 455343, 421907, 394735, 412027, 338300, 344947, 343324, 342410, 327545, 323387, 301237, 286874, 264552, 249358, 227758, 204353, 187366, 148593, 138303, 120889, 110605, 93824, 78622, 62594, 48492, 39663, 30009, 22563, 17053, 12022, 8124, 5711, 3607, 2390, 1579, 1011, 494, 291, 372, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 F1985 = c(698087, 726418, 734869, 736535, 744577, 778147, 796802, 832698, 854417, 896712, 939806, 990877, 1010238, 988291, 965939, 935985, 922468, 902105, 908447, 710515, 879888, 819451, 797751, 773704, 763765, 771409, 788121, 771007, 751141, 793394, 826608, 828858, 889841, 943406, 1007246, 1088435, 1198240, 1195628, 1139419, 718092, 784180, 958867, 933504, 962058, 944468, 866148, 758637, 818539, 846194, 854975, 831392, 796367, 807635, 792944, 778242, 745855, 734709, 716348, 704493, 688966, 665583, 618809, 603566, 582863, 554815, 572575, 456446, 464967, 459762, 458661, 437434, 434946, 412616, 401006, 373800, 354081, 328472, 295232, 276112, 222018, 216393, 190592, 182019, 161227, 140463, 115970, 91916, 80485, 62674, 49168, 37839, 27822, 20306, 14718, 10026, 6564, 4760, 2913, 1799, 926, 1386, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 M1990 = c(621085, 645402, 667257, 687831, 704464, 736058, 761634, 769649, 771683, 782809, 817406, 839095, 873298, 896453, 943628, 985737, 1042024, 1054881, 1034094, 1005479, 973949, 944150, 919825, 916854, 713421, 883781, 826886, 808914, 784220, 774668, 781953, 799044, 779718, 761121, 803517, 838061, 837748, 892900, 946671, 1009449, 1089260, 1201223, 1197000, 1145495, 717007, 769005, 937807, 911479, 944264, 919743, 839221, 733134, 787247, 814957, 822689, 789554, 755444, 761760, 749978, 726631, 691021, 673338, 650990, 624476, 596724, 549075, 481806, 420591, 386452, 356859, 370104, 299809, 303523, 295724, 290812, 273596, 263794, 240910, 222217, 196940, 179520, 157591, 135288, 117665, 88321, 78121, 64403, 55406, 43522, 34228, 24631, 17848, 13272, 9129, 6157, 4118, 2524, 1533, 935, 566, 647, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 F1990 = c(592600, 615076, 634260, 655607, 669315, 702303, 726407, 734636, 736490, 744888, 777859, 797019, 832487, 853227, 896313, 937693, 988506, 1006504, 987020, 965149, 932473, 912977, 893522, 894019, 698931, 864869, 809441, 791595, 767843, 758496, 767364, 785240, 768365, 749202, 792161, 823055, 826834, 886971, 940406, 1001685, 1082127, 1192114, 1188137, 1132220, 713707, 776919, 949119, 924139, 953472, 932065, 854326, 747303, 809303, 835977, 844229, 815172, 785470, 795281, 781824, 763774, 730878, 718656, 700076, 686543, 672312, 643216, 597623, 581526, 558750, 527678, 543261, 429636, 436600, 425157, 422908, 397757, 391046, 366912, 348782, 316259, 293058, 264553, 230221, 207509, 159132, 148793, 124725, 112921, 94080, 76851, 58261, 42950, 34182, 24396, 17093, 11495, 7419, 4815, 3027, 1790, 2576, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 M1995 = c(609216, 614989, 606889, 619493, 619428, 629916, 649749, 672371, 690873, 706918, 736103, 762492, 770688, 773727, 783958, 820866, 843556, 875464, 898934, 946955, 981345, 1027784, 1036176, 1011951, 983972, 955370, 937672, 920132, 920151, 718800, 891348, 834566, 816403, 790825, 780707, 788702, 803470, 782578, 764634, 806425, 838188, 839141, 894531, 946993, 1008499, 1088256, 1200806, 1189535, 1138015, 711723, 759251, 927393, 900511, 928788, 905844, 825214, 719936, 769577, 793802, 798092, 762856, 725277, 726730, 710919, 686166, 648860, 628847, 603318, 573453, 544228, 496562, 430627, 371237, 336686, 306446, 312171, 247321, 245812, 233068, 222039, 202470, 188880, 164889, 145548, 122705, 105942, 87986, 71092, 57334, 39603, 32436, 24720, 19437, 13843, 9783, 6171, 4032, 2820, 1706, 976, 1205, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 F1995 = c(582362, 586019, 578374, 588572, 589912, 601336, 619888, 638816, 658956, 671848, 703147, 727793, 736180, 737988, 745729, 779439, 798838, 832861, 857391, 903654, 937529, 981998, 999681, 977824, 956741, 927680, 914494, 895731, 895985, 702126, 868712, 813381, 795891, 772276, 762346, 771792, 787930, 770107, 752151, 794432, 823907, 827681, 886632, 940070, 1000430, 1080439, 1190322, 1181836, 1127009, 710425, 770095, 942760, 916903, 945590, 924783, 847365, 740576, 799998, 825167, 833753, 803717, 770370, 778710, 764339, 746025, 712209, 698390, 677929, 660247, 648597, 617346, 568608, 551080, 525290, 491285, 499901, 390885, 394301, 376651, 366918, 339728, 326261, 296485, 273661, 240138, 213320, 184320, 154187, 129763, 93276, 81409, 63767, 52523, 40187, 29697, 20190, 13464, 9716, 6036, 3833, 4971, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 M2000 = c(600466, 596910, 610326, 607950, 606869, 615685, 618234, 608946, 620484, 620082, 634159, 646345, 673706, 692224, 706716, 738536, 765613, 772956, 772660, 784219, 823540, 834550, 858862, 874109, 916181, 955777, 1005385, 1020949, 1004494, 978672, 955040, 934421, 916453, 916005, 714899, 887876, 830981, 813476, 786872, 777081, 784295, 799822, 778822, 760715, 800517, 830052, 830544, 882903, 932313, 991960, 1068508, 1172217, 1165232, 1109956, 694125, 740133, 901083, 873685, 900734, 874604, 796438, 693530, 738582, 762043, 758935, 722261, 678589, 674979, 654568, 626884, 590373, 563026, 535445, 504578, 476848, 428635, 366138, 310938, 274724, 245387, 243345, 185705, 176442, 162064, 147712, 128978, 114420, 94325, 78305, 61055, 49678, 37909, 28027, 20789, 12892, 9497, 6502, 4425, 2822, 1824, 2027, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 F2000 = c(571186, 569250, 581831, 581353, 577957, 588448, 589508, 580020, 589798, 590584, 605357, 616000, 640697, 660282, 671126, 704392, 728441, 736916, 737769, 746663, 776798, 790541, 821808, 841135, 883936, 925199, 973691, 995701, 975953, 954488, 929220, 915242, 896745, 895971, 702614, 869898, 814511, 797785, 773125, 763260, 772350, 789135, 770634, 751750, 792179, 820721, 823375, 881209, 932586, 990345, 1070463, 1175634, 1170344, 1113337, 702174, 761830, 931715, 905769, 933340, 911279, 835779, 730911, 787932, 815024, 816659, 787956, 749661, 755222, 738010, 717809, 683298, 666734, 645390, 623437, 611447, 578338, 527533, 506633, 473975, 438299, 438440, 334513, 327377, 307963, 291128, 261856, 242656, 211054, 185204, 154470, 130143, 104568, 81375, 63272, 41628, 32932, 23296, 17262, 11826, 8102, 10229, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 M2000J = c(594995, 591236, 604562, 602338, 601435, 610395, 613368, 604179, 615909, 615366, 629032, 641247, 668413, 687133, 701545, 733084, 759363, 766390, 765241, 775522, 813067, 823058, 846087, 860381, 901266, 940058, 989528, 1004162, 987204, 961132, 937319, 917218, 899257, 900671, 700138, 872086, 815862, 798340, 773740, 765198, 772678, 789513, 769056, 751147, 791229, 820782, 821925, 874602, 924234, 984157, 1060728, 1164534, 1157894, 1102797, 688285, 734409, 895713, 868642, 895679, 869954, 792307, 689803, 734822, 758539, 755631, 719198, 675898, 672622, 652420, 624820, 588335, 561154, 533552, 502739, 475016, 426798, 364656, 309114, 273041, 243961, 242176, 184757, 175699, 161369, 147175, 128532, 114029, 93994, 78047, 60882, 49552, 37805, 27971, 20741, 12848, 9479, 6490, 4416, 2814, 1817, 2025, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 F2000J = c(565755, 563871, 576274, 576060, 572854, 583295, 584739, 575579, 585388, 585974, 600349, 610982, 635688, 655243, 666104, 698971, 722511, 730627, 730348, 737533, 765494, 777000, 806162, 824696, 866772, 907175, 955186, 975629, 954924, 932643, 906671, 893444, 875233, 877238, 685111, 851663, 797304, 780644, 758435, 749813, 759256, 777483, 759365, 740894, 781685, 810586, 814201, 872474, 924147, 982634, 1062849, 1168340, 1163307, 1106813, 696720, 756378, 926374, 900587, 928463, 906460, 831311, 726915, 784007, 811370, 813097, 784528, 746675, 752437, 735243, 715545, 680952, 664522, 643238, 621352, 609514, 576369, 525696, 504632, 472162, 436727, 437140, 333465, 326426, 307077, 290273, 261204, 241990, 210560, 184720, 154117, 129889, 104340, 81214, 63144, 41535, 32860, 23253, 17230, 11801, 8077, 10205, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
 M2005 = c(539668, 557804, 571375, 588649, 597006, 607278, 604292, 610904, 608086, 605943, 616199, 617258, 608449, 620052, 618720, 632362, 653268, 675064, 696653, 716083, 741422, 753852, 757026, 746565, 755957, 786273, 806426, 838134, 861964, 905754, 949205, 999283, 1014512, 997497, 972768, 945606, 927533, 910300, 908866, 710482, 882923, 827731, 805966, 779029, 769821, 774589, 790161, 766938, 748341, 787471, 816353, 816299, 865997, 913501, 971090, 1043747, 1145025, 1135716, 1079446, 673435, 718324, 874355, 849367, 869302, 843181, 763350, 660974, 698526, 714359, 707797, 667385, 621368, 611177, 586033, 553780, 511696, 484419, 453050, 418680, 388472, 339083, 281960, 231663, 198904, 171025, 160746, 117340, 105891, 92264, 78885, 64379, 53130, 40492, 30756, 21829, 15942, 10778, 7232, 4757, 2717, 1615, 969, 540, 289, 167, 90, 42, 23, 20, 3, 2),
 F2005 = c(517132, 533512, 544274, 560801, 567866, 575699, 575444, 582445, 580785, 577619, 588325, 588164, 579067, 589196, 589222, 601812, 619808, 638398, 660443, 674489, 701168, 717475, 724303, 722848, 729982, 760627, 782125, 816883, 839660, 882203, 924371, 973483, 995080, 974451, 954207, 926907, 913562, 896126, 893579, 702820, 870861, 815550, 795941, 771168, 761606, 769944, 786091, 767125, 747451, 787750, 815028, 817565, 873788, 924649, 982229, 1060582, 1164429, 1157535, 1101184, 694065, 752586, 921463, 895682, 922336, 898033, 820761, 715569, 768743, 789694, 792837, 762627, 723176, 724894, 705863, 681194, 645035, 626316, 601320, 574415, 559398, 519961, 465704, 436403, 403387, 364303, 354088, 262679, 248723, 224972, 203672, 174451, 152356, 124701, 101015, 77761, 59638, 44137, 30924, 22021, 13075, 8403, 5237, 3402, 2017, 1234, 624, 344, 188, 84, 40, 20),
 M2005J = c(534608, 552566, 566141, 583453, 591544, 601759, 599021, 605917, 603105, 601088, 611362, 612691, 603902, 615658, 614179, 627332, 647717, 668962, 689417, 706388, 729003, 739397, 739353, 726424, 736034, 765524, 785557, 818066, 842525, 886482, 930001, 980913, 995932, 979718, 955075, 928201, 911131, 894234, 894427, 696975, 868445, 814069, 792704, 767140, 758855, 763914, 780543, 757674, 739337, 778746, 807601, 807885, 857977, 905485, 963305, 1036101, 1137140, 1128246, 1072183, 667715, 712814, 869043, 844179, 864408, 838597, 759219, 657326, 694860, 710874, 704475, 664359, 618730, 608758, 583810, 551711, 509693, 482619, 451201, 416920, 386801, 337554, 280692, 230218, 197682, 170007, 159884, 116727, 105398, 91824, 78558, 64153, 52921, 40328, 30628, 21741, 15884, 10754, 7211, 4738, 2707, 1608, 967, 539, 287, 167, 90, 42, 23, 20, 3, 2),
 F2005J = c(512227, 528565, 539269, 555693, 562787, 570354, 570413, 577458, 576096, 572921, 583609, 583775, 574740, 584876, 584652, 596815, 614357, 632794, 652901, 663077, 685649, 698742, 702721, 698331, 707540, 737301, 758317, 793695, 817087, 860021, 902219, 952039, 972949, 952372, 931781, 904413, 891986, 875162, 875320, 685606, 853037, 798614, 779216, 756806, 748317, 756836, 774635, 755939, 736891, 777518, 805057, 808690, 865315, 916432, 974701, 1053115, 1157235, 1150558, 1094704, 688806, 747355, 916301, 890701, 917534, 893409, 816341, 711746, 765034, 786132, 789373, 759337, 720301, 722171, 703205, 678888, 642802, 624234, 599239, 572457, 557551, 518219, 464115, 434783, 401966, 363076, 353041, 261894, 248057, 224337, 203099, 174015, 151981, 124420, 100782, 77586, 59515, 44060, 30870, 21987, 13038, 8389, 5224, 3391, 2011, 1232, 623, 343, 187, 84, 40, 19),
 M2010 = c(535357, 534800, 549618, 547391, 543415, 541784, 561736, 572664, 587557, 596064, 603214, 602200, 611951, 608621, 605957, 625135, 630044, 617821, 623883, 612346, 620070, 633987, 655100, 671178, 685905, 711906, 734612, 744281, 745319, 755605, 789707, 810617, 844822, 866048, 909817, 952113, 1003334, 1019444, 1001440, 973791, 946353, 929854, 909126, 907805, 707237, 875220, 820099, 799335, 772698, 760617, 765827, 778349, 756737, 735910, 772753, 799902, 800001, 847340, 893276, 946970, 1017505, 1111132, 1099971, 1044270, 647590, 686748, 830331, 800182, 816330, 788183, 707137, 607840, 637594, 642992, 629940, 586255, 537517, 519347, 489295, 450526, 406441, 372484, 339041, 304029, 270589, 223708, 177598, 138353, 112871, 91692, 79600, 53653, 44863, 35831, 27852, 19836, 14982, 10098, 6798, 4025, 2534, 1505, 838, 481, 240, 127, 66, 38, 17, 2, 3),
 F2010 = c(510618, 510617, 524576, 522149, 518207, 516705, 537120, 544652, 560176, 567203, 572061, 574398, 583821, 581783, 577029, 593631, 595993, 584693, 592009, 587802, 599080, 615342, 633182, 650335, 662254, 692406, 714943, 725675, 730412, 738542, 771598, 790366, 825114, 846215, 887193, 928180, 978648, 997629, 977208, 954562, 927939, 916907, 898523, 895344, 702777, 868952, 812419, 795184, 770223, 758369, 766232, 781299, 763147, 742787, 781458, 808459, 811286, 866398, 916613, 973489, 1048918, 1150785, 1144348, 1088314, 684416, 740117, 902585, 874253, 898487, 872957, 793847, 690903, 739366, 757137, 756546, 722590, 679840, 677778, 654252, 623613, 583834, 559643, 529513, 497917, 472773, 425162, 369796, 334519, 299116, 259773, 237240, 166103, 148000, 124196, 104369, 77790, 62390, 45747, 33028, 22062, 14996, 9589, 5883, 3539, 1713, 1064, 586, 321, 171, 94, 75),
 M2010J = c(529061, 528416, 543121, 541118, 537581, 536230, 556302, 567211, 582215, 590348, 597582, 596606, 606261, 602967, 600387, 616731, 621876, 609601, 613695, 597843, 600454, 610706, 628961, 642776, 657469, 684069, 707083, 716678, 716786, 730078, 764572, 786140, 821361, 844032, 888326, 929944, 982154, 998119, 981358, 953919, 926954, 911124, 890835, 890997, 692205, 858837, 804428, 784285, 758724, 747799, 753059, 766639, 745821, 725002, 761750, 788867, 789256, 836802, 882686, 936519, 1006964, 1100087, 1089261, 1034232, 639832, 678884, 822551, 792387, 808507, 780648, 700515, 601883, 631202, 637334, 624866, 581139, 533186, 515480, 485672, 447364, 403490, 370336, 336961, 302089, 268970, 222842, 176851, 137654, 112280, 91281, 79270, 53431, 44695, 35720, 27768, 19777, 14931, 10057, 6770, 4011, 2529, 1500, 836, 478, 240, 127, 66, 37, 16, 2, 3),
 F2010J = c(504519, 504440, 518237, 516176, 512635, 511351, 531968, 539456, 554936, 561895, 566519, 568960, 578294, 576246, 571569, 585981, 588608, 576878, 582063, 572126, 576029, 587781, 604630, 621353, 634719, 664897, 687341, 696689, 698676, 709586, 742654, 761664, 798146, 820625, 862040, 903091, 953025, 972428, 952248, 929671, 902226, 891860, 873566, 874212, 683064, 847834, 793126, 775856, 753481, 742815, 750867, 767283, 749747, 730110, 769191, 795794, 799709, 854989, 905034, 962583, 1038074, 1139451, 1133179, 1078392, 676514, 731826, 894094, 865615, 890130, 864950, 787001, 684696, 733074, 750502, 750237, 716598, 674962, 672951, 649760, 619923, 580276, 556354, 527061, 494972, 470358, 423748, 368611, 333291, 298067, 258952, 236620, 165591, 147613, 123862, 104068, 77599, 62227, 45645, 32955, 22008, 14958, 9561, 5871, 3533, 1706, 1061, 584, 320, 170, 94, 75),
 M2015 = c(488646, 496812, 514340, 517889, 533234, 535281, 540338, 550486, 546601, 541885, 543132, 561901, 573235, 590503, 599253, 615314, 615201, 624601, 618127, 612173, 618294, 613685, 600363, 608260, 605790, 616202, 631361, 653268, 670795, 684091, 709122, 732061, 744101, 744738, 754725, 787195, 808838, 840265, 863248, 904656, 944154, 997639, 1011220, 994781, 966224, 936899, 920877, 899784, 898229, 699088, 863615, 808872, 787394, 760465, 747965, 750627, 764221, 740862, 719326, 754487, 779239, 776097, 820184, 864252, 911347, 972084, 1058636, 1041367, 982794, 604781, 637232, 765578, 732095, 740270, 707265, 628530, 533884, 551102, 547285, 526616, 477824, 427524, 400898, 364913, 323167, 277905, 243196, 210328, 177750, 147462, 113513, 83931, 60680, 43318, 31893, 24835, 14809, 10882, 7540, 5199, 3292, 2244, 1355, 738, 362, 194, 106, 48, 26, 9, 9),
 F2015 = c(468544, 473524, 492351, 494877, 507489, 508688, 514398, 524514, 520353, 517243, 517942, 536997, 545320, 561721, 569313, 580245, 581786, 590136, 588423, 582382, 590999, 586960, 575793, 584220, 583763, 596497, 611419, 631629, 651192, 663158, 692947, 716873, 727730, 730603, 737978, 770654, 790480, 822348, 843804, 884669, 924082, 974075, 994671, 974693, 950679, 922380, 909657, 890291, 888578, 697021, 859623, 805459, 786137, 760939, 749827, 757242, 771731, 753175, 732630, 770945, 796734, 798314, 851456, 902301, 955086, 1026866, 1124914, 1114989, 1055137, 662299, 714557, 869144, 838593, 859848, 831229, 751834, 650373, 690948, 701764, 694520, 655790, 611232, 600593, 567833, 531646, 483243, 452247, 414115, 373861, 337150, 289174, 238297, 201919, 159631, 126764, 106487, 67118, 53244, 39819, 29414, 19096, 13614, 8880, 5391, 2875, 1631, 911, 477, 267, 101, 137),
 M2015J = c(480925, 488854, 506509, 510136, 526126, 528569, 533839, 544244, 540436, 535852, 537452, 556179, 567602, 584656, 593163, 607238, 607002, 615670, 605293, 592574, 593541, 587587, 572852, 579453, 575812, 584739, 600113, 623977, 641836, 656748, 683082, 706903, 718911, 719739, 731922, 765137, 787671, 819971, 843777, 886156, 925569, 979040, 993141, 977032, 949171, 919995, 904583, 883933, 883626, 685760, 849454, 795059, 774056, 748722, 737051, 739877, 754176, 731332, 710042, 745443, 770335, 767225, 811290, 855322, 902503, 963060, 1049771, 1032732, 974638, 598354, 630715, 758874, 725839, 734527, 701972, 623623, 529555, 546857, 543687, 523422, 474895, 425248, 398642, 362913, 321618, 277019, 242433, 209624, 177041, 146934, 113139, 83665, 60411, 43120, 31760, 24745, 14765, 10846, 7516, 5188, 3287, 2235, 1345, 734, 359, 192, 105, 47, 26, 9, 9),
 F2015J = c(460898, 465670, 484764, 487542, 500829, 502380, 508146, 518304, 514472, 511567, 512539, 531623, 539923, 556169, 563639, 572575, 574169, 581725, 576615, 564474, 568405, 563401, 551264, 559090, 557439, 567692, 583036, 603549, 622514, 635390, 665374, 689314, 699689, 701164, 711578, 744181, 763752, 797487, 820026, 861006, 900986, 950653, 970731, 950785, 926725, 898401, 886317, 867434, 868678, 678558, 840789, 787639, 768601, 745807, 736114, 743775, 759574, 741261, 721176, 760104, 786154, 788158, 841695, 892505, 945788, 1017646, 1115673, 1105838, 1046806, 655731, 707837, 862259, 831783, 853259, 824735, 746324, 645491, 685937, 696955, 689937, 651695, 607739, 597148, 564448, 529123, 481677, 450853, 412778, 372685, 336224, 288386, 237687, 201316, 159157, 126441, 106229, 66946, 53123, 39735, 29349, 19057, 13587, 8861, 5381, 2869, 1626, 908, 476, 263, 98, 136),
 M2020 = c(425174, 443318, 465785, 477647, 499265, 511421, 511271, 522070, 524058, 537831, 542356, 545009, 554827, 552460, 547479, 549189, 571502, 577524, 590473, 591341, 599122, 595722, 607438, 607959, 607628, 616283, 617665, 608393, 617037, 614709, 627959, 639989, 661486, 678489, 689108, 712613, 737068, 746200, 746742, 754232, 787456, 807174, 836725, 858743, 899348, 934925, 987951, 1001876, 984614, 953624, 923018, 906390, 884012, 880302, 683281, 842548, 788824, 767258, 741565, 725108, 726778, 738473, 713490, 691447, 722715, 741752, 736356, 773688, 809590, 848674, 898630, 974111, 949118, 888828, 538599, 561533, 670027, 632854, 632702, 595744, 519332, 431327, 434337, 420044, 391053, 341010, 292041, 260360, 224083, 185979, 150062, 121414, 96135, 70704, 52988, 36610, 24062, 15354, 9835, 6249, 4166, 2144, 1378, 880, 483, 275, 223, 128, 61, 27, 1),
 F2020 = c(406650, 423207, 444220, 456416, 474400, 487243, 485305, 498587, 500267, 511040, 515380, 518176, 528286, 524919, 521625, 521181, 541657, 545713, 560916, 567944, 577927, 578734, 586497, 586024, 584255, 594097, 594502, 584368, 592946, 591964, 606266, 618786, 638083, 657183, 667245, 695106, 719706, 730322, 732178, 737400, 770853, 789164, 820244, 840905, 880465, 917469, 968651, 989261, 969591, 942331, 914413, 901504, 880203, 878653, 688075, 846742, 794086, 774759, 750382, 736210, 742894, 756022, 736792, 716293, 752286, 774689, 775762, 825151, 870265, 919341, 987530, 1078410, 1065025, 1004558, 626986, 673299, 818265, 783717, 797760, 765027, 686726, 586308, 614410, 615013, 598178, 552744, 502121, 478789, 438169, 394527, 343762, 303628, 262251, 206909, 171163, 133378, 98995, 74721, 55062, 38458, 27866, 14968, 10477, 6424, 4222, 2549, 1501, 930, 496, 184, 140),
 M2020J = c(416205, 433846, 456414, 468049, 489631, 502330, 502013, 513149, 515259, 529830, 534703, 537738, 547504, 545257, 540663, 542488, 564625, 570613, 582147, 575382, 571312, 564746, 571200, 566966, 564608, 573123, 576561, 567683, 579399, 578685, 590411, 605476, 630411, 649321, 662611, 688249, 713544, 723237, 723939, 734260, 768475, 789116, 820049, 843069, 884062, 920288, 973588, 987839, 970786, 940004, 909718, 893886, 871719, 869283, 672794, 831887, 778458, 757176, 732762, 717175, 719141, 731371, 706834, 684936, 716452, 735734, 730784, 768394, 804441, 843806, 893927, 969386, 944711, 884767, 535397, 558373, 667148, 630180, 630242, 593445, 517309, 429584, 432676, 418613, 389708, 339914, 291038, 259622, 223473, 185466, 149595, 121003, 95793, 70463, 52794, 36510, 23994, 15290, 9797, 6222, 4150, 2138, 1371, 875, 478, 273, 221, 127, 58, 27, 1),
 F2020J = c(397871, 414017, 435436, 447403, 465233, 478571, 476561, 490253, 492130, 503635, 508384, 511193, 521194, 518177, 515263, 514877, 535419, 539373, 553170, 551251, 549240, 548915, 554778, 552351, 548599, 558404, 560425, 550503, 561271, 561255, 573461, 587548, 609448, 629231, 641405, 669655, 694071, 704138, 704655, 713333, 746741, 765165, 797921, 819657, 859579, 897265, 948471, 968395, 948552, 921292, 893145, 880712, 860423, 861585, 671926, 830748, 778657, 759654, 737517, 724574, 731783, 746355, 727290, 707336, 743655, 766558, 768418, 818504, 863784, 913580, 981865, 1072979, 1059763, 999723, 623162, 669281, 814274, 779955, 794284, 761514, 683530, 583466, 611824, 612679, 595900, 550667, 500391, 477253, 436737, 393350, 342804, 302784, 261586, 206339, 170733, 133098, 98794, 74524, 54911, 38348, 27807, 14939, 10454, 6408, 4213, 2545, 1496, 930, 494, 182, 140)
)

# Vital statistics of Japan from 1899 to 2020
# https://www.ipss.go.jp/syoushika/tohkei/Popular/P_Detail2021.asp?fname=T05-28.htm (MMR1899-2009)
# http://www.mhlw.go.jp/toukei/saikin/hw/jinkou/kakutei15/ (2015 fixed on Dec 2016)
# http://www.mhlw.go.jp/toukei/saikin/hw/jinkou/kakutei16/dl/03_h1.pdf
# https://www.mhlw.go.jp/toukei/saikin/hw/jinkou/kakutei18/index.html (2018 confirmed on Dec 2019)
# https://www.mhlw.go.jp/toukei/saikin/hw/jinkou/kakutei19/index.html (2019 confirmed)
# https://www.mhlw.go.jp/toukei/saikin/hw/jinkou/kakutei20/index.html (2020 confirmed)
# https://www.e-stat.go.jp/stat-search/file-download?statInfId=000032119349&fileKind=1 (MMR2010-)
Jvital <- data.frame(
YEAR = c(1899, 1900, 1901, 1902, 1903, 1904, 1905, 1906, 1907, 1908, 1909, 1910, 1911, 1912, 1913, 1914, 1915, 1916, 1917, 1918, 1919, 1920, 1921, 1922, 1923, 1924, 1925, 1926, 1927, 1928, 1929, 1930, 1931, 1932, 1933, 1934, 1935, 1936, 1937, 1938, 1939, 1940, 1941, 1942, 1943, 1947, 1948, 1949, 1950, 1951, 1952, 1953, 1954, 1955, 1956, 1957, 1958, 1959, 1960, 1961, 1962, 1963, 1964, 1965, 1966, 1967, 1968, 1969, 1970, 1971, 1972, 1973, 1974, 1975, 1976, 1977, 1978, 1979, 1980, 1981, 1982, 1983, 1984, 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019, 2020),
CBR = c(32, 32.4, 33.9, 33.6, 32.7, 31.2, 31.2, 29.6, 34, 34.7, 34.9, 34.8, 35.1, 34.4, 34.3, 34.8, 34.1, 33.7, 33.5, 32.7, 32.3, 36.2, 35.1, 34.3, 35.2, 33.9, 34.9, 34.6, 33.4, 34.1, 32.7, 32.4, 32.1, 32.9, 31.5, 29.9, 31.6, 30, 30.9, 27.2, 26.6, 29.4, 31.8, 30.9, 30.9, 34.3, 33.5, 33, 28.1, 25.3, 23.4, 21.5, 20, 19.4, 18.4, 17.2, 18, 17.5, 17.2, 16.9, 17, 17.3, 17.7, 18.6, 13.7, 19.4, 18.6, 18.5, 18.8, 19.2, 19.3, 19.4, 18.6, 17.1, 16.3, 15.5, 14.9, 14.2, 13.6, 13, 12.8, 12.7, 12.5, 11.9, 11.4, 11.1, 10.8, 10.2, 10, 9.9, 9.8, 9.6, 10, 9.6, 9.7, 9.5, 9.6, 9.4, 9.5, 9.3, 9.2, 8.9, 8.8, 8.4, 8.7, 8.6, 8.7, 8.5, 8.5, 8.3, 8.2, 8.2, 8.0, 8.0, 7.8, 7.6, 7.4, 7.0, 6.8),
CDR = c(21.5, 20.8, 20.9, 21.3, 20.4, 20.7, 21.6, 20.3, 21.4, 21.5, 22.5, 21.6, 20.9, 20.5, 20, 21.2, 20.7, 22.2, 22.2, 27.3, 23.3, 25.4, 22.7, 22.4, 22.9, 21.3, 20.3, 19.1, 19.7, 19.8, 19.9, 18.2, 19, 17.7, 17.7, 18.1, 16.8, 17.5, 17.1, 17.7, 17.8, 16.5, 16, 16.1, 16.7, 14.6, 11.9, 11.6, 10.9, 9.9, 8.9, 8.9, 8.2, 7.8, 8, 8.3, 7.4, 7.4, 7.6, 7.4, 7.5, 7, 6.9, 7.1, 6.8, 6.8, 6.8, 6.8, 6.9, 6.6, 6.5, 6.6, 6.5, 6.3, 6.3, 6.1, 6.1, 6, 6.2, 6.1, 6, 6.2, 6.2, 6.3, 6.2, 6.2, 6.5, 6.4, 6.7, 6.7, 6.9, 7.1, 7.1, 7.4, 7.2, 7.3, 7.5, 7.8, 7.7, 7.7, 7.8, 8, 8.2, 8.6, 8.6, 8.8, 9.1, 9.1, 9.5, 9.9, 10.0, 10.1, 10.1, 10.3, 10.5, 10.8, 11.0, 11.2, 11.1),
IMR = c(153.8, 155, 149.9, 154, 152.4, 151.9, 151.7, 153.6, 151.3, 158, 167.3, 161.2, 158.4, 154.2, 152.1, 158.5, 160.4, 170.3, 173.2, 188.6, 170.5, 165.7, 168.3, 166.4, 163.4, 156.2, 142.4, 137.5, 141.7, 137.6, 142.1, 124.1, 131.5, 117.5, 121.3, 124.8, 106.7, 116.7, 105.8, 114.4, 106.2, 90, 84.1, 85.5, 86.6, 76.7, 61.7, 62.5, 60.1, 57.5, 49.4, 48.9, 44.6, 39.8, 40.6, 40, 34.5, 33.7, 30.7, 28.6, 26.4, 23.2, 20.4, 18.5, 19.3, 14.9, 15.3, 14.2, 13.1, 12.4, 11.7, 11.3, 10.8, 10, 9.3, 8.9, 8.4, 7.9, 7.5, 7.1, 6.6, 6.2, 6, 5.5, 5.2, 5, 4.8, 4.6, 4.6, 4.4, 4.5, 4.3, 4.2, 4.3, 3.8, 3.7, 3.6, 3.4, 3.2, 3.1, 3, 3, 2.8, 2.8, 2.6, 2.6, 2.6, 2.4, 2.3, 2.3, 2.2, 2.1, 2.1, 1.9, 2.0, 1.9, 1.9, 1.9, 1.8),
NMR = c(77.9, 79, 77.1, 77.2, 75.8, 73.9, 71.2, 75.5, 73.5, 74.5, 76.5, 74.1, 72.8, 71.3, 70.7, 69.5, 69.7, 73.1, 77.1, 81.3, 72.6, 69, 68.5, 67.5, 66.3, 63.2, 58.1, 56.9, 56.4, 54.2, 55.4, 49.9, 51.7, 47.9, 48.5, 50.6, 44.7, 48.1, 43.8, 46.2, 44.3, 38.7, 34.2, 34.1, 33.8, 31.4, 27.5, 26.9, 27.4, 27.5, 25.4, 25.5, 24.1, 22.3, 23, 21.6, 19.5, 18.6, 17, 16.5, 15.3, 13.8, 12.4, 11.7, 12, 9.9, 9.8, 9.1, 8.7, 8.2, 7.8, 7.4, 7.1, 6.8, 6.4, 6.1, 5.6, 5.2, 4.9, 4.7, 4.2, 3.9, 3.7, 3.4, 3.1, 2.9, 2.7, 2.6, 2.6, 2.4, 2.4, 2.3, 2.3, 2.2, 2, 1.9, 2, 1.8, 1.8, 1.6, 1.7, 1.7, 1.5, 1.4, 1.3, 1.3, 1.2, 1.2, 1.1, 1.1, 1.0, 1.0, 0.9, 0.9, 0.9, 0.9, 0.9, 0.9, 0.8),
NIR = c(10.5, 11.6, 13, 12.3, 12.3, 10.5, 9.6, 9.3, 12.6, 13.2, 12.4, 13.2, 14.1, 13.9, 14.2, 13.6, 13.4, 11.5, 11.3, 5.5, 9, 10.8, 12.4, 11.9, 12.2, 12.6, 14.7, 15.5, 13.7, 14.4, 12.9, 14.2, 13.2, 15.2, 13.8, 11.8, 14.9, 12.4, 13.8, 9.4, 8.9, 12.9, 15.7, 14.7, 14.3, 19.7, 21.6, 21.4, 17.2, 15.4, 14.4, 12.6, 11.9, 11.6, 10.4, 8.9, 10.5, 10.1, 9.6, 9.5, 9.5, 10.3, 10.7, 11.4, 7, 12.7, 11.8, 11.7, 11.8, 12.6, 12.8, 12.8, 12.1, 10.8, 10, 9.4, 8.8, 8.3, 7.3, 6.9, 6.8, 6.5, 6.3, 5.6, 5.2, 4.9, 4.3, 3.7, 3.3, 3.2, 2.9, 2.5, 2.9, 2.1, 2.5, 2.2, 2.1, 1.6, 1.8, 1.6, 1.4, 0.9, 0.7, -0.2, 0.1, -0.1, -0.4, -0.6, -1.0, -1.6, -1.7, -1.9, -2.1, -2.3, -2.6, -3.2, -3.6, -4.2, -4.3),
SBRPB = c(89.1, 88.5, 93.8, 94.5, 93.6, 92.6, 89.1, 97, 89.6, 89.1, 87.1, 84.2, 81.6, 78.3, 77.6, 74.6, 72.8, 72, 71.9, 73.7, 69.5, 66.4, 65, 62.9, 61.5, 59.2, 56.3, 55.7, 53.7, 53.3, 53.3, 53.4, 52.5, 51.9, 51.1, 52.4, 50.1, 50.2, 48.6, 49.1, 49.2, 46, 43.4, 41, 39.6, 44.2, 50.9, 66.7, 84.9, 92.2, 92.3, 93.8, 95.6, 95.8, 97.1, 101.2, 100.7, 100.6, 100.4, 101.7, 98.8, 95.6, 89.2, 81.4, 98.2, 71.6, 71.1, 68.6, 65.3, 61.4, 57.8, 52.6, 51.3, 50.8, 52.7, 51.5, 48.7, 47.7, 46.8, 49.2, 49, 45.5, 46.3, 46, 45.3, 45.3, 43.4, 42.4, 42.3, 39.7, 38.9, 36.6, 33.5, 32.1, 31.7, 32.1, 31.4, 31.6, 31.2, 31, 31.1, 30.5, 30, 29.1, 27.5, 26.2, 25.2, 24.6, 24.2, 23.9, 23.4, 22.9, 22.9, 22.0, 21.0, 21.1, 20.9, 22.0, 20.1),
SARPB = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, 36.9, 39.1, 41.7, 43, 42.8, 43.5, 44.6, 44.5, 46.9, 49.9, 50.2, 51.3, 52.3, 54.3, 54.2, 53.3, 51.7, 47.6, 55.2, 43.6, 43.4, 42.3, 40.6, 39.3, 37.8, 35.6, 34.9, 33.8, 33.1, 32.6, 31.1, 29.6, 28.8, 28.8, 27.7, 25.4, 24.3, 22.1, 21.4, 21.2, 19.5, 18.9, 18.3, 17.5, 17.2, 16.4, 15.4, 14.9, 14.7, 14.2, 13.6, 13.7, 13.2, 13, 12.7, 12.6, 12.5, 12.3, 11.9, 11.7, 11.3, 11.1, 11.2, 11.1, 10.8, 10.4, 10.6, 10.6, 10.1, 10.1, 9.9, 10.2, 9.5),
ACRPB = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, 10.9, 25.9, 43.2, 49.3, 49.5, 50.2, 51.1, 51.3, 50.1, 51.3, 50.5, 49.3, 48.1, 47.4, 44.6, 42.4, 37.5, 33.8, 43.1, 28, 27.7, 26.3, 24.7, 22.1, 20.1, 17, 16.4, 17.1, 19.6, 18.9, 17.6, 18.1, 18, 20.5, 21.3, 20.1, 22, 23.9, 23.9, 24, 23.9, 23.5, 23.9, 22.1, 21.6, 20.2, 18.1, 17.2, 17, 17.9, 17.8, 17.9, 18.1, 18, 18.3, 17.8, 17.5, 16.7, 15.6, 14.5, 13.9, 13.5, 13.0, 12.8, 12.6, 12.5, 12.3, 11.4, 10.9, 11.0, 11.0, 11.8, 10.6),
PNMPB = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, 21.6, 20.2, 19.5, 18.3, 16.9, 16.6, 15.4, 14.6, 13.7, 12.7, 12.1, 11.1, 8.5, 8.1, 7.7, 7.5, 7, 6.7, 6.4, 6.2, 6, 5.8, 5.5, 5.5, 5.3, 5, 4.8, 4.7, 4.5, 4.3, 4.2, 4.2, 4.1, 4.0, 3.7, 3.7, 3.7, 3.6, 3.5, 3.3, 3.4, 3.2),
MR = c(6.9, 7.9, 8.5, 8.8, 8.1, 8.6, 7.5, 7.5, 9.1, 9.6, 9, 9, 8.7, 8.5, 8.4, 8.7, 8.4, 8.1, 8.3, 9.1, 8.7, 9.8, 9.2, 9, 8.8, 8.7, 8.7, 8.3, 7.9, 8, 7.8, 7.9, 7.6, 7.8, 7.2, 7.5, 8, 7.8, 9.5, 7.6, 7.8, 9.3, 11, 9.4, 10.2, 12, 11.9, 10.3, 8.6, 7.9, 7.9, 7.8, 7.9, 8, 7.9, 8.5, 9, 9.1, 9.3, 9.4, 9.8, 9.7, 9.9, 9.7, 9.5, 9.6, 9.5, 9.6, 10, 10.5, 10.4, 9.9, 9.1, 8.5, 7.8, 7.2, 6.9, 6.8, 6.7, 6.6, 6.6, 6.4, 6.2, 6.1, 5.9, 5.7, 5.8, 5.8, 5.9, 6, 6.1, 6.4, 6.3, 6.4, 6.4, 6.2, 6.3, 6.1, 6.4, 6.4, 6, 5.9, 5.7, 5.7, 5.8, 5.7, 5.8, 5.6, 5.5, 5.2, 5.3, 5.3, 5.1, 5.1, 5.0, 4.9, 4.7, 4.8, 4.3),
DR = c(1.53, 1.46, 1.43, 1.43, 1.44, 1.39, 1.29, 1.39, 1.29, 1.26, 1.21, 1.21, 1.16, 1.17, 1.16, 1.15, 1.14, 1.13, 1.03, 1.03, 1.03, 0.99, 0.94, 0.92, 0.88, 0.88, 0.87, 0.83, 0.82, 0.78, 0.81, 0.8, 0.77, 0.77, 0.73, 0.71, 0.7, 0.66, 0.66, 0.63, 0.64, 0.68, 0.69, 0.64, 0.68, 1.02, 0.99, 1.01, 1.01, 0.97, 0.92, 0.86, 0.87, 0.84, 0.8, 0.79, 0.8, 0.78, 0.74, 0.74, 0.75, 0.73, 0.74, 0.79, 0.8, 0.84, 0.87, 0.89, 0.93, 0.99, 1.02, 1.04, 1.04, 1.07, 1.11, 1.14, 1.15, 1.17, 1.22, 1.32, 1.39, 1.51, 1.5, 1.39, 1.37, 1.3, 1.26, 1.29, 1.28, 1.37, 1.45, 1.52, 1.57, 1.6, 1.66, 1.78, 1.94, 2, 2.1, 2.27, 2.3, 2.25, 2.15, 2.08, 2.04, 2.02, 1.99, 2.01, 1.99, 1.87, 1.87, 1.84, 1.77, 1.81, 1.73, 1.70, 1.68, 1.69, 1.57),
TFR = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, 5.11, NA, NA, NA, NA, 4.72, NA, NA, NA, NA, NA, NA, 4.37, 3.82, 3.74, 4.12, NA, NA, NA, NA, NA, NA, 4.54, 4.4, 4.32, 3.65, 3.26, 2.98, 2.69, 2.48, 2.37, 2.22, 2.04, 2.11, 2.04, 2, 1.96, 1.98, 2, 2.05, 2.14, 1.58, 2.23, 2.13, 2.13, 2.13, 2.16, 2.14, 2.14, 2.05, 1.91, 1.85, 1.8, 1.79, 1.77, 1.75, 1.74, 1.77, 1.8, 1.81, 1.76, 1.72, 1.69, 1.66, 1.57, 1.54, 1.53, 1.5, 1.46, 1.5, 1.42, 1.43, 1.39, 1.38, 1.34, 1.36, 1.33, 1.32, 1.29, 1.29, 1.26, 1.32, 1.34, 1.37, 1.37, 1.39, 1.39, 1.41, 1.43, 1.42, 1.45, 1.44, 1.43, 1.42, 1.36, 1.33),
ASMRM = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, 23.6, 19.3, 18.9, 18.6, 16.9, 15.7, 16.4, 15.2, 14.8, 15.6, 16.3, 14.4, 14.4, 14.8, 14.3, 14.6, 13.4, 13.2, 13.7, 12.7, 12.6, 12.5, 12.4, 12.3, 11.5, 11.2, 11.2, 10.9, 10.4, 10.1, 9.6, 9.4, 9, 9.2, 8.9, 8.5, 8.6, 8.3, 8.1, 7.8, 7.6, 7.7, 7.4, 7.5, 7.4, 7.4, 7.3, 7.1, 7.2, 6.8, 6.7, 6.6, 6.7, 6.3, 6.2, 6, 6, 5.9, 5.9, 5.7, 5.6, 5.6, 5.4, 5.4, 5.5, 5.2, 5.1, 5.0, 4.9, 4.8, 4.7, 4.6, 4.6, 4.5),
ASMRM2 = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, rep(NA, 58), 16.6, 15.9, 15.7, 15.7, 15.2, 15.6, 15.7, 15.3, 14.9, 14.5, 14.3, 14.1, 14.0, 13.8, 13.5, 13.3),
ASMRF = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, 18.3, 15.4, 15, 14.6, 13.4, 12.4, 12.6, 11.3, 11, 11.5, 11.8, 10.4, 10.2, 10.4, 10, 10, 9.3, 9.1, 9.3, 8.7, 8.5, 8.4, 8.2, 8.2, 7.6, 7.4, 7.4, 7.2, 6.9, 6.6, 6.2, 6, 5.7, 5.8, 5.6, 5.2, 5.2, 5, 4.8, 4.6, 4.4, 4.5, 4.2, 4.2, 4.1, 4, 4, 3.8, 3.8, 3.6, 3.5, 3.4, 3.4, 3.2, 3.1, 3, 3, 3, 3, 2.9, 2.8, 2.8, 2.7, 2.7, 2.9, 2.7, 2.7, 2.6, 2.5, 2.5, 2.5, 2.5, 2.4, 2.4),
ASMRF2 = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, rep(NA, 58), 8.9, 8.6, 8.5, 8.5, 8.1, 8.3, 8.5, 8.3, 8.1, 7.9, 7.9, 7.7, 7.6, 7.6, 7.5, 7.2),
PNMPLB = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, 46.6, 46.7, 45.6, 46, 45.1, 43.9, 45.5, 45, 43.9, 43, 41.4, 40.9, 38.7, 36.2, 33.1, 30.1, 31.3, 26.3, 24.5, 23, 21.7, 20.4, 19, 18, 16.9, 16, 14.8, 14.1, 13, 12.5, 11.7, 10.8, 10.1, 9.3, 8.7, 8, 7.3, 6.9, 6.5, 6, 5.7, 5.3, 5.2, 5, 5, 4.7, 4.4, 4.2, 4.1, 4, 3.8, 3.6, 3.7, 3.6, 3.3, 3.3, 3.1, 3, 2.9, 2.9, 2.9, 2.8, 2.7, 2.6, 2.5, 2.5, 2.4, 2.4, 2.2, 2.3, 2.1),
MMR = c(409.8, 397.8, 402.6, 392.9, 369.3, 361.7, 387.8, 403.9, 379.4, 388.4, 344.9, 333.0, 325.4, 306.1, 309.7, 328.4, 332.5, 325.8, 326.1, 352.1, 309.2, 329.9, 337.3, 312.4, 316.8, 295.3, 285.4, 256.7, 264.7, 265.8, 267.4, 257.9, 255.4, 240.2, 257.8, 264.7, 247.1, 243.3, 237.5, 240.5, 240.9, 228.6, 207.0, 196.9, 193.6, 160.1, 157.0, 159.2, 161.2, 156.7, 154.7, 163.6, 166.7, 161.7, 153.9, 153.6, 139.2, 131.7, 117.5, 108.2, 100.9, 92.7, 90.1, 80.4, 83.9, 65.5, 63.3, 53.9, 48.7, 42.5, 38.2, 36.3, 32.7, 27.3, 24.5, 21.9, 21.0, 21.8, 19.5, 18.3, 17.5, 14.8, 14.6, 15.1, 12.9, 11.5, 9.2, 10.4, 8.2, 8.6, 8.8, 7.4, 5.9, 6.9, 5.8, 6.3, 6.9, 5.9, 6.3, 6.3, 7.1, 6.0, 4.3, 5.7, 4.8, 3.1, 3.5, 4.8, 4.1, 3.8, 4.0, 3.4, 2.7, 3.8, 3.4, 3.4, 3.3, 3.3, 2.7)
)

Jvital2013byPref <- data.frame(
 PNAME = c("Hokkaido", "Aomori", "Iwate", "Miyagi", "Akita", "Yamagata",
 "Fukushima", "Ibaraki", "Tochigi", "Gunma", "Saitama", "Chiba", "Tokyo",
 "Kanagawa", "Niigata", "Toyama", "Ishikawa", "Fukui", "Yamanashi",
 "Nagano", "Gifu", "Shizuoka", "Aichi", "Mie", "Shiga", "Kyoto", "Osaka",
 "Hyogo", "Nara", "Wakayama", "Tottori", "Shimane", "Okayama", "Hiroshima",
 "Yamaguchi", "Tokushima", "Kagawa", "Ehime", "Kouchi", "Fukuoka", "Saga",
 "Nagasaki", "Kumamoto", "Oita", "Miyazaki", "Kagoshima", "Okinawa"),
 JCODE = c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17,
 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34,
 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47),
 CBR =c(7.1, 6.8, 7.2, 8.2, 5.9, 7.2, 7.5, 7.7, 7.9, 7.6, 8.1, 7.9,
 8.5, 8.3, 7.4, 7.3, 8.2, 8.2, 7.4, 7.8, 7.9, 8.2, 9.2, 8.1, 9.3,
 7.8, 8.3, 8.3, 7.4, 7.3, 8.3, 7.9, 8.5, 8.8, 7.6, 7.4, 8.2, 7.7,
 7.1, 9.1, 8.7, 8.3, 8.9, 8.2, 8.8, 8.7, 12.2),
 CDR =c(11, 12.8, 12.4, 9.6, 14.2, 13.2, 12.2, 10.5, 10.5, 11.1,
 8.4, 8.8, 8.5, 8.1, 12.2, 11.8, 10.6, 11.2, 11.3, 11.6, 10.7,
 10.5, 8.6, 10.9, 8.8, 9.8, 9.4, 9.9, 10.2, 13.1, 12.7, 13.7, 11.1,
 10.5, 13.1, 13.1, 11.8, 12.5, 13.8, 9.8, 11.5, 12.4, 11.3, 11.9,
 11.6, 12.6, 7.8),
 IMR =c(2.2, 1.5, 1.3, 2.6, 1.6, 3.7, 1.6, 2.5, 1.9, 2.4, 2, 2.3,
 2, 2, 2.2, 2.7, 1.6, 1.9, 2.3, 2.2, 2.5, 2.1, 2, 3, 2.8, 2.6, 1.9,
 1.6, 1.9, 2.1, 1.3, 2.3, 2, 1.7, 2, 4.2, 2.4, 2.3, 2.7, 2.2, 3.2,
 2.3, 2.6, 1.9, 2.7, 2.5, 1.7),
 NMR =c(1.1, 0.7, 0.4, 1.4, 0.3, 1.7, 0.6, 1.4, 1, 1, 0.9, 1, 0.9,
 1.1, 1, 1.2, 0.8, 0.9, 1.5, 1, 1.3, 1.1, 0.9, 1.5, 1.5, 1.4, 0.8,
 0.7, 0.9, 0.7, 0.8, 1.1, 0.9, 0.8, 0.7, 2.5, 1, 1.3, 1.3, 0.9, 1.1,
 1.2, 1.1, 1, 0.8, 1, 1.3),
 NIR =c(-3.9, -6, -5.2, -1.4, -8.3, -6, -4.7, -2.8, -2.6, -3.6, -0.4,
 -0.9, 0, 0.2, -4.9, -4.5, -2.4, -2.9, -3.9, -3.8, -2.7, -2.2, 0.6,
 -2.9, 0.6, -2, -1.1, -1.6, -2.8, -5.8, -4.4, -5.8, -2.6, -1.7, -5.5,
 -5.7, -3.5, -4.9, -6.7, -0.7, -2.8, -4.1, -2.4, -3.6, -2.7, -3.9, 4.4),
 SBRPB =c(28.8, 25.5, 27, 22.4, 23.6, 21.2, 25.8, 23.5, 21.6, 22.9,
 23.8, 22.8, 21.7, 21.3, 23.2, 24.1, 17.6, 22.5, 20.4, 22.7, 19.1, 20.9,
 20.8, 20.5, 19.6, 21.4, 22.5, 20.7, 24.4, 23.7, 21.4, 23.1, 22.6, 21.4,
 21.8, 21.4, 19.3, 28, 23, 25.4, 21.1, 28.4, 25.4, 27.7, 29, 28.1, 25.1),
 SARPB =c(10.1, 12, 11.9, 8.6, 11.2, 11.5, 14.9, 10.4, 9.4, 11.5, 11.8,
 11.6, 10.1, 10.5, 9.6, 14.3, 10.1, 11.5, 8.9, 10.1, 8.6, 10.7, 10, 9.7,
 9.9, 9.6, 10.1, 9.7, 11, 9, 10.5, 9.5, 8, 8.9, 11.1, 9.7, 8.6, 10.3,
 11.7, 10, 8.7, 11.9, 9.8, 10.7, 10.1, 10.5, 12.4),
 ACRPB =c(18.7, 13.6, 15.1, 13.9, 12.3, 9.7, 10.9, 13.1, 12.2, 11.4, 12,
 11.3, 11.7, 10.8, 13.6, 9.9, 7.5, 11, 11.5, 12.6, 10.4, 10.2, 10.8, 10.9,
 9.6, 11.8, 12.4, 11, 13.4, 14.7, 10.9, 13.6, 14.7, 12.4, 10.8, 11.7,
 10.7, 17.7, 11.3, 15.4, 12.4, 16.5, 15.6, 17, 18.9, 17.6, 12.7),
 PNMPB =c(3.6, 2.8, 3.9, 3.7, 3.1, 4, 5.3, 4.2, 3.7, 5.5, 3.7, 3.5, 3.6,
 3.8, 3.9, 4.8, 3.6, 4.3, 4.2, 3.6, 3.6, 3.9, 3.9, 4.1, 4.4, 4.7, 3.6,
 3.1, 4.4, 3.4, 2.7, 3.6, 3.4, 3.3, 3, 4.4, 2.2, 4.7, 4.9, 3.4, 3.8, 3.7,
 2.9, 4.4, 3.1, 3.3, 4.5),
 SBRA22W =c(2.7, 2.3, 3.6, 2.6, 2.7, 2.9, 4.9, 3.1, 2.9, 4.7, 3.1, 2.8,
 3, 3, 3, 4.1, 3, 3.5, 3.1, 2.8, 2.7, 2.9, 3.3, 2.8, 3.2, 3.3, 3, 2.7,
 3.8, 2.9, 2.1, 2.9, 2.8, 2.6, 2.3, 2.6, 1.7, 3.6, 4, 2.7, 2.9, 3, 2.3,
 3.6, 2.7, 2.6, 3.8),
 ENMR =c(0.9, 0.5, 0.3, 1.1, 0.3, 1.1, 0.5, 1.1, 0.8, 0.8, 0.6, 0.6, 0.6,
 0.8, 0.8, 0.6, 0.6, 0.8, 1.1, 0.8, 0.9, 1, 0.6, 1.2, 1.2, 1.4, 0.6, 0.4,
 0.6, 0.4, 0.6, 0.7, 0.6, 0.6, 0.7, 1.8, 0.5, 1, 0.9, 0.7, 1, 0.7, 0.6,
 0.7, 0.4, 0.7, 0.6),
 MR =c(4.9, 4.3, 4.2, 5.2, 3.7, 4.2, 4.7, 4.9, 5.2, 4.6, 5.1, 5.1, 6.8,
 5.6, 4.3, 4.4, 4.6, 4.8, 4.7, 4.7, 4.7, 5, 5.8, 4.9, 5.3, 4.9, 5.6, 5.1,
 4.5, 4.7, 4.7, 4.3, 5, 5.2, 4.6, 4.5, 4.9, 4.6, 4.4, 5.6, 4.8, 4.7, 5,
 4.9, 5.1, 4.9, 6.3),
 DR =c(2.09, 1.75, 1.55, 1.8, 1.42, 1.47, 1.67, 1.74, 1.85, 1.8, 1.84,
 1.85, 1.92, 1.85, 1.41, 1.47, 1.58, 1.51, 1.76, 1.63, 1.6, 1.84, 1.79,
 1.82, 1.67, 1.78, 2.08, 1.83, 1.65, 2.01, 1.71, 1.5, 1.79, 1.81, 1.79,
 1.67, 1.81, 1.84, 1.94, 2.04, 1.72, 1.7, 1.86, 1.86, 2.08, 1.87, 2.59),
 TFR =c(1.28, 1.4, 1.46, 1.34, 1.35, 1.47, 1.53, 1.42, 1.43, 1.41, 1.33,
 1.33, 1.13, 1.31, 1.44, 1.43, 1.49, 1.6, 1.44, 1.54, 1.45, 1.53, 1.47,
 1.49, 1.53, 1.26, 1.32, 1.42, 1.31, 1.52, 1.62, 1.65, 1.49, 1.57, 1.56,
 1.43, 1.59, 1.52, 1.47, 1.45, 1.59, 1.64, 1.65, 1.56, 1.72, 1.63, 1.94),
 CSM.ALL = c(1098.2, 1283.7, 1237.9, 958.7, 1415.9, 1323, 1217.7,
 1049.3, 1050, 1110.8, 844.7, 876.7, 851.4, 814.8, 1223.9, 1178.1,
 1062.9, 1117.9, 1129.3, 1160, 1066.3, 1046.7, 856, 1092.7, 875.7,
 983.4, 942, 991.5, 1021, 1310.1, 1266.6, 1373.3, 1108.2, 1045.1,
 1311, 1307.3, 1175.9, 1250.4, 1380.6, 979.9, 1153.1, 1238.3, 1128.7,
 1185.8, 1156.5, 1264.2, 778.7),
 CSM.CANCER = c(341, 369.7, 333, 280.4, 392.8, 353.4, 315.4, 291.1,
 287, 304.2, 253.7, 262.3, 256.9, 251.3, 339.6, 330.2, 297, 296.4,
 298.4, 293.6, 299, 286.6, 253.7, 290.2, 254.4, 296.9, 293.8, 297.1,
 302.9, 353.9, 352.8, 367.6, 290.6, 292.3, 355.6, 324, 312.1, 317.6,
 341.9, 300.9, 329.9, 354.1, 293.9, 307, 315.9, 326.8, 213.3),
 CSM.HD = c(175.5, 198.7, 211.7, 143.7, 207.4, 204.7, 216.2, 164.3,
 170.3, 171.2, 142.8, 158, 128.4, 118.6, 175.4, 155.8, 168.2, 182.8,
 152.6, 180.4, 173.8, 151.2, 114.9, 162.9, 145.5, 160.3, 150.2, 152.2,
 186.1, 236.3, 190.9, 196.6, 170.3, 173.9, 216.1, 196.2, 198.9, 238.6,
 245.3, 113.5, 161.7, 192.9, 182.8, 174, 197.6, 185.8, 107.9),
 CSM.PNEUM = c(106.5, 143.1, 106.6, 76.7, 139.9, 137.1, 111.3, 107.4,
 101.6, 126, 88.4, 84.3, 77.9, 71.4, 109.6, 126.7, 108.8, 123.1, 96.8,
 97.1, 91.8, 84.6, 74.8, 101.2, 81.4, 93.9, 100.5, 92.4, 101.6, 139.1,
 109.2, 133.3, 124.5, 101.5, 158.9, 143.9, 79, 120.5, 160.8, 103.2,
 137.6, 128.3, 112.8, 125.4, 116.8, 140, 70.9),
 CSM.CEVD = c(92, 135.5, 160.9, 106.3, 162.8, 152.1, 136, 112.5, 114.3,
 110.1, 76.7, 78.3, 74.7, 73.4, 143.9, 120.2, 112.7, 104.1, 118.8,
 145.9, 95.9, 111.3, 73.2, 103.1, 75.9, 85.1, 69.5, 86, 86.7, 106.4,
 128, 134.7, 106.1, 92.9, 122.4, 110.1, 100.7, 113.3, 141.5, 80.6,
 105.3, 106.3, 99.8, 116.3, 115.5, 132.6, 60.8),
 CSM.SEN = c(42.9, 66.4, 71.9, 63.3, 85.6, 90.1, 73.6, 61.2, 68, 59.7,
 35.7, 46.3, 45.1, 51.3, 86.8, 69.8, 64.5, 57.3, 91.1, 83.1, 78.9,
 84.7, 49.6, 86.3, 45.8, 50.6, 32.2, 50.5, 50.1, 83.9, 103.3, 105,
 66.7, 60.2, 76.2, 76, 74.2, 82.5, 57.7, 36.3, 51.7, 60.5, 65.1,
 61.2, 49.8, 63.3, 34.3),
 CSM.ACC = c(28.4, 37.4, 40.1, 27, 51.9, 43.7, 40.1, 34.9, 27.7,
 35.6, 20.8, 24.7, 21.3, 28.5, 43.8, 47.8, 35.2, 49.9, 44.6, 40.7,
 37.9, 34.3, 27.1, 38.1, 32, 22.6, 26.3, 33, 23.6, 39.1, 38.7, 44.8,
 39.7, 37.1, 34.7, 44.6, 42.1, 46.6, 56.1, 33.3, 38.6, 42.2, 34.2,
 44.4, 39.3, 45.8, 20.8),
 CSM.SUI = c(21.2, 23.3, 26.4, 19.8, 26.5, 24.6, 21.7, 21.2, 22.6,
 25.2, 20.8, 19.9, 20.2, 17.9, 26.1, 22.6, 17.7, 17.9, 23.4, 20.1,
 19.1, 20.7, 19.1, 19.3, 21, 19.3, 20.8, 20.5, 18.3, 21.3, 21.1,
 25.4, 17.8, 19.8, 20, 22.1, 18.8, 22.6, 21.6, 21.1, 18.1, 20.1,
 20.4, 21.8, 22.9, 21.6, 20.8),
 CSM.KF = c(29.7, 35.6, 26, 19, 28.5, 23.9, 23, 19.5, 19.5, 19.2,
 15.5, 14.1, 14.7, 13.3, 21.1, 19.3, 16.6, 24.4, 20.5, 20.2, 20.6,
 21.2, 16.4, 23.9, 15.3, 21, 21, 20.3, 18.4, 29.4, 26.1, 26, 22.5,
 22.8, 27, 30.8, 25.8, 28.7, 33.3, 19.2, 22.5, 23.7, 24.5, 22.4,
 26.6, 29.1, 14.9),
 CSM.COPD = c(13.2, 13.7, 15.3, 10.5, 13.6, 18.7, 17.9, 13.5, 13.1,
 17.7, 9.3, 9.4, 10.4, 10.6, 13.7, 12.7, 13, 14.2, 16, 15, 13.9,
 13.5, 9.4, 14.8, 12.3, 14.6, 12.9, 14.4, 14.2, 21.5, 15.3, 17.9,
 16, 14.6, 16.5, 23.9, 12.8, 15.1, 14, 13.7, 17.7, 16.2, 16.3, 18.5,
 16.4, 20.5, 15.3),
 CSM.AA = c(14.5, 13.6, 12.2, 14.1, 16.6, 18.9, 16.1, 14, 14.3, 13.7,
 9.4, 10.8, 13, 10.7, 13.2, 16.8, 13, 13.3, 14.6, 15.8, 14.5, 14.4,
 11.9, 15.6, 11.8, 11.5, 8.9, 11.1, 11.9, 14.9, 17.4, 18.1, 12.2, 11.9,
 16.8, 14.8, 11.6, 12.7, 18.2, 13.7, 12.7, 16.5, 17.9, 12.7, 13.8,
 19.2, 11),
 CSM.LIVD = c(11.8, 16.4, 12.1, 9.9, 12.8, 13.2, 14.5, 14.8, 13.8,
 12.5, 11.3, 10.7, 13.7, 12.6, 10, 12.9, 11.5, 10.8, 12.3, 11, 10.5,
 11, 10.5, 10.8, 8.5, 10.3, 15.7, 13.4, 10.1, 16, 11.3, 13.3, 12.8,
 13.1, 14.3, 17.9, 13.1, 14.1, 16, 12.1, 12.7, 13.4, 12.2, 13.2,
 13.5, 14.3, 20.4),
 CSM.DIAB = c(12.5, 16, 13.2, 10.1, 15.2, 11.3, 16.2, 13, 13.6, 12.2,
 9.9, 10, 9.6, 7.1, 13.2, 13.4, 10.5, 12.2, 15.1, 13.3, 8.7, 13.1,
 8.3, 12.6, 7.3, 9.5, 11.1, 11, 9.8, 11.7, 14.6, 12.1, 11.8, 10.4,
 11.6, 17.6, 17.4, 11.9, 15, 11.2, 12.3, 10.8, 10.1, 11.1, 11.5,
 14.6, 13.1),
 CSM.SEP = c(12.5, 8.7, 5.5, 7.5, 10.5, 8.3, 7.8, 10.1, 7.2, 9.6,
 7.9, 7, 7.6, 6.6, 6.4, 11.7, 9.7, 7.4, 8.5, 6.3, 9.1, 8.3, 8.8,
 9.2, 6.2, 8.2, 9.9, 8.9, 8.4, 11.3, 8.5, 9.2, 9.6, 9.3, 12.1, 11.7,
 10.4, 9.4, 17, 10.3, 9.2, 12.2, 10.4, 10.1, 10.8, 13.1, 12.4),
 CSM.MNP = c(10.4, 9.5, 12.2, 9.1, 12.3, 9.2, 9.8, 8.5, 8.6, 10.7,
 8.4, 7.7, 7.8, 7, 9.4, 7.5, 8.6, 8.4, 9.7, 9.7, 9.3, 8.1, 7.7, 9.5,
 7.2, 8.9, 8.1, 8.6, 8.8, 11.4, 9.8, 11.5, 9.8, 8.6, 9.9, 12.7, 7.8,
 11.7, 13.2, 8.1, 9.1, 13, 10.7, 9.6, 9.4, 11.9, 5.3),
 CSM.DEM = c(8.2, 11.7, 8.4, 10.5, 12.6, 14.5, 12.2, 6.9, 10.8, 8.7,
 5.1, 6, 6.8, 6.8, 18.9, 14.5, 10.6, 8, 10, 13.3, 8.8, 11.5, 5.7,
 13.2, 8.4, 7.8, 4.7, 7, 8.2, 6.4, 10.3, 18.2, 6.5, 7.6, 6.8, 9.8,
 6.1, 10.5, 5.7, 6.4, 7.1, 10.9, 9.1, 12.8, 7.4, 5.3, 4.5),
 CSM.TB = c(1.1, 1.8, 1, 0.9, 2.3, 1.6, 1.5, 1.6, 0.7, 1.7, 1.1, 1.4,
 1.9, 1.3, 1.1, 1.5, 1.3, 1.9, 1.4, 1.6, 1.7, 1.8, 1.9, 1.5, 1.3,
 1.5, 2.9, 1.6, 1.3, 2.4, 0.9, 1.9, 1, 1.7, 2.2, 1.7, 1.3, 1.1, 2.3,
 1.3, 2.8, 2.3, 2, 2.2, 1.2, 2.1, 1.9),
 CSM.TA = c(4.7, 5.3, 7.7, 4.1, 6.8, 5, 5.5, 8, 6.3, 5.2, 4, 4.6, 2.1,
 2.8, 5.7, 6.4, 6.7, 9.2, 5.6, 5.3, 6.8, 6.2, 4.1, 6.4, 5.2, 3.9, 3.4,
 4.6, 4.1, 6.8, 7.3, 7.9, 8, 5.8, 6, 8.4, 8.7, 8.1, 8.2, 4, 7.2, 5.2,
 6.1, 7.1, 6.1, 7.8, 4.7)
)

# Years of Life Lost by selected causes for each prefecture in Japan in 2015
# http://www.mhlw.go.jp/toukei/saikin/hw/life/tdfk15/dl/tdfk15-09.xls
PrefYLL2015 <- data.frame(
 PNAME = c("Hokkaido", "Aomori", "Iwate", "Miyagi", "Akita", "Yamagata",
 "Fukushima", "Ibaraki", "Tochigi", "Gunma", "Saitama", "Chiba", "Tokyo",
 "Kanagawa", "Niigata", "Toyama", "Ishikawa", "Fukui", "Yamanashi",
 "Nagano", "Gifu", "Shizuoka", "Aichi", "Mie", "Shiga", "Kyoto", "Osaka",
 "Hyogo", "Nara", "Wakayama", "Tottori", "Shimane", "Okayama", "Hiroshima",
 "Yamaguchi", "Tokushima", "Kagawa", "Ehime", "Kouchi", "Fukuoka", "Saga",
 "Nagasaki", "Kumamoto", "Oita", "Miyazaki", "Kagoshima", "Okinawa"),
 JCODE = 1:47,
 CancerM = c(4.15, 4.07, 3.61, 3.74, 4.03, 3.69, 3.56, 3.73, 3.6, 3.58, 
 3.68, 3.67, 3.8, 3.8, 3.83, 3.68, 3.84, 3.58, 3.47, 3.26, 3.53, 3.58, 
 3.64, 3.5, 3.64, 3.85, 3.96, 3.88, 3.77, 3.75, 4.2, 3.92, 3.58, 3.73, 
 3.7, 3.43, 3.68, 3.67, 3.69, 3.99, 3.91, 3.93, 3.62, 3.52, 3.73, 3.58, 3.5),
 CardioM = c(1.41, 1.47, 1.74, 1.5, 1.29, 1.42, 1.68, 1.43, 1.59, 1.58, 
 1.58, 1.79, 1.41, 1.48, 1.35, 1.18, 1.3, 1.44, 1.28, 1.42, 1.46, 1.33, 
 1.13, 1.41, 1.4, 1.57, 1.54, 1.34, 1.62, 1.58, 1.3, 1.25, 1.41, 1.49, 
 1.52, 1.32, 1.67, 1.77, 1.52, 0.9, 1.09, 1.32, 1.35, 1.34, 1.52, 1.33, 1.46),
 CerebroM = c(0.75, 0.92, 1.11, 0.94, 0.98, 0.88, 0.87, 0.91, 0.95, 0.83, 
 0.76, 0.77, 0.76, 0.78, 0.96, 0.86, 0.81, 0.78, 0.89, 0.92, 0.72, 0.91, 
 0.71, 0.75, 0.62, 0.73, 0.64, 0.75, 0.62, 0.66, 0.86, 0.81, 0.76, 0.69, 
 0.78, 0.74, 0.73, 0.75, 0.81, 0.72, 0.78, 0.7, 0.76, 0.76, 0.87, 0.9, 0.83),
 PneumoniaM = c(0.84, 0.89, 0.74, 0.67, 0.76, 0.76, 0.73, 0.86, 0.79, 0.87, 
 0.96, 0.89, 0.81, 0.76, 0.69, 0.87, 0.86, 0.82, 0.8, 0.61, 0.72, 0.69, 
 0.75, 0.8, 0.74, 0.76, 0.93, 0.76, 0.83, 0.8, 0.72, 0.68, 0.89, 0.82, 0.94, 
 0.93, 0.6, 0.8, 0.91, 0.85, 0.86, 0.84, 0.78, 0.85, 0.89, 0.95, 0.75),
 AccidentM = c(0.48, 0.6, 0.61, 0.46, 0.54, 0.51, 0.52, 0.47, 0.44, 0.45, 
 0.35, 0.4, 0.32, 0.44, 0.55, 0.62, 0.59, 0.61, 0.6, 0.55, 0.54, 0.45, 
 0.45, 0.54, 0.54, 0.37, 0.4, 0.49, 0.42, 0.5, 0.49, 0.51, 0.54, 0.56, 
 0.48, 0.53, 0.6, 0.63, 0.73, 0.49, 0.55, 0.55, 0.5, 0.54, 0.59, 0.64, 0.5),
 TrafficM = c(0.13, 0.15, 0.19, 0.14, 0.11, 0.16, 0.15, 0.21, 0.17, 0.11, 
 0.11, 0.13, 0.07, 0.1, 0.14, 0.15, 0.15, 0.17, 0.18, 0.14, 0.15, 0.14, 
 0.12, 0.19, 0.15, 0.12, 0.11, 0.15, 0.13, 0.17, 0.17, 0.14, 0.17, 0.16, 
 0.14, 0.15, 0.23, 0.18, 0.17, 0.14, 0.18, 0.14, 0.14, 0.14, 0.17, 0.18, 0.15),
 SuicideM = c(0.67, 0.66, 0.77, 0.69, 0.82, 0.74, 0.74, 0.65, 0.67, 0.71, 
 0.6, 0.64, 0.56, 0.54, 0.74, 0.76, 0.65, 0.62, 0.64, 0.74, 0.66, 0.67, 0.55, 
 0.64, 0.62, 0.57, 0.61, 0.6, 0.57, 0.69, 0.64, 0.72, 0.62, 0.59, 0.61, 0.61, 
 0.63, 0.67, 0.6, 0.65, 0.62, 0.64, 0.66, 0.6, 0.73, 0.63, 0.7),
 KidneyM = c(0.2, 0.18, 0.14, 0.13, 0.14, 0.17, 0.14, 0.15, 0.16, 0.14, 
 0.15, 0.13, 0.13, 0.12, 0.1, 0.13, 0.11, 0.16, 0.16, 0.12, 0.15, 0.16, 
 0.14, 0.16, 0.15, 0.15, 0.16, 0.15, 0.12, 0.15, 0.15, 0.14, 0.14, 0.15, 
 0.15, 0.16, 0.14, 0.16, 0.18, 0.13, 0.14, 0.15, 0.15, 0.15, 0.16, 0.17, 0.15),
 LiverM = c(0.18, 0.23, 0.2, 0.19, 0.2, 0.15, 0.19, 0.19, 0.18, 0.18, 0.16, 
 0.17, 0.27, 0.25, 0.17, 0.17, 0.17, 0.18, 0.21, 0.2, 0.16, 0.18, 0.16, 0.15, 
 0.16, 0.18, 0.28, 0.22, 0.2, 0.22, 0.21, 0.19, 0.18, 0.2, 0.19, 0.22, 0.19, 
 0.22, 0.24, 0.21, 0.19, 0.2, 0.19, 0.21, 0.23, 0.24, 0.4),
 DiabetesM = c(0.12, 0.16, 0.11, 0.1, 0.11, 0.08, 0.13, 0.12, 0.12, 0.13, 
 0.12, 0.11, 0.12, 0.08, 0.09, 0.12, 0.09, 0.13, 0.15, 0.11, 0.08, 0.13, 
 0.09, 0.11, 0.08, 0.09, 0.12, 0.11, 0.08, 0.09, 0.15, 0.08, 0.11, 0.11, 
 0.1, 0.13, 0.13, 0.09, 0.1, 0.14, 0.12, 0.08, 0.11, 0.12, 0.11, 0.13, 0.16),
 HypertensM = c(0.03, 0.02, 0.03, 0.04, 0.03, 0.02, 0.03, 0.02, 0.02, 0.05, 
 0.03, 0.05, 0.04, 0.02, 0.03, 0.04, 0.03, 0.03, 0.02, 0.03, 0.02, 0.03, 
 0.03, 0.03, 0.02, 0.02, 0.08, 0.03, 0.04, 0.02, 0.02, 0.03, 0.02, 0.03, 
 0.02, 0.04, 0.03, 0.03, 0.03, 0.06, 0.06, 0.03, 0.03, 0.03, 0.03, 0.03, 0.06),
 TBM = c(0.01, 0.01, 0.01, 0.01, 0, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.02, 
 0.02, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.02, 0.01, 0.01, 
 0.02, 0.03, 0.02, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.02, 0.01, 0.01, 
 0.01, 0.01, 0.01, 0.01, 0.02, 0.01, 0.01, 0.01, 0.02),
 CancerF = c(3.31, 3.15, 2.89, 2.8, 2.99, 2.79, 2.84, 2.88, 2.82, 2.76, 2.87, 
 2.82, 3.02, 2.99, 2.81, 2.85, 2.9, 2.84, 2.8, 2.73, 2.81, 2.75, 2.87, 2.57, 
 2.81, 2.96, 3.02, 2.89, 2.82, 2.75, 3, 2.87, 2.64, 2.8, 2.85, 2.62, 2.58, 
 2.7, 2.88, 3.18, 3.09, 3.05, 2.8, 2.76, 2.75, 2.83, 2.91),
 CardioF = c(1.45, 1.35, 1.52, 1.31, 1.21, 1.27, 1.5, 1.41, 1.47, 1.4, 1.53, 
 1.6, 1.34, 1.31, 1.22, 1.18, 1.36, 1.32, 1.16, 1.23, 1.39, 1.25, 1.21, 1.28, 
 1.44, 1.53, 1.47, 1.34, 1.68, 1.57, 1.25, 1.23, 1.35, 1.47, 1.5, 1.34, 1.56, 
 1.7, 1.56, 1.03, 1.2, 1.36, 1.35, 1.26, 1.55, 1.3, 1.34),
 CerebroF = c(0.73, 0.91, 1.09, 0.9, 0.97, 0.96, 0.93, 0.87, 0.97, 0.82, 0.75, 
 0.77, 0.71, 0.73, 0.93, 0.83, 0.8, 0.71, 0.86, 0.95, 0.78, 0.87, 0.71, 0.78, 
 0.66, 0.69, 0.6, 0.69, 0.65, 0.68, 0.86, 0.82, 0.74, 0.71, 0.78, 0.71, 0.7, 
 0.75, 0.77, 0.66, 0.76, 0.69, 0.74, 0.74, 0.87, 0.95, 0.72),
 PneumoniaF = c(0.64, 0.69, 0.54, 0.48, 0.54, 0.52, 0.54, 0.72, 0.64, 0.71, 
 0.76, 0.71, 0.61, 0.58, 0.5, 0.64, 0.62, 0.62, 0.52, 0.47, 0.57, 0.5, 0.56, 
 0.57, 0.55, 0.61, 0.79, 0.6, 0.65, 0.64, 0.55, 0.47, 0.72, 0.62, 0.8, 0.76, 
 0.52, 0.6, 0.78, 0.72, 0.77, 0.67, 0.6, 0.71, 0.72, 0.8, 0.57),
 AccidentF = c(0.27, 0.34, 0.34, 0.25, 0.36, 0.29, 0.3, 0.3, 0.24, 0.28, 0.21, 
 0.23, 0.2, 0.32, 0.36, 0.4, 0.37, 0.39, 0.33, 0.31, 0.35, 0.29, 0.28, 0.3, 
 0.34, 0.18, 0.27, 0.28, 0.24, 0.27, 0.32, 0.28, 0.29, 0.33, 0.27, 0.36, 0.33, 
 0.34, 0.38, 0.32, 0.29, 0.33, 0.28, 0.36, 0.29, 0.34, 0.22),
 TrafficF = c(0.05, 0.07, 0.1, 0.03, 0.06, 0.05, 0.07, 0.08, 0.07, 0.06, 0.04, 
 0.05, 0.02, 0.04, 0.06, 0.07, 0.07, 0.06, 0.05, 0.06, 0.07, 0.05, 0.05, 0.06, 
 0.07, 0.04, 0.03, 0.04, 0.05, 0.08, 0.09, 0.04, 0.06, 0.06, 0.08, 0.05, 0.1, 
 0.07, 0.06, 0.04, 0.06, 0.05, 0.06, 0.06, 0.04, 0.06, 0.04),
 SuicideF = c(0.29, 0.26, 0.34, 0.29, 0.34, 0.28, 0.29, 0.29, 0.28, 0.34, 0.29, 
 0.31, 0.31, 0.29, 0.32, 0.3, 0.21, 0.19, 0.27, 0.31, 0.29, 0.26, 0.26, 0.27, 
 0.29, 0.28, 0.31, 0.31, 0.27, 0.26, 0.26, 0.3, 0.24, 0.28, 0.29, 0.35, 0.3, 
 0.31, 0.29, 0.26, 0.18, 0.22, 0.27, 0.29, 0.28, 0.26, 0.29),
 KidneyF = c(0.19, 0.18, 0.15, 0.13, 0.14, 0.15, 0.14, 0.14, 0.15, 0.13, 
 0.14, 0.12, 0.12, 0.11, 0.12, 0.12, 0.12, 0.17, 0.15, 0.12, 0.14, 0.15, 
 0.13, 0.16, 0.15, 0.15, 0.17, 0.16, 0.14, 0.17, 0.18, 0.13, 0.15, 0.16, 
 0.15, 0.19, 0.17, 0.15, 0.18, 0.15, 0.13, 0.15, 0.17, 0.17, 0.15, 0.19, 0.16),
 LiverF = c(0.12, 0.11, 0.09, 0.1, 0.08, 0.1, 0.1, 0.11, 0.11, 0.12, 0.11, 
 0.09, 0.11, 0.1, 0.07, 0.08, 0.1, 0.09, 0.1, 0.09, 0.09, 0.09, 0.1, 0.09, 
 0.09, 0.09, 0.14, 0.11, 0.1, 0.11, 0.07, 0.1, 0.1, 0.11, 0.11, 0.13, 0.11, 
 0.1, 0.1, 0.11, 0.11, 0.09, 0.1, 0.09, 0.1, 0.09, 0.21),
 DiabetesF = c(0.1, 0.12, 0.09, 0.08, 0.1, 0.06, 0.1, 0.1, 0.1, 0.09, 0.09, 
 0.08, 0.08, 0.07, 0.08, 0.08, 0.07, 0.08, 0.1, 0.09, 0.07, 0.1, 0.07, 0.08, 
 0.08, 0.08, 0.08, 0.09, 0.08, 0.07, 0.09, 0.06, 0.07, 0.1, 0.07, 0.09, 0.09, 
 0.09, 0.08, 0.09, 0.09, 0.07, 0.07, 0.08, 0.08, 0.1, 0.13),
 HypertensF = c(0.04, 0.03, 0.04, 0.05, 0.04, 0.03, 0.05, 0.04, 0.04, 0.04, 
 0.03, 0.05, 0.04, 0.03, 0.04, 0.05, 0.04, 0.04, 0.04, 0.04, 0.03, 0.05, 0.03, 
 0.05, 0.03, 0.03, 0.07, 0.04, 0.05, 0.03, 0.03, 0.05, 0.03, 0.04, 0.04, 0.04, 
 0.05, 0.03, 0.04, 0.07, 0.07, 0.05, 0.04, 0.05, 0.04, 0.04, 0.05),
 TBF = c(0.01, 0.01, 0.01, 0.01, 0, 0.01, 0, 0.01, 0.01, 0.01, 0.01, 0.01, 
 0.01, 0.01, 0.01, 0.01, 0, 0, 0.01, 0, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 
 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0, 0.01, 0.01, 
 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01)
)

# Years of Life Lost by selected causes for each prefecture in Japan in 2010
# https://www.mhlw.go.jp/toukei/saikin/hw/life/tdfk10/dl/zuhyou.xls
PrefYLL2010 <- data.frame(
 PNAME = c("Hokkaido", "Aomori", "Iwate", "Miyagi", "Akita", "Yamagata",
 "Fukushima", "Ibaraki", "Tochigi", "Gunma", "Saitama", "Chiba", "Tokyo",
 "Kanagawa", "Niigata", "Toyama", "Ishikawa", "Fukui", "Yamanashi",
 "Nagano", "Gifu", "Shizuoka", "Aichi", "Mie", "Shiga", "Kyoto", "Osaka",
 "Hyogo", "Nara", "Wakayama", "Tottori", "Shimane", "Okayama", "Hiroshima",
 "Yamaguchi", "Tokushima", "Kagawa", "Ehime", "Kouchi", "Fukuoka", "Saga",
 "Nagasaki", "Kumamoto", "Oita", "Miyazaki", "Kagoshima", "Okinawa"),
 JCODE = 1:47,
 CancerM = c(4.3, 4.01, 3.84, 3.76, 4.04, 3.76, 3.7, 3.67, 3.6, 3.73, 3.78, 
 3.64, 3.93, 3.88, 4.02, 3.79, 3.87, 3.65, 3.67, 3.38, 3.62, 3.73, 3.79, 
 3.59, 3.86, 3.99, 4.03, 4.06, 3.99, 3.97, 4.16, 3.84, 3.67, 3.88, 3.74, 
 3.78, 3.77, 3.93, 3.89, 4.18, 4.04, 3.9, 3.75, 3.81, 3.69, 3.71, 3.57),
 CardioM = c(1.56, 1.73, 1.69, 1.44, 1.48, 1.33, 1.73, 1.43, 1.64, 1.41, 
 1.68, 1.73, 1.48, 1.46, 1.41, 1.2, 1.44, 1.41, 1.44, 1.31, 1.54, 1.4, 
 1.29, 1.51, 1.37, 1.61, 1.57, 1.42, 1.69, 1.51, 1.4, 1.56, 1.36, 1.66, 
 1.6, 1.37, 1.74, 1.91, 1.58, 1.01, 1.27, 1.35, 1.31, 1.32, 1.53, 1.44, 1.54),
 CerebroM = c(0.91, 1.1, 1.33, 1.2, 1.16, 1.04, 1.07, 1.08, 1.15, 0.97, 
 0.97, 0.92, 0.95, 0.92, 1.09, 1.05, 0.94, 0.83, 0.95, 1.17, 0.83, 1.05, 
 0.88, 0.86, 0.86, 0.79, 0.79, 0.83, 0.74, 0.78, 0.94, 0.91, 0.96, 0.87, 
 0.95, 0.84, 0.75, 0.88, 1.09, 0.81, 0.81, 0.89, 0.92, 0.96, 1.01, 1.13, 1.02), 
 Top3M = c(8.34, 8.53, 8.68, 7.89, 8.34, 7.54, 8.06, 7.6, 7.94, 7.37, 
 7.95, 7.71, 7.76, 7.56, 8.05, 7.38, 7.69, 7.11, 7.32, 7.23, 7.22, 7.52, 
 7.23, 7.2, 7.38, 7.74, 7.78, 7.66, 7.89, 7.53, 8.03, 7.7, 7.18, 7.82, 
 7.68, 7.17, 7.66, 8.24, 8.07, 7.09, 7.45, 7.4, 7.15, 7.42, 7.65, 7.68, 7.32),
 PneumoniaM = c(0.89, 0.92, 0.87, 0.78, 0.95, 0.85, 0.8, 0.87, 0.86, 
 0.99, 0.94, 0.92, 0.83, 0.87, 0.8, 0.84, 0.92, 0.99, 0.77, 0.71, 0.87, 
 0.8, 0.8, 0.88, 0.88, 0.88, 1, 0.83, 0.86, 0.9, 0.75, 0.76, 0.98, 0.89, 
 0.96, 0.91, 0.71, 0.91, 0.97, 0.96, 0.99, 0.9, 0.88, 0.89, 0.9, 1.02, 0.88),
 AccidentM = c(0.61, 0.71, 0.64, 0.56, 0.69, 0.49, 0.66, 0.66, 0.59, 
 0.5, 0.45, 0.52, 0.39, 0.48, 0.68, 0.76, 0.62, 0.69, 0.56, 0.69, 0.75, 
 0.56, 0.57, 0.68, 0.54, 0.42, 0.47, 0.57, 0.5, 0.57, 0.61, 0.49, 0.63, 
 0.66, 0.53, 0.64, 0.59, 0.65, 0.82, 0.58, 0.7, 0.72, 0.54, 0.64, 0.67, 
 0.71, 0.58),
 TrafficM = c(0.18, 0.13, 0.21, 0.16, 0.19, 0.14, 0.19, 0.27, 0.26, 
 0.16, 0.14, 0.16, 0.08, 0.12, 0.23, 0.21, 0.17, 0.2, 0.2, 0.25, 0.23, 
 0.16, 0.17, 0.22, 0.18, 0.17, 0.14, 0.19, 0.16, 0.19, 0.2, 0.13, 0.23, 
 0.24, 0.22, 0.16, 0.26, 0.14, 0.25, 0.17, 0.22, 0.23, 0.18, 0.2, 0.18, 
 0.21, 0.18),
 SuicideM = c(0.87, 0.91, 1.03, 0.8, 0.94, 0.86, 0.86, 0.81, 0.78, 0.87, 
 0.76, 0.71, 0.68, 0.68, 0.97, 0.78, 0.78, 0.84, 0.98, 0.84, 0.7, 0.8, 
 0.67, 0.63, 0.75, 0.8, 0.75, 0.77, 0.68, 0.79, 0.86, 1, 0.8, 0.76, 0.8, 
 0.62, 0.81, 0.72, 0.84, 0.81, 0.91, 0.91, 0.84, 0.83, 0.89, 0.76, 0.94), 
 KidneyM = c(0.2, 0.19, 0.14, 0.13, 0.16, 0.14, 0.15, 0.15, 0.15, 0.12, 
 0.15, 0.14, 0.13, 0.11, 0.12, 0.14, 0.11, 0.17, 0.16, 0.13, 0.16, 
 0.18, 0.15, 0.16, 0.16, 0.15, 0.15, 0.14, 0.13, 0.15, 0.13, 0.16, 
 0.13, 0.15, 0.14, 0.21, 0.17, 0.18, 0.17, 0.13, 0.09, 0.13, 0.14, 
 0.17, 0.15, 0.17, 0.13), 
 LiverM = c(0.16, 0.23, 0.17, 0.21, 0.22, 0.19, 0.18, 0.18, 0.22, 
 0.19, 0.18, 0.19, 0.31, 0.29, 0.19, 0.25, 0.19, 0.16, 0.25, 0.18, 
 0.19, 0.16, 0.18, 0.17, 0.19, 0.19, 0.31, 0.25, 0.14, 0.18, 0.25, 
 0.21, 0.25, 0.21, 0.23, 0.29, 0.24, 0.24, 0.23, 0.24, 0.23, 0.27, 
 0.19, 0.16, 0.26, 0.22, 0.39), 
 DiabetesM = c(0.12, 0.14, 0.15, 0.14, 0.13, 0.09, 0.13, 0.16, 0.13, 
 0.15, 0.12, 0.14, 0.13, 0.09, 0.14, 0.14, 0.1, 0.11, 0.16, 0.14, 
 0.09, 0.13, 0.1, 0.12, 0.07, 0.11, 0.14, 0.12, 0.08, 0.09, 0.16, 
 0.1, 0.14, 0.09, 0.1, 0.15, 0.17, 0.13, 0.11, 0.15, 0.15, 0.13, 0.13, 
 0.15, 0.1, 0.13, 0.15), 
 HypertensM = c(0.02, 0.04, 0.03, 0.04, 0.02, 0.02, 0.03, 0.02, 0.02, 
 0.07, 0.03, 0.05, 0.04, 0.02, 0.03, 0.03, 0.02, 0.04, 0.02, 0.03, 0.02, 
 0.04, 0.03, 0.03, 0.02, 0.02, 0.09, 0.04, 0.02, 0.02, 0.03, 0.02, 0.02, 
 0.02, 0.02, 0.03, 0.03, 0.04, 0.02, 0.06, 0.04, 0.03, 0.03, 0.04, 0.04, 
 0.02, 0.05), 
 TBM = c(0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.02, 0.01, 0.01, 0.02, 
 0.02, 0.03, 0.03, 0.01, 0.01, 0.01, 0.02, 0.02, 0.01, 0.01, 0.01, 0.03, 
 0.01, 0.02, 0.01, 0.03, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.02, 0.02, 
 0.01, 0.01, 0.02, 0.01, 0.02, 0.04, 0.03, 0.02, 0.01, 0.01, 0.02, 0.02), 
 CancerF = c(3.27, 3.21, 2.9, 2.87, 2.96, 2.79, 2.78, 2.84, 2.85, 2.85, 
 2.89, 2.89, 3.03, 3.01, 2.86, 2.92, 2.88, 2.94, 2.61, 2.66, 2.76, 2.82, 
 2.91, 2.63, 2.77, 3.15, 3.16, 2.95, 3.02, 2.99, 3.18, 2.88, 2.81, 2.91, 
 2.95, 2.83, 2.87, 2.86, 2.73, 3.17, 3.13, 3.15, 2.91, 2.74, 2.92, 2.96, 
 2.95), 
 CardioF = c(1.67, 1.56, 1.62, 1.32, 1.52, 1.47, 1.72, 1.46, 1.64, 1.44, 
 1.78, 1.72, 1.51, 1.43, 1.33, 1.35, 1.56, 1.61, 1.63, 1.28, 1.55, 1.41, 
 1.5, 1.41, 1.57, 1.68, 1.67, 1.5, 1.98, 1.7, 1.45, 1.62, 1.47, 1.62, 1.62, 
 1.44, 1.64, 1.94, 1.64, 1.23, 1.43, 1.59, 1.46, 1.51, 1.64, 1.48, 1.45), 
 CerebroF = c(0.92, 1.11, 1.27, 1.2, 1.11, 1.13, 1.15, 1.11, 1.16, 1.03, 
 0.99, 0.94, 0.92, 0.97, 1.21, 1.05, 0.94, 0.93, 0.92, 1.26, 0.99, 1.04, 
 0.91, 0.94, 0.85, 0.85, 0.74, 0.8, 0.77, 0.8, 1.07, 0.98, 0.93, 0.83, 0.97, 
 0.88, 0.77, 0.87, 1.02, 0.87, 0.87, 0.84, 0.93, 0.97, 1.05, 1.15, 0.85), 
 Top3F = c(7.14, 7.01, 6.96, 6.49, 6.83, 6.46, 6.86, 6.47, 6.81, 6.38, 6.86, 
 6.66, 6.52, 6.45, 6.54, 6.37, 6.4, 6.55, 6.13, 6.28, 6.33, 6.22, 6.31, 
 5.85, 6.24, 6.86, 6.66, 6.24, 7.05, 6.42, 6.87, 6.52, 6.16, 6.36, 6.65, 
 6.06, 6.3, 6.75, 6.56, 6.27, 6.4, 6.64, 6.25, 6.35, 6.83, 6.72, 6.06), 
 PneumoniaF = c(0.71, 0.73, 0.74, 0.61, 0.79, 0.72, 0.68, 0.8, 0.86, 0.88, 
 0.84, 0.82, 0.71, 0.74, 0.6, 0.81, 0.77, 0.76, 0.64, 0.57, 0.66, 0.64, 
 0.68, 0.67, 0.66, 0.7, 0.94, 0.74, 0.84, 0.73, 0.49, 0.64, 0.78, 0.74, 
 0.91, 0.79, 0.65, 0.71, 0.85, 0.83, 0.92, 0.82, 0.76, 0.78, 0.82, 0.88, 0.76),
 AccidentF = c(0.34, 0.36, 0.4, 0.37, 0.34, 0.37, 0.4, 0.35, 0.27, 0.39, 
 0.28, 0.32, 0.26, 0.32, 0.42, 0.43, 0.54, 0.45, 0.3, 0.34, 0.42, 0.31, 0.33, 
 0.4, 0.34, 0.24, 0.3, 0.37, 0.26, 0.33, 0.37, 0.31, 0.42, 0.4, 0.29, 0.34, 
 0.46, 0.4, 0.45, 0.35, 0.38, 0.35, 0.31, 0.42, 0.34, 0.42, 0.26), 
 TrafficF = c(0.07, 0.08, 0.07, 0.07, 0.05, 0.08, 0.08, 0.14, 0.07, 0.1, 
 0.05, 0.08, 0.03, 0.04, 0.1, 0.08, 0.14, 0.11, 0.06, 0.05, 0.11, 0.06, 
 0.08, 0.12, 0.11, 0.07, 0.05, 0.07, 0.04, 0.08, 0.07, 0.08, 0.09, 0.11, 
 0.1, 0.08, 0.11, 0.1, 0.12, 0.08, 0.11, 0.08, 0.07, 0.09, 0.09, 0.12, 0.08),
 SuicideF = c(0.37, 0.34, 0.46, 0.3, 0.38, 0.4, 0.32, 0.38, 0.33, 0.36, 
 0.35, 0.33, 0.38, 0.35, 0.37, 0.37, 0.32, 0.25, 0.4, 0.34, 0.31, 0.3, 
 0.29, 0.28, 0.36, 0.32, 0.4, 0.36, 0.28, 0.34, 0.39, 0.34, 0.3, 0.31, 
 0.38, 0.33, 0.34, 0.32, 0.33, 0.32, 0.29, 0.32, 0.35, 0.3, 0.32, 0.28, 0.43),
 KidneyF = c(0.23, 0.19, 0.18, 0.17, 0.21, 0.16, 0.14, 0.17, 0.13, 0.17, 
 0.18, 0.15, 0.15, 0.13, 0.12, 0.17, 0.18, 0.16, 0.19, 0.12, 0.16, 0.15, 
 0.14, 0.14, 0.21, 0.2, 0.2, 0.18, 0.12, 0.17, 0.16, 0.12, 0.17, 0.19, 0.21, 
 0.19, 0.2, 0.16, 0.2, 0.18, 0.14, 0.17, 0.18, 0.19, 0.17, 0.2, 0.17), 
 LiverF = c(0.12, 0.12, 0.09, 0.1, 0.08, 0.06, 0.1, 0.12, 0.13, 0.12, 0.14, 
 0.1, 0.12, 0.13, 0.09, 0.11, 0.08, 0.07, 0.18, 0.1, 0.14, 0.08, 0.1, 0.08, 
 0.12, 0.08, 0.14, 0.13, 0.13, 0.1, 0.06, 0.08, 0.1, 0.12, 0.1, 0.17, 0.11, 
 0.1, 0.08, 0.1, 0.12, 0.08, 0.13, 0.09, 0.1, 0.12, 0.18),
 DiabetesF = c(0.14, 0.12, 0.13, 0.1, 0.08, 0.09, 0.12, 0.13, 0.11, 0.1, 
 0.11, 0.1, 0.1, 0.09, 0.09, 0.12, 0.11, 0.11, 0.11, 0.09, 0.09, 0.13, 0.09, 
 0.1, 0.1, 0.09, 0.11, 0.11, 0.08, 0.1, 0.12, 0.1, 0.09, 0.11, 0.13, 0.16, 
 0.14, 0.09, 0.11, 0.1, 0.07, 0.08, 0.08, 0.08, 0.11, 0.11, 0.14), 
 HypertensF = c(0.05, 0.05, 0.05, 0.04, 0.03, 0.03, 0.05, 0.04, 0.05, 0.08, 
 0.04, 0.06, 0.05, 0.03, 0.06, 0.06, 0.03, 0.04, 0.06, 0.05, 0.03, 0.05, 
 0.04, 0.05, 0.05, 0.04, 0.09, 0.05, 0.06, 0.04, 0.04, 0.04, 0.04, 0.04, 
 0.04, 0.06, 0.03, 0.04, 0.04, 0.08, 0.07, 0.06, 0.05, 0.06, 0.05, 0.04, 0.06),
 TBF = c(0.01, 0.01, 0.01, 0.01, 0.01, 0, 0.01, 0.02, 0, 0.01, 0.01, 0.01, 
 0.01, 0.01, 0, 0.01, 0.01, 0.01, 0.02, 0.01, 0.02, 0.01, 0.02, 0.01, 0.01, 
 0.01, 0.01, 0.01, 0, 0.02, 0, 0, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.02, 
 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.02)
)

# Years of Life Lost by selected causes for each prefecture in Japan in 2020
# https://www.mhlw.go.jp/toukei/saikin/hw/life/tdfk20/dl/tdfk20-08.xls
PrefYLL2020 <- data.frame(
 PNAME = c("Hokkaido", "Aomori", "Iwate", "Miyagi", "Akita", "Yamagata",
 "Fukushima", "Ibaraki", "Tochigi", "Gunma", "Saitama", "Chiba", "Tokyo",
 "Kanagawa", "Niigata", "Toyama", "Ishikawa", "Fukui", "Yamanashi",
 "Nagano", "Gifu", "Shizuoka", "Aichi", "Mie", "Shiga", "Kyoto", "Osaka",
 "Hyogo", "Nara", "Wakayama", "Tottori", "Shimane", "Okayama", "Hiroshima",
 "Yamaguchi", "Tokushima", "Kagawa", "Ehime", "Kouchi", "Fukuoka", "Saga",
 "Nagasaki", "Kumamoto", "Oita", "Miyazaki", "Kagoshima", "Okinawa"), 
 JCODE = 1:47, 
 CancerM = c(3.94, 3.85, 3.49, 3.55, 3.76, 3.46, 3.51, 3.48, 3.39, 3.24, 
 3.41, 3.45, 3.48, 3.51, 3.58, 3.4, 3.51, 3.32, 3.27, 3.14, 3.33, 3.32, 
 3.4, 3.3, 3.46, 3.56, 3.63, 3.62, 3.48, 3.64, 3.74, 3.64, 3.38, 3.48, 
 3.5, 3.32, 3.35, 3.39, 3.64, 3.73, 3.71, 3.68, 3.41, 3.35, 3.53, 3.46, 3.45),
 CardioM = c(1.35, 1.51, 1.63, 1.46, 1.13, 1.56, 1.54, 1.44, 1.62, 1.48, 
 1.54, 1.57, 1.46, 1.59, 1.24, 1.09, 1.3, 1.47, 1.26, 1.34, 1.31, 1.35, 
 1.05, 1.37, 1.35, 1.6, 1.65, 1.42, 1.54, 1.67, 1.06, 1.2, 1.39, 1.54, 
 1.56, 1.39, 1.58, 1.78, 1.37, 0.99, 1.18, 1.3, 1.36, 1.35, 1.48, 1.39, 1.48),
 CerebroM = c(0.7, 0.84, 1.05, 0.9, 0.95, 0.81, 0.81, 0.88, 0.9, 0.74, 0.65, 
 0.71, 0.7, 0.66, 0.85, 0.79, 0.72, 0.67, 0.77, 0.79, 0.63, 0.86, 0.62, 
 0.72, 0.61, 0.66, 0.59, 0.67, 0.55, 0.58, 0.72, 0.67, 0.67, 0.65, 0.73, 
 0.63, 0.68, 0.72, 0.71, 0.62, 0.66, 0.66, 0.67, 0.75, 0.77, 0.73, 0.83),
 Top3M = c(7.07, 7.45, 7.5, 7.05, 6.89, 6.95, 6.96, 6.87, 7.1, 6.47, 6.58, 
 6.72, 6.64, 6.7, 6.71, 6.18, 6.55, 6.47, 6.24, 6.2, 6.18, 6.49, 5.82, 6.3, 
 6.33, 6.86, 6.9, 6.7, 6.52, 6.95, 6.49, 6.48, 6.36, 6.69, 6.91, 6.25, 6.57, 
 7.05, 6.75, 6.18, 6.47, 6.61, 6.32, 6.38, 6.85, 6.53, 6.64), 
 PneumoniaM = c(0.5, 0.56, 0.44, 0.38, 0.49, 0.44, 0.47, 0.57, 0.51, 0.56, 
 0.61, 0.56, 0.49, 0.45, 0.37, 0.5, 0.5, 0.54, 0.5, 0.38, 0.47, 0.41, 0.46, 
 0.47, 0.4, 0.43, 0.6, 0.46, 0.56, 0.53, 0.42, 0.35, 0.55, 0.49, 0.62, 0.64, 
 0.36, 0.51, 0.54, 0.52, 0.53, 0.55, 0.47, 0.47, 0.55, 0.6, 0.39), 
 AccidentM = c(0.45, 0.54, 0.46, 0.4, 0.45, 0.38, 0.51, 0.4, 0.39, 0.37, 
 0.29, 0.34, 0.3, 0.38, 0.41, 0.5, 0.45, 0.48, 0.5, 0.45, 0.49, 0.39, 0.36, 
 0.39, 0.46, 0.33, 0.37, 0.41, 0.37, 0.51, 0.44, 0.35, 0.45, 0.44, 0.38, 
 0.55, 0.48, 0.49, 0.6, 0.42, 0.43, 0.43, 0.48, 0.49, 0.46, 0.54, 0.4), 
 TrafficM = c(0.11, 0.1, 0.09, 0.1, 0.07, 0.07, 0.09, 0.11, 0.13, 0.08, 
 0.08, 0.09, 0.05, 0.07, 0.09, 0.08, 0.1, 0.09, 0.11, 0.09, 0.08, 0.09, 
 0.08, 0.13, 0.13, 0.11, 0.08, 0.09, 0.11, 0.11, 0.1, 0.08, 0.12, 0.12, 
 0.1, 0.13, 0.16, 0.12, 0.14, 0.1, 0.1, 0.1, 0.11, 0.11, 0.1, 0.11, 0.1), 
 SuicideM = c(0.63, 0.68, 0.66, 0.66, 0.58, 0.72, 0.68, 0.64, 0.6, 0.68, 
 0.52, 0.56, 0.5, 0.52, 0.66, 0.66, 0.53, 0.59, 0.6, 0.69, 0.58, 0.61, 
 0.54, 0.55, 0.6, 0.5, 0.56, 0.59, 0.6, 0.63, 0.61, 0.65, 0.62, 0.57, 0.64, 
 0.59, 0.6, 0.64, 0.69, 0.58, 0.64, 0.52, 0.61, 0.67, 0.67, 0.68, 0.53), 
 KidneyM = c(0.2, 0.19, 0.18, 0.14, 0.18, 0.18, 0.16, 0.14, 0.15, 0.16, 
 0.16, 0.15, 0.15, 0.13, 0.14, 0.14, 0.13, 0.14, 0.18, 0.13, 0.15, 0.16, 
 0.13, 0.17, 0.17, 0.15, 0.17, 0.16, 0.13, 0.16, 0.17, 0.16, 0.14, 0.16, 
 0.16, 0.18, 0.15, 0.16, 0.19, 0.15, 0.15, 0.15, 0.17, 0.17, 0.15, 0.19, 0.17),
 LiverM = c(0.22, 0.27, 0.24, 0.2, 0.21, 0.18, 0.24, 0.22, 0.23, 0.18, 0.2, 
 0.2, 0.29, 0.31, 0.19, 0.19, 0.2, 0.14, 0.24, 0.18, 0.16, 0.19, 0.18, 0.18, 
 0.18, 0.22, 0.31, 0.27, 0.21, 0.25, 0.21, 0.22, 0.22, 0.24, 0.22, 0.25, 
 0.23, 0.26, 0.26, 0.24, 0.22, 0.22, 0.25, 0.22, 0.26, 0.24, 0.56), 
 DiabetesM = c(0.13, 0.14, 0.12, 0.11, 0.14, 0.07, 0.14, 0.13, 0.13, 0.13, 
 0.11, 0.14, 0.12, 0.08, 0.11, 0.13, 0.1, 0.13, 0.14, 0.11, 0.09, 0.12, 
 0.07, 0.11, 0.09, 0.09, 0.12, 0.12, 0.11, 0.08, 0.11, 0.1, 0.1, 0.11, 
 0.1, 0.14, 0.16, 0.13, 0.09, 0.13, 0.12, 0.1, 0.11, 0.1, 0.16, 0.14, 0.16), 
 HypertensM = c(0.07, 0.04, 0.05, 0.05, 0.06, 0.03, 0.04, 0.04, 0.03, 0.19, 
 0.05, 0.15, 0.03, 0.02, 0.06, 0.05, 0.06, 0.02, 0.04, 0.04, 0.02, 0.04, 
 0.02, 0.04, 0.03, 0.03, 0.1, 0.04, 0.08, 0.03, 0.03, 0.03, 0.02, 0.04, 0.07, 
 0.05, 0.07, 0.05, 0.05, 0.08, 0.05, 0.03, 0.03, 0.04, 0.08, 0.04, 0.09), 
 Covid19M = c(0.08, 0, 0.01, 0.02, 0, 0.01, 0.03, 0.03, 0.03, 0.02, 0.07, 
 0.07, 0.11, 0.07, 0.01, 0.02, 0.03, 0.01, 0.01, 0.02, 0.03, 0.03, 0.06, 0.04, 
 0.03, 0.05, 0.12, 0.1, 0.04, 0.01, 0, 0, 0.03, 0.02, 0.01, 0.02, 0.01, 0.02, 
 0.02, 0.05, 0.01, 0.01, 0.02, 0.02, 0.02, 0.01, 0.11), 
 CancerF = c(3.27, 3.13, 2.96, 2.84, 2.88, 2.72, 2.74, 2.8, 2.78, 2.74, 2.83, 
 2.79, 2.89, 2.86, 2.74, 2.82, 2.85, 2.5, 2.69, 2.69, 2.79, 2.74, 2.79, 2.57, 
 2.64, 2.85, 2.9, 2.8, 2.79, 2.71, 2.86, 2.81, 2.66, 2.74, 2.81, 2.65, 2.72, 
 2.73, 2.79, 3.06, 2.86, 2.97, 2.81, 2.67, 2.84, 2.7, 2.88), 
 CardioF = c(1.27, 1.28, 1.35, 1.28, 1.03, 1.29, 1.33, 1.25, 1.3, 1.3, 1.4, 
 1.35, 1.25, 1.22, 1.09, 1.08, 1.23, 1.36, 1.16, 1.13, 1.22, 1.17, 1.03, 
 1.22, 1.27, 1.43, 1.43, 1.3, 1.39, 1.41, 1.04, 1.12, 1.31, 1.44, 1.49, 
 1.19, 1.43, 1.58, 1.4, 1.02, 1.2, 1.3, 1.28, 1.22, 1.43, 1.31, 1.22), 
 CerebroF = c(0.65, 0.73, 0.97, 0.82, 0.88, 0.75, 0.78, 0.76, 0.81, 0.69, 
 0.63, 0.65, 0.62, 0.61, 0.78, 0.73, 0.67, 0.69, 0.69, 0.78, 0.61, 0.76, 
 0.6, 0.64, 0.57, 0.58, 0.52, 0.6, 0.57, 0.51, 0.74, 0.68, 0.59, 0.6, 0.65, 
 0.6, 0.59, 0.66, 0.71, 0.58, 0.61, 0.57, 0.62, 0.68, 0.75, 0.73, 0.7), 
 Top3F = c(5.97, 5.92, 6.16, 5.72, 5.54, 5.49, 5.58, 5.52, 5.63, 5.45, 5.55, 
 5.45, 5.41, 5.27, 5.28, 5.33, 5.53, 5.27, 5.18, 5.26, 5.28, 5.29, 4.96, 
 5.03, 5.12, 5.58, 5.5, 5.37, 5.43, 5.24, 5.31, 5.27, 5.21, 5.5, 5.69, 5, 
 5.38, 5.73, 5.64, 5.29, 5.35, 5.57, 5.37, 5.26, 5.79, 5.43, 5.39), 
 PneumoniaF = c(0.35, 0.4, 0.29, 0.25, 0.32, 0.28, 0.32, 0.46, 0.34, 0.41, 
 0.46, 0.41, 0.34, 0.3, 0.25, 0.32, 0.33, 0.37, 0.31, 0.25, 0.32, 0.3, 0.31, 
 0.32, 0.27, 0.29, 0.46, 0.32, 0.35, 0.39, 0.29, 0.22, 0.38, 0.34, 0.47, 0.5, 
 0.26, 0.38, 0.48, 0.39, 0.45, 0.41, 0.34, 0.36, 0.44, 0.47, 0.27), 
 AccidentF = c(0.28, 0.33, 0.26, 0.24, 0.3, 0.26, 0.29, 0.25, 0.21, 0.24, 
 0.19, 0.2, 0.2, 0.28, 0.28, 0.34, 0.25, 0.32, 0.25, 0.25, 0.31, 0.26, 0.25, 
 0.25, 0.28, 0.16, 0.24, 0.24, 0.2, 0.33, 0.28, 0.22, 0.25, 0.24, 0.23, 0.3, 
 0.27, 0.31, 0.29, 0.26, 0.26, 0.26, 0.24, 0.32, 0.27, 0.29, 0.18), 
 TrafficF = c(0.04, 0.05, 0.03, 0.03, 0.04, 0.05, 0.04, 0.05, 0.03, 0.03, 
 0.03, 0.03, 0.02, 0.02, 0.05, 0.03, 0.02, 0.07, 0.02, 0.02, 0.05, 0.04, 
 0.03, 0.06, 0.05, 0.04, 0.03, 0.03, 0.03, 0.07, 0.04, 0.03, 0.04, 0.03, 
 0.04, 0.05, 0.06, 0.06, 0.05, 0.03, 0.05, 0.03, 0.04, 0.07, 0.06, 0.03, 0.03),
 SuicideF = c(0.34, 0.29, 0.29, 0.34, 0.26, 0.28, 0.33, 0.3, 0.37, 0.36, 0.33, 
 0.34, 0.34, 0.31, 0.33, 0.27, 0.26, 0.27, 0.33, 0.32, 0.3, 0.28, 0.28, 0.29, 
 0.32, 0.26, 0.35, 0.31, 0.34, 0.27, 0.22, 0.29, 0.25, 0.3, 0.26, 0.27, 0.28, 
 0.25, 0.25, 0.32, 0.26, 0.19, 0.25, 0.27, 0.29, 0.28, 0.26), 
 KidneyF = c(0.18, 0.17, 0.14, 0.13, 0.13, 0.14, 0.12, 0.12, 0.13, 0.13, 0.14, 
 0.12, 0.12, 0.12, 0.12, 0.12, 0.13, 0.15, 0.14, 0.09, 0.14, 0.13, 0.12, 0.14, 
 0.14, 0.14, 0.16, 0.14, 0.14, 0.16, 0.12, 0.14, 0.13, 0.15, 0.16, 0.16, 0.15, 
 0.14, 0.18, 0.14, 0.15, 0.15, 0.15, 0.17, 0.16, 0.17, 0.18), 
 LiverF = c(0.12, 0.09, 0.08, 0.1, 0.12, 0.11, 0.13, 0.12, 0.12, 0.12, 0.11, 
 0.1, 0.12, 0.12, 0.09, 0.11, 0.11, 0.08, 0.11, 0.09, 0.09, 0.11, 0.11, 0.09, 
 0.09, 0.11, 0.14, 0.13, 0.1, 0.1, 0.12, 0.08, 0.11, 0.11, 0.08, 0.16, 0.11, 
 0.11, 0.11, 0.11, 0.08, 0.1, 0.11, 0.11, 0.12, 0.11, 0.25), 
 DiabetesF = c(0.11, 0.09, 0.1, 0.07, 0.08, 0.06, 0.1, 0.1, 0.09, 0.09, 0.08, 
 0.09, 0.07, 0.06, 0.08, 0.07, 0.07, 0.09, 0.08, 0.08, 0.06, 0.08, 0.06, 
 0.09, 0.07, 0.06, 0.08, 0.07, 0.08, 0.06, 0.07, 0.07, 0.07, 0.08, 0.08, 
 0.09, 0.1, 0.09, 0.07, 0.08, 0.07, 0.07, 0.08, 0.09, 0.09, 0.09, 0.12), 
 HypertensF = c(0.07, 0.05, 0.06, 0.06, 0.06, 0.04, 0.05, 0.06, 0.05, 0.12, 
 0.04, 0.11, 0.04, 0.03, 0.06, 0.05, 0.06, 0.05, 0.05, 0.06, 0.03, 0.05, 
 0.03, 0.06, 0.04, 0.04, 0.08, 0.05, 0.08, 0.03, 0.04, 0.06, 0.03, 0.05, 
 0.06, 0.06, 0.08, 0.06, 0.04, 0.08, 0.06, 0.05, 0.04, 0.05, 0.07, 0.04, 0.1),
 Covid19F = c(0.06, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.02, 0.01, 0.02, 0.05, 
 0.04, 0.07, 0.04, 0.01, 0.01, 0.02, 0.01, 0.01, 0.01, 0.02, 0.01, 0.04, 0.02, 
 0.02, 0.03, 0.08, 0.06, 0.02, 0.01, 0, 0, 0.02, 0.02, 0.01, 0.02, 0.01, 0.01, 
 0.01, 0.03, 0.02, 0.01, 0.02, 0.01, 0.01, 0.01, 0.1)
)

# Life expectancy at birth for each prefecture in Japan since 1965
# https://www.mhlw.go.jp/toukei/saikin/hw/life/tdfk20/dl/tdfk20-08.xls
Prefe0 <- data.frame(
 PNAME = c("Hokkaido", "Aomori", "Iwate", "Miyagi", "Akita", "Yamagata",
 "Fukushima", "Ibaraki", "Tochigi", "Gunma", "Saitama", "Chiba", "Tokyo",
 "Kanagawa", "Niigata", "Toyama", "Ishikawa", "Fukui", "Yamanashi",
 "Nagano", "Gifu", "Shizuoka", "Aichi", "Mie", "Shiga", "Kyoto", "Osaka",
 "Hyogo", "Nara", "Wakayama", "Tottori", "Shimane", "Okayama", "Hiroshima",
 "Yamaguchi", "Tokushima", "Kagawa", "Ehime", "Kouchi", "Fukuoka", "Saga",
 "Nagasaki", "Kumamoto", "Oita", "Miyazaki", "Kagoshima", "Okinawa"),
 JCODE = 1:47,
 E0M.1965 = c(67.46, 65.32, 65.87, 67.29, 65.39, 66.49, 66.46, 66.99, 
 66.47, 67.34, 67.26, 67.71, 69.84, 69.05, 67.18, 66.70, 67.14, 67.96, 
 67.56, 68.45, 68.90, 68.21, 69.00, 68.61, 67.26, 69.18, 68.02, 68.29, 
 67.97, 67.75, 67.18, 67.77, 68.68, 68.61, 67.30, 66.69, 67.67, 67.81, 
 66.94, 67.32, 66.69, 66.29, 67.18, 66.83, 66.93, 67.36, NA), 
 E0M.1970 = c(69.26, 67.82, 68.03, 69.49, 67.56, 68.71, 68.52, 68.32, 
 68.30, 69.22, 69.38, 69.61, 71.30, 70.85, 69.07, 69.18, 69.77, 70.18, 
 69.42, 70.46, 70.69, 70.31, 70.74, 70.23, 69.66, 71.08, 70.16, 70.32, 
 70.29, 69.48, 69.29, 69.54, 70.69, 70.15, 69.16, 68.56, 69.95, 69.26, 
 68.02, 69.32, 68.83, 68.17, 69.06, 68.99, 68.40, 68.14, NA), 
 E0M.1975 = c(71.46, 69.69, 70.27, 71.50, 70.17, 70.96, 70.71, 70.58, 
 70.61, 71.23, 71.88, 71.99, 73.19, 72.95, 71.14, 71.11, 71.63, 72.21, 
 71.66, 72.40, 72.18, 72.32, 72.39, 71.75, 71.51, 72.63, 71.60, 71.82, 
 72.00, 71.25, 71.42, 71.55, 72.25, 72.04, 71.20, 70.71, 71.91, 71.25, 
 70.20, 71.41, 71.10, 70.74, 71.36, 71.03, 70.75, 70.54, 72.15), 
 E0M.1980 = c(72.96, 71.41, 72.72, 73.40, 72.48, 73.12, 72.90, 72.78, 
 72.86, 73.72, 73.79, 73.85, 74.46, 74.52, 73.29, 73.27, 73.48, 74.24, 
 73.26, 74.50, 74.13, 74.10, 74.08, 73.83, 73.61, 74.20, 72.96, 73.31, 
 73.43, 72.79, 73.02, 73.38, 74.21, 73.69, 72.96, 72.54, 74.28, 73.16, 
 72.20, 72.99, 73.09, 72.41, 73.61, 73.21, 72.77, 72.53, 74.52), 
 E0M.1985 = c(74.50, 73.05, 74.27, 75.11, 74.12, 74.99, 74.38, 74.35, 
 74.36, 75.11, 75.20, 75.27, 75.60, 75.59, 74.83, 74.81, 75.28, 75.64, 
 75.02, 75.91, 75.53, 75.48, 75.44, 74.87, 75.34, 75.39, 74.01, 74.47, 
 74.87, 74.19, 74.40, 75.30, 75.28, 75.19, 74.45, 74.35, 75.61, 74.75, 
 74.04, 74.19, 74.32, 74.09, 75.24, 74.82, 74.39, 74.09, 76.34), 
 E0M.1990 = c(75.67, 74.18, 75.43, 76.29, 75.29, 76.37, 75.71, 75.67, 
 75.38, 76.36, 76.31, 76.46, 76.35, 76.70, 76.49, 76.14, 76.38, 76.84, 
 76.26, 77.44, 76.72, 76.58, 76.32, 76.03, 76.36, 76.39, 75.02, 75.59, 
 76.15, 75.23, 75.66, 76.15, 76.32, 76.22, 75.74, 75.47, 76.09, 75.82, 
 75.44, 75.24, 75.45, 75.14, 76.27, 75.98, 75.45, 75.39, 76.67),
 E0M.1995 = c(76.56, 74.71, 76.35, 77.00, 75.92, 76.99, 76.47, 76.32, 
 76.12, 76.98, 76.95, 76.89, 76.91, 77.20, 76.98, 77.16, 77.16, 77.51, 
 76.82, 78.08, 77.17, 77.22, 76.90, 76.76, 77.13, 77.14, 75.90, 75.54, 
 77.14, 76.07, 76.09, 76.90, 77.03, 76.77, 76.36, 76.21, 77.12, 76.43, 
 76.18, 76.12, 76.26, 76.15, 77.31, 76.83, 76.53, 76.13, 77.22),
 E0M.2000 = c(77.55, 75.67, 77.09, 77.71, 76.81, 77.69, 77.18, 77.20, 
 77.14, 77.86, 78.05, 78.05, 77.98, 78.24, 77.66, 78.03, 77.96, 78.55, 
 77.90, 78.90, 78.10, 78.15, 78.01, 77.90, 78.19, 78.15, 76.97, 77.57, 
 78.36, 77.01, 77.39, 77.54, 77.80, 77.76, 77.03, 77.19, 77.99, 77.30, 
 76.85, 77.21, 76.95, 77.21, 78.29, 77.91, 77.42, 76.98, 77.64),
 E0M.2005 = c(78.30, 76.27, 77.81, 78.60, 77.44, 78.54, 77.97, 78.35, 
 78.01, 78.78, 79.05, 78.95, 79.36, 79.52, 78.75, 79.07, 79.26, 79.47, 
 78.89, 79.84, 79.00, 79.35, 79.05, 78.90, 79.60, 79.34, 78.21, 78.72, 
 79.25, 77.97, 78.26, 78.49, 79.22, 79.06, 78.11, 78.09, 78.91, 78.25, 
 77.93, 78.35, 78.31, 78.13, 79.22, 78.99, 78.62, 77.97, 78.64),
 E0M.2010 = c(79.17, 77.28, 78.53, 79.65, 78.22, 79.97, 78.84, 79.09, 
 79.06, 79.40, 79.62, 79.88, 79.82, 80.25, 79.47, 79.71, 79.71, 80.47, 
 79.54, 80.88, 79.92, 79.95, 79.71, 79.68, 80.58, 80.21, 78.99, 79.59, 
 80.14, 79.07, 79.01, 79.51, 79.77, 79.91, 79.03, 79.44, 79.73, 79.13, 
 78.91, 79.30, 79.28, 78.88, 80.29, 80.06, 79.70, 79.21, 79.40),
 E0M.2015 = c(80.28, 78.67, 79.86, 80.99, 79.51, 80.52, 80.12, 80.28, 
 80.10, 80.61, 80.82, 80.96, 81.07, 81.32, 80.69, 80.61, 81.04, 81.27, 
 80.85, 81.75, 81.00, 80.95, 81.10, 80.86, 81.78, 81.40, 80.23, 80.92, 
 81.36, 79.94, 80.17, 80.79, 81.03, 81.08, 80.51, 80.32, 80.85, 80.16, 
 80.26, 80.66, 80.65, 80.38, 81.22, 81.08, 80.34, 80.02, 80.27),
 E0M.2020 = c(80.92, 79.27, 80.64, 81.70, 80.48, 81.39, 80.60, 80.89, 
 81.00, 81.13, 81.44, 81.45, 81.77, 82.04, 81.29, 81.74, 82.00, 81.98, 
 81.71, 82.68, 81.90, 81.59, 81.77, 81.68, 82.73, 82.24, 80.81, 81.72, 
 82.40, 81.03, 81.34, 81.63, 81.90, 81.95, 81.12, 81.27, 81.56, 81.13, 
 80.79, 81.38, 81.41, 81.01, 81.91, 81.88, 81.15, 80.95, 80.73),
 E0F.1965 = c(72.82, 71.77, 71.58, 73.19, 71.24, 71.94, 72.04, 72.52, 
 72.44, 72.38, 72.45, 73.29, 74.70, 74.08, 72.19, 72.04, 72.40, 72.87, 
 73.29, 72.81, 73.03, 74.07, 73.67, 73.32, 72.48, 73.75, 73.30, 73.48, 
 72.89, 73.57, 73.39, 73.01, 74.03, 73.93, 72.98, 72.14, 73.16, 73.30, 
 73.32, 73.11, 72.65, 72.06, 72.60, 72.07, 72.45, 72.71, NA), 
 E0F.1970 = c(74.73, 74.68, 74.13, 75.30, 74.14, 74.46, 74.46, 74.43, 
 74.27, 74.50, 74.62, 75.33, 75.96, 75.97, 74.65, 74.78, 75.04, 75.04, 
 75.38, 75.22, 74.96, 75.88, 75.28, 75.29, 74.75, 75.66, 75.21, 75.63, 
 75.16, 75.19, 75.44, 75.37, 76.37, 75.80, 75.33, 74.30, 75.44, 75.41, 
 74.99, 75.44, 74.85, 74.37, 74.97, 74.66, 74.62, 74.62, NA), 
 E0F.1975 = c(76.74, 76.50, 76.20, 77.00, 75.86, 76.35, 76.35, 76.12, 
 76.31, 76.42, 76.61, 77.07, 77.89, 77.85, 76.76, 76.56, 76.58, 76.81, 
 77.43, 77.00, 76.41, 77.64, 76.63, 76.84, 76.47, 77.30, 76.57, 77.13, 
 76.76, 76.81, 77.45, 77.53, 77.76, 77.48, 77.27, 76.00, 77.12, 76.91, 
 76.50, 77.44, 76.83, 76.46, 76.89, 76.73, 76.77, 76.53, 78.96),
 E0F.1980 = c(78.58, 78.39, 78.59, 78.85, 78.64, 78.58, 78.46, 78.35, 
 78.13, 78.46, 78.68, 79.07, 79.49, 79.55, 78.97, 78.93, 78.88, 79.18, 
 79.21, 79.44, 78.47, 79.62, 78.73, 79.07, 78.64, 79.19, 78.36, 78.84, 
 78.65, 78.47, 79.45, 79.42, 79.78, 79.51, 79.14, 78.48, 79.64, 79.43, 
 78.98, 79.21, 79.02, 78.67, 79.37, 78.54, 78.84, 78.44, 81.72), 
 E0F.1985 = c(80.42, 79.90, 80.69, 80.69, 80.29, 80.86, 80.25, 79.97, 
 79.98, 80.39, 80.65, 80.88, 81.09, 81.22, 80.86, 80.80, 80.89, 81.01, 
 80.94, 81.13, 80.31, 81.37, 80.51, 80.61, 80.63, 80.68, 79.84, 80.40, 
 80.27, 80.13, 81.11, 81.60, 81.31, 80.94, 81.16, 80.56, 81.28, 81.01, 
 80.97, 80.91, 80.94, 80.81, 81.47, 80.58, 80.84, 80.34, 83.70), 
 E0F.1990 = c(81.92, 81.49, 81.93, 82.15, 81.80, 82.10, 81.95, 81.59, 
 81.30, 81.90, 81.75, 82.19, 82.09, 82.35, 82.50, 82.35, 82.24, 82.36, 
 82.39, 82.71, 81.69, 82.47, 81.63, 82.01, 81.88, 82.07, 81.16, 81.64, 
 81.89, 81.70, 82.33, 83.09, 82.70, 82.38, 82.46, 81.93, 82.13, 82.24, 
 82.44, 82.19, 82.17, 82.10, 82.85, 82.08, 82.30, 82.10, 84.47), 
 E0F.1995 = c(83.41, 82.51, 83.41, 83.32, 83.12, 83.23, 82.93, 82.87, 
 82.76, 83.12, 82.92, 83.19, 83.12, 83.35, 83.66, 83.86, 83.54, 83.63, 
 83.67, 83.89, 83.00, 83.70, 82.80, 83.02, 83.20, 83.44, 82.52, 81.83, 
 82.96, 82.71, 83.59, 84.03, 83.81, 83.66, 83.57, 83.17, 83.47, 83.28, 
 83.57, 83.44, 83.43, 83.23, 84.39, 83.61, 83.66, 83.36, 85.08), 
 E0F.2000 = c(84.84, 83.69, 84.60, 84.74, 84.32, 84.57, 84.21, 84.21, 
 84.04, 84.47, 84.34, 84.51, 84.38, 84.74, 85.19, 85.24, 85.18, 85.39, 
 85.21, 85.31, 84.33, 84.95, 84.22, 84.49, 84.92, 84.81, 84.01, 84.34, 
 84.80, 84.23, 84.91, 85.30, 85.25, 85.09, 84.61, 84.49, 84.85, 84.57, 
 84.76, 84.62, 85.07, 84.81, 85.30, 84.69, 85.09, 84.68, 86.01), 
 E0F.2005 = c(85.78, 84.80, 85.49, 85.75, 85.19, 85.72, 85.45, 85.26, 
 85.03, 85.47, 85.29, 85.49, 85.70, 86.03, 86.27, 86.32, 86.46, 86.25, 
 86.17, 86.48, 85.56, 86.06, 85.40, 85.58, 86.17, 85.92, 85.20, 85.62, 
 85.84, 85.34, 86.27, 86.57, 86.49, 86.27, 85.63, 85.67, 85.89, 85.64, 
 85.87, 85.84, 86.04, 85.85, 86.54, 86.06, 86.11, 85.70, 86.88), 
 E0F.2010 = c(86.30, 85.34, 85.86, 86.39, 85.93, 86.28, 86.05, 85.83, 
 85.66, 85.91, 85.88, 86.20, 86.39, 86.63, 86.96, 86.75, 86.75, 86.94, 
 86.65, 87.18, 86.26, 86.22, 86.22, 86.25, 86.69, 86.65, 85.93, 86.14, 
 86.60, 85.69, 86.08, 87.07, 86.93, 86.94, 86.07, 86.21, 86.34, 86.54, 
 86.47, 86.48, 86.58, 86.30, 86.98, 86.91, 86.61, 86.28, 87.02), 
 E0F.2015 = c(86.77, 85.93, 86.44, 87.16, 86.38, 86.96, 86.40, 86.33, 
 86.24, 86.84, 86.66, 86.91, 87.26, 87.24, 87.32, 87.42, 87.28, 87.54, 
 87.22, 87.67, 86.82, 87.10, 86.86, 86.99, 87.57, 87.35, 86.73, 87.07, 
 87.25, 86.47, 87.27, 87.64, 87.67, 87.33, 86.88, 86.66, 87.21, 86.82, 
 87.01, 87.14, 87.12, 86.97, 87.49, 87.31, 87.12, 86.78, 87.44), 
 E0F.2020 = c(87.08, 86.33, 87.05, 87.51, 87.10, 87.38, 86.81, 86.94, 
 86.89, 87.18, 87.31, 87.50, 87.86, 87.89, 87.57, 87.97, 88.11, 87.84, 
 87.94, 88.23, 87.51, 87.48, 87.52, 87.59, 88.26, 88.25, 87.37, 87.90, 
 87.95, 87.36, 87.91, 88.21, 88.29, 88.16, 87.43, 87.42, 87.64, 87.34, 
 87.84, 87.70, 87.78, 87.41, 88.22, 87.99, 87.60, 87.53, 87.88)
)

# Funtions for mutual conversion among lifetable functions
lxtodx <- function(lx) {
 nc <- length(lx)
 dx <- numeric(nc)
 for (i in 1:(nc-1)) {
  dx[i] <- lx[i]-lx[i+1]
 }
 dx[nc] <- lx[nc]
 return(dx)
}

dxtolx <- function(dx) {
 nc <- length(dx)
 lx <- numeric(nc)
 lx[1] <- 100000
 for (i in 2:nc) {
  lx[i] <- lx[i-1]-dx[i-1]
 }
 lx[nc] <- 0
 return(lx)
}

qxtodx <- function(qx) {
 nc <- length(qx)
 lx <- numeric(nc)
 dx <- numeric(nc)
 lx[1] <- 100000
 for (i in 1:(nc-1)) {
  dx[i] <- lx[i]*qx[i]
  lx[i+1] <- lx[i]-dx[i]
 }
 dx[nc] <- lx[nc]*qx[nc]
 lx[nc] <- 0
 return(dx)
}

dxtoqx <- function(dx) {
 nc <- length(dx)
 lx <- numeric(nc)
 qx <- numeric(nc)
 lx[1] <- 100000
 for (i in 1:(nc-1)) {
  qx[i] <- dx[i]/lx[i]
  lx[i+1] <- lx[i]-dx[i]
 }
 qx[nc] <- 1
 return(qx)
}

qxtomx <- function(qx, ax=0.5, n=1, mmax=NULL) {
 mx <- qx/(n*(1-qx*(1-ax)))
 if (!is.null(mmax)) { mx[length(mx)] <- mmax }
 return(mx)
}

mxtoqx <- function(mx, ax=0.5, n=1) {
 qx <- n*mx/(1+n*mx*(1-ax))
 qx[length(qx)] <- 1
 return(qx)
}

qxtolx <- function(qx) {
 nc <- length(qx)
 lx <- numeric(nc)
 dx <- numeric(nc)
 lx[1] <- 100000
 for (i in 1:(nc-1)) {
  dx[i] <- lx[i]*qx[i]
  lx[i+1] <- lx[i]-dx[i]
 }
 lx[nc] <- 0
 return(lx)
}

lxtoqx <- function(lx) {
 nc <- length(lx)
 dx <- numeric(nc)
 qx <- numeric(nc)
 for (i in 2:nc) {
  dx[i-1] <- lx[i-1]-lx[i]
  qx[i-1] <- dx[i-1]/lx[i-1]
 }
 dx[nc] <- lx[nc]
 qx[nc] <- 1
 return(qx)
}

uxtoqx <- function(ux) {
 nc <- length(ux)
 lx <- numeric(nc)
 lnlx <- numeric(nc)
 dx <- numeric(nc)
 qx <- numeric(nc)
 lx[1] <- 100000
 lnlx[1] <- log(lx[1])
 for (i in 2:nc) {
  lnlx[i] <- lnlx[i-1]-ux[i-1]
  lx[i] <- exp(lnlx[i])
  dx[i-1] <- lx[i-1]-lx[i]
  qx[i-1] <- dx[i-1]/lx[i-1]
 }
 dx[nc] <- lx[nc]
 qx[nc] <- 1
 return(qx)
}

# making lifetable from mx
lifetable <- function(mx, ns=NULL, class=5, mode=1) {
 nc <- length(mx)
 qx <- numeric(nc)
 if (mode>10) { mode <- mode %% 10; grev <- TRUE } else { grev <- FALSE }
 if (is.null(ns)) {
  n <- rep(class, nc)
  ages <- c(0, cumsum(n)[1:(nc-1)])
  if (mode %in% 4:5) { mode <- mode-2 }
 }
 else {
  n <- ns
  ages <- c(0, cumsum(n)[1:(nc-1)])
  if (mode %in% 2:3) { mode <- mode+2 }
 }
 if (mode==1) { ax <- c(rep(0.5, nc-1), 1/mx[nc])
 } else if (mode==2) { ax <- c(0.1, rep(0.4, 4), rep(0.5, nc-6), 1/mx[nc])
 } else if (mode==3) { ax <- c(0.3, rep(0.4, 4), rep(0.5, nc-6), 1/mx[nc])
 } else if (mode==4) { ax <- c(0.1, 0.4, rep(0.5, nc-3), 1/mx[nc])
 } else if (mode==5) { ax <- c(0.3, 0.4, rep(0.5, nc-3), 1/mx[nc])
 } else if (mode==6) { 
   if (mx[1]<0.107) {
     ax <- c(0.045+2.684*mx[1], (1.651-2.816*mx[1])/4, rep(0.5, nc-3), 1/mx[nc])
   } else {
     ax <- c(0.330, 1.352/4, rep(0.5, nc-3), 1/mx[nc])
   } # Males
 } else if (mode==7) {
   if (mx[1]<0.107) {
     ax <- c(0.053+2.8*mx[1], (1.522-1.518*mx[1])/4, rep(0.5, nc-3), 1/mx[nc])
   } else {
     ax <- c(0.350, 1.361/4, rep(0.5, nc-3), 1/mx[nc])
   } # Females
 } else {
   ax <- c(rep(0.5, nc-1), 1/mx[nc]) # default is mode 1
 }
 if (!grev) { 
  qx <- n*mx/(1+n*(1-ax)*mx)
  qx[nc] <- 1
 } # simple calculation
 else { # Greville's correction (ignoring ax)
  for (i in 1:(nc-1)) {
   qx[i] <- mx[i] / (1/n[1]+mx[i]*(1/2+n[i]/12*(mx[i]-(log(mx[i+1])-log(mx[i]))/n[i]))) / n[i]
  }
  qx[nc] <- 1
 }
 px <- dx <- lx <- Lx <- numeric(nc)
 lx[1] <- 100000
 px <- 1-qx
 for (i in 1:(nc-1)) {
  dx[i] <- lx[i]*qx[i]
  lx[i+1] <- lx[i]-dx[i]
  Lx[i] <- n[i]*(lx[i+1]+ax[i]*dx[i])
 }
 dx[nc] <- lx[nc]
 Lx[nc] <- lx[nc]/mx[nc] # same as n[nc]*lx[nc] - n[nc]*(1-ax[nc])*dx[nc]
 Tx <- rev(cumsum(rev(Lx)))
 ex <- Tx/lx
 return(data.frame(ages,n,ax,mx,qx,px,lx,dx,Lx,Tx,ex))
}

# making lifetable from mx (pattern2)
lifetable2 <- function(mx, ax=0.5, n=1) {
 nc <- length(mx)
 if (length(ax)==1) { ax <- rep(ax, nc) }
 if (length(n)==1) { n <- rep(n, nc) }
 qx <- mxtoqx(mx, ax, n)
 ages <- c(0, cumsum(n)[1:(nc-1)])
 qx[nc] <- 1
 px <- dx <- lx <- Lx <- numeric(nc)
 lx[1] <- 100000
 px <- 1-qx
 for (i in 1:(nc-1)) {
  dx[i] <- lx[i]*qx[i]
  lx[i+1] <- lx[i]-dx[i]
  Lx[i] <- n[i]*(lx[i+1]+ax[i]*dx[i])
 }
 dx[nc] <- lx[nc]
 Lx[nc] <- lx[nc]/mx[nc] # same as n[nc]*lx[nc] - n[nc]*(1-ax[nc])*dx[nc]
 Tx <- rev(cumsum(rev(Lx)))
 ex <- Tx/lx
 return(data.frame(ages,n,ax,mx,qx,px,lx,dx,Lx,Tx,ex))
}

# making lifetable from lx
lifetable3 <- function (lx, ax=0.5, n=1) {
    nc <- length(lx)
    if (length(ax) == 1) {
        ax <- rep(ax, nc)
    }
    if (length(n) == 1) {
        n <- rep(n, nc)
    }
    ages <- c(0, cumsum(n)[1:(nc - 1)])
    mx <- qx <- px <- dx <- Lx <- numeric(nc)
    for (i in 1:(nc - 1)) {
        dx[i] <- lx[i] - lx[i+1]
        qx[i] <- dx[i]/lx[i]
        px[i] <- 1 - qx[i]
        mx[i] <- qx[i]/(n[i] * (1 - qx[i] * (1 - ax[i])))
        Lx[i] <- n[i] * (lx[i+1] + ax[i] * dx[i])
    }
    dx[nc] <- lx[nc]
    qx[nc] <- 1
    px[nc] <- 0
    mx[nc] <- 1/(n[nc] * ax[nc])
    Lx[nc] <- lx[nc]/mx[nc]
    Tx <- rev(cumsum(rev(Lx)))
    ex <- Tx/lx
    return(data.frame(ages, n, ax, mx, qx, px, lx, dx, Lx, Tx, ex))
}

# making lifetable from qx
clifetable <- function(qx) {
 nc <- length(qx)
 lx <- numeric(nc)
 dx <- numeric(nc)
 Lx <- numeric(nc)
 lx[1] <- 100000
 for (i in 1:(nc-1)) {
  dx[i] <- lx[i]*qx[i]
  lx[i+1] <- lx[i]-dx[i]
  Lx[i] <- (lx[i]+lx[i+1])/2
 }
 dx[nc] <- lx[nc]
 Lx[nc] <- lx[nc]/2 # Wada (2006)
 Tx <- rev(cumsum(rev(Lx)))
 ex <- Tx/lx
 return(data.frame(qx,lx,dx,Lx,Tx,ex))
}

# functions for healthy life expectancy calculation
Jp2010s <- data.frame(
  Pxm = c(2689162, 2841813, 3013782, 3096387, 3228469, 3642952, 
          4180032, 4926663, 4381848, 4015388, 3807362, 4296539, 
          4936772, 3933785, 3235341, 2593169, 1700191, 1052072),
  Pxf = c(2565299, 2708194, 2870493, 2932213, 3076411, 3511714, 
          4033928, 4761382, 4268754, 3950745, 3800955, 4359516, 
          5117803, 4296437, 3752050, 3379056, 2663083, 2761968),
  Dxm = c(1873, 261, 350, 941, 1962, 2412, 3177, 4867, 6629, 
          9566, 14638, 27134, 46155, 57468, 73470, 102673, 
          119801, 159813),
  Dxf = c(1509, 219, 203, 481, 791, 1025, 1660, 2688, 3533, 
          4966, 7376, 12192, 19941, 25619, 36778, 60415, 
          91456, 292332),
  lxm = c(100000, 99661, 99614, 99557, 99403, 99118, 98795, 98421, 
          97925, 97174, 96004, 94164, 91282, 86929, 80842, 72127, 58934, 41062),
  lxf = c(100000, 99709, 99671, 99634, 99554, 99431, 99286, 99084, 
          98801, 98385, 97757, 96820, 95500, 93592, 90872, 86507, 78971, 66190),
  Txm = c(7963518, 7464920, 6966743, 6468797, 5971330, 5474998, 
          4980198, 4487127, 3996178, 3508304, 3025136, 2549369, 2085238, 
          1639074, 1218817, 835000, 505129, 253559),
  Txf = c(8638891, 8140093, 7641653, 7143382, 6645388, 6147923, 
          5651111, 5155164, 4660406, 4167367, 3676902, 3190334, 2709350, 
          2236330, 1774737, 1330308, 914910, 549344))

# getax function derives ax from the national
# lifetable's lx and Tx as
# ifelse(lx<50000, 0.5, 
#  [{T(x)-T(x+1)}-5*l(x+1)]/5/{l(x)-l(x+1)})
# and a(omega)=1, omega is open-ended max ageclass
getax <- function(lx, Tx, n=5) { # from National lifetable
  lxa <- c(lx[-1], 0)
  Txa <- c(Tx[-1], 0)
  ax <- ifelse(lx<50000, 0.5, ((Tx-Txa)-n*lxa)/n/(lx-lxa))
  nn <- length(ax); ax[nn] <- 1 # as of Hashimoto et al.
  return(ax)
}

# making healthy lifetable from mx and pix and Nx
# if Nx is not given, calculation of confidence
# intervals is impossible.
# I ignored the variance owing to mortality estimation.
# Hashimoto et al. obtained ax from national lifetable.
hlifetable <- function(mx, ax=0.5, n=5, pix=0, 
                       Nx=NULL, conf.level=0.95) {
  nc <- length(mx)
  if (length(ax)==1) { ax <- rep(ax, nc) }
  if (length(n)==1) { n <- rep(n, nc) }
  if (length(pix)==1) { pix <- rep(pix, nc) }
  qx <- mxtoqx(mx, ax, n)
  ages <- c(0, cumsum(n)[1:(nc-1)])
  qx[nc] <- 1
  px <- dx <- lx <- Lx <- numeric(nc)
  lx[1] <- 100000
  px <- 1-qx
  for (i in 1:(nc-1)) {
    dx[i] <- lx[i]*qx[i]
    lx[i+1] <- lx[i]-dx[i]
    Lx[i] <- n[i]*(lx[i+1]+ax[i]*dx[i])
  }
  dx[nc] <- lx[nc]
  Lx[nc] <- lx[nc]/mx[nc] # same as n[nc]*lx[nc] - n[nc]*(1-ax[nc])*dx[nc]
  hLx <- Lx*(1-pix)
  uLx <- Lx*pix
  Tx <- rev(cumsum(rev(Lx)))
  hTx <- rev(cumsum(rev(hLx)))
  uTx <- rev(cumsum(rev(uLx)))
  ex <- Tx/lx
  hex <- hTx/lx
  uex <- uTx/lx
  if (!is.null(Nx)) {
    S2pix <- pix*(1-pix)/Nx
    Vhex <- rev(cumsum(rev(Lx^2*S2pix)))/(lx^2)
    rs <- qnorm((1+conf.level)/2)
    llhex <- hex - rs*sqrt(Vhex)
    ulhex <- hex + rs*sqrt(Vhex)
  }
  else {
    llhex <- ulhex <- hex
  }
  return(data.frame(
    ages, n, ax, mx, qx, px, lx, dx, Lx, Tx, ex,
    hLx, hTx, hex, llhex, ulhex, uLx, uTx, uex))
}

Siler <- function(a1, b1, a2, a3, b3, t) { # for the lifetable function qx
 qxS <- a1*exp(-b1*t)+a2+a3*exp(b3*t)
 qxSa <- ifelse(qxS<0,0,ifelse(qxS>1,1,qxS)) # qx cannot outrange from [0, 1].
 return(qxSa)
}

fitSiler <- function(initialpar=c(0.01,3,1e-4,1e-5,0.1), data, mode=1, Method="Nelder-Mead", ...) {
 if (mode==1) {
  fSiler <- function(x, rqx) { # rqx must be real qx for each age 0 to length(rqx)-1.
   nc <- length(rqx)
   mqx <- Siler(x[1], x[2], x[3], x[4], x[5], 0:(nc-1))
   matched <- !is.na(rqx)
   res <- sum((mqx[matched]-rqx[matched])^2)
   RMSE <- sqrt(res/nc)
   return(RMSE)
  }
 } else { 
  if (mode==2) {
   fSiler <- function(x, rqx) { # rqx must be real qx for each age 0 to length(rqx)-1.
    nc <- length(rqx)
    mqx <- Siler(x[1], x[2], x[3], x[4], x[5], 0:(nc-1))
    matched <- !is.na(rqx)
    res <- sum((qxtodx(mqx[matched])-qxtodx(rqx[matched]))^2)
    RMSE <- sqrt(res/nc)
    return(RMSE)
   }
  } else {
   fSiler <- function(x, rqx) { # rqx must be real qx for each age 0 to length(rqx)-1.
    nc <- length(rqx)
    mqx <- Siler(x[1], x[2], x[3], x[4], x[5], 0:(nc-1))
    matched <- !is.na(rqx)
    res <- sum((qxtolx(mqx[matched])-qxtolx(rqx[matched]))^2)
    RMSE <- sqrt(res/nc)
    return(RMSE)
   }
  }
 }
 rS <- optim(initialpar, fSiler, gr=NULL, data, method=Method, ...)
 return(c(rS$par,rS$value,rS$convergence))
}

GompertzMakeham <- function(A, B, C, t) { # for the force of mortality at age x, mu(x)
 ux <- A*exp(B*t)+C
 qx <- uxtoqx(ux)
 return(qx)
}

fitGM <- function(initialpar=c(0.01, 0.0003, 0.07), data, mode=1, Method="Nelder-Mead", ...) {
 if (mode==1) {
  fGompertzMakeham <- function(x, rqx) { # rqx must be real qx for each age 0 to length(rqx)-1.
   nc <- length(rqx)
   mqx <- GompertzMakeham(x[1], x[2], x[3], 0:(nc-1))
   matched <- !is.na(rqx)
   res <- sum((mqx[matched]-rqx[matched])^2)
   RMSE <- sqrt(res/nc)
   return(RMSE)
  }
 } else {
  if (mode==2) {
   fGompertzMakeham <- function(x, rqx) { # rqx must be real qx for each age 0 to length(rqx)-1.
    nc <- length(rqx)
    mqx <- GompertzMakeham(x[1], x[2], x[3], 0:(nc-1))
    matched <- !is.na(rqx)
    res <- sum((qxtodx(mqx[matched])-qxtodx(rqx[matched]))^2)
    RMSE <- sqrt(res/nc)
    return(RMSE)
   }
  } else {
   fGompertzMakeham <- function(x, rqx) { # rqx must be real qx for each age 0 to length(rqx)-1.
    nc <- length(rqx)
    mqx <- GompertzMakeham(x[1], x[2], x[3], 0:(nc-1))
    matched <- !is.na(rqx)
    res <- sum((qxtolx(mqx[matched])-qxtolx(rqx[matched]))^2)
    RMSE <- sqrt(res/nc)
    return(RMSE)
   }
  }
 }
 rGM <- optim(initialpar, fGompertzMakeham, gr=NULL, data, method=Method, ...)
 return(c(rGM$par,rGM$value,rGM$convergence))
}

Denny <- function(a ,b, c, t) { # for lx
 lx <- ifelse(t<105, 1/(1+a*(t/(105-t))^3+b*sqrt(exp(t/(105-t))-1)+c*(1-exp(-2*t))), 0)
 lx <- ifelse(lx>1, 1, lx)
 return(lx*100000)
}

fitDenny <- function(initialpar=rep(0.1, 3), data, mode=3, Method="Nelder-Mead", ...) {
 if (length(data)>105) { data <- data[1:105] }
 if (mode==1) {
  fDenny <- function(x, rlx) { # rlx must be real lx for each age 0 to length(rlx)-1.
   nc <- length(rlx)
   mlx <- Denny(x[1], x[2], x[3], 0:(nc-1))
   matched <- !is.na(rlx)
   res <- sum((lxtoqx(mlx[matched])-lxtoqx(rlx[matched]))^2)
   RMSE <- sqrt(res/nc)
   return(RMSE)
  }
 } else {
  if (mode==2) {
   fDenny <- function(x, rlx) { # rlx must be real lx for each age 0 to length(rlx)-1.
    nc <- length(rlx)
    mlx <- Denny(x[1], x[2], x[3], 0:(nc-1))
    matched <- !is.na(rlx)
    res <- sum((lxtodx(mlx[matched])-lxtodx(rlx[matched]))^2)
    RMSE <- sqrt(res/nc)
    return(RMSE)
   }
  } else {
   fDenny <- function(x, rlx) { # rlx must be real lx for each age 0 to length(rlx)-1.
    nc <- length(rlx)
    mlx <- Denny(x[1], x[2], x[3], 0:(nc-1))
    matched <- !is.na(rlx)
    res <- sum((mlx[matched]-rlx[matched])^2)
    RMSE <- sqrt(res/nc)
    return(RMSE)
   }
  }
 }
 rDenny <- optim(initialpar, fDenny, gr=NULL, data, method=Method, ...)
 return(c(rDenny$par,rDenny$value,rDenny$convergence))
}

CM <- function(scale=0.8, a0=18, k=2) {
# Coale and McNeil's model nupitiality schedule
# Returned values will be the proportions ever married for ages 10-60.
# Age-specific nupitiality model by Coale and McNeil, 1972.
# G(a)=C*Gs((a-a0)/k)
# C is scale factor, must less than 1. The proportion who eventually marry.
# Thus 1-C represents non-marriage propotion for lifetime.
# Gs(a) is standard ever-married schedule.
# gs(x)=0.19465*exp(-0.174*(x-6.06)-exp(-0.288*(x-6.06)))
# Gs(a)=integrate gs(x) from 0 to a
# a0 is the age when nupitiality begins (about 1% have married)
# k is how fast women marry after initial age a0
# the mean age at marriage becomes a0+11.36*k
# its variance becomes 43.34*k^2
# Source: Preston SH et al. (2001) Demography, Blackwell, pp.203
# This schedule may not fit for so-called "Dekichatta-Kon"
  ages <- 10:60
  gs <- function(x) {0.19465*exp(-0.174*(x-6.06)-exp(-0.288*(x-6.06)))}
  GCem <- GCpm <- GCfm <- scale*sapply((ages-a0)/k, gs)
  for (i in 2:length(ages)) {
    GCpm[i] <- GCfm[i]*(1-GCem[i-1])
    GCem[i] <- GCpm[i]+GCem[i-1] 
  }
  mu <- sum(ages*GCpm)
  V <- sum((ages-mu)^2*GCpm)
  return(list(g=GCfm, G=GCem, mu=mu, sigma=sqrt(V)))
}

fitCM <- function(initialpar=c(0.8, 18, 2), data, ages=10:60, mode=1, Method="Nelder-Mead", ...) {
# data must be age specific probability of first marriage if mode==1,
# otherwise proportion of ever married women for each age
# length of data must be same as that of ages
if (mode==1) {
  fCM <- function(z, Dz=data, Mz=mode, Az=ages) {
    # the target function to be optimized, the data must be given for ages from 12 to 49.
    nc <- length(Dz)
    Azz <- Az[1]:Az[nc]-9
    mmz <- CM(z[1], z[2], z[3])$g[Azz]
    res <- sum((Dz-mmz)^2)
    RMSE <- sqrt(res/nc)
    return(RMSE)
  }
} else {
  fCM <- function(z, Dz=data, Mz=mode, Az=ages) {
    # the target function to be optimized, the data must be given for ages from 12 to 49.
    nc <- length(Dz)
    Azz <- Az[1]:Az[nc]-9
    mmz <- CM(z[1], z[2], z[3])$G[Azz]
    res <- sum((Dz-mmz)^2)
    RMSE <- sqrt(res/nc)
    return(RMSE)
  }
}
  rCM <- optim(initialpar, fCM, Dz=data, Mz=mode, Az=ages, method=Method, ...)
  return(c(rCM$par, rCM$value, rCM$convergence))
}

CT <- function(M=1, m=0) {
# Coale and Trussell model fertility schedule
# Age-specific fertility model by Coale and Trussell, 1978.
# nf[a]=n(a) and rn[a]=v(a) were cited from the original article.
# ASMFR = M*n(a)*exp(m*v(a))
# The function returns the age-specific marital fertility for ages from 12 to 49
 nf <- c(0.175,0.225,0.275,0.325,0.375,0.421,0.460,0.475,0.477,0.475,0.470,0.465,0.460,0.455,0.449,0.442,0.435,0.428,0.420,0.410,0.400,0.389,0.375,0.360,0.343,0.325,0.305,0.280,0.247,0.207,0.167,0.126,0.087,0.055,0.035,0.021,0.011,0.003)
# n(a): Age-specific natural fertility (originally by Louis Henry)
 rn <- c(0.000,0.000,0.000,0.000,0.000,0.000,0.000,0.000,0.004,0.030,0.060,0.100,0.150,0.200,0.250,0.310,0.370,0.440,0.520,0.600,0.680,0.760,0.830,0.900,0.970,1.040,1.110,1.180,1.250,1.320,1.390,1.460,1.530,1.590,1.640,1.670,1.690,1.700)*(-1)
# v(a): Age-specific downward discordance factor from natural fertility
 ages <- 12:49
 rval <- M*nf*exp(m*rn)
 names(rval) <- ages
 return(rval)
}

fitCT <- function(initialpar=c(1.0,1.0), data, Method="Nelder-Mead", ...) { # data must be ASMFRs for ages 12 to 49
 fCT <- function(z, rASMFR) {
  # the target function to be optimized, the data must be given for ages from 12 to 49.
  nc <- length(rASMFR)
  mASMFR <- CT(z[1], z[2])
  res <- sum((rASMFR-mASMFR)^2)
  RMSE <- sqrt(res/nc)
  return(RMSE)
 }
 rCT <- optim(initialpar, fCT, gr=NULL, data, method=Method, ...)
 return(c(rCT$par, rCT$value, rCT$convergence))
}

Hadwiger <- function(a=3.4, b=2.5, c=22.2) {
 # Hadwiger model fertility schedule for ages from 15 to 54.
 # Implemented by Minato Nakazawa <minato-nakazawa@umin.net>, 14 Dec. 2011.
 ages <- 15:54
 rval <- a*b/c*(c/ages)^1.5*exp(-b^2*(c/ages+ages/c-2))
 names(rval) <- ages
 return(rval)
}

fitHad <- function(initialpar=c(3.4, 2.5, 22.2), data, Method="Nelder-Mead", ...) { # data must be ASFRs for ages 15 to 54.
 fHad <- function(z, rASFR) {
  # the target function to be optimized, the data must be given for ages from 15 to 54.
  nc <- length(rASFR)
  res <- sum((rASFR - Hadwiger(z[1],z[2],z[3]))^2)
  RMSE <- sqrt(res/nc)
  return(RMSE)
 }
 rHad <- optim(initialpar, fHad, gr=NULL, data, method=Method, ...)
 return(c(rHad$par, rHad$value, rHad$convergence))
}

WhipplesIndex <- function(X) { # X should be age-specific population from age 0 for each age
  res <- sum(X[5:12*5+1])/sum(X[24:63])*100*5
  judge <- ifelse(res < 105, "highly accurate", 
                  ifelse(res < 110, "fairly accurate", 
                         ifelse(res < 125, "approximate",
                                ifelse(res < 175, "rough", "very rough"))))
  return(list(WI=res, JUDGE=judge))
}

CaretakerRatio <- function(PM, PF) { # PM should be age-specific males population, PF females
  # PM should be age-specific male population from age 0 for each age
  # PF should be age-specific female population from age 0 for each age
  NM <- length(PM)
  NF <- length(PF)
  res <- (sum(PM[81:NM])+sum(PF[81:NF]))/sum(PF[51:65])*100
  return(list(CR=res)) # The value in UK (1990) was 46.
}

IndexOfDissimilarity <- function(X, Y) {
 XX <- ifelse(is.na(X), 0, X)
 XX <- XX/sum(XX)
 YY <- ifelse(is.na(Y), 0, Y)
 YY <- YY/sum(YY)
 res <- 0.5*sum(abs(XX-YY))
 return(list(ID=res))
}

# defining Population Expansion Index (a.k.a. Bulge Index)
# X has to be the vector starting from age 0
# CLS is the width of age class (default 1)
# if MODE=1, modified PEI, otherwise original PEI is given.
PEI <- function(X, CLS=1, MODE=1) { 
 N1 <- 20/CLS + 1 - ifelse(MODE==1, 0, 5/CLS)
 N2 <- N1 + 20/CLS - 1
 D1 <- 10/CLS + 1 - ifelse(MODE==1, 0, 5/CLS)
 D2 <- D1 + 10/CLS - 1
 D3 <- D1 + 30/CLS
 D4 <- D2 + 30/CLS
 return(sum(X[N1:N2]) / (sum(X[D1:D2]) + sum(X[D3:D4])) * 100)
}
