% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcat.R
\name{write.fcat}
\alias{write.fcat}
\title{Write a format catalog to the file system}
\usage{
write.fcat(x, dir_path = getwd(), file_name = NULL)
}
\arguments{
\item{x}{The format catalog to write.}

\item{dir_path}{The directory path to write the catalog to. Default is the 
current working directory.}

\item{file_name}{The name of the file to save the catalog as.  Default is
the name of the variable that contains the catalog.  The ".fcat" file
extension will be added automatically.}
}
\value{
The full path of the saved format catalog.
}
\description{
The \code{write.fcat} function writes a format catalog
to the file system.  By default, the catalog will be written to the 
current working directory, using the variable name as the file name.  These
defaults can be overridden using the appropriate parameters.  The catalog
will be saved with a file extension of ".fcat". 

Note that the format catalog is saved as an RDS file.  The ".fcat" file 
extension only serves to distinguish the format catalog from other RDS
files.
}
\examples{
# Create format catalog
c1 <- fcat(num_fmt  = "\%.1f",
           label_fmt = value(condition(x == "A", "Label A"),
                             condition(x == "B", "Label B"),
                             condition(TRUE, "Other")),
           date_fmt = "\%d\%b\%Y")
           
# Get temp directory
tmp <- tempdir()            
           
# Save catalog to file system
pth <- write.fcat(c1, dir_path = tmp)

# Read from file system
c2 <- read.fcat(pth)

# Use formats in the catalog
fapply(2, c1$num_fmt)
fapply(c("A", "B", "C", "B"), c1$label_fmt)
fapply(Sys.Date(), c1$date_fmt)
}
\seealso{
Other fcat: 
\code{\link{as.data.frame.fcat}()},
\code{\link{as.fcat.data.frame}()},
\code{\link{as.fcat.fmt_lst}()},
\code{\link{as.fcat.list}()},
\code{\link{as.fcat}()},
\code{\link{fcat}()},
\code{\link{is.fcat}()},
\code{\link{print.fcat}()},
\code{\link{read.fcat}()}
}
\concept{fcat}
