% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmt.R
\name{labels.fmt}
\alias{labels.fmt}
\title{Extract labels from a user-defined format}
\usage{
\method{labels}{fmt}(object, ...)
}
\arguments{
\item{object}{A user-defined format of class "fmt".}

\item{...}{Following arguments.}
}
\value{
A vector of label values.
}
\description{
The \code{labels} function creates a vector of labels associated with 
a user-defined format.
}
\details{
The \code{condition} function creates a condition as part of a format 
definition.  Each condition has a label as part of its definition.
The \code{labels} function extracts the labels from the conditions and
returns them as a vector.  While the labels will typically be of type
character, they can be of any data type. See the \code{\link{condition}}
function help for further details.
}
\examples{
# Define format
fmt1 <- value(condition(x == "A", "Label A"),
              condition(x == "B", "Label B"), 
              condition(TRUE, "Other"))
              
# Extract labels
labels(fmt1)
# [1] "Label A" "Label B" "Other" 
}
\seealso{
\code{\link{value}} to define a format,
\code{\link{condition}} to define the conditions for a format, and 
\code{\link{fapply}} to apply the format to a vector.

Other fmt: 
\code{\link{as.data.frame.fmt}()},
\code{\link{as.fmt}()},
\code{\link{as.fmt.data.frame}()},
\code{\link{condition}()},
\code{\link{is.format}()},
\code{\link{print.fmt}()},
\code{\link{value}()}
}
\concept{fmt}
