% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peak_finding.R
\name{correct_peak}
\alias{correct_peak}
\title{Manually Correct Single Peak}
\usage{
correct_peak(
  df.peaks,
  df.data,
  measurement,
  peak,
  additional.msecs,
  path.data = NULL
)
}
\arguments{
\item{df.peaks}{The resulting tibble of the function \code{find_peaks()}. See \code{?find_peaks} for more details.}

\item{df.data}{A data frame or tibble in the below format. The columns \code{t} (time), \code{force}, \code{measurement}, and \code{specimen}.
(measurement ID) must be present. This will usually be the same table that was used before in \code{find_peaks()}.}

\item{measurement}{A character string defining the measurement ID (e.g. measurement number) of the peak to be corrected. Must be congruent with the
respective measurement ID within \code{df.peaks} and \code{df}.}

\item{peak}{A numerical value defining the peak to be corrected.}

\item{additional.msecs}{A numerical value defining the time before and after the originally defined window of the peak to be corrected. Higher
values allow defining start and end points further away from the original start and end points.
@param path.data A string character defining where to save the result and log file. If \code{NULL} (default),
data is not stored in files. Log files cannot be retrieved in this case.}

\item{path.data}{A string character defining where to save the results. If \code{NULL} (default),
data is not stored in a file.}
}
\value{
Changes values within \code{df.peaks} and returns the changed tibble.
}
\description{
Interactive correction of a single peak.
}
\details{
When running the function, you will be prompted to select the actual start and end of the current \code{peak} of the current \code{measurement}. If more or less
than exactly 2 points are defined, the process is terminated.
}
\section{\code{df} needs to contain the following columns:}{
\tabular{ccc}{
   \strong{\code{t}} \tab \strong{\code{force}} \tab \strong{\code{measurement}} \cr
   \code{t.1} \tab \code{force.1} \tab \code{measurement.1} \cr
   \code{...} \tab \code{...} \tab \code{...} \cr
   \code{t.n} \tab \code{force.n} \tab \code{measurement.m} \cr
}
}

\examples{
# Using the forceR::df.all.200.tax dataset:
\donttest{
# This function needs user input.
peaks.df <- correct_peak(df.peaks = forceR::peaks.df,
                        df.data = forceR::df.all.200.tax,
                        measurement = "m_01",
                        peak = 1,
                        additional.msecs = 5)
}
}
