% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tscv.R
\name{tsCV}
\alias{tsCV}
\title{Time series cross-validation}
\usage{
tsCV(y, forecastfunction, h = 1, ...)
}
\arguments{
\item{y}{Univariate time series}

\item{forecastfunction}{Function to return an object of class
\code{forecast}. Its first argument must be a univariate time series, and it
must have an argument \code{h} for the forecast horizon.}

\item{h}{Forecast horizon}

\item{...}{Other arguments are passed to \code{forecastfunction}.}
}
\value{
Numerical time series object containing the forecast errors.
}
\description{
\code{tsCV} computes the forecast errors obtained by applying
\code{forecastfunction} to subsets of the time series \code{y} using a
rolling forecast origin.
}
\details{
Let \code{y} contain the time series \eqn{y_1,\dots,y_T}{y[1:T]}. Then
\code{forecastfunction} is applied successively to the time series
\eqn{y_1,\dots,y_t}{y[1:t]}, for \eqn{t=1,\dots,T-h}, making predictions
\eqn{\hat{y}_{t+h|t}}{f[t+h]}. The errors are given by \eqn{e_{t+h} =
y_{t+h}-\hat{y}_{t+h|t}}{e[t+h] = y[t+h]-f[t+h]}. These are returned as a
vector, \eqn{e_1,\dots,e_T}{e[1:T]}. The first few errors may be missing as
it may not be possible to apply \code{forecastfunction} to very short time
series.
}
\examples{

#Fit an AR(2) model to each subset
far2 <- function(x, h){forecast(Arima(x, order=c(2,0,0)), h=h)}
e <- tsCV(lynx, far2, h=1)

}
\seealso{
\link{CV}, \link{CVar}, \link{residuals.Arima}.
}
\author{
Rob J Hyndman
}
\keyword{ts}
