% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvts.R
\name{tsPartition}
\alias{tsPartition}
\title{Generate training and test indices for time series cross validation}
\usage{
tsPartition(x, rolling, windowSize, maxHorizon)
}
\arguments{
\item{x}{A time series}

\item{rolling}{Should indices be generated for a rolling or non-rolling procedure?}

\item{windowSize}{Size of window for training}

\item{maxHorizon}{Maximum forecast horizon}
}
\value{
List containing train and test indices for each fold
}
\description{
Training and test indices are generated for time series cross validation.
Generated indices are based on the training windowSize, forecast horizons
and whether a rolling or non-rolling cross validation procedure is desired.
}
\examples{
tsPartition(AirPassengers, rolling = TRUE, windowSize = 10, maxHorizon = 2)

}
\author{
Ganesh Krishnan
}
