% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildEnsembleCPTs.R
\name{buildEnsembleCPTs}
\alias{buildEnsembleCPTs}
\title{buildEnsembleCPTs}
\usage{
buildEnsembleCPTs(lsimu, lminimalProbGenoMOI)
}
\arguments{
\item{lsimu}{list of simulations}

\item{lminimalProbGenoMOI}{list of minimal probabilities of genotypes given MOI # nolint}
}
\value{
list of CPTs
}
\description{
Build ensemble of CPTs from a list of simulations
}
\examples{
library(forrel)
library(mispitools)
freqs <- lapply(getfreqs(Argentina)[1:15], function(x) {x[x!=0]})
fam  <- linearPed(2)
fam  <- addChildren(fam, father =  1, mother =  2)
fam  <- pedtools::setMarkers(fam, locusAttributes = freqs)
ped  <- profileSim(fam, N = 1, ids = c(6)  , numCores = 1,seed=123)
lsimEnsemble  <- simTestIDMarkers(ped,2,numSim=5,seed=123)
lensembleIT   <- buildEnsembleITValues(lsimu=lsimEnsemble,ITtab=simME$ITtable,bFullIT = TRUE)
lensembleCPTs <- buildEnsembleCPTs(lsimu=lsimEnsemble,lminimalProbGenoMOI=simME$lprobGenoMOI)
}
