% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmse_per.R
\name{rmse_per}
\alias{rmse_per}
\title{RMSE of an estimator in percentage}
\usage{
rmse_per(df, y, yhat)
}
\arguments{
\item{df}{a data frame.}

\item{y}{Quoted name of the variable representing the observed values in the data frame. If a data frame is not provided, \code{y} can also be a numeric vector.}

\item{yhat}{Quoted name of the variable representing the estimated values in the data frame. If a data frame is not provided, \code{yhat} can also be a numeric vector.}
}
\value{
Numeric vector with the RMSE value, in percentage.
}
\description{
Function for calculating the Root-Mean-Square-Error of an estimator.
}
\details{
Function for calculating the Root-Mean-Square-Error of an estimator, given the observed values, and the estimated values.
}
\examples{
library(forestmangr)
data(exfm11)
head(exfm11)

# RMSE of an estimator, given the data frame and quoted variable names:
rmse_per(exfm11, "TH", "TH_EST3")

# RMSE of an estimator, given the vectors for observed and estimated values:
rmse_per(y = exfm11$TH, yhat = exfm11$TH_EST3)

}
\seealso{
other statistics to evaluate estimators: 
  \code{\link{bias_per}} for the bias of an estimator
}
\author{
Sollano Rabelo Braga \email{sollanorb@gmail.com}
}
\keyword{Root-Mean-Square-Error}
