% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ident_model.R
\name{ident_model}
\alias{ident_model}
\title{Identity of a Model Test}
\usage{
ident_model(
  df,
  factor,
  reduced_model,
  filter = NA,
  gray_scale = TRUE,
  signif = 0.05,
  font = "serif",
  output = "table"
)
}
\arguments{
\item{df}{a data frame.}

\item{factor}{Quoted name of the factor variable used to differentiate the data projects in the test.}

\item{reduced_model}{Quoted or unquoted reduced model used in the test.  The variables mentioned in the model must exist in the provided data frame. X and Y sides of the model must be separated by "~".}

\item{filter}{Optional argument. If supplied with levels present in \code{factor}, only these levels will be used in the test. \code{NA}.}

\item{gray_scale}{If \code{TRUE} a gray scale will be used in the plots. Default: \code{FALSE}.}

\item{signif}{Numeric value for the significance level used in the test. Default: \code{0.05}.}

\item{font}{font family used in the plots. Can be either \code{"serif"} for Times New Roman or \code{"sans"} for arial unicode MS. Default: \code{"serif"}.}

\item{output}{Defines the type of output. If \code{"table"} an anova table with the identity of model test is provided,
if \code{"plot"} a ggplot plot/object representing the test is created,
if \code{"table_plot"}, both anova table and plot are provided, and if \code{"full"},
a list is provided, with details on the dummies variables created, the reduced and complete models,
the anova table and the plot. Default: \code{"table"}}
}
\value{
A data frame, a ggplot object, or a list, varying according to the \code{output} argument.
}
\description{
Function for using the Identity of a Model test, as described by Regazzi (1999).
}
\examples{
library(forestmangr)
data("exfm13")
exfm13

# The objective is to know if the diameter's behavior is similar among 3 species.
# For this we'll use a quadratic model. We'll use nitrogen (N) as our X variable.

ident_model(exfm13, "species", dbh ~ N + N2)

# This test shows that there are differences between the species. 
# We can get more details on this using a different output, that will also
# give us a plot:

ident_model(exfm13, "species", dbh ~  N + N2, output = "table_plot")

# This gives us only the plot:
ident_model(exfm13, "species", dbh ~  N + N2, output = "table_plot")

# And this gives us additional information on the test:
ident_model(exfm13, "species", dbh ~  N + N2, output = "full")

# Looking at the plot, it seems that 2 species are behaving very similar, while
# the Pequi species is different from the other 2. We can confirm this by running
# the test in a paired fashion, using the filter argument:

ident_model(exfm13, "species", dbh ~  N + N2,
 filter = c("PEQUI", "SUCUPIRA-PRETA"), output = "table_plot")
 
ident_model(exfm13, "species", dbh ~  N + N2, 
filter = c("PEQUI", "VINHATICO"), output = "table_plot")

ident_model(exfm13, "species", dbh ~  N + N2, 
filter = c("SUCUPIRA-PRETA", "VINHATICO"), output = "table_plot")

# As we imagined, a single model can be used to describe the behavior of
# the "Sucupira-preta" and "Vinhatico" species,
# and a second model is needed to explain the Pequi Variable.

# It's possible to apply a color scale to the plots, and also change it's font to arial:

ident_model(exfm13, "species", dbh ~  N + N2,output="plot",gray_scale=FALSE,font="sans")

}
\references{
Regazzi, A. J. (1999) Teste para verificar a identidade de modelos de regressao e a igualdade de parametros no caso de dados de delineamentos experimentais, Ceres, 46(266), pp. 383–409.
}
\author{
Sollano Rabelo Braga \email{sollanorb@gmail.com}

Marcio leles Romarco de Oliveira \email{marcioromarco@gmail.com}
}
