% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/species_aggreg.R
\name{species_aggreg}
\alias{species_aggreg}
\title{Get the aggregation state of species}
\usage{
species_aggreg(df, species, plot, NI_label = "")
}
\arguments{
\item{df}{A data frame.}

\item{species}{Quoted name of the scientific names variable, or any variable used to differentiate the different species found in data.}

\item{plot}{Quoted name of the plot variable. used to differentiate the plots trees, and calculate the number of sampled plots.}

\item{NI_label}{Label used for Species not identified. This parameter works along with species. The level supplied here will not be considered in the classification. Default \code{""}.}
}
\value{
a data frame with the aggregation classification.
}
\description{
Get the aggregation state of species according to the Payandeh, Hazen and Morista methods.
}
\examples{
library(forestmangr)
data("exfm20")
exfm20

# Get the aggregation indexes of species:
species_aggreg(exfm20, "scientific.name", "transect")

}
\references{
Souza, A. L. and Soares, C. P. B. (2013) Florestas Nativas: estrutura, dinamica e manejo. Vicosa: UFV.
}
\author{
Eric Bastos Gorgens \email{e.gorgens@gmail.com}
}
