% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/molds.R
\name{cast}
\alias{cast}
\alias{cast_integer}
\alias{cast_scalar_integer}
\alias{cast_nullable_integer}
\alias{cast_nullable_scalar_integer}
\alias{cast_integer_list}
\alias{cast_nullable_integer_list}
\alias{cast_double}
\alias{cast_scalar_double}
\alias{cast_nullable_double}
\alias{cast_nullable_scalar_double}
\alias{cast_double_list}
\alias{cast_nullable_double_list}
\alias{cast_character}
\alias{cast_scalar_character}
\alias{cast_nullable_character}
\alias{cast_nullable_scalar_character}
\alias{cast_character_list}
\alias{cast_nullable_character_list}
\alias{cast_string}
\alias{cast_nullable_string}
\alias{cast_string_list}
\alias{cast_nullable_string_list}
\alias{cast_logical}
\alias{cast_scalar_logical}
\alias{cast_nullable_logical}
\alias{cast_nullable_scalar_logical}
\alias{cast_logical_list}
\alias{cast_nullable_logical_list}
\alias{cast_choice}
\title{Cast values into shape}
\usage{
cast_integer(x, n = NULL, allow_na = FALSE, allow_null = FALSE)

cast_scalar_integer(x, allow_na = FALSE, allow_null = FALSE)

cast_nullable_integer(x, n = NULL, allow_na = FALSE)

cast_nullable_scalar_integer(x, allow_na = FALSE)

cast_integer_list(x, n = NULL, allow_na = FALSE, allow_null = FALSE)

cast_nullable_integer_list(x, n = NULL, allow_na = FALSE)

cast_double(x, n = NULL, allow_na = FALSE, allow_null = FALSE)

cast_scalar_double(x, allow_na = FALSE, allow_null = FALSE)

cast_nullable_double(x, n = NULL, allow_na = FALSE)

cast_nullable_scalar_double(x, allow_na = FALSE)

cast_double_list(x, n = NULL, allow_na = FALSE, allow_null = FALSE)

cast_nullable_double_list(x, n = NULL, allow_na = FALSE)

cast_character(x, n = NULL, allow_na = FALSE, allow_null = FALSE)

cast_scalar_character(x, allow_na = FALSE, allow_null = FALSE)

cast_nullable_character(x, n = NULL, allow_na = FALSE)

cast_nullable_scalar_character(x, allow_na = FALSE)

cast_character_list(x, n = NULL, allow_na = FALSE,
  allow_null = FALSE)

cast_nullable_character_list(x, n = NULL, allow_na = FALSE)

cast_string(x, allow_na = FALSE, allow_null = FALSE)

cast_nullable_string(x, allow_na = FALSE)

cast_string_list(x, n = NULL, allow_na = FALSE, allow_null = FALSE)

cast_nullable_string_list(x, n = NULL, allow_na = FALSE)

cast_logical(x, n = NULL, allow_na = FALSE, allow_null = FALSE)

cast_scalar_logical(x, allow_na = FALSE, allow_null = FALSE)

cast_nullable_logical(x, n = NULL, allow_na = FALSE)

cast_nullable_scalar_logical(x, allow_na = FALSE)

cast_logical_list(x, n = NULL, allow_na = FALSE, allow_null = FALSE)

cast_nullable_logical_list(x, n = NULL, allow_na = FALSE)

cast_choice(x, choices, allow_na = FALSE, allow_null = FALSE)
}
\arguments{
\item{x}{A vector.}

\item{n}{The required length of the vector. If \code{NULL}, the length is not checked.}

\item{allow_na}{Whether to allow \code{NA}s in the vector.}

\item{allow_null}{Whether to allow \code{NULL}.}

\item{choices}{A character, numeric, or integer vector of allowed values.}
}
\description{
These functions verify and attempt to coerce values into the specified types and shapes. If they
are unsuccessful in the coercion, an error is thrown.
}
\examples{
# Cast a double vector to integer
cast_integer(c(1, 2))

# Cast a numeric to a string
cast_string(4.5)

# Cast an integer vector to a list of doubles
cast_double_list(1:4)

}
