% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_value.R
\name{format_value}
\alias{format_value}
\title{Converts a (possibly compound) value into a string using the \code{format} information}
\usage{
format_value(x, format = NULL, output = c("ascii", "html"), na_str = "NA")
}
\arguments{
\item{x}{ANY. The value to be formatted}

\item{format}{character(1) or function. The format label (string) or formatter function to apply to \code{x}.}

\item{output}{character(1). output type}

\item{na_str}{character(1). String that should be displayed when the value of \code{x} is missing. Defaults to \code{"NA"}.}
}
\value{
formatted text representing the cell \code{x}.
}
\description{
Converts a (possibly compound) value into a string using the \code{format} information
}
\examples{

x <- format_value(pi, format = "xx.xx")
x

format_value(x, output = "ascii")

}
\seealso{
[round_fmt()]
}
