% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{matrix_form}
\alias{matrix_form}
\alias{matrix_form,MatrixPrintForm-method}
\title{Transform rtable to a list of matrices which can be used for outputting}
\usage{
matrix_form(obj, indent_rownames = FALSE)

\S4method{matrix_form}{MatrixPrintForm}(obj, indent_rownames = FALSE)
}
\arguments{
\item{obj}{ANY. Object to be transformed into a ready-to-render form (a MatrixPrintForm object)}

\item{indent_rownames}{logical(1), if TRUE the column with the row names in the `strings` matrix of has indented row
names (strings pre-fixed)}
}
\value{
A `MatrixPrintForm` classed list with the following elements:
\describe{
\item{strings}{The content, as it should be printed, of the top-left material, column headers, row labels , and cell values of \code{tt}}
\item{spans}{The column-span information for each print-string in the strings matrix}
\item{aligns}{The text alignment for each print-string in the strings matrix}
\item{display}{Whether each print-string in the strings matrix should be printed or not}.
\item{row_info}{the data.frame generated by \code{summarize_rows(tt)}}
}

With an additional \code{nrow_header} attribute indicating the number of pseudo "rows"  the
column structure defines.
}
\description{
Although rtables are represented as a tree data structure when outputting the table to ASCII or HTML it is useful to
map the rtable to an in between state with the formatted cells in a matrix form.
}
\details{
The strings in the return object are defined as follows: row labels are those determined by \code{summarize_rows} and cell values are determined using \code{get_formatted_cells}. (Column labels are calculated using a non-exported internal funciton.
}
