% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_value.R
\name{check_formats}
\alias{check_formats}
\alias{is_valid_format}
\alias{check_aligns}
\title{Check if a format or alignment is supported}
\usage{
is_valid_format(x, stop_otherwise = FALSE)

check_aligns(algn)
}
\arguments{
\item{x}{either format string or an object returned by \code{sprintf_format}}

\item{stop_otherwise}{logical, if \code{x} is not a format should an error be
thrown}

\item{algn}{vector of characters that indicates the requested cell alignments.}
}
\value{
\itemize{
\item \code{is_valid_format}: \code{TRUE} if \code{x} is \code{NULL}, a supported
format string, or a function; \code{FALSE} otherwise.
}

\itemize{
\item \code{check_aligns}: \code{TRUE} if it passes the check.
}
}
\description{
Utility functions for checking formats and alignments.
}
\note{
No check if the function is actually a \code{formatter} is performed.
}
\examples{
is_valid_format("xx.x")
is_valid_format("fakeyfake")

check_aligns(c("decimal", "dec_right"))

}
