% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ASM_Server.R
\name{ASM_init_state}
\alias{ASM_init_state}
\title{Initialize ASM Module State}
\usage{
ASM_init_state(FM_yaml_file, MOD_yaml_file, id, session)
}
\arguments{
\item{FM_yaml_file}{App configuration file with FM as main section.}

\item{MOD_yaml_file}{Module configuration file with MC as main section.}

\item{id}{ID string for the module.}

\item{session}{Shiny session variable}
}
\value{
list containing an empty ASM state
}
\description{
Creates a list of the initialized module state
}
\examples{
# Within shiny the session variable will exist,
# this creates an example here for testing purposes:
sess_res = ASM_test_mksession()
session = sess_res$session
state = ASM_init_state(
   FM_yaml_file  = system.file(package = "formods",
                               "templates",
                               "formods.yaml"),
   MOD_yaml_file = system.file(package = "formods",
                               "templates",
                               "ASM.yaml"),
   id              = "ASM",
   session         = session)
state
}
