% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formods.R
\name{remove_hold}
\alias{remove_hold}
\title{Removes Hold on UI Element}
\usage{
remove_hold(state, session, inputId)
}
\arguments{
\item{state}{module state with all of the current ui elements populated}

\item{session}{Shiny session variable}

\item{inputId}{The input ID of the UI element that was put on hold}
}
\value{
No return value, called to remove holds.
}
\description{
When some buttons are clicked they will change the state of the
system, but other UI components will not detect that change correctly. So those
triggers are put on hold. This will remove the hold after those UI
components have updated.
}
\examples{
# Within shiny both session and input variables will exist, 
# this creates examples here for testing purposes:
sess_res = DW_test_mksession(session=list())
session = sess_res$session
input   = sess_res$input

# For this example we also need a state variable
state = sess_res$state

# This sets a hold on the specified inputID. This is normally done in 
# your XX_fetch_state() function.
state = set_hold(state, inputId = "select_dw_views")

# This will fetch the hold status of the specified inputID. 
fetch_hold(state, inputId = "select_dw_views")

# This will remove the hold and is normally done in one of the UI outputs
# with a priority set to ensure it happens after the rest of the UI has
# refreshed.
state = remove_hold(state, session, inputId = "select_dw_views")
}
