% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/get.vars.R, R/lhs.vars.R, R/rhs.vars.R
\docType{methods}
\name{get.vars}
\alias{.lhs.vars}
\alias{.rhs.vars}
\alias{get.vars}
\alias{get.vars,call,ANY-method}
\alias{get.vars,expression,missing-method}
\alias{get.vars,formula,ANY-method}
\alias{get.vars,name,ANY-method}
\alias{lhs.vars}
\alias{lhs.vars,call-method}
\alias{lhs.vars,expression-method}
\alias{lhs.vars,formula-method}
\alias{rhs.vars}
\alias{rhs.vars,call-method}
\alias{rhs.vars,expression-method}
\alias{rhs.vars,formula-method}
\title{Get variable (names) from various R objects}
\usage{
get.vars(x, data = NULL, ...)

\S4method{get.vars}{formula,ANY}(x, data = NULL, ...)

\S4method{get.vars}{call,ANY}(x, data = NULL, ...)

\S4method{get.vars}{expression,missing}(x, data = NULL, ...)

\S4method{get.vars}{name,ANY}(x, data = NULL, ...)

lhs.vars(x, ...)

.lhs.vars(x, ..., data = NULL)

\S4method{lhs.vars}{formula}(x, ..., data = NULL)

\S4method{lhs.vars}{call}(x, ..., data = NULL)

\S4method{lhs.vars}{expression}(x, ...)

rhs.vars(x, ...)

.rhs.vars(x, ..., data = NULL)

\S4method{rhs.vars}{formula}(x, ..., data = NULL)

\S4method{rhs.vars}{call}(x, ..., data = NULL)

\S4method{rhs.vars}{expression}(x, ...)
}
\arguments{
\item{x}{object to extract vars from.}

\item{data}{data set/list or environment on which the names are defined}

\item{...}{arguments passed to subsequent functions

\code{get.vars} and variant get the variables from objects optionally
interpreting on \code{.} on the data.  This is useful, for example, when you
wish to know what data is used based on a given formula.

Methods/functions beginning with \code{.} are not exported}
}
\value{
character vector of variables names
}
\description{
\code{get.vars} extracts variable names from various R objects such as
formulas, expressions, calls, symbols, etc.  It is very similar to
\code{\link[base]{all.vars}} except that all symbols, etc. are interpolated
to the names of variables.
}
\examples{
get.vars( Species ~ ., iris )
  get.vars( quote( Sepal.Length * Sepal.Width ), iris )
}
\seealso{
\code{\link[base]{all.vars}}
}

