% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markerSim.R
\name{markerSim}
\alias{markerSim}
\title{Marker simulation}
\usage{
markerSim(
  x,
  N = 1,
  ids = NULL,
  alleles = NULL,
  afreq = NULL,
  mutmod = NULL,
  rate = NULL,
  partialmarker = NULL,
  loopBreakers = NULL,
  eliminate = 0,
  seed = NULL,
  verbose = TRUE
)
}
\arguments{
\item{x}{A \code{ped} object or a list of such.}

\item{N}{A positive integer: the number of (independent) markers to be
simulated.}

\item{ids}{A vector containing ID labels of those pedigree members whose
genotypes should be simulated. By default, all individuals are included.}

\item{alleles}{A vector containing the alleles for the marker to be
simulation. If a single integer is given, this is interpreted as the number
of alleles, and the actual alleles as \code{1:alleles}. Must be NULL if
\code{partialmarker} is non-NULL.}

\item{afreq}{A vector containing the population frequencies for
the marker alleles. Must be NULL if \code{partialmarker} is non-NULL.}

\item{mutmod, rate}{Arguments specifying a mutation model, passed on to
\code{\link[pedtools:marker]{pedtools::marker()}} (see there for explanations).}

\item{partialmarker}{Either NULL (resulting in unconditional simulation), a
marker object (on which the simulation should be conditioned) or the name
(or index) of a marker attached to \code{x}.}

\item{loopBreakers}{A numeric containing IDs of individuals to be used as
loop breakers. Relevant only if the pedigree has loops, and only if
\code{partialmarker} is non-NULL. See \code{\link[pedtools:breakLoops]{pedtools::breakLoops()}}.}

\item{eliminate}{A non-negative integer, indicating the number of iterations
in the internal genotype-compatibility algorithm. Positive values can save
time if \code{partialmarker} is non-NULL and the number of alleles is large.}

\item{seed}{NULL, or a numeric seed for the random number generator.}

\item{verbose}{A logical.}
}
\value{
A \code{ped} object equal to \code{x} except its \code{MARKERS} entry, which
consists of the \code{N} simulated markers.
}
\description{
Simulates marker genotypes conditional on the pedigree structure and known
genotypes. Note: This function simulates independent realisations at a single
locus. Equivalently, it can be thought of as independent simulations of
identical, unlinked markers. For simulations of a \emph{set} of markers, see
\code{\link[=profileSim]{profileSim()}}.
}
\details{
This implements (with various time savers) the algorithm used in SLINK of the
LINKAGE/FASTLINK suite. If \code{partialmarker} is NULL, genotypes are simulated
by simple gene dropping, using \code{\link[=simpleSim]{simpleSim()}}.
}
\examples{
x = nuclearPed(2)

# Unconditional simulation
markerSim(x, N = 2, alleles = 1:3)

# Conditional on one child being homozygous 1/1
x = setMarkers(x, marker(x, '3' = 1, alleles = 1:3))
markerSim(x, N = 2, partialmarker = 1)
markerSim(x, N = 1, ids = 4, partialmarker = 1, verbose = FALSE)

}
\references{
G. M. Lathrop, J.-M. Lalouel, C. Julier, and J. Ott, \emph{Strategies
for Multilocus Analysis in Humans}, PNAS 81(1984), pp. 3443-3446.
}
\seealso{
\code{\link[=profileSim]{profileSim()}}, \code{\link[=simpleSim]{simpleSim()}}
}
\author{
Magnus Dehli Vigeland
}
