% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mra.plot.R
\name{mra.plot}
\alias{mra.plot}
\title{Multiscale Regression Plot}
\usage{
mra.plot(
  betas,
  order = 1,
  ci = FALSE,
  iterations = NULL,
  return.ci = FALSE,
  loess.beta = FALSE,
  loess.ci = FALSE
)
}
\arguments{
\item{betas}{an object containing modeling results from multiscale regression
analysis. The object should be returned from the \code{mra} function of this
package.}

\item{order}{integer representing the detrending order used in the \code{mra} 
calculation. Default is 1.}

\item{ci}{a logical indicating whether confidence intervals should be 
computed using the \code{iaafft} function from this package. NOTE: with long 
time series (>> than N = 1,000), this can greatly reduce processing speed. 
Confidence intervals can be used for conventional significance testing of 
scale-wise correlation coefficients.}

\item{iterations}{integer that specifies the the number of surrogate time 
series to be generated for the purpose of confidence intervals. 
Default = 19. Larger number of surrogates will slow computational speed but
produce better confidence interval estimates.}

\item{return.ci}{logical indicating whether the confidence intervals 
should be returned}

\item{loess.beta}{logical indicating whether a loess fit should be used for 
displaying multiscale regression coefficient trajectories}

\item{loess.ci}{logical indicating whether a loess fit should be used to smooth 
confidence intervals}
}
\description{
A plotting method for constructing scalewise regression plot
}
