% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Framboids_growth.R
\name{Framboids_growth}
\alias{Framboids_growth}
\title{Generate size distribution of framboidal pyrite based on different growth mechanisms}
\usage{
Framboids_growth(Number_Framboids = 1000, Initialization = TRUE, framboids,
  Simulation = 1, Initial_Diameter = 0, Nanocrystals_Diameter = 0.1,
  Packing_Factor = 0.74078, Random_Limit = 1, Iterations = 3,
  MaxMeanDiameter = 20)
}
\arguments{
\item{Number_Framboids}{An integer indicanting the number of framboids to grow}

\item{Initialization}{If TRUE the growth starts from empty framboids. If FALSE the growth continues
from framboids}

\item{framboids}{When Initialization=FALSE contains a framboids data_frame previously grown}

\item{Simulation}{The growth mechanism to simulate.
1-4 surface-controlled,
5-6 supply-controlled,
1,3,5,6 size dependent,
2,4,7,8 size independent,
1,2,5,7 adding nanocrystals,
3,4,6,8 increasing diameter}

\item{Initial_Diameter}{A number (in micrometers) representing the growth over preexistent
spherical objects}

\item{Nanocrystals_Diameter}{A number (in micrometers) with the diameter of nanocrystals
forming framboids}

\item{Packing_Factor}{A number from 0 to 1 representing the packing factor of nanocrystals}

\item{Random_Limit}{A number from 0 to 1 representing the maximum value of random numbers
in algorithm}

\item{Iterations}{An integer value that controls the maximum number of iterations of the algorithm}

\item{MaxMeanDiameter}{A number (in micrometers) controlling the maximum mean of the size
distribution of framboids}
}
\value{
A framboids data_frame
}
\description{
Generate size distribution of framboidal pyrite based on different growth mechanisms
}
\examples{
## Size dependent and surface-controlled growth of 1000 framboids adding nanocrystals
## until the mean of the diameters of framboids was 15 micrometers.
library(frambgrowth)
Framboids<-Framboids_growth(100,Initialization=TRUE, Simulation=1,
Iterations=1000, MaxMeanDiameter=15)
## Size dependent and surface-controlled growth of 1000 framboids adding nanocrystals
## until the mean of the diameters of framboids was 10 micrometers,
## followed by size dependent and supply-controlled growth until the mean was 15 micrometers.
Framboids<-Framboids_growth(100,Initialization=TRUE, Simulation=1,
Iterations=1000, MaxMeanDiameter=10)
Framboids<-Framboids_growth(100,Initialization=FALSE, Simulation=5, framboids=Framboids,
Iterations=1000, MaxMeanDiameter=15)
}
\references{
## Merinero, R.; Cardenes, V. (in press)
## Theoretical growth of framboidal and sunflower pyrite using the R-package frambgrowth.
## Mineralogy and Petrology. doi:10.1007/s00710-017-0535-x
}
\seealso{
\code{\link{Sunflowers_growth}}
}
