% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fredr_request.R
\name{fredr_request}
\alias{fredr_request}
\title{Send a request to the FRED API}
\usage{
fredr_request(endpoint, ..., to_frame = TRUE, print_req = FALSE)
}
\arguments{
\item{endpoint}{A string representing the FRED API endpoint of interest. See
\link{fredr_endpoints} for a list of endpoint possible values. \emph{Required parameter.}}

\item{...}{A series of named parameters to be used in the query.  Must be of the form
\code{param_key = "param_value"}.  Acceptable parameters are endpoint-specific.
See the \link{fredr_endpoints} data frame for a list of endpoints and \code{\link[=fredr_docs]{fredr_docs()}}
access to the web documentation for each endpoint function.}

\item{to_frame}{A boolean value indicating whether or not the response
should be parsed and formatted as a data frame.  If \code{FALSE},
a \code{response} object is returned and further processing can be done with
\code{\link[httr]{content}}.  Default is \code{TRUE}.}

\item{print_req}{A boolean value indicating whether or not the request
should be printed as well.  Useful for debugging.  Default is \code{FALSE}.}
}
\value{
If \code{to_frame = TRUE}, a \code{tibble} containing the parsed response.
If \code{to_frame = FALSE}, a \code{response} object returned directly from
\code{\link[httr]{GET}}.
}
\description{
Send a general request to the FRED API by specifying an endpoint and a sequence
of parameters.  The \code{fredr_request()} function forms and submits a request to
a specified endpoint of the FRED API.  The return is either the \code{response}
object from \code{\link[httr]{GET}} or the response parsed as a \code{tibble}.
}
\section{API Documentation}{


\href{https://api.stlouisfed.org/docs/fred/}{FRED API}
}

\examples{
\donttest{

fredr_request(
  endpoint = "series/observations",
  series_id = "GNPCA",
  observation_start = "1990-01-01",
  observation_end = "2000-01-01"
)
# Compare with to_frame = TRUE
resp <- fredr_request(
  endpoint = "series/observations",
  series_id = "GNPCA",
  observation_start = "1990-01-01",
  observation_end = "2000-01-01",
  to_frame = FALSE
)

}
}
