% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fredr_category.R
\name{fredr_category}
\alias{fredr_category}
\title{Get a FRED category}
\usage{
fredr_category(category_id)
}
\arguments{
\item{category_id}{An integer ID for the category.}
}
\value{
A \code{tibble} object containing the name and parent ID for the category
indicated by \code{category_id}.
}
\description{
Get a FRED category
}
\section{API Documentation}{


\href{https://fred.stlouisfed.org/docs/api/fred/category.html}{fred/category}
}

\examples{
if (fredr_has_key()) {
# Root category
fredr_category(category_id = 0L)
# "Production & Business Activity" category
fredr_category(category_id = 1L)
}
}
\seealso{
\code{\link[=fredr_category_children]{fredr_category_children()}}, \code{\link[=fredr_category_related]{fredr_category_related()}},
\code{\link[=fredr_category_series]{fredr_category_series()}}, \code{\link[=fredr_category_tags]{fredr_category_tags()}}, \code{\link[=fredr_category_related_tags]{fredr_category_related_tags()}}
}
