% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fredr_related_tags.R
\name{fredr_related_tags}
\alias{fredr_related_tags}
\title{Get related FRED tags given one or more tags}
\usage{
fredr_related_tags(
  tag_names,
  ...,
  exclude_tag_names = NULL,
  tag_group_id = NULL,
  search_text = NULL,
  limit = NULL,
  offset = NULL,
  order_by = NULL,
  sort_order = NULL,
  realtime_start = NULL,
  realtime_end = NULL
)
}
\arguments{
\item{tag_names}{A semicolon delimited string of tag names to be related to.}

\item{...}{These dots only exist for future extensions and should be empty.}

\item{exclude_tag_names}{A semicolon delimited string of tag names that series
match \emph{none} of. No exclusions are done by default.}

\item{tag_group_id}{A string tag group id to filter tags by type. No filtering
by tag group by default. Possible values are:
\itemize{
\item \code{"freq"} = Frequency
\item \code{"gen"} = General or Concept
\item \code{"geo"} = Geography
\item \code{"geot"} = Geography Type
\item \code{"rls"} = Release
\item \code{"seas"} = Seasonal Adjustment
\item \code{"src"} = Source
}}

\item{search_text}{A string indicating the words to find matching tags with.
No filtering by search words by default.}

\item{limit}{An integer limit on the maximum number of results to return.
Defaults to \code{1000}, the maximum.}

\item{offset}{An integer used in conjunction with \code{limit} for long series.
This mimics the idea of \emph{pagination} to retrieve large amounts of data over
multiple calls. Defaults to \code{0}.}

\item{order_by}{Order results by values of the specified attribute. Possible
values are:
\itemize{
\item \code{"series_count"} (default)
\item \code{"popularity"}
\item \code{"created"}
\item \code{"name"}
\item \code{"group_id"}
}}

\item{sort_order}{A string representing the order of the resulting series,
sorted by the attribute values specified by \code{order_by}. Possible values
are: \code{"asc"} (default), and \code{"desc"}.}

\item{realtime_start}{A \code{Date} indicating the start of the real-time period.
Defaults to today's date. For more information, see
\href{https://fred.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}

\item{realtime_end}{A \code{Date} indicating the end of the real-time period.
Defaults to today's date. For more information, see
\href{https://fred.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}
}
\value{
A \code{tibble} containing tags related to \code{tag_names} and their
descriptions.  Data include tag name, group ID, popularity, series count, tag
creation date, and additional notes.
}
\description{
Get related FRED tags. Optionally, filter results by tag group, or
search text. Related FRED tags are the tags assigned to series that match
\emph{all} tags in the \code{tag_names} parameter and \emph{no} tags in the
\code{exclude_tag_names} parameter.
}
\section{API Documentation}{


\href{https://fred.stlouisfed.org/docs/api/fred/related_tags.html}{fred/related_tags}
}

\examples{

if (fredr_has_key()) {

fredr_related_tags(tag_names = "monetary aggregates;weekly")

fredr_related_tags(
   tag_names = "monetary aggregates;weekly",
   tag_group_id = "gen"
 )

 }
}
\seealso{
\code{\link[=fredr_category_tags]{fredr_category_tags()}}, \code{\link[=fredr_category_related_tags]{fredr_category_related_tags()}}, \code{\link[=fredr_docs]{fredr_docs()}},
\code{\link[=fredr_release_tags]{fredr_release_tags()}}, \code{\link[=fredr_release_related_tags]{fredr_release_related_tags()}},
\code{\link[=fredr_series_search_tags]{fredr_series_search_tags()}}, \code{\link[=fredr_series_search_related_tags]{fredr_series_search_related_tags()}},
\code{\link[=fredr_tags_series]{fredr_tags_series()}}, \code{\link[=fredr_tags]{fredr_tags()}}
}
