% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fs_transform.R
\name{read.fs.transform}
\alias{read.fs.transform}
\title{Load transformation matrix from a file.}
\usage{
read.fs.transform(filepath, format = "auto")
}
\arguments{
\item{filepath}{character string, the full path to the transform file.}

\item{format}{character string, the file format. Currently 'auto' (guess based on file extension), 'xfm' (for xform format) or 'dat' (for tkregister style, e.g. register.dat) are supported.}
}
\value{
named list, the 'matrix field contains a '4x4 numerical matrix, the transformation matrix. Other fields may exist, depending on the parsed format.
}
\description{
Load transformation matrix from a file.
}
\note{
Currently this function has been tested with linear transformation files only, all others are unsupported.
}
\examples{
    tf_file = system.file("extdata", "talairach.xfm",
                               package = "freesurferformats",
                               mustWork = TRUE);
    transform = read.fs.transform(tf_file);
    transform$matrix;

}
\seealso{
Other header coordinate space: 
\code{\link{mghheader.is.ras.valid}()},
\code{\link{mghheader.ras2vox.tkreg}()},
\code{\link{mghheader.ras2vox}()},
\code{\link{mghheader.scanner2tkreg}()},
\code{\link{mghheader.tkreg2scanner}()},
\code{\link{mghheader.vox2ras.tkreg}()},
\code{\link{mghheader.vox2ras}()},
\code{\link{read.fs.transform.dat}()},
\code{\link{read.fs.transform.lta}()},
\code{\link{read.fs.transform.xfm}()},
\code{\link{sm0to1}()},
\code{\link{sm1to0}()}
}
\concept{header coordinate space}
