% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gifti_xml_tools.R
\name{gifti_xml_add_global_metadata}
\alias{gifti_xml_add_global_metadata}
\title{Add metadata to GIFTI XML tree.}
\usage{
gifti_xml_add_global_metadata(xmltree, metadata_named_list, as_cdata = TRUE)
}
\arguments{
\item{xmltree}{XML tree from xml2}

\item{metadata_named_list}{named list, the metadata entries}

\item{as_cdata}{logical, whether to wrap the value in cdata tags}
}
\value{
the modified tree.
}
\description{
Add metadata to GIFTI XML tree.
}
\note{
Assumes that there already exists a global MetaData node. Also not that this is not supposed to be used for adding metadata to datarrays.
}
\examples{
  xmltree = gifti_xml(list(rep(3.1, 3L), matrix(seq(6)+0.1, nrow=2L)));
  newtree = gifti_xml_add_global_metadata(xmltree, list("User"="Me", "Weather"="Great"));
  gifti_xsd = "https://www.nitrc.org/frs/download.php/158/gifti.xsd";
  xml2::xml_validate(newtree, xml2::read_xml(gifti_xsd));

}
