% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_french_data.R
\name{download_french_data}
\alias{download_french_data}
\title{Download the data set}
\usage{
download_french_data(
  dataset_name,
  dir = NULL,
  dest_file = NULL,
  overwrite = FALSE,
  max_tries = 3
)
}
\arguments{
\item{dataset_name}{string with the data set name. Use \code{get_french_data_list()} to get the list of data sets available to download.}

\item{dir}{character. Should be a valid directory path where to save the compressed downloaded file.}

\item{dest_file}{character. Should be a valid file name to save the compressed downloaded file. If \code{dir} is defined and \code{dest_file} is left empty, the original file name will be used.}

\item{overwrite}{boolean. Overwrite an existing file?}

\item{max_tries}{numeric. Number of file download trials.}
}
\value{
An objects of class \code{\link[=french_dataset-class]{french_dataset}} with the following elements:
\itemize{
\item \code{info} - holds the information about when and were the information was retrieved.
\item \code{details_url} - url for the webpage with details on data set.
\item \code{subsets} a tibble with with the subsets contained in the downloaded file, the tibble contains a \code{name} and \code{data} column.
}
}
\description{
Download the data set
}
\examples{
\donttest{
ff_3f <- download_french_data('Fama/French 3 Factors')
ff_3f
}
}
