% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars-bootstrap.R
\name{bs_vars_font}
\alias{bs_vars_font}
\title{Bootstrap CSS font variables}
\usage{
bs_vars_font(family_sans_serif = NULL, size_base = NULL,
  size_large = NULL, size_small = NULL, size_h1 = NULL,
  size_h2 = NULL, size_h3 = NULL, size_h4 = NULL, size_h5 = NULL,
  size_h6 = NULL)
}
\arguments{
\item{family_sans_serif}{Font family to use.}

\item{size_base}{Size of base font, e.g. normal text, default in Bootstrap is \code{"15px"}.}

\item{size_large}{Size of large text.}

\item{size_small}{Size of small text.}

\item{size_h1}{Size of h1 tags.}

\item{size_h2}{Size of h2 tags.}

\item{size_h3}{Size of h3 tags.}

\item{size_h4}{Size of h4 tags.}

\item{size_h5}{Size of h5 tags.}

\item{size_h6}{Size of h6 tags.}
}
\value{
a \code{list} that can be used in \code{\link{create_theme}}.
}
\description{
Those variables can be used to customize
 fonts in Bootstrap and Bootswatch themes.
}
\note{
In Bootstrap, only \code{size_base} is defined, all others are calculated from this one.
 See default parameters for Bootstrap: \url{https://getbootstrap.com/docs/3.4/customize/}.
}
\examples{
# Use a smaller font than the default
bs_vars_font(
  size_base = "12px"
)

if (interactive()) {
  library(shiny)
  library(fresh)

  ui <- fluidPage(
    use_theme(create_theme(
      theme = "default",
      bs_vars_font(
        size_base = "32px"
      )
    )),
    tags$h1("Big font theme"),

    sidebarLayout(
      sidebarPanel(
        "This is the sidebar panel"
      ),
      mainPanel(
        tags$h1("First level title"),
        tags$h2("Second level title"),
        tags$h3("Third level title"),
        tags$h4("Fourth level title"),
        tags$h5("Fifth level title"),
        tags$h6("Sixth level title")
      )
    )
  )

  server <- function(input, output, session) {

  }

  shinyApp(ui, server)
}
}
