% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_observations.R
\name{get_observations}
\alias{get_observations}
\title{Get weather observations from the "observation" resource in the Frost API}
\usage{
get_observations(client_id,
                 sources,
                 reference_time,
                 elements,
                 maxage = NULL,
                 limit = NULL,
                 time_offsets = NULL,
                 time_resolutions = NULL,
                 time_series_ids = NULL,
                 performance_categories = NULL,
                 exposure_categories = NULL,
                 qualities = NULL,
                 levels = NULL,
                 include_extra = NULL,
                 fields = NULL,
                 return_response = FALSE)
}
\arguments{
\item{client_id}{A string. The client ID to use to send requests to the Frost
API.}

\item{sources}{A character vector. The station IDs of the data sources
to get observations for. For example, "SN18700" is the station ID for
"Blindern". The full list of station IDs can be retrieved with
\code{\link{get_sources}()}.}

\item{reference_time}{A string. The time range to get observations for in
either extended ISO-8601 format or the single word "latest".}

\item{elements}{A character vector. The elements to get observations for.
The full list of elements can be retrieved with the
\code{\link{get_elements}()}.}

\item{maxage}{A string. The maximum observation age as an ISO-8601 period,
e.g. \code{"P1D"}. This parameter is only applicable when \code{reference_time
= "latest"}. Defaults to "PT3H".}

\item{limit}{A string or a positive integer. The maximum number of
observation times to be returned for each combination of source and
element, counting from the most recent time. This parameter is only
applicable when \code{reference_time = "latest"}. Set \code{limit = "all"}
to get all available times or a positive integer. Defaults to 1.}

\item{time_offsets}{A character vector. The time offsets to get observations
for provided as a vector of ISO-8601 periods, e.g. \code{c("PT6H", "PT18H")}.}

\item{time_resolutions}{A character vector. The time resolutions to get
observations for provided as a vector of ISO-8601 periods e.g.
\code{c("PT6H", "PT18H")}.}

\item{time_series_ids}{A numeric vector. The internal time series IDs to get
observations for as a vector of integers, e.g. c(0, 1).}

\item{performance_categories}{A character vector. The performance categories
to get observations for as a vector of letters, e.g. \code{c("A", "C")}.}

\item{exposure_categories}{A numeric vector. The exposure categories to get
observations for as a vector of integers, e.g. \code{c(1, 2)}.}

\item{qualities}{A numeric vector. The qualities to get observations for as
a vector of integers, e.g. \code{c(1, 2)}.}

\item{levels}{A numeric vector. The sensor levels to get observations for as
a vector of integers, e.g. \code{c(1, 2, 10, 20)}.}

\item{include_extra}{An integer. If this parameter is set to 1, and extra
data is available, then this data is included in the response. Extra data
currently consists of the original observation value and the 16-character
control info.}

\item{fields}{A character vector. Fields to include in the response (i.e.
output). If this parameter is specified, then only these fields are
returned in the response. If not specified, then all fields will be
returned in the response.}

\item{return_response}{A logical. If set to \code{TRUE}, then the function
returns the response from the GET request. If set to \code{FALSE} (default),
then the function returns a tibble (data frame) of the content in the
response.}
}
\value{
The function returns either a data frame of historical weather
observations, or the response of the GET request, depending on the
boolean value set for \code{return_response}.
}
\description{
\code{get_observations()} retrieves historical weather data
from the Frost API. This is the core resource for retrieving actual
observation data from MET Norway's data storage systems. The function
requires input for \code{client_id}, \code{sources}, \code{reference_time},
and \code{elements}. The other function arguments are optional, and default
to \code{NULL}, which means that the response from the API is not
filtered on these parameters.
}
\examples{
\donttest{
client.id <- "<YOUR CLIENT ID>"

# Get daily data for temperature, rain, and wind speed for 2018
sources <- "SN18700"
reference.time <- "2018-01-01/2018-12-31"
elements <- c("mean(air_temperature P1D)",
              "sum(precipitation_amount P1D)",
              "mean(wind_speed P1D)")

obs.df <- get_observations(client_id = client.id,
                           sources = sources,
                           reference_time = reference.time,
                           elements = elements)
}

}
