% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.R
\name{vis.subject.morph.native}
\alias{vis.subject.morph.native}
\title{Visualize native space morphometry data for a subject.}
\usage{
vis.subject.morph.native(subjects_dir, subject_id, measure, hemi,
  surface = "white", colormap = squash::jet, views = c("t4"),
  rgloptions = list())
}
\arguments{
\item{subjects_dir, }{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{subject_id, }{string. The subject identifier.}

\item{measure, }{string. The morphometry data to use. E.g., 'area' or 'thickness.'}

\item{hemi, }{string, one of 'lh', 'rh', or 'both'. The hemisphere name. Used to construct the names of the label data files to be loaded.}

\item{surface, }{string. The display surface. E.g., "white", "pial", or "inflated". Defaults to "white".}

\item{colormap, }{a colormap. See the squash package for some colormaps. Defaults to squash::jet.}

\item{views, }{list of strings. Valid entries include: 'si': single interactive view. 't4': tiled view showing the brain from 4 angles. 't9': tiled view showing the brain from 9 angles.}

\item{rgloptions}{option list passed to [rgl::par3d()]. Example: rgloptions = list("windowRect"=c(50,50,1000,1000));}
}
\value{
list of coloredmeshes. The coloredmeshes used for the visualization.
}
\description{
Creates a surface mesh, applies a colormap transform the morphometry data values into colors, and renders the resulting colored mesh in an interactive window. If hemi is 'both', the data is rendered for the wholw brain.
}
\examples{
\donttest{
   fsbrain::download_optional_data();
   subjects_dir = fsbrain::get_optional_data_filepath("subjects_dir");
   vis.subject.morph.native(subjects_dir, 'subject1', 'thickness', 'lh');
}

}
\seealso{
Other visualization functions: \code{\link{vis.data.on.fsaverage}},
  \code{\link{vis.data.on.subject}},
  \code{\link{vis.subject.annot}}
}
\concept{visualization functions}
