% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata_io.R
\name{read.md.subjects}
\alias{read.md.subjects}
\title{Read subjects file}
\usage{
read.md.subjects(subjects_file, header)
}
\arguments{
\item{subjects_file}{character string, the path to the subjects file.}

\item{header}{logical, whether the file starts with a header line.}
}
\value{
vector of strings, the subject identifiers.
}
\description{
Load a list of subjects from a subjects file, i.e., a simple text file containing one subject name per line.
}
\examples{
   subjects_file = system.file("extdata", "subjects.txt", package = "fsbrain", mustWork = TRUE);
   subjects_list = read.md.subjects(subjects_file, header = FALSE);

}
\seealso{
Other metadata functions: 
\code{\link{demographics.to.fsgd.file}()},
\code{\link{read.md.demographics}()},
\code{\link{report.on.demographics}()}
}
\concept{metadata functions}
