% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsdir_abstraction_group.R
\name{write.group.morph.standard.mf}
\alias{write.group.morph.standard.mf}
\title{Write per-vertex standard space data for a group of subjects to given file names.}
\usage{
write.group.morph.standard.mf(
  filepaths_hl,
  data_hl,
  format = "auto",
  create_dirs = TRUE
)
}
\arguments{
\item{filepaths_hl}{\code{\link[fsbrain]{hemilist}} of vectors of character strings, the full paths to the output files, including file names and extension.}

\item{data_hl}{\code{\link[fsbrain]{hemilist}} of numerical matrix or data.frame, the morph data for the hemispheres of all subjects. See \code{groupmorph.split.hemilist} to get this format if you have a full matrix or dataframe for both hemispheres.}

\item{format}{character string, a valid format spec for \code{freesurferformats::write.fs.morph}, e.g., "auto" to derive from filename, "mgh", "mgz", "curv" or others.}

\item{create_dirs}{logical, whether to create missing (sub) directories which occur in the 'filepaths'.}
}
\description{
Write per-vertex standard space data for a group of subjects to given file names.
}
\seealso{
\code{\link[fsbrain]{write.group.morph.standard.sf}} to write the data to a single stacked file instead.
}
