% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_multiview.R
\name{get.view.angle.names}
\alias{get.view.angle.names}
\title{Get list of valid view angle names.}
\usage{
get.view.angle.names(angle_set = "all", add_sd_prefix = TRUE)
}
\arguments{
\item{angle_set}{string, which view subset to return. Available subsets are: 'all' (or alias 't9'): for all 9 angles. 't4': for the t4 views. 'medial': the 2 medial views, one for each hemi. 'lateral': the 2 lateral views, one for each hemi. 'lh': medial and laterial for the left hemisphere. 'rh': medial and laterial for the right hemisphere.}

\item{add_sd_prefix}{logical, whether the prefix 'sd_' should be added to the string. This will construct full view names. If set to false, only the substring after the prefix 'sd_' will be returned. This is used internally only and should not be needed in general.}
}
\value{
vector of character strings, all valid view angle strings.
}
\description{
The returned strings are used as constants to identify a view of type `sd_<angle>`. They can be used to construct entries for the parameter `views` of functions like \code{\link[fsbrain]{vis.subject.morph.native}}, or directly as parameter 'view_angles' for functions like \code{\link[fsbrain]{vislayout.from.coloredmeshes}}.
}
