% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{fsr_is_empty}
\alias{fsr_is_empty}
\title{Checking whether a \code{pgeometry} object is empty}
\usage{
fsr_is_empty(pgo)
}
\arguments{
\item{pgo}{A \code{pgeometry} object.}
}
\value{
A Boolean value that indicates if a \code{pgeometry} is empty.
}
\description{
This function checks whether a \code{pgeometry} object is empty (i.e., if it does not contain components).
}
\details{
It checks if a pgeometry object has any component or not. If the number of components of a \code{pgeometry} object is equal to 0, then
it returns  \code{TRUE}. Otherwise, it returns \code{FALSE}.
}
\examples{

# Creating an empty pgeometry object 
pgo1 <- create_empty_pgeometry("PLATEAULINE")

# Checking if it is empty
fsr_is_empty(pgo1)

# Creating a component to populate the pgeometry object

library(sf)
md <- 0.4
pts <- rbind(c(1, 1), c(2, 3), c(2, 1))

comp <- component_from_sfg(st_multipoint(pts), md)

# Adding the component to the pgeometry object
pgo1 <- spa_add_component(pgo1, comp)

# Checking if it is still empty
fsr_is_empty(pgo1) 

}
